## Deploying a Rama cluster

If deploying on AWS or Azure, the easiest way to set up a Rama cluster is with the one-click deploys in [rama-aws-deploy](https://github.com/redplanetlabs/rama-aws-deploy) or [rama-azure-deploy](https://github.com/redplanetlabs/rama-azure-deploy).

Instructions for setting up a Rama cluster manually can be found [on this page](https://redplanetlabs.com/docs/~/operating-rama.html).

## Activating self-monitoring

The Rama Cluster UI contains bountiful telemetry on the runtime operation of modules. To enable self-monitoring, you need to launch the built-in monitoring module. For a small Rama cluster we recommend deploying like this:

```
rama deploy --action launch --systemModule monitoring --tasks 4 --threads 2 --workers 1
```

We also recommend configuring telemetry retention to limit the amount of disk space used by the monitoring module. Instructions for that are [in this section](https://redplanetlabs.com/docs/~/operating-rama.html#_configuring_telemetry_retention).

## Upgrading a Rama cluster

See [this section](https://redplanetlabs.com/docs/~/operating-rama.html#_upgrading_a_rama_cluster_to_a_new_version) for instructions on upgrading an existing Rama cluster to a new version.

## Learning Rama

The best way to start learning Rama is with [the tutorial](https://redplanetlabs.com/docs/~/tutorial1.html). There are [additional pages](https://redplanetlabs.com/docs/~/clj-defining-modules.html) for Clojure API users.

The [rama-demo-gallery](https://github.com/redplanetlabs/rama-demo-gallery) repository contains short, self-contained, thoroughly commented examples of applying Rama towards a variety of use cases.
