/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import rpl.shaded.org.apache.kafka.common.serialization.ByteArrayDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.ByteArraySerializer;
import rpl.shaded.org.apache.kafka.common.serialization.ByteBufferDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.ByteBufferSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.BytesDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.BytesSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.Deserializer;
import rpl.shaded.org.apache.kafka.common.serialization.DoubleDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.DoubleSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.FloatDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.FloatSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.IntegerDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.IntegerSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.LongDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.LongSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.Serde;
import rpl.shaded.org.apache.kafka.common.serialization.Serializer;
import rpl.shaded.org.apache.kafka.common.serialization.ShortDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.ShortSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.StringDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.StringSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.UUIDDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.UUIDSerializer;
import rpl.shaded.org.apache.kafka.common.serialization.VoidDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.VoidSerializer;
import rpl.shaded.org.apache.kafka.common.utils.Bytes;

public class Serdes {
    public static <T> Serde<T> serdeFrom(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return Serdes.String();
        }
        if (Short.class.isAssignableFrom(type)) {
            return Serdes.Short();
        }
        if (Integer.class.isAssignableFrom(type)) {
            return Serdes.Integer();
        }
        if (Long.class.isAssignableFrom(type)) {
            return Serdes.Long();
        }
        if (Float.class.isAssignableFrom(type)) {
            return Serdes.Float();
        }
        if (Double.class.isAssignableFrom(type)) {
            return Serdes.Double();
        }
        if (byte[].class.isAssignableFrom(type)) {
            return Serdes.ByteArray();
        }
        if (ByteBuffer.class.isAssignableFrom(type)) {
            return Serdes.ByteBuffer();
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return Serdes.Bytes();
        }
        if (UUID.class.isAssignableFrom(type)) {
            return Serdes.UUID();
        }
        throw new IllegalArgumentException("Unknown class for built-in serializer. Supported types are: String, Short, Integer, Long, Float, Double, ByteArray, ByteBuffer, Bytes, UUID");
    }

    public static <T> Serde<T> serdeFrom(Serializer<T> serializer, Deserializer<T> deserializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer must not be null");
        }
        if (deserializer == null) {
            throw new IllegalArgumentException("deserializer must not be null");
        }
        return new WrapperSerde<T>(serializer, deserializer);
    }

    public static Serde<Long> Long() {
        return new LongSerde();
    }

    public static Serde<Integer> Integer() {
        return new IntegerSerde();
    }

    public static Serde<Short> Short() {
        return new ShortSerde();
    }

    public static Serde<Float> Float() {
        return new FloatSerde();
    }

    public static Serde<Double> Double() {
        return new DoubleSerde();
    }

    public static Serde<String> String() {
        return new StringSerde();
    }

    public static Serde<ByteBuffer> ByteBuffer() {
        return new ByteBufferSerde();
    }

    public static Serde<Bytes> Bytes() {
        return new BytesSerde();
    }

    public static Serde<UUID> UUID() {
        return new UUIDSerde();
    }

    public static Serde<byte[]> ByteArray() {
        return new ByteArraySerde();
    }

    public static Serde<Void> Void() {
        return new VoidSerde();
    }

    public static final class UUIDSerde
    extends WrapperSerde<UUID> {
        public UUIDSerde() {
            super(new UUIDSerializer(), new UUIDDeserializer());
        }
    }

    public static final class ByteArraySerde
    extends WrapperSerde<byte[]> {
        public ByteArraySerde() {
            super(new ByteArraySerializer(), new ByteArrayDeserializer());
        }
    }

    public static final class BytesSerde
    extends WrapperSerde<Bytes> {
        public BytesSerde() {
            super(new BytesSerializer(), new BytesDeserializer());
        }
    }

    public static final class ByteBufferSerde
    extends WrapperSerde<ByteBuffer> {
        public ByteBufferSerde() {
            super(new ByteBufferSerializer(), new ByteBufferDeserializer());
        }
    }

    public static final class StringSerde
    extends WrapperSerde<String> {
        public StringSerde() {
            super(new StringSerializer(), new StringDeserializer());
        }
    }

    public static final class DoubleSerde
    extends WrapperSerde<Double> {
        public DoubleSerde() {
            super(new DoubleSerializer(), new DoubleDeserializer());
        }
    }

    public static final class FloatSerde
    extends WrapperSerde<Float> {
        public FloatSerde() {
            super(new FloatSerializer(), new FloatDeserializer());
        }
    }

    public static final class ShortSerde
    extends WrapperSerde<Short> {
        public ShortSerde() {
            super(new ShortSerializer(), new ShortDeserializer());
        }
    }

    public static final class IntegerSerde
    extends WrapperSerde<Integer> {
        public IntegerSerde() {
            super(new IntegerSerializer(), new IntegerDeserializer());
        }
    }

    public static final class LongSerde
    extends WrapperSerde<Long> {
        public LongSerde() {
            super(new LongSerializer(), new LongDeserializer());
        }
    }

    public static final class VoidSerde
    extends WrapperSerde<Void> {
        public VoidSerde() {
            super(new VoidSerializer(), new VoidDeserializer());
        }
    }

    public static class WrapperSerde<T>
    implements Serde<T> {
        private final Serializer<T> serializer;
        private final Deserializer<T> deserializer;

        public WrapperSerde(Serializer<T> serializer, Deserializer<T> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
            this.serializer.configure(configs, isKey);
            this.deserializer.configure(configs, isKey);
        }

        @Override
        public void close() {
            this.serializer.close();
            this.deserializer.close();
        }

        @Override
        public Serializer<T> serializer() {
            return this.serializer;
        }

        @Override
        public Deserializer<T> deserializer() {
            return this.deserializer;
        }
    }
}

