/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import rpl.shaded.org.apache.kafka.common.message.DeleteGroupsResponseData;
import rpl.shaded.org.apache.kafka.common.protocol.ApiKeys;
import rpl.shaded.org.apache.kafka.common.protocol.Errors;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class DeleteGroupsResponse
extends AbstractResponse {
    public final DeleteGroupsResponseData data;

    public DeleteGroupsResponse(DeleteGroupsResponseData data) {
        this.data = data;
    }

    public DeleteGroupsResponse(Struct struct) {
        short latestVersion = (short)(DeleteGroupsResponseData.SCHEMAS.length - 1);
        this.data = new DeleteGroupsResponseData(struct, latestVersion);
    }

    public DeleteGroupsResponse(Struct struct, short version) {
        this.data = new DeleteGroupsResponseData(struct, version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public Map<String, Errors> errors() {
        HashMap<String, Errors> errorMap = new HashMap<String, Errors>();
        for (DeleteGroupsResponseData.DeletableGroupResult result2 : this.data.results()) {
            errorMap.put(result2.groupId(), Errors.forCode(result2.errorCode()));
        }
        return errorMap;
    }

    public Errors get(String group) throws IllegalArgumentException {
        DeleteGroupsResponseData.DeletableGroupResult result2 = this.data.results().find(group);
        if (result2 == null) {
            throw new IllegalArgumentException("could not find group " + group + " in the delete group response");
        }
        return Errors.forCode(result2.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (DeleteGroupsResponseData.DeletableGroupResult result2 : this.data.results()) {
            Errors error = Errors.forCode(result2.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    public static DeleteGroupsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteGroupsResponse(ApiKeys.DELETE_GROUPS.parseResponse(version, buffer), version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

