/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import rpl.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import rpl.shaded.org.apache.kafka.common.protocol.ApiMessage;
import rpl.shaded.org.apache.kafka.common.protocol.Message;
import rpl.shaded.org.apache.kafka.common.protocol.MessageUtil;
import rpl.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import rpl.shaded.org.apache.kafka.common.protocol.Readable;
import rpl.shaded.org.apache.kafka.common.protocol.Writable;
import rpl.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import rpl.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import rpl.shaded.org.apache.kafka.common.protocol.types.Field;
import rpl.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import rpl.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import rpl.shaded.org.apache.kafka.common.protocol.types.Schema;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.protocol.types.Type;
import rpl.shaded.org.apache.kafka.common.utils.ByteUtils;

public class OffsetFetchResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<OffsetFetchResponseTopic> topics;
    private short errorCode;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public OffsetFetchResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public OffsetFetchResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public OffsetFetchResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<OffsetFetchResponseTopic>();
        this.errorCode = 0;
    }

    @Override
    public short apiKey() {
        return 9;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<OffsetFetchResponseTopic> newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 3 ? _readable.readInt() : 0;
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetFetchResponseTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new ArrayList<OffsetFetchResponseTopic>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetFetchResponseTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this.errorCode = _version >= 2 ? _readable.readShort() : (short)0;
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 6) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (OffsetFetchResponseTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (OffsetFetchResponseTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 2) {
            _writable.writeShort(this.errorCode);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 3 ? struct.getInt("throttle_time_ms") : 0;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<OffsetFetchResponseTopic>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new OffsetFetchResponseTopic((Struct)nestedObject, _version));
        }
        this.errorCode = _version >= 2 ? struct.getShort("error_code") : (short)0;
        if (_version >= 6 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 6) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 3) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (OffsetFetchResponseTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.set("error_code", (Object)this.errorCode);
        }
        if (_version >= 6) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1)) : (_arraySize += 4);
        for (OffsetFetchResponseTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 2) {
            _size += 2;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 6) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetFetchResponseData)) {
            return false;
        }
        OffsetFetchResponseData other = (OffsetFetchResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return this.errorCode == other.errorCode;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.errorCode;
        return hashCode;
    }

    public String toString() {
        return "OffsetFetchResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", errorCode=" + this.errorCode + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<OffsetFetchResponseTopic> topics() {
        return this.topics;
    }

    public short errorCode() {
        return this.errorCode;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetFetchResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public OffsetFetchResponseData setTopics(List<OffsetFetchResponseTopic> v) {
        this.topics = v;
        return this;
    }

    public OffsetFetchResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(OffsetFetchResponseTopic.SCHEMA_0), "The responses per topic."));
        SCHEMA_2 = new Schema(new Field("topics", new ArrayOf(OffsetFetchResponseTopic.SCHEMA_0), "The responses per topic."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."));
        SCHEMA_4 = SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(OffsetFetchResponseTopic.SCHEMA_0), "The responses per topic."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."));
        SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(OffsetFetchResponseTopic.SCHEMA_5), "The responses per topic."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."));
        SCHEMA_7 = SCHEMA_6 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new CompactArrayOf(OffsetFetchResponseTopic.SCHEMA_6), "The responses per topic."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class OffsetFetchResponsePartition
    implements Message {
        private int partitionIndex;
        private long committedOffset;
        private int committedLeaderEpoch;
        private String metadata;
        private short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public OffsetFetchResponsePartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetFetchResponsePartition(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public OffsetFetchResponsePartition() {
            this.partitionIndex = 0;
            this.committedOffset = 0L;
            this.committedLeaderEpoch = -1;
            this.metadata = "";
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetFetchResponsePartition");
            }
            this.partitionIndex = _readable.readInt();
            this.committedOffset = _readable.readLong();
            this.committedLeaderEpoch = _version >= 5 ? _readable.readInt() : -1;
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.metadata = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field metadata had invalid length " + length);
                }
                this.metadata = _readable.readString(length);
            }
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetFetchResponsePartition");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.committedOffset);
            if (_version >= 5) {
                _writable.writeInt(this.committedLeaderEpoch);
            }
            if (this.metadata == null) {
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.metadata);
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetFetchResponsePartition");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.partitionIndex = struct.getInt("partition_index");
            this.committedOffset = struct.getLong("committed_offset");
            this.committedLeaderEpoch = _version >= 5 ? struct.getInt("committed_leader_epoch") : -1;
            this.metadata = struct.getString("metadata");
            this.errorCode = struct.getShort("error_code");
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetFetchResponsePartition");
            }
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("committed_offset", (Object)this.committedOffset);
            if (_version >= 5) {
                struct.set("committed_leader_epoch", (Object)this.committedLeaderEpoch);
            }
            struct.set("metadata", (Object)this.metadata);
            struct.set("error_code", (Object)this.errorCode);
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetFetchResponsePartition");
            }
            _size += 4;
            _size += 8;
            if (_version >= 5) {
                _size += 4;
            }
            if (this.metadata == null) {
                _size = _version >= 6 ? ++_size : (_size += 2);
            } else {
                byte[] _stringBytes = this.metadata.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'metadata' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.metadata, _stringBytes);
                _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchResponsePartition)) {
                return false;
            }
            OffsetFetchResponsePartition other = (OffsetFetchResponsePartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.committedOffset != other.committedOffset) {
                return false;
            }
            if (this.committedLeaderEpoch != other.committedLeaderEpoch) {
                return false;
            }
            if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.committedOffset >> 32) ^ (int)this.committedOffset);
            hashCode = 31 * hashCode + this.committedLeaderEpoch;
            hashCode = 31 * hashCode + (this.metadata == null ? 0 : this.metadata.hashCode());
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "OffsetFetchResponsePartition(partitionIndex=" + this.partitionIndex + ", committedOffset=" + this.committedOffset + ", committedLeaderEpoch=" + this.committedLeaderEpoch + ", metadata=" + (this.metadata == null ? "null" : "'" + this.metadata.toString() + "'") + ", errorCode=" + this.errorCode + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long committedOffset() {
            return this.committedOffset;
        }

        public int committedLeaderEpoch() {
            return this.committedLeaderEpoch;
        }

        public String metadata() {
            return this.metadata;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetFetchResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public OffsetFetchResponsePartition setCommittedOffset(long v) {
            this.committedOffset = v;
            return this;
        }

        public OffsetFetchResponsePartition setCommittedLeaderEpoch(int v) {
            this.committedLeaderEpoch = v;
            return this;
        }

        public OffsetFetchResponsePartition setMetadata(String v) {
            this.metadata = v;
            return this;
        }

        public OffsetFetchResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The committed message offset."), new Field("metadata", Type.NULLABLE_STRING, "The partition metadata."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error.")))));
            SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The committed message offset."), new Field("committed_leader_epoch", Type.INT32, "The leader epoch."), new Field("metadata", Type.NULLABLE_STRING, "The partition metadata."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
            SCHEMA_7 = SCHEMA_6 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("committed_offset", Type.INT64, "The committed message offset."), new Field("committed_leader_epoch", Type.INT32, "The leader epoch."), new Field("metadata", Type.COMPACT_NULLABLE_STRING, "The partition metadata."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class OffsetFetchResponseTopic
    implements Message {
        private String name;
        private List<OffsetFetchResponsePartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public OffsetFetchResponseTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetFetchResponseTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public OffsetFetchResponseTopic() {
            this.name = "";
            this.partitions = new ArrayList<OffsetFetchResponsePartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<OffsetFetchResponsePartition> newCollection;
            int arrayLength;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetFetchResponseTopic");
            }
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new OffsetFetchResponsePartition(_readable, _version));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList<OffsetFetchResponsePartition>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new OffsetFetchResponsePartition(_readable, _version));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetFetchResponseTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    OffsetFetchResponsePartition partitionsElement = (OffsetFetchResponsePartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    OffsetFetchResponsePartition partitionsElement = (OffsetFetchResponsePartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetFetchResponseTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<OffsetFetchResponsePartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new OffsetFetchResponsePartition((Struct)nestedObject, _version));
            }
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetFetchResponseTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (OffsetFetchResponsePartition element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetFetchResponseTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1)) : (_arraySize += 4);
            for (OffsetFetchResponsePartition partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetFetchResponseTopic)) {
                return false;
            }
            OffsetFetchResponseTopic other = (OffsetFetchResponseTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "OffsetFetchResponseTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<OffsetFetchResponsePartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetFetchResponseTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetFetchResponseTopic setPartitions(List<OffsetFetchResponsePartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetFetchResponsePartition.SCHEMA_0), "The responses per partition")))));
            SCHEMA_5 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetFetchResponsePartition.SCHEMA_5), "The responses per partition"));
            SCHEMA_7 = SCHEMA_6 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(OffsetFetchResponsePartition.SCHEMA_6), "The responses per partition"), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

