/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.zk;

import rpl.shaded.kafka.zk.KafkaZkClient;
import rpl.shaded.kafka.zookeeper.AsyncRequest;
import rpl.shaded.kafka.zookeeper.AsyncResponse;
import rpl.shaded.kafka.zookeeper.CheckOp;
import rpl.shaded.kafka.zookeeper.CreateOp;
import rpl.shaded.kafka.zookeeper.CreateRequest;
import rpl.shaded.kafka.zookeeper.CreateResponse;
import rpl.shaded.kafka.zookeeper.DeleteOp;
import rpl.shaded.kafka.zookeeper.DeleteRequest;
import rpl.shaded.kafka.zookeeper.DeleteResponse;
import rpl.shaded.kafka.zookeeper.MultiRequest;
import rpl.shaded.kafka.zookeeper.MultiResponse;
import rpl.shaded.kafka.zookeeper.ResponseMetadata;
import rpl.shaded.kafka.zookeeper.SetDataOp;
import rpl.shaded.kafka.zookeeper.SetDataRequest;
import rpl.shaded.kafka.zookeeper.SetDataResponse;
import rpl.shaded.kafka.zookeeper.ZkOp;
import rpl.shaded.kafka.zookeeper.ZkOpResult;
import rpl.shaded.kafka.zookeeper.ZooKeeperClient;
import rpl.shaded.org.apache.kafka.common.errors.ControllerMovedException;
import rpl.shaded.org.apache.kafka.common.utils.Time;
import rpl.shaded.org.apache.zookeeper.CreateMode;
import rpl.shaded.org.apache.zookeeper.KeeperException;
import rpl.shaded.org.apache.zookeeper.OpResult;
import rpl.shaded.org.apache.zookeeper.client.ZKClientConfig;
import rpl.shaded.org.apache.zookeeper.data.ACL;
import rpl.shaded.org.apache.zookeeper.data.Stat;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Product;
import rpl.shaded.scala.collection.Seq$;
import rpl.shaded.scala.collection.SeqFactory;
import rpl.shaded.scala.collection.SeqOps;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class KafkaZkClient$ {
    public static final KafkaZkClient$ MODULE$ = new KafkaZkClient$();

    public KafkaZkClient apply(String connectString, boolean isSecure, int sessionTimeoutMs, int connectionTimeoutMs, int maxInFlightRequests, Time time, String metricGroup, String metricType, Option<String> name, Option<ZKClientConfig> zkClientConfig) {
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(connectString, sessionTimeoutMs, connectionTimeoutMs, maxInFlightRequests, time, metricGroup, metricType, name, zkClientConfig);
        return new KafkaZkClient(zooKeeperClient, isSecure, time);
    }

    public String apply$default$7() {
        return "rpl.shaded.kafka.server";
    }

    public String apply$default$8() {
        return "SessionExpireListener";
    }

    public Option<String> apply$default$9() {
        return None$.MODULE$;
    }

    public Option<ZKClientConfig> apply$default$10() {
        return None$.MODULE$;
    }

    public MultiRequest kafka$zk$KafkaZkClient$$wrapRequestWithControllerEpochCheck(AsyncRequest request, int expectedControllerZkVersion) {
        MultiRequest multiRequest;
        CheckOp checkOp = new CheckOp("/controller_epoch", expectedControllerZkVersion);
        if (request instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)request;
            String path = createRequest.path();
            byte[] data = createRequest.data();
            rpl.shaded.scala.collection.Seq<ACL> acl = createRequest.acl();
            CreateMode createMode = createRequest.createMode();
            Option<Object> ctx = createRequest.ctx();
            multiRequest = new MultiRequest((rpl.shaded.scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Product[]{checkOp, new CreateOp(path, data, acl, createMode)})), ctx);
        } else if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            String path = deleteRequest.path();
            int version = deleteRequest.version();
            Option<Object> ctx = deleteRequest.ctx();
            multiRequest = new MultiRequest((rpl.shaded.scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Product[]{checkOp, new DeleteOp(path, version)})), ctx);
        } else if (request instanceof SetDataRequest) {
            SetDataRequest setDataRequest = (SetDataRequest)request;
            String path = setDataRequest.path();
            byte[] data = setDataRequest.data();
            int version = setDataRequest.version();
            Option<Object> ctx = setDataRequest.ctx();
            multiRequest = new MultiRequest((rpl.shaded.scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Product[]{checkOp, new SetDataOp(path, data, version)})), ctx);
        } else {
            throw new IllegalStateException(new StringBuilder(37).append(request).append(" does not need controller epoch check").toString());
        }
        return multiRequest;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public AsyncResponse kafka$zk$KafkaZkClient$$unwrapResponseWithControllerEpochCheck(AsyncResponse response) {
        if (!(response instanceof MultiResponse)) throw new IllegalStateException(new StringBuilder(48).append("Cannot unwrap ").append(response).append(" because it is not a MultiResponse").toString());
        MultiResponse multiResponse = (MultiResponse)response;
        KeeperException.Code resultCode = multiResponse.resultCode();
        Option<Object> ctx = multiResponse.ctx();
        rpl.shaded.scala.collection.Seq<ZkOpResult> zkOpResults = multiResponse.zkOpResults();
        ResponseMetadata responseMetadata = multiResponse.metadata();
        if (zkOpResults != null) {
            SeqOps seqOps;
            Seq$ unapplySeq_this = Seq$.MODULE$;
            SeqOps seqOps2 = seqOps = SeqFactory.unapplySeq$(unapplySeq_this, zkOpResults);
            Object var25_7 = null;
            seqOps = null;
            SeqOps seqOps3 = seqOps2;
            new SeqFactory.UnapplySeqWrapper(seqOps3);
            int lengthCompare$extension_len = 2;
            if (seqOps3.lengthCompare(lengthCompare$extension_len) == 0) {
                int apply$extension_i = 0;
                ZkOpResult zkOpResult = (ZkOpResult)seqOps3.apply(apply$extension_i);
                int apply$extension_i2 = 1;
                ZkOpResult zkOpResult2 = (ZkOpResult)seqOps3.apply(apply$extension_i2);
                if (zkOpResult != null) {
                    ZkOp checkOp = zkOpResult.zkOp();
                    OpResult checkOpResult = zkOpResult.rawOpResult();
                    if (checkOp instanceof CheckOp) {
                        void var2_29;
                        CheckOp checkOp2 = (CheckOp)checkOp;
                        if (checkOpResult instanceof OpResult.ErrorResult) {
                            OpResult.ErrorResult errorResult = (OpResult.ErrorResult)checkOpResult;
                            if (checkOp2.path().equals("/controller_epoch")) {
                                KeeperException.Code errorCode;
                                KeeperException.Code code = errorCode = KeeperException.Code.get((int)errorResult.getErr());
                                KeeperException.Code code2 = KeeperException.Code.BADVERSION;
                                if (code == null) {
                                    if (code2 == null) throw new ControllerMovedException(new StringBuilder(61).append("Controller epoch zkVersion check fails. Expected zkVersion = ").append(checkOp2.version()).toString());
                                } else if (code.equals(code2)) {
                                    throw new ControllerMovedException(new StringBuilder(61).append("Controller epoch zkVersion check fails. Expected zkVersion = ").append(checkOp2.version()).toString());
                                }
                                KeeperException.Code code3 = errorCode;
                                KeeperException.Code code4 = KeeperException.Code.OK;
                                if (code3 == null ? code4 != null : !code3.equals(code4)) {
                                    throw KeeperException.create((KeeperException.Code)errorCode, (String)checkOp2.path());
                                }
                            }
                        }
                        OpResult rawOpResult = zkOpResult2.rawOpResult();
                        ZkOp zkOp = zkOpResult2.zkOp();
                        if (zkOp instanceof CreateOp) {
                            CreateOp createOp = (CreateOp)zkOp;
                            String string = rawOpResult instanceof OpResult.CreateResult ? ((OpResult.CreateResult)rawOpResult).getPath() : null;
                            CreateResponse createResponse = new CreateResponse(resultCode, createOp.path(), ctx, string, responseMetadata);
                            return var2_29;
                        }
                        if (zkOp instanceof DeleteOp) {
                            DeleteOp deleteOp = (DeleteOp)zkOp;
                            DeleteResponse deleteResponse = new DeleteResponse(resultCode, deleteOp.path(), ctx, responseMetadata);
                            return var2_29;
                        }
                        if (!(zkOp instanceof SetDataOp)) throw new IllegalStateException(new StringBuilder(17).append("Unexpected zkOp: ").append(zkOp).toString());
                        SetDataOp setDataOp = (SetDataOp)zkOp;
                        Stat stat = rawOpResult instanceof OpResult.SetDataResult ? ((OpResult.SetDataResult)rawOpResult).getStat() : null;
                        SetDataResponse setDataResponse = new SetDataResponse(resultCode, setDataOp.path(), ctx, stat, responseMetadata);
                        return var2_29;
                    }
                }
            }
        }
        if (zkOpResults != null) throw new IllegalStateException(new StringBuilder(86).append("Cannot unwrap ").append(response).append(" because the first zookeeper op is not check op in original MultiRequest").toString());
        throw KeeperException.create((KeeperException.Code)resultCode);
    }

    private KafkaZkClient$() {
    }
}

