/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.tools;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.slf4j.event.Level;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.tools.ReplicaBuffer;
import rpl.shaded.kafka.tools.ReplicaFetcher;
import rpl.shaded.kafka.tools.TopicPartitionReplica;
import rpl.shaded.kafka.utils.CommandLineUtils$;
import rpl.shaded.kafka.utils.CoreUtils$;
import rpl.shaded.kafka.utils.Exit$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.kafka.utils.ToolsUtils$;
import rpl.shaded.kafka.utils.Whitelist;
import rpl.shaded.org.apache.kafka.clients.admin.Admin;
import rpl.shaded.org.apache.kafka.clients.admin.ListTopicsOptions;
import rpl.shaded.org.apache.kafka.clients.admin.TopicDescription;
import rpl.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import rpl.shaded.org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import rpl.shaded.org.apache.kafka.common.Node;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.TopicPartitionInfo;
import rpl.shaded.org.apache.kafka.common.serialization.StringDeserializer;
import rpl.shaded.org.apache.kafka.common.utils.Exit;
import rpl.shaded.org.apache.kafka.common.utils.Time;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Console$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.IterableOnce;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.MapOps;
import rpl.shaded.scala.collection.Seq;
import rpl.shaded.scala.collection.immutable.Iterable;
import rpl.shaded.scala.collection.immutable.Map;
import rpl.shaded.scala.collection.mutable.Buffer;
import rpl.shaded.scala.collection.mutable.Buffer$;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class ReplicaVerificationTool$
implements Logging {
    public static final ReplicaVerificationTool$ MODULE$ = new ReplicaVerificationTool$();
    private static final String clientId = "replicaVerificationTool";
    private static final String dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat(MODULE$.dateFormatString());
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String clientId() {
        return clientId;
    }

    public String dateFormatString() {
        return dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(Time.SYSTEM.milliseconds()));
    }

    public void main(String[] args) {
        Seq<TopicDescription> seq;
        Map<Object, Node> map;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo((Object)0x100000, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)1000, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo((Object)".*", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)-1L, (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)30000L, (Object[])new Long[0]);
        AbstractOptionSpec helpOpt = parser.accepts("help", "Print usage information.").forHelp();
        AbstractOptionSpec versionOpt = parser.accepts("version", "Print version information and exit.").forHelp();
        OptionSet options = parser.parse(args);
        if (args.length == 0 || options.has((OptionSpec)helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        if (options.has((OptionSpec)versionOpt)) {
            throw CommandLineUtils$.MODULE$.printVersionAndDie();
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, ScalaRunTime$.MODULE$.wrapRefArray(new OptionSpec[]{brokerListOpt}));
        String regex = (String)options.valueOf((OptionSpec)topicWhiteListOpt);
        Whitelist topicWhiteListFiler = new Whitelist(regex);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException(new StringBuilder(21).append(regex).append(" is an invalid regex.").toString());
        }
        int fetchSize = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        long initialOffsetTime = (Long)options.valueOf((OptionSpec)initialOffsetTimeOpt);
        long reportInterval = (Long)options.valueOf((OptionSpec)reportIntervalOpt);
        if (this.logger().underlying().isInfoEnabled()) {
            String string;
            String string2 = string = "Getting topic metadata...";
            string = null;
            String msgWithLogIdent_msg = string2;
            Object var34_19 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Admin adminClient = this.createAdminClient(brokerList);
        try {
            map = this.brokerDetails(adminClient);
            seq = this.listTopicsMetadata(adminClient);
        }
        finally {
            CoreUtils$.MODULE$.swallow(() -> adminClient.close(), this, Level.WARN);
        }
        Seq filteredTopicMetadata = (Seq)seq.filter((Function1<TopicDescription, Object> & Serializable)topicMetaData -> BoxesRunTime.boxToBoolean(topicWhiteListFiler.isTopicAllowed(topicMetaData.name(), false)));
        if (filteredTopicMetadata.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = ReplicaVerificationTool$.$anonfun$main$4(topicWhiteListOpt);
                Object var35_26 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            throw Exit$.MODULE$.exit(1, None$.MODULE$);
        }
        Seq topicPartitionReplicas = (Seq)filteredTopicMetadata.flatMap((Function1<TopicDescription, Buffer> & Serializable)topicMetadata -> (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitions()).asScala()).flatMap((Function1<TopicPartitionInfo, Buffer> & Serializable)partitionMetadata -> (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1<Node, TopicPartitionReplica> & Serializable)node -> new TopicPartitionReplica(topicMetadata.name(), partitionMetadata.partition(), node.id()))));
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = ReplicaVerificationTool$.$anonfun$main$8(topicPartitionReplicas);
            Object var36_28 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        Map brokerToTopicPartitions = (Map)topicPartitionReplicas.groupBy((Function1<TopicPartitionReplica, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.replicaId())).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            Tuple2<Integer, void> tuple2;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            int brokerId = x0$1._1$mcI$sp();
            Seq partitions = (Seq)x0$1._2();
            Object CC = partitions.map((Function1<TopicPartitionReplica, TopicPartition> & Serializable)partition -> new TopicPartition(partition.topic(), partition.partitionId()));
            Integer $minus$greater$extension_$this = brokerId;
            Tuple2<Integer, void> tuple22 = tuple2 = new Tuple2<Integer, void>($minus$greater$extension_$this, $minus$greater$extension_y);
            Object var4_4 = null;
            CC = null;
            tuple2 = null;
            Tuple2<Integer, void> tuple23 = tuple22;
            return tuple23;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = ReplicaVerificationTool$.$anonfun$main$12(brokerToTopicPartitions);
            Object var37_30 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        Map expectedReplicasPerTopicPartition = (Map)topicPartitionReplicas.groupBy((Function1<TopicPartitionReplica, TopicPartition> & Serializable)replica -> new TopicPartition(replica.topic(), replica.partitionId())).map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2<TopicPartition, Integer> tuple2;
            Integer n;
            Seq replicaSet;
            TopicPartition topicAndPartition;
            if (x0$2 != null) {
                topicAndPartition = (TopicPartition)x0$2._1();
                replicaSet = (Seq)x0$2._2();
                if (replicaSet == null) {
                    throw null;
                }
            } else {
                throw new MatchError((Object)null);
            }
            Integer n2 = n = Integer.valueOf(replicaSet.length());
            n = null;
            Integer $minus$greater$extension_y = n2;
            Tuple2<TopicPartition, Integer> tuple22 = tuple2 = new Tuple2<TopicPartition, Integer>(topicAndPartition, $minus$greater$extension_y);
            Object var4_4 = null;
            tuple2 = null;
            Tuple2<TopicPartition, Integer> tuple23 = tuple22;
            return tuple23;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = ReplicaVerificationTool$.$anonfun$main$15(expectedReplicasPerTopicPartition);
            Object var38_32 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        Seq topicPartitions = (Seq)filteredTopicMetadata.flatMap((Function1<TopicDescription, Buffer> & Serializable)topicMetaData -> (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetaData.partitions()).asScala()).map((Function1<TopicPartitionInfo, TopicPartition> & Serializable)partitionMetadata -> new TopicPartition(topicMetaData.name(), partitionMetadata.partition())));
        Properties consumerProps = this.consumerConfig(brokerList);
        ReplicaBuffer replicaBuffer = new ReplicaBuffer(expectedReplicasPerTopicPartition, this.initialOffsets(topicPartitions, consumerProps, initialOffsetTime), brokerToTopicPartitions.size(), reportInterval);
        int verificationBrokerId = ((Tuple2)brokerToTopicPartitions.head())._1$mcI$sp();
        AtomicInteger counter = new AtomicInteger(0);
        Iterable fetcherThreads = (Iterable)brokerToTopicPartitions.map((Function1<Tuple2, ReplicaFetcher> & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError((Object)null);
            }
            int brokerId = x0$3._1$mcI$sp();
            Seq topicPartitions = (Seq)x0$3._2();
            ReplicaFetcher replicaFetcher = new ReplicaFetcher(new StringBuilder(15).append("ReplicaFetcher-").append(brokerId).toString(), (Node)map.apply((Object)brokerId), topicPartitions, replicaBuffer, 30000, 256000, fetchSize, maxWaitMs, 1, brokerId == verificationBrokerId, consumerProps, counter.incrementAndGet());
            return replicaFetcher;
        });
        Exit.addShutdownHook("ReplicaVerificationToolShutdownHook", () -> Exit$.$anonfun$addShutdownHook$1(() -> {
            ReplicaVerificationTool$ info_this = MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String string;
                String string2 = string = "Stopping all fetchers";
                string = null;
                String msgWithLogIdent_msg = string2;
                Object var2_3 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            Object var1_1 = null;
            fetcherThreads.foreach((Function1<ReplicaFetcher, Object> & Serializable)x$3 -> {
                x$3.shutdown();
                return BoxedUnit.UNIT;
            });
        }));
        fetcherThreads.foreach((Function1<ReplicaFetcher, Object> & Serializable)x$4 -> {
            x$4.start();
            return BoxedUnit.UNIT;
        });
        String println_x = new StringBuilder(34).append(this.getCurrentTimeString()).append(": verification process is started.").toString();
        Console$.MODULE$.println(println_x);
    }

    private Seq<TopicDescription> listTopicsMetadata(Admin adminClient) {
        Set<String> topics = adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get();
        IterableOnceOps iterableOnceOps = JavaConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeTopics(topics).all().get().values()).asScala();
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps toBuffer_this = iterableOnceOps;
        return (Buffer)Buffer$.MODULE$.from((IterableOnce)((Object)toBuffer_this));
    }

    private Map<Object, Node> brokerDetails(Admin adminClient) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeCluster().nodes().get()).asScala()).map((Function1<Node, Tuple2> & Serializable)n -> new Tuple2<Integer, Node>(n.id(), (Node)n))).toMap($less$colon$less$.MODULE$.refl());
    }

    private Admin createAdminClient(String brokerUrl) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerUrl);
        return Admin.create(props);
    }

    private Map<TopicPartition, Object> initialOffsets(Seq<TopicPartition> topicPartitions, Properties consumerConfig, long initialOffsetTime) {
        Map<TopicPartition, Object> map;
        KafkaConsumer kafkaConsumer;
        KafkaConsumer kafkaConsumer2 = kafkaConsumer = new KafkaConsumer(consumerConfig);
        kafkaConsumer = null;
        try (KafkaConsumer consumer = kafkaConsumer2;){
            if (-1L == initialOffsetTime) {
                map = ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection<TopicPartition>)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).mapValues((Function1<Long, Object> & Serializable)x$5 -> BoxesRunTime.boxToLong(x$5)).toMap($less$colon$less$.MODULE$.refl());
            } else if (-2L == initialOffsetTime) {
                map = ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets((Collection<TopicPartition>)JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).mapValues((Function1<Long, Object> & Serializable)x$6 -> BoxesRunTime.boxToLong(x$6)).toMap($less$colon$less$.MODULE$.refl());
            } else {
                Map timestampsToSearch = ((IterableOnceOps)topicPartitions.map((Function1<TopicPartition, Tuple2> & Serializable)tp -> {
                    Long l;
                    Long l2 = l = Long.valueOf(initialOffsetTime);
                    l = null;
                    Long $minus$greater$extension_y = l2;
                    return new Tuple2<TopicPartition, Long>((TopicPartition)tp, $minus$greater$extension_y);
                })).toMap($less$colon$less$.MODULE$.refl());
                map = ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes(JavaConverters$.MODULE$.mapAsJavaMapConverter(timestampsToSearch).asJava())).asScala()).mapValues((Function1<OffsetAndTimestamp, Object> & Serializable)v -> BoxesRunTime.boxToLong(v.offset())).toMap($less$colon$less$.MODULE$.refl());
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Properties consumerConfig(String brokerUrl) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", brokerUrl);
        properties.put("group.id", "ReplicaVerification");
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        return var2_2;
    }

    private KafkaConsumer<String, String> createConsumer(Properties consumerConfig) {
        return new KafkaConsumer<String, String>(consumerConfig);
    }

    public static final /* synthetic */ String $anonfun$main$1() {
        return "Getting topic metadata...";
    }

    public static final /* synthetic */ String $anonfun$main$4(ArgumentAcceptingOptionSpec topicWhiteListOpt$1) {
        return new StringBuilder(88).append("No topics found. ").append(topicWhiteListOpt$1).append(" if specified, is either filtering out all topics or there is no topic.").toString();
    }

    public static final /* synthetic */ String $anonfun$main$8(Seq topicPartitionReplicas$1) {
        return new StringBuilder(27).append("Selected topic partitions: ").append(topicPartitionReplicas$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$12(Map brokerToTopicPartitions$1) {
        return new StringBuilder(29).append("Topic partitions per broker: ").append(brokerToTopicPartitions$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$15(Map expectedReplicasPerTopicPartition$1) {
        return new StringBuilder(39).append("Expected replicas per topic partition: ").append(expectedReplicasPerTopicPartition$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$20() {
        return "Stopping all fetchers";
    }

    private ReplicaVerificationTool$() {
    }
}

