/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.tools;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import rpl.shaded.com.typesafe.scalalogging.LazyLogging;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.tools.ConsumerPerformance;
import rpl.shaded.kafka.utils.ToolsUtils$;
import rpl.shaded.org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import rpl.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import rpl.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import rpl.shaded.org.apache.kafka.common.Metric;
import rpl.shaded.org.apache.kafka.common.MetricName;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.scala.Console$;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.Tuple2$mcDD$sp;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.immutable.$colon$colon;
import rpl.shaded.scala.collection.immutable.List;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.mutable.Map;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.LongRef;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class ConsumerPerformance$
implements LazyLogging {
    public static final ConsumerPerformance$ MODULE$ = new ConsumerPerformance$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$(MODULE$);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$(this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public void main(String[] args) {
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting consumer...");
        }
        AtomicLong totalMessagesRead = new AtomicLong(0L);
        AtomicLong totalBytesRead = new AtomicLong(0L);
        Map<MetricName, Metric> metrics = null;
        AtomicLong joinGroupTimeInMs = new AtomicLong(0L);
        if (!config.hideHeader()) {
            this.printHeader(config.showDetailedStats());
        }
        KafkaConsumer<byte[], byte[]> consumer = new KafkaConsumer<byte[], byte[]>(config.props());
        long startMs = System.currentTimeMillis();
        this.consume(consumer, new $colon$colon<Nothing$>((Nothing$)((Object)config.topic()), Nil$.MODULE$), config.numMessages(), config.recordFetchTimeoutMs(), config, totalMessagesRead, totalBytesRead, joinGroupTimeInMs, startMs);
        long endMs = System.currentTimeMillis();
        if (config.printMetrics()) {
            metrics = JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.metrics()).asScala();
        }
        consumer.close();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        long fetchTimeInMs = endMs - startMs - joinGroupTimeInMs.get();
        if (!config.showDetailedStats()) {
            double totalMBRead = (double)totalBytesRead.get() * 1.0 / (double)0x100000;
            String println_x = StringOps$.MODULE$.format$extension("%s, %s, %.4f, %.4f, %d, %.4f, %d, %d, %.4f, %.4f", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{config.dateFormat().format(startMs), config.dateFormat().format(endMs), totalMBRead, totalMBRead / elapsedSecs, totalMessagesRead.get(), (double)totalMessagesRead.get() / elapsedSecs, joinGroupTimeInMs.get(), fetchTimeInMs, totalMBRead / ((double)fetchTimeInMs / 1000.0), (double)totalMessagesRead.get() / ((double)fetchTimeInMs / 1000.0)}));
            Console$.MODULE$.println(println_x);
            Object var18_13 = null;
        }
        if (metrics != null) {
            ToolsUtils$.MODULE$.printMetrics(metrics);
        }
    }

    public void printHeader(boolean showDetailedStats) {
        String newFieldsInHeader = ", rebalance.time.ms, fetch.time.ms, fetch.MB.sec, fetch.nMsg.sec";
        if (!showDetailedStats) {
            String println_x = new StringBuilder(82).append("start.time, end.time, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec").append(newFieldsInHeader).toString();
            Console$.MODULE$.println(println_x);
            return;
        }
        String println_x = new StringBuilder(76).append("time, threadId, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec").append(newFieldsInHeader).toString();
        Console$.MODULE$.println(println_x);
    }

    public void consume(KafkaConsumer<byte[], byte[]> consumer, List<String> topics, long count, long timeout, ConsumerPerformance.ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicLong joinTime, long testStartTime) {
        LongRef longRef;
        LongRef longRef2;
        LongRef longRef3;
        LongRef longRef4;
        LongRef longRef5;
        LongRef longRef6;
        LongRef longRef7;
        long create_e = 0L;
        LongRef longRef8 = longRef7 = new LongRef(create_e);
        longRef7 = null;
        LongRef bytesRead = longRef8;
        long create_e2 = 0L;
        LongRef longRef9 = longRef6 = new LongRef(create_e2);
        longRef6 = null;
        LongRef messagesRead = longRef9;
        long create_e3 = 0L;
        LongRef longRef10 = longRef5 = new LongRef(create_e3);
        longRef5 = null;
        LongRef lastBytesRead = longRef10;
        long create_e4 = 0L;
        LongRef longRef11 = longRef4 = new LongRef(create_e4);
        longRef4 = null;
        LongRef lastMessagesRead = longRef11;
        long create_e5 = 0L;
        LongRef longRef12 = longRef3 = new LongRef(create_e5);
        longRef3 = null;
        LongRef joinStart = longRef12;
        long create_e6 = 0L;
        LongRef longRef13 = longRef2 = new LongRef(create_e6);
        longRef2 = null;
        LongRef joinTimeMsInSingleRound = longRef13;
        consumer.subscribe((Collection<String>)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava(), new ConsumerRebalanceListener(joinTime, joinStart, joinTimeMsInSingleRound){
            private final AtomicLong joinTime$1;
            private final LongRef joinStart$1;
            private final LongRef joinTimeMsInSingleRound$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                ConsumerRebalanceListener.super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.joinTime$1.addAndGet(System.currentTimeMillis() - this.joinStart$1.elem);
                this.joinTimeMsInSingleRound$1.elem += System.currentTimeMillis() - this.joinStart$1.elem;
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                this.joinStart$1.elem = System.currentTimeMillis();
            }
            {
                this.joinTime$1 = joinTime$1;
                this.joinStart$1 = joinStart$1;
                this.joinTimeMsInSingleRound$1 = joinTimeMsInSingleRound$1;
            }
        });
        long create_e7 = System.currentTimeMillis();
        LongRef currentTimeMillis = new LongRef(create_e7);
        long create_e8 = currentTimeMillis.elem;
        LongRef longRef14 = longRef = new LongRef(create_e8);
        longRef = null;
        LongRef lastReportTime = longRef14;
        long lastConsumedTime = currentTimeMillis.elem;
        while (messagesRead.elem < count && currentTimeMillis.elem - lastConsumedTime <= timeout) {
            Iterable records = JavaConverters$.MODULE$.iterableAsScalaIterableConverter(consumer.poll(Duration.ofMillis(100L))).asScala();
            currentTimeMillis.elem = System.currentTimeMillis();
            if (records.nonEmpty()) {
                lastConsumedTime = currentTimeMillis.elem;
            }
            records.foreach((Function1<ConsumerRecord, Object> & Serializable)record -> {
                ConsumerPerformance$.$anonfun$consume$1(messagesRead, bytesRead, currentTimeMillis, lastReportTime, config, lastBytesRead, lastMessagesRead, joinTimeMsInSingleRound, record);
                return BoxedUnit.UNIT;
            });
        }
        if (messagesRead.elem < count) {
            String println_x = new StringBuilder(57).append(new StringBuilder(91).append("WARNING: Exiting before consuming the expected number of messages: timeout (").append(timeout).append(" ms) exceeded. ").toString()).append("You can use the --timeout option to increase the timeout.").toString();
            Console$.MODULE$.println(println_x);
            Object var47_35 = null;
        }
        totalMessagesRead.set(messagesRead.elem);
        totalBytesRead.set(bytesRead.elem);
    }

    public void printConsumerProgress(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat, long periodicJoinTimeInMs) {
        this.printBasicProgress(id, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, endMs, dateFormat);
        this.printExtendedProgress(bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, endMs, periodicJoinTimeInMs);
        Console$.MODULE$.println();
    }

    private void printBasicProgress(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat) {
        double elapsedMs = endMs - startMs;
        double totalMbRead = (double)bytesRead * 1.0 / (double)0x100000;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        double intervalMbPerSec = 1000.0 * intervalMbRead / elapsedMs;
        double intervalMessagesPerSec = (double)(messagesRead - lastMessagesRead) / elapsedMs * 1000.0;
        String print_x = StringOps$.MODULE$.format$extension("%s, %d, %.4f, %.4f, %d, %.4f", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{dateFormat.format(endMs), id, totalMbRead, intervalMbPerSec, messagesRead, intervalMessagesPerSec}));
        Console$.MODULE$.print(print_x);
    }

    /*
     * WARNING - void declaration
     */
    private void printExtendedProgress(long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, long periodicJoinTimeInMs) {
        void var24_13;
        void var22_12;
        long fetchTimeMs = endMs - startMs - periodicJoinTimeInMs;
        double intervalMbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        long intervalMessagesRead = messagesRead - lastMessagesRead;
        Tuple2$mcDD$sp tuple2$mcDD$sp = fetchTimeMs <= 0L ? new Tuple2$mcDD$sp(0.0, 0.0) : new Tuple2$mcDD$sp(1000.0 * intervalMbRead / (double)fetchTimeMs, 1000.0 * (double)intervalMessagesRead / (double)fetchTimeMs);
        double intervalMbPerSec = ((Tuple2)tuple2$mcDD$sp)._1$mcD$sp();
        double intervalMessagesPerSec = ((Tuple2)tuple2$mcDD$sp)._2$mcD$sp();
        String print_x = StringOps$.MODULE$.format$extension(", %d, %d, %.4f, %.4f", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{periodicJoinTimeInMs, fetchTimeMs, (double)var22_12, (double)var24_13}));
        Console$.MODULE$.print(print_x);
    }

    public static final /* synthetic */ void $anonfun$consume$1(LongRef messagesRead$1, LongRef bytesRead$1, LongRef currentTimeMillis$1, LongRef lastReportTime$1, ConsumerPerformance.ConsumerPerfConfig config$1, LongRef lastBytesRead$1, LongRef lastMessagesRead$1, LongRef joinTimeMsInSingleRound$1, ConsumerRecord record) {
        ++messagesRead$1.elem;
        if (record.key() != null) {
            bytesRead$1.elem += (long)((byte[])record.key()).length;
        }
        if (record.value() != null) {
            bytesRead$1.elem += (long)((byte[])record.value()).length;
        }
        if (currentTimeMillis$1.elem - lastReportTime$1.elem >= (long)config$1.reportingInterval()) {
            if (config$1.showDetailedStats()) {
                MODULE$.printConsumerProgress(0, bytesRead$1.elem, lastBytesRead$1.elem, messagesRead$1.elem, lastMessagesRead$1.elem, lastReportTime$1.elem, currentTimeMillis$1.elem, config$1.dateFormat(), joinTimeMsInSingleRound$1.elem);
            }
            joinTimeMsInSingleRound$1.elem = 0L;
            lastReportTime$1.elem = currentTimeMillis$1.elem;
            lastMessagesRead$1.elem = messagesRead$1.elem;
            lastBytesRead$1.elem = bytesRead$1.elem;
        }
    }

    private ConsumerPerformance$() {
    }
}

