/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.metrics.KafkaMetricsGroup;
import rpl.shaded.kafka.server.CachedPartition;
import rpl.shaded.kafka.server.EvictableKey;
import rpl.shaded.kafka.server.FetchSession;
import rpl.shaded.kafka.server.FetchSession$;
import rpl.shaded.kafka.server.LastUsedKey;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.org.apache.kafka.common.requests.FetchMetadata;
import rpl.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.collection.Map;
import rpl.shaded.scala.collection.Map$;
import rpl.shaded.scala.collection.mutable.HashMap;
import rpl.shaded.scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001\u0002\u000f\u001e\u0001\tB\u0001\"\u000e\u0001\u0003\u0006\u0004%IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013%A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0005\u00011A\u0005\nqBq\u0001\u0013\u0001A\u0002\u0013%\u0011\n\u0003\u0004P\u0001\u0001\u0006K!\u0010\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019i\u0006\u0001)A\u0005%\"9a\f\u0001b\u0001\n\u0013y\u0006BB6\u0001A\u0003%\u0001\rC\u0004m\u0001\t\u0007I\u0011B7\t\rI\u0004\u0001\u0015!\u0003o\u0011\u001d\u0019\bA1A\u0005\n5Da\u0001\u001e\u0001!\u0002\u0013q\u0007\u0002C;\u0001\u0005\u0004%\t!\b<\t\u000f\u0005\u0015\u0001\u0001)A\u0005o\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001BBA\u000b\u0001\u0011\u0005a\u0007\u0003\u0004\u0002\u0018\u0001!\t\u0001\u0010\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005U\u0003\u0001\"\u0001\u0002\\!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r$!\u0005$fi\u000eD7+Z:tS>t7)Y2iK*\u0011adH\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0001\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001G%z\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+[5\t1F\u0003\u0002-?\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\b\u0019><w-\u001b8h!\t\u00014'D\u00012\u0015\t\u0011t$A\u0004nKR\u0014\u0018nY:\n\u0005Q\n$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006QQ.\u0019=F]R\u0014\u0018.Z:\u0016\u0003]\u0002\"\u0001\n\u001d\n\u0005e*#aA%oi\u0006YQ.\u0019=F]R\u0014\u0018.Z:!\u0003))g/[2uS>tWj]\u000b\u0002{A\u0011AEP\u0005\u0003\u007f\u0015\u0012A\u0001T8oO\u0006YQM^5di&|g.T:!\u0003\u0019a\u0014N\\5u}Q\u00191)\u0012$\u0011\u0005\u0011\u0003Q\"A\u000f\t\u000bU*\u0001\u0019A\u001c\t\u000bm*\u0001\u0019A\u001f\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0003EqW/\u001c)beRLG/[8og~#S-\u001d\u000b\u0003\u00156\u0003\"\u0001J&\n\u00051+#\u0001B+oSRDqAT\u0004\u0002\u0002\u0003\u0007Q(A\u0002yIE\naB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0005tKN\u001c\u0018n\u001c8t+\u0005\u0011\u0006\u0003B*Yoik\u0011\u0001\u0016\u0006\u0003+Z\u000bq!\\;uC\ndWM\u0003\u0002XK\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005e#&a\u0002%bg\"l\u0015\r\u001d\t\u0003\tnK!\u0001X\u000f\u0003\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\u0002\u0013M,7o]5p]N\u0004\u0013\u0001\u00037bgR,6/\u001a3\u0016\u0003\u0001\u0004B!\u00194i56\t!M\u0003\u0002dI\u0006!Q\u000f^5m\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\u000fQ\u0013X-Z'baB\u0011A)[\u0005\u0003Uv\u00111\u0002T1tiV\u001bX\rZ&fs\u0006IA.Y:u+N,G\rI\u0001\u000fKZL7\r^1cY\u0016\u0014\u00150\u00117m+\u0005q\u0007\u0003B1g_j\u0003\"\u0001\u00129\n\u0005El\"\u0001D#wS\u000e$\u0018M\u00197f\u0017\u0016L\u0018aD3wS\u000e$\u0018M\u00197f\u0005f\fE\u000e\u001c\u0011\u0002+\u00154\u0018n\u0019;bE2,')\u001f)sSZLG.Z4fI\u00061RM^5di\u0006\u0014G.\u001a\"z!JLg/\u001b7fO\u0016$\u0007%\u0001\bfm&\u001cG/[8og6+G/\u001a:\u0016\u0003]\u00042\u0001_A\u0001\u001b\u0005I(B\u0001>|\u0003\u0011\u0019wN]3\u000b\u0005Ib(BA?\u007f\u0003\u0019I\u0018-\\7fe*\tq0A\u0002d_6L1!a\u0001z\u0005\u0015iU\r^3s\u0003=)g/[2uS>t7/T3uKJ\u0004\u0013aA4fiR!\u00111BA\t!\u0011!\u0013Q\u0002.\n\u0007\u0005=QE\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003'\u0019\u0002\u0019A\u001c\u0002\u0013M,7o]5p]&#\u0017\u0001B:ju\u0016\fq\u0002^8uC2\u0004\u0016M\u001d;ji&|gn]\u0001\r]\u0016<8+Z:tS>t\u0017\n\u001a\u000b\u0002o\u0005\u0011R.Y=cK\u000e\u0013X-\u0019;f'\u0016\u001c8/[8o)%9\u0014\u0011EA\u0013\u0003_\t\t\u0004\u0003\u0004\u0002$]\u0001\r!P\u0001\u0004]><\bbBA\u0014/\u0001\u0007\u0011\u0011F\u0001\u000baJLg/\u001b7fO\u0016$\u0007c\u0001\u0013\u0002,%\u0019\u0011QF\u0013\u0003\u000f\t{w\u000e\\3b]\"1\u0011QC\fA\u0002]Bq!a\r\u0018\u0001\u0004\t)$\u0001\tde\u0016\fG/\u001a)beRLG/[8ogB)A%a\u000e\u0002<%\u0019\u0011\u0011H\u0013\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BA\u001f\u0003\u0007r1\u0001RA \u0013\r\t\t%H\u0001\r\r\u0016$8\r[*fgNLwN\\\u0005\u0005\u0003\u000b\n9EA\u0005D\u0003\u000eCUiX'B!*\u0019\u0011\u0011I\u000f\u0002\u0011Q\u0014\u00180\u0012<jGR$\u0002\"!\u000b\u0002N\u0005=\u00131\u000b\u0005\b\u0003OA\u0002\u0019AA\u0015\u0011\u0019\t\t\u0006\u0007a\u0001_\u0006\u00191.Z=\t\r\u0005\r\u0002\u00041\u0001>\u0003\u0019\u0011X-\\8wKR!\u00111BA-\u0011\u0019\t\u0019\"\u0007a\u0001oQ!\u00111BA/\u0011\u0019\tyF\u0007a\u00015\u000691/Z:tS>t\u0017!\u0002;pk\u000eDG#\u0002&\u0002f\u0005\u001d\u0004BBA07\u0001\u0007!\f\u0003\u0004\u0002$m\u0001\r!\u0010")
public class FetchSessionCache
implements KafkaMetricsGroup {
    private final int maxEntries;
    private final long evictionMs;
    private long numPartitions;
    private final HashMap<Object, FetchSession> sessions;
    private final TreeMap<LastUsedKey, FetchSession> lastUsed;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private HashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    private TreeMap<LastUsedKey, FetchSession> lastUsed() {
        return this.lastUsed;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId) {
        return this.sessions().get(sessionId);
    }

    public synchronized int size() {
        return this.sessions().size();
    }

    public synchronized long totalPartitions() {
        return this.numPartitions();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int newSessionId() {
        void var1_1;
        int id;
        do {
            id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        } while (this.sessions().contains(id) || id == 0);
        return (int)var1_1;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size, Function0<ImplicitLinkedHashCollection<CachedPartition>> createPartitions) {
        if (this.sessions().size() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size, 0), now)) {
            ImplicitLinkedHashCollection<CachedPartition> partitionMap = createPartitions.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, partitionMap, now, now, FetchMetadata.nextEpoch(0));
            this.debug((Function0<String> & Serializable)() -> new StringBuilder(22).append("Created fetch session ").append(session.toString()).toString());
            this.sessions().put(session.id(), session);
            this.touch(session, now);
            return session.id();
        }
        this.debug((Function0<String> & Serializable)() -> new StringBuilder(48).append("No fetch session created for privileged=").append(privileged).append(", size=").append(size).append(".").toString());
        return 0;
    }

    public synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        Map.Entry<LastUsedKey, FetchSession> lastUsedEntry = this.lastUsed().firstEntry();
        if (lastUsedEntry == null) {
            this.trace((Function0<String> & Serializable)() -> "There are no cache entries to evict.");
            return false;
        }
        if (now - lastUsedEntry.getKey().lastUsedMs() > this.evictionMs()) {
            FetchSession session = lastUsedEntry.getValue();
            this.trace((Function0<String> & Serializable)() -> new StringBuilder(29).append("Evicting stale FetchSession ").append(session.id()).append(".").toString());
            this.remove(session);
            this.evictionsMeter().mark();
            return true;
        }
        Map.Entry<EvictableKey, FetchSession> evictableEntry = (privileged ? this.evictableByPrivileged() : this.evictableByAll()).firstEntry();
        if (evictableEntry == null) {
            this.trace((Function0<String> & Serializable)() -> "No evictable entries found.");
            return false;
        }
        if (key.compareTo(evictableEntry.getKey()) < 0) {
            this.trace((Function0<String> & Serializable)() -> new StringBuilder(18).append("Can't evict ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).toString());
            return false;
        }
        this.trace((Function0<String> & Serializable)() -> new StringBuilder(16).append("Evicting ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).append(".").toString());
        this.remove(evictableEntry.getValue());
        this.evictionsMeter().mark();
        return true;
    }

    public synchronized Option<FetchSession> remove(int sessionId) {
        Option option;
        Option<FetchSession> option2 = this.get(sessionId);
        if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else if (option2 instanceof Some) {
            FetchSession session = (FetchSession)((Some)option2).value();
            option = this.remove(session);
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Option<FetchSession> remove(FetchSession session) {
        void var3_3;
        EvictableKey evictableKey;
        synchronized (session) {
            this.lastUsed().remove(session.lastUsedKey());
            evictableKey = session.evictableKey();
        }
        this.evictableByAll().remove(evictableKey);
        this.evictableByPrivileged().remove(evictableKey);
        Option<FetchSession> removeResult = this.sessions().remove(session.id());
        if (removeResult.isDefined()) {
            this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
        }
        return var3_3;
    }

    public synchronized void touch(FetchSession session, long now) {
        synchronized (session) {
            this.lastUsed().remove(session.lastUsedKey());
            session.lastUsedMs_$eq(now);
            this.lastUsed().put(session.lastUsedKey(), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            if (!session.privileged() || now - session.creationMs() > this.evictionMs()) {
                this.evictableByPrivileged().put(newEvictableKey, session);
            }
            if (now - session.creationMs() > this.evictionMs()) {
                this.evictableByAll().put(newEvictableKey, session);
            }
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
            return;
        }
    }

    public final /* synthetic */ int kafka$server$FetchSessionCache$$$anonfun$new$1() {
        return this.size();
    }

    public final /* synthetic */ long kafka$server$FetchSessionCache$$$anonfun$new$2() {
        return this.totalPartitions();
    }

    public FetchSessionCache(int maxEntries, long evictionMs) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        this.numPartitions = 0L;
        this.sessions = new HashMap();
        this.lastUsed = new TreeMap();
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSISONS(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSISONS(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final int value() {
                FetchSessionCache fetchSessionCache = this.$outer;
                if (fetchSessionCache == null) {
                    throw null;
                }
                return fetchSessionCache.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), this.removeMetric$default$2());
        this.newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final long value() {
                FetchSessionCache fetchSessionCache = this.$outer;
                if (fetchSessionCache == null) {
                    throw null;
                }
                return fetchSessionCache.totalPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), this.removeMetric$default$2());
        this.evictionsMeter = this.newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, (Map)Map$.MODULE$.empty());
    }
}

