/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.api.ApiVersion;
import rpl.shaded.kafka.coordinator.transaction.CompleteAbort$;
import rpl.shaded.kafka.coordinator.transaction.CompleteCommit$;
import rpl.shaded.kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import rpl.shaded.kafka.coordinator.transaction.Dead$;
import rpl.shaded.kafka.coordinator.transaction.Empty$;
import rpl.shaded.kafka.coordinator.transaction.Ongoing$;
import rpl.shaded.kafka.coordinator.transaction.PrepareAbort$;
import rpl.shaded.kafka.coordinator.transaction.PrepareCommit$;
import rpl.shaded.kafka.coordinator.transaction.TransactionConfig;
import rpl.shaded.kafka.coordinator.transaction.TransactionLog$;
import rpl.shaded.kafka.coordinator.transaction.TransactionMetadata;
import rpl.shaded.kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import rpl.shaded.kafka.coordinator.transaction.TransactionState;
import rpl.shaded.kafka.coordinator.transaction.TransactionStateManager$;
import rpl.shaded.kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import rpl.shaded.kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import rpl.shaded.kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import rpl.shaded.kafka.coordinator.transaction.TxnMetadataCacheEntry;
import rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata;
import rpl.shaded.kafka.log.AppendOrigin$Coordinator$;
import rpl.shaded.kafka.log.Log;
import rpl.shaded.kafka.log.LogConfig$;
import rpl.shaded.kafka.message.UncompressedCodec$;
import rpl.shaded.kafka.server.FetchDataInfo;
import rpl.shaded.kafka.server.FetchLogEnd$;
import rpl.shaded.kafka.server.ReplicaManager;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.kafka.utils.Pool;
import rpl.shaded.kafka.utils.Scheduler;
import rpl.shaded.kafka.zk.KafkaZkClient;
import rpl.shaded.org.apache.kafka.common.KafkaException;
import rpl.shaded.org.apache.kafka.common.MetricName;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.metrics.MeasurableStat;
import rpl.shaded.org.apache.kafka.common.metrics.Metrics;
import rpl.shaded.org.apache.kafka.common.metrics.Sensor;
import rpl.shaded.org.apache.kafka.common.metrics.stats.Avg;
import rpl.shaded.org.apache.kafka.common.metrics.stats.Max;
import rpl.shaded.org.apache.kafka.common.protocol.Errors;
import rpl.shaded.org.apache.kafka.common.record.CompressionType;
import rpl.shaded.org.apache.kafka.common.record.FileRecords;
import rpl.shaded.org.apache.kafka.common.record.MemoryRecords;
import rpl.shaded.org.apache.kafka.common.record.MutableRecordBatch;
import rpl.shaded.org.apache.kafka.common.record.Record;
import rpl.shaded.org.apache.kafka.common.record.Records;
import rpl.shaded.org.apache.kafka.common.record.SimpleRecord;
import rpl.shaded.org.apache.kafka.common.record.TimestampType;
import rpl.shaded.org.apache.kafka.common.requests.ProduceResponse;
import rpl.shaded.org.apache.kafka.common.requests.TransactionResult;
import rpl.shaded.org.apache.kafka.common.utils.Time;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.Function5;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableOnce;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.MapFactory;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.mutable.Growable;
import rpl.shaded.scala.collection.mutable.ListBuffer;
import rpl.shaded.scala.collection.mutable.Map;
import rpl.shaded.scala.collection.mutable.Map$;
import rpl.shaded.scala.collection.mutable.Set;
import rpl.shaded.scala.collection.mutable.Set$;
import rpl.shaded.scala.package$;
import rpl.shaded.scala.reflect.ClassTag$;
import rpl.shaded.scala.reflect.ScalaSignature;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.LongRef;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.ObjectRef;
import rpl.shaded.scala.runtime.ScalaRunTime$;
import rpl.shaded.scala.runtime.java8.JFunction0$mcV$sp;
import rpl.shaded.scala.runtime.java8.JFunction0$mcZ$sp;
import rpl.shaded.scala.util.Either;
import rpl.shaded.scala.util.Left;
import rpl.shaded.scala.util.Right;
import rpl.shaded.scala.util.Right$;

@ScalaSignature(bytes="\u0006\u0005\t=x!\u0002\u001c8\u0011\u0003qd!\u0002!8\u0011\u0003\t\u0005\"\u0002%\u0002\t\u0003I\u0005b\u0002&\u0002\u0005\u0004%\ta\u0013\u0005\u0007\u001f\u0006\u0001\u000b\u0011\u0002'\t\u000fA\u000b!\u0019!C\u0001\u0017\"1\u0011+\u0001Q\u0001\n1CqAU\u0001C\u0002\u0013\u00051\n\u0003\u0004T\u0003\u0001\u0006I\u0001\u0014\u0005\b)\u0006\u0011\r\u0011\"\u0001L\u0011\u0019)\u0016\u0001)A\u0005\u0019\u001a!\u0001i\u000e\u0001W\u0011!i6B!A!\u0002\u0013a\u0005\u0002\u00030\f\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0015\\!\u0011!Q\u0001\n\u0019D\u0001\"[\u0006\u0003\u0002\u0003\u0006IA\u001b\u0005\ta.\u0011\t\u0011)A\u0005c\"AAo\u0003B\u0001B\u0003%Q\u000f\u0003\u0006\u0002\u0004-\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0004\f\u0005\u0003\u0005\u000b\u0011BA\t\u0011\u0019A5\u0002\"\u0001\u0002\u001e\u00151\u0011\u0011G\u0006\u0001\u0003gA\u0011\"!\u001c\f\u0005\u0004%I!a\u001c\t\u0011\u0005%5\u0002)A\u0005\u0003cB\u0011\"a#\f\u0005\u0004%I!!$\t\u0011\u0005m5\u0002)A\u0005\u0003\u001fC!\"!(\f\u0005\u0004%\taNAP\u0011!\t9l\u0003Q\u0001\n\u0005\u0005\u0006BCA]\u0017\t\u0007I\u0011A\u001c\u0002<\"A\u0011\u0011Z\u0006!\u0002\u0013\ti\f\u0003\u0005\u0002L.\u0011\r\u0011\"\u0003L\u0011\u001d\tim\u0003Q\u0001\n1C\u0011\"a4\f\u0005\u0004%I!!5\t\u0011\u0005e7\u0002)A\u0005\u0003'D\u0001\"a7\f\t\u00039\u0014Q\u001c\u0005\t\u0003O\\A\u0011A\u001c\u0002j\"9\u0011q_\u0006\u0005\u0002\u0005e\bb\u0002B\n\u0017\u0011\u0005!Q\u0003\u0005\b\u0005/YA\u0011\u0001B\r\u0011\u001d\u0011id\u0003C\u0001\u0005\u007fAqAa\u0012\f\t\u0013\u0011I\u0005C\u0004\u0003T-!\tA!\u0016\t\u000f\t\u00054\u0002\"\u0001\u0003d!9!QN\u0006\u0005\u0002\t=\u0004B\u0002B:\u0017\u0011%1\nC\u0004\u0003v-!IAa\u001e\t\u0011\t55\u0002\"\u00018\u0005\u001fCqAa'\f\t\u0003\u0011i\nC\u0004\u0003,.!\tA!,\t\u000f\t-6\u0002\"\u0001\u00032\"9!qW\u0006\u0005\n\tU\u0001b\u0002B]\u0017\u0011\u0005!1\u0018\u0005\n\u0005+\\\u0011\u0013!C\u0001\u0005/DqA!<\f\t\u0003\u0011)\"A\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe*\u0011\u0001(O\u0001\fiJ\fgn]1di&|gN\u0003\u0002;w\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005a\u0014!B6bM.\f7\u0001\u0001\t\u0003\u007f\u0005i\u0011a\u000e\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\u001c\"!\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta(A\u0010EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t7/T1y)&lWm\\;u\u001bN,\u0012\u0001\u0014\t\u0003\u00076K!A\u0014#\u0003\u0007%sG/\u0001\u0011EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t7/T1y)&lWm\\;u\u001bN\u0004\u0013A\t#fM\u0006,H\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:l5/A\u0012EK\u001a\fW\u000f\u001c;Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\u0002U\u0011+g-Y;mi\u0006\u0013wN\u001d;US6,GmT;u)J\fgn]1di&|gn]%oi\u0016\u0014h/\u00197Ng\u0006YC)\u001a4bk2$\u0018IY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$XM\u001d<bY6\u001b\b%\u0001\u0018EK\u001a\fW\u000f\u001c;SK6|g/Z#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t\u0013:$XM\u001d<bY6\u001b\u0018a\f#fM\u0006,H\u000e\u001e*f[>4X-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:J]R,'O^1m\u001bN\u00043cA\u0006C/B\u0011\u0001lW\u0007\u00023*\u0011!lO\u0001\u0006kRLGn]\u0005\u00039f\u0013q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e\u0003!Q8n\u00117jK:$\bC\u00011d\u001b\u0005\t'B\u00012<\u0003\tQ8.\u0003\u0002eC\ni1*\u00194lCj[7\t\\5f]R\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005a;\u0017B\u00015Z\u0005%\u00196\r[3ek2,'/\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005-tW\"\u00017\u000b\u00055\\\u0014AB:feZ,'/\u0003\u0002pY\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw\r\u0005\u0002@e&\u00111o\u000e\u0002\u0012)J\fgn]1di&|gnQ8oM&<\u0017\u0001\u0002;j[\u0016\u0004\"A^@\u000e\u0003]T!A\u0017=\u000b\u0005eT\u0018AB2p[6|gN\u0003\u0002=w*\u0011A0`\u0001\u0007CB\f7\r[3\u000b\u0003y\f1a\u001c:h\u0013\r\t\ta\u001e\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\t\u0005\u001d\u00111B\u0007\u0003\u0003\u0013Q1!a\u0001y\u0013\u0011\ti!!\u0003\u0003\u000f5+GO]5dg\u0006Q\u0012N\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]B!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018m\n1!\u00199j\u0013\u0011\tY\"!\u0006\u0003\u0015\u0005\u0003\u0018NV3sg&|g\u000e\u0006\n\u0002 \u0005\u0005\u00121EA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0002CA \f\u0011\u0015iF\u00031\u0001M\u0011\u0015qF\u00031\u0001`\u0011\u0015)G\u00031\u0001g\u0011\u0015IG\u00031\u0001k\u0011\u0015\u0001H\u00031\u0001r\u0011\u0015!H\u00031\u0001v\u0011\u001d\t\u0019\u0001\u0006a\u0001\u0003\u000bAq!a\u0004\u0015\u0001\u0004\t\tB\u0001\fTK:$G\u000b\u001f8NCJ\\WM]:DC2d'-Y2l!9\u0019\u0015QGA\u001d\u0019\u0006=\u00131LA1\u0003OJ1!a\u000eE\u0005%1UO\\2uS>tW\u0007\u0005\u0003\u0002<\u0005%c\u0002BA\u001f\u0003\u000b\u00022!a\u0010E\u001b\t\t\tEC\u0002\u0002Du\na\u0001\u0010:p_Rt\u0014bAA$\t\u00061\u0001K]3eK\u001aLA!a\u0013\u0002N\t11\u000b\u001e:j]\u001eT1!a\u0012E!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+q\u0006A!/Z9vKN$8/\u0003\u0003\u0002Z\u0005M#!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];miB\u0019q(!\u0018\n\u0007\u0005}sGA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rE\u0002@\u0003GJ1!!\u001a8\u0005I!\u0006P\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\u0011\u0007\r\u000bI'C\u0002\u0002l\u0011\u0013A!\u00168ji\u0006a1\u000f[;ui&tw\rR8x]V\u0011\u0011\u0011\u000f\t\u0005\u0003g\n))\u0004\u0002\u0002v)!\u0011qOA=\u0003\u0019\tGo\\7jG*!\u00111PA?\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u007f\n\t)\u0001\u0003vi&d'BAAB\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0015Q\u000f\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u001bMDW\u000f\u001e;j]\u001e$un\u001e8!\u0003%\u0019H/\u0019;f\u0019>\u001c7.\u0006\u0002\u0002\u0010B!\u0011\u0011SAL\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006e\u0014!\u00027pG.\u001c\u0018\u0002BAM\u0003'\u0013aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\u000bgR\fG/\u001a'pG.\u0004\u0013!\u00057pC\u0012Lgn\u001a)beRLG/[8ogV\u0011\u0011\u0011\u0015\t\u0007\u0003G\u000bi+!-\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000bq!\\;uC\ndWMC\u0002\u0002,\u0012\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty+!*\u0003\u0007M+G\u000fE\u0002@\u0003gK1!!.8\u0005\t\"&/\u00198tC\u000e$\u0018n\u001c8QCJ$\u0018\u000e^5p]\u0006sG\rT3bI\u0016\u0014X\t]8dQ\u0006\u0011Bn\\1eS:<\u0007+\u0019:uSRLwN\\:!\u0003a!(/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003{\u0003r!a)\u0002@2\u000b\u0019-\u0003\u0003\u0002B\u0006\u0015&aA'baB\u0019q(!2\n\u0007\u0005\u001dwGA\u000bUq:lU\r^1eCR\f7)Y2iK\u0016sGO]=\u00023Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u001fiJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\fq\u0004\u001e:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;!\u0003M\u0001\u0018M\u001d;ji&|g\u000eT8bIN+gn]8s+\t\t\u0019\u000e\u0005\u0003\u0002\b\u0005U\u0017\u0002BAl\u0003\u0013\u0011aaU3og>\u0014\u0018\u0001\u00069beRLG/[8o\u0019>\fGmU3og>\u0014\b%A\nbI\u0012du.\u00193j]\u001e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002h\u0005}\u00171\u001d\u0005\u0007\u0003C\u0014\u0003\u0019\u0001'\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0007\u0003K\u0014\u0003\u0019\u0001'\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0017!D:uCR,'+Z1e\u0019>\u001c7.\u0006\u0002\u0002lB!\u0011Q^Az\u001b\t\tyO\u0003\u0003\u0002r\u0006M\u0015A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\n\t\u0005U\u0018q\u001e\u0002\t%\u0016\fG\rT8dW\u0006!B/[7fI>+H\u000f\u0016:b]N\f7\r^5p]N$\"!a?\u0011\r\u0005u(q\u0001B\u0007\u001d\u0011\tyPa\u0001\u000f\t\u0005}\"\u0011A\u0005\u0002\u000b&\u0019!Q\u0001#\u0002\u000fA\f7m[1hK&!!\u0011\u0002B\u0006\u0005!IE/\u001a:bE2,'b\u0001B\u0003\tB\u0019qHa\u0004\n\u0007\tEqGA\u0011Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0003:$\u0007K]8ek\u000e,'/\u00133Fa>\u001c\u0007.A\u0010f]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:$\"!a\u001a\u0002'\u001d,G\u000f\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0015\t\tm!\u0011\b\t\t\u0003{\u0014iB!\t\u0003.%!!q\u0004B\u0006\u0005\u0019)\u0015\u000e\u001e5feB!!1\u0005B\u0015\u001b\t\u0011)CC\u0002\u0003(a\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005W\u0011)C\u0001\u0004FeJ|'o\u001d\t\u0006\u0007\n=\"1G\u0005\u0004\u0005c!%AB(qi&|g\u000eE\u0002@\u0005kI1Aa\u000e8\u0005y\u0019un\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.\u00118e)btW*\u001a;bI\u0006$\u0018\rC\u0004\u0003<\u0019\u0002\r!!\u000f\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fa\u0004];u)J\fgn]1di&|gn\u0015;bi\u0016LeMT8u\u000bbL7\u000f^:\u0015\t\t\u0005#1\t\t\t\u0003{\u0014iB!\t\u00034!9!QI\u0014A\u0002\u0005m\u0013a\u0003;y]6+G/\u00193bi\u0006\fadZ3u\u0003:$W*Y=cK\u0006#G\r\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0015\r\tm!1\nB'\u0011\u001d\u0011Y\u0004\u000ba\u0001\u0003sAqAa\u0014)\u0001\u0004\u0011\t&A\u000bde\u0016\fG/\u001a3Uq:lU\r^1eCR\fw\n\u001d;\u0011\u000b\r\u0013y#a\u0017\u00029Y\fG.\u001b3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;NgR!!q\u000bB/!\r\u0019%\u0011L\u0005\u0004\u00057\"%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0005?J\u0003\u0019\u0001'\u0002\u0019QDh\u000eV5nK>,H/T:\u0002/Q\u0014\u0018M\\:bGRLwN\u001c+pa&\u001c7i\u001c8gS\u001e\u001cXC\u0001B3!\u0011\u00119G!\u001b\u000e\u0005\u0005u\u0014\u0002\u0002B6\u0003{\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u00031\u0001\u0018M\u001d;ji&|gNR8s)\ra%\u0011\u000f\u0005\b\u0005wY\u0003\u0019AA\u001d\u0003\u0005:W\r\u001e+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0003]aw.\u00193Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0003z\t}$1\u0012\t\b1\nm\u0014\u0011HA.\u0013\r\u0011i(\u0017\u0002\u0005!>|G\u000eC\u0004\u0003\u00026\u0002\rAa!\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!!Q\u0011BD\u001b\u0005A\u0018b\u0001BEq\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBAs[\u0001\u0007A*\u0001\u000fbI\u0012du.\u00193fIR\u0013\u0018M\\:bGRLwN\\:U_\u000e\u000b7\r[3\u0015\u0011\u0005\u001d$\u0011\u0013BK\u0005/CaAa%/\u0001\u0004a\u0015!\u0005;y]R{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011Q\u001d\u0018A\u00021CqA!'/\u0001\u0004\u0011I(\u0001\nm_\u0006$W\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0018\u0001\n7pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014H\u000b\u001f8U_BL7\rU1si&$\u0018n\u001c8\u0015\u0011\u0005\u001d$q\u0014BQ\u0005GCa!!90\u0001\u0004a\u0005BBAs_\u0001\u0007A\nC\u0004\u0003&>\u0002\rAa*\u0002\u001dM,g\u000e\u001a+y]6\u000b'o[3sgB\u0019!\u0011V\u000b\u000e\u0003-\taE]3n_Z,GK]1og\u0006\u001cG/[8og\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)\u0011\t9Ga,\t\r\u0005\u0005\b\u00071\u0001M)\u0019\t9Ga-\u00036\"1\u0011\u0011]\u0019A\u00021Ca!!:2\u0001\u0004a\u0015A\f<bY&$\u0017\r^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi&\u001b8\u000b^1cY\u0016\fa#\u00199qK:$GK]1og\u0006\u001cG/[8o)>dun\u001a\u000b\r\u0003O\u0012iLa0\u0003B\n\u0015'q\u001a\u0005\b\u0005w\u0019\u0004\u0019AA\u001d\u0011\u0019\t)o\ra\u0001\u0019\"9!1Y\u001aA\u0002\u0005\u0005\u0014a\u00038fo6+G/\u00193bi\u0006DqAa24\u0001\u0004\u0011I-\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB91Ia3\u0003\"\u0005\u001d\u0014b\u0001Bg\t\nIa)\u001e8di&|g.\r\u0005\n\u0005#\u001c\u0004\u0013!a\u0001\u0005'\fAB]3uef|e.\u0012:s_J\u0004ra\u0011Bf\u0005C\u00119&\u0001\u0011baB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8hI\u0011,g-Y;mi\u0012*TC\u0001BmU\u0011\u0011\u0019Na7,\u0005\tu\u0007\u0003\u0002Bp\u0005Sl!A!9\u000b\t\t\r(Q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa:E\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005W\u0014\tOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001b\u001d5vi\u0012|wO\u001c")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public ReentrantReadWriteLock.ReadLock stateReadLock() {
        return this.stateLock().readLock();
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        rpl.shaded.scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", () -> {
            long now = $this.time.milliseconds();
            Lock inReadLock_inLock_lock = this.stateLock().readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$enableTransactionalIdExpiration$2(this, now);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either2 = this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), new Some<TransactionMetadata>(txnMetadata));
        if (either2 == null) {
            throw null;
        }
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> right_this = either2;
        Object var6_2 = null;
        Either.RightProjection<Errors, Option<CoordinatorEpochAndTxnMetadata>> map_this = new Either.RightProjection<Errors, Option<CoordinatorEpochAndTxnMetadata>>(right_this);
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either3 = map_this.e();
        if (either3 instanceof Right) {
            Object map_b = ((Right)either3).value();
            Option option = (Option)map_b;
            either = new Right<Errors, CoordinatorEpochAndTxnMetadata>(TransactionStateManager.$anonfun$putTransactionStateIfNotExists$1(txnMetadata, option));
        } else {
            either = map_this.e();
        }
        return either;
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)this.config.transactionLogMinInsyncReplicas()).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)this.config.transactionLogSegmentBytes()).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs(transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        Option<Object> option = this.zkClient.getTopicPartitionCount("__transaction_state");
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToInteger(this.config.transactionLogNumPartitions()) : getOrElse_this.get();
        Object object2 = object;
        Object var1_1 = null;
        object = null;
        return BoxesRunTime.unboxToInt(object2);
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        long startMs = this.time.milliseconds();
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>(None$.MODULE$);
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String> & Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            LongRef longRef;
            Log log = (Log)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            long create_e = log.logStartOffset();
            LongRef longRef2 = longRef = new LongRef(create_e);
            longRef = null;
            LongRef currOffset = longRef2;
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var22_20 = null;
                    Object var23_21 = null;
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true);
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").toString()).append(new StringBuilder(58).append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString()).toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords(buffer);
                    } else {
                        throw new MatchError(records);
                    }
                    ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memoryRecords.batches()).asScala()).foreach((Function1<MutableRecordBatch, Object> & Serializable)batch -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$6(loadedTransactions, currOffset, batch);
                        return BoxedUnit.UNIT;
                    });
                    long endMs = this.time.milliseconds();
                    long timeLapse = endMs - startMs;
                    this.partitionLoadSensor().record(timeLapse, endMs, false);
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(61).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(timeLapse).append(" milliseconds").toString());
                }
            }
            catch (Throwable t) {
                this.error((Function0<String> & Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable> & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        Option<TxnMetadataCacheEntry> previousTxnMetadataCacheEntryOpt = this.transactionMetadataCache().put(txnTopicPartition, txnMetadataCacheEntry);
        if (previousTxnMetadataCacheEntryOpt == null) {
            throw null;
        }
        if (!previousTxnMetadataCacheEntryOpt.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry2 = previousTxnMetadataCacheEntryOpt.get();
            this.warn((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").toString()).append(new StringBuilder(26).append("loading metadata at epoch ").append(coordinatorEpoch$2).toString()).toString());
        }
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var6_6 = null;
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), () -> this.loadTransactions$1(topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        timestamp = this.time.milliseconds();
        var17_9 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
        withRecords_magic = 2;
        var23_12 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        v0 = var24_14 = MemoryRecords.withRecords(withRecords_magic, withRecords_initialOffset, withRecords_compressionType, (TimestampType)withRecords_timestampType, -1L, (short)-1, -1, -1, false, (SimpleRecord[])withRecords_records);
        var23_12 = null;
        var24_14 = null;
        v1 = var20_15 = v0;
        var20_15 = null;
        v2 = var18_16 = v1;
        var16_10 = null;
        var17_9 = null;
        var18_16 = null;
        records = v2;
        topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        v3 = Predef$.MODULE$.Map();
        v4 = new Tuple2[1];
        v4[0] = new Tuple2<TopicPartition, MemoryRecords>(topicPartition, records);
        var13_19 = ScalaRunTime$.MODULE$.wrapRefArray(v4);
        if (v3 == null) {
            throw null;
        }
        var13_19 = null;
        recordsPerPartition = (rpl.shaded.scala.collection.immutable.Map)MapFactory.apply$(v3, (Seq)apply_elems);
        inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block11: {
                block10: {
                    var25_22 = false;
                    var26_23 = null;
                    var27_24 = this.getTransactionState(transactionalId);
                    if (!(var27_24 instanceof Left)) break block10;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var27_24).value();
                    responseCallback.apply($anonfun$appendTransactionToLog$13_err);
                    break block11;
                }
                if (!(var27_24 instanceof Right)) ** GOTO lbl-1000
                var25_22 = true;
                var26_23 = (Right)var27_24;
                var29_26 = (Option)var26_23.value();
                if (None$.MODULE$.equals(var29_26)) {
                    responseCallback.apply(Errors.NOT_COORDINATOR);
                } else if (var25_22 && (var30_27 = (Option)var26_23.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var30_27).value();
                    if (BoxesRunTime.unboxToBoolean($anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((JFunction0$mcZ$sp)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$appendTransactionToLog$14(rpl.shaded.kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int rpl.shaded.scala.Function1 ), ()Z)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, recordsPerPartition, (Function1<rpl.shaded.scala.collection.Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1<rpl.shaded.scala.collection.Map, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(rpl.shaded.kafka.coordinator.transaction.TransactionStateManager rpl.shaded.org.apache.kafka.common.TopicPartition java.lang.String rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata int rpl.shaded.scala.Function1 rpl.shaded.scala.Function1 rpl.shaded.scala.collection.Map ), (Lrpl/shaded/scala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicPartition)topicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback), new Some<Lock>(this.stateLock().readLock()), this.replicaManager.appendRecords$default$8());
                        this.trace((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var27_24);
                }
            }
            var26_23 = null;
            var27_24 = null;
            var28_25 = null;
            var29_26 = null;
            var30_27 = null;
            var31_28 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1<Errors, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$5));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String> & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add(partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError((Object)null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ rpl.shaded.scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (rpl.shaded.scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1<Tuple2, TransactionalIdAndProducerIdEpoch> & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError((Object)null);
                }
                String txnId = (String)x0$3._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            });
            return iterableOnce;
        });
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionState transactionState = ((TransactionMetadata)x0$2._2()).state();
            boolean bl2 = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
            bl = bl2;
        } else {
            throw new MatchError((Object)null);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError((Object)null);
        }
        boolean bl = ((TransactionMetadata)x0$3._2()).txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$12(TransactionStateManager $this, rpl.shaded.scala.collection.immutable.Map transactionalIdByPartition$1, TopicPartition topicPartition$1, ProduceResponse.PartitionResponse response$1) {
        rpl.shaded.scala.collection.mutable.Iterable toRemove = (rpl.shaded.scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply(topicPartition$1.partition());
        Option option = $this.transactionMetadataCache().get(topicPartition$1.partition());
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            toRemove.foreach((Function1<TransactionalIdCoordinatorEpochAndMetadata, Object> & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0<Object> & Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains(Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).toString()).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append((Object)response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf((Object)idCoordinatorEpochAndMetadata.coordinatorEpoch())).toString());
                    txnMetadata.pendingState_$eq(None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
        }
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$11(TransactionStateManager $this, rpl.shaded.scala.collection.immutable.Map transactionalIdByPartition$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)x0$1._2();
            Lock inReadLock_inLock_lock = $this.stateLock().readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$enableTransactionalIdExpiration$12($this, transactionalIdByPartition$1, topicPartition, response);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
            return;
        }
        throw new MatchError((Object)null);
    }

    private final void removeFromCacheCallback$1(rpl.shaded.scala.collection.Map responses, rpl.shaded.scala.collection.immutable.Map transactionalIdByPartition$1) {
        responses.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$11(this, transactionalIdByPartition$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$2(TransactionStateManager $this, long now$2) {
        rpl.shaded.scala.collection.immutable.Map transactionalIdByPartition = ((IterableOps)$this.transactionMetadataCache().flatMap((Function1<Tuple2, Iterable> & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)x0$1._2();
            Iterable iterable = (Iterable)((IterableOps)((IterableOps)entry.metadataPerTransactionalId().filter((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$2)))).filter((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5($this, now$2, x0$3)))).map((Function1<Tuple2, TransactionalIdCoordinatorEpochAndMetadata> & Serializable)x0$4 -> {
                if (x0$4 == null) {
                    throw new MatchError((Object)null);
                }
                String transactionalId = (String)x0$4._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$4._2();
                TxnTransitMetadata txnMetadataTransition = (TxnTransitMetadata)txnMetadata.inLock((Function0<TxnTransitMetadata> & Serializable)() -> txnMetadata.prepareDead());
                TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                return transactionalIdCoordinatorEpochAndMetadata;
            });
            return iterable;
        })).groupBy((Function1<TransactionalIdCoordinatorEpochAndMetadata, Object> & Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger($this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
        rpl.shaded.scala.collection.immutable.Map recordsPerPartition = (rpl.shaded.scala.collection.immutable.Map)transactionalIdByPartition.map((Function1<Tuple2, Tuple2> & Serializable)x0$5 -> {
            MemoryRecords memoryRecords;
            MemoryRecords memoryRecords2;
            void withRecords_timestampType;
            MemoryRecords memoryRecords3;
            if (x0$5 == null) {
                throw new MatchError((Object)null);
            }
            int partition = x0$5._1$mcI$sp();
            SimpleRecord[] deletes = (SimpleRecord[])((IterableOnceOps)((rpl.shaded.scala.collection.mutable.Iterable)x0$5._2()).map((Function1<TransactionalIdCoordinatorEpochAndMetadata, SimpleRecord> & Serializable)entry -> new SimpleRecord(now$2, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            CompressionType withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
            byte withRecords_magic = 2;
            TimestampType timestampType = TimestampType.CREATE_TIME;
            long withRecords_initialOffset = 0L;
            MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords(withRecords_magic, withRecords_initialOffset, withRecords_compressionType, (TimestampType)withRecords_timestampType, -1L, (short)-1, -1, -1, false, deletes);
            timestampType = null;
            memoryRecords3 = null;
            MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
            memoryRecords2 = null;
            MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
            Object var8_4 = null;
            memoryRecords = null;
            MemoryRecords records = memoryRecords6;
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
            Tuple2<TopicPartition, MemoryRecords> tuple2 = new Tuple2<TopicPartition, MemoryRecords>(topicPartition, records);
            return tuple2;
        });
        $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, recordsPerPartition, (Function1<rpl.shaded.scala.collection.Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1<rpl.shaded.scala.collection.Map, Object> & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
            return BoxedUnit.UNIT;
        }, new Some<Lock>($this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
    }

    public static final /* synthetic */ Nothing$ $anonfun$putTransactionStateIfNotExists$2(TransactionMetadata txnMetadata$3) {
        throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata$3).toString());
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$putTransactionStateIfNotExists$1(TransactionMetadata txnMetadata$3, Option x$1) {
        if (x$1 == null) {
            throw null;
        }
        if (x$1.isEmpty()) {
            throw TransactionStateManager.$anonfun$putTransactionStateIfNotExists$2(txnMetadata$3);
        }
        return (CoordinatorEpochAndTxnMetadata)x$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$2) {
        return x$2.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ TransactionMetadata $anonfun$getAndMaybeAddTransactionState$5(TransactionMetadata createdTxnMetadata$1) {
        return createdTxnMetadata$1;
    }

    public static final /* synthetic */ TransactionMetadata $anonfun$getAndMaybeAddTransactionState$4(TxnMetadataCacheEntry cacheEntry$1, String transactionalId$2, TransactionMetadata createdTxnMetadata) {
        Option<TransactionMetadata> option = Option$.MODULE$.apply(cacheEntry$1.metadataPerTransactionalId().putIfNotExists(transactionalId$2, createdTxnMetadata));
        if (option == null) {
            throw null;
        }
        Option<TransactionMetadata> getOrElse_this = option;
        TransactionMetadata transactionMetadata = getOrElse_this.isEmpty() ? createdTxnMetadata : getOrElse_this.get();
        return transactionMetadata;
    }

    public static final /* synthetic */ Option $anonfun$getAndMaybeAddTransactionState$3(Option createdTxnMetadataOpt$1, TxnMetadataCacheEntry cacheEntry$1, String transactionalId$2) {
        Option option;
        if (createdTxnMetadataOpt$1.isEmpty()) {
            option = None$.MODULE$;
        } else {
            TransactionMetadata transactionMetadata = (TransactionMetadata)createdTxnMetadataOpt$1.get();
            option = new Some<TransactionMetadata>(TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$4(cacheEntry$1, transactionalId$2, transactionMetadata));
        }
        return option;
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$getAndMaybeAddTransactionState$6(TxnMetadataCacheEntry cacheEntry$1, TransactionMetadata x$3) {
        return new CoordinatorEpochAndTxnMetadata(cacheEntry$1.coordinatorEpoch(), x$3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$2, Option createdTxnMetadataOpt$1) {
        Either either;
        int partitionId = $this.partitionFor(transactionalId$2);
        if ($this.loadingPartitions().exists((Function1<TransactionPartitionAndLeaderEpoch, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$2)))) {
            void apply_value;
            Errors errors = Errors.COORDINATOR_LOAD_IN_PROGRESS;
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            return new Left(apply_value);
        }
        Option option = $this.transactionMetadataCache().get(partitionId);
        if (option instanceof Some) {
            void apply_value;
            Right right;
            Option option2;
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option option3 = Option$.MODULE$.apply(cacheEntry.metadataPerTransactionalId().get(transactionalId$2));
            if (option3 == null) {
                throw null;
            }
            Option orElse_this = option3;
            Option option4 = orElse_this.isEmpty() ? TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(createdTxnMetadataOpt$1, cacheEntry, transactionalId$2) : orElse_this;
            Option option5 = option4;
            Object var8_7 = null;
            option4 = null;
            Option txnMetadata = option5;
            Right$ right$ = package$.MODULE$.Right();
            if (txnMetadata == null) {
                throw null;
            }
            if (txnMetadata.isEmpty()) {
                option2 = None$.MODULE$;
            } else {
                TransactionMetadata transactionMetadata = (TransactionMetadata)txnMetadata.get();
                option2 = new Some<CoordinatorEpochAndTxnMetadata>(TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$6(cacheEntry, transactionMetadata));
            }
            None$ none$ = option2;
            option2 = null;
            None$ none$2 = none$;
            if (right$ == null) {
                throw null;
            }
            Right right2 = right = new Right(apply_value);
            none$2 = null;
            right = null;
            either = right2;
        } else if (None$.MODULE$.equals(option)) {
            void apply_value;
            Left left;
            Errors errors = Errors.NOT_COORDINATOR;
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            Left left2 = left = new Left(apply_value);
            errors = null;
            left = null;
            either = left2;
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    public static final /* synthetic */ long $anonfun$loadTransactionMetadata$1() {
        return -1L;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        Object object;
        Option<Object> option = this.replicaManager.getLogEndOffset(topicPartition$2);
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            Long l;
            Long l2 = l = Long.valueOf(-1L);
            l = null;
            object = l2;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var2_2 = null;
        object = null;
        return BoxesRunTime.unboxToLong(object2);
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1<TransactionPartitionAndLeaderEpoch, Object> & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean(TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ String $anonfun$loadTransactionMetadata$8() {
        return "Transaction state log's key should not be null";
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        if (!record.hasKey()) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Transaction state log's key should not be null").toString());
        }
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$6(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch) {
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach((Function1<Record, Object> & Serializable)record -> {
            TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions$1, currOffset$1, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add(partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$3(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function5 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains(partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError((Object)null);
                }
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                Object t = txnMetadata.inLock((Function0<Object> & Serializable)() -> {
                    Object object;
                    TransactionState transactionState = txnMetadata.state();
                    if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        Growable growable;
                        Growable growable2;
                        Growable growable3;
                        void $plus$eq_elem;
                        Growable growable4;
                        TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                        if (transactionsPendingForCompletion == null) {
                            throw null;
                        }
                        Growable growable5 = growable4 = transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                        growable4 = null;
                        Growable growable6 = growable3 = growable5;
                        growable3 = null;
                        Growable growable7 = growable2 = growable6;
                        growable2 = null;
                        Growable growable8 = growable = growable7;
                        transactionalIdCoordinatorEpochAndTransitMetadata = null;
                        growable = null;
                        object = growable8;
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        Growable growable;
                        Growable growable9;
                        Growable growable10;
                        void $plus$eq_elem;
                        Growable growable11;
                        TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                        if (transactionsPendingForCompletion == null) {
                            throw null;
                        }
                        Growable growable12 = growable11 = transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                        growable11 = null;
                        Growable growable13 = growable10 = growable12;
                        growable10 = null;
                        Growable growable14 = growable9 = growable13;
                        growable9 = null;
                        Growable growable15 = growable = growable14;
                        transactionalIdCoordinatorEpochAndTransitMetadata = null;
                        growable = null;
                        object = growable15;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                return t;
            });
            $this.loadingPartitions().remove(partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1<TransactionalIdCoordinatorEpochAndTransitMetadata, Object> & Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply(txnTransitMetadata.transactionalId(), txnTransitMetadata.coordinatorEpoch(), txnTransitMetadata.result(), txnTransitMetadata.txnMetadata(), txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
        }
    }

    private final void loadTransactions$1(TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function5 sendTxnMarkers$1) {
        this.info((Function0<String> & Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains(partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$3_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError((Object)null);
                    }
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    Object t = txnMetadata.inLock((Function0<Object> & Serializable)() -> {
                        Object object;
                        TransactionState transactionState = txnMetadata.state();
                        if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            Growable growable;
                            Growable growable2;
                            Growable growable3;
                            void $plus$eq_elem;
                            Growable growable4;
                            TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                            if (transactionsPendingForCompletion == null) {
                                throw null;
                            }
                            Growable growable5 = growable4 = transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                            growable4 = null;
                            Growable growable6 = growable3 = growable5;
                            growable3 = null;
                            Growable growable7 = growable2 = growable6;
                            growable2 = null;
                            Growable growable8 = growable = growable7;
                            transactionalIdCoordinatorEpochAndTransitMetadata = null;
                            growable = null;
                            object = growable8;
                        } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            Growable growable;
                            Growable growable9;
                            Growable growable10;
                            void $plus$eq_elem;
                            Growable growable11;
                            TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                            if (transactionsPendingForCompletion == null) {
                                throw null;
                            }
                            Growable growable12 = growable11 = transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                            growable11 = null;
                            Growable growable13 = growable10 = growable12;
                            growable10 = null;
                            Growable growable14 = growable9 = growable13;
                            growable9 = null;
                            Growable growable15 = growable = growable14;
                            transactionalIdCoordinatorEpochAndTransitMetadata = null;
                            growable = null;
                            object = growable15;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    });
                    return t;
                });
                this.loadingPartitions().remove(partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$3_transactionsPendingForCompletion.foreach((Function1<TransactionalIdCoordinatorEpochAndTransitMetadata, Object> & Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply(txnTransitMetadata.transactionalId(), txnTransitMetadata.coordinatorEpoch(), txnTransitMetadata.result(), txnTransitMetadata.txnMetadata(), txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
            Object var8_7 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var6_6 = null;
        this.info((Function0<String> & Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() != partitionId$2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        void retain_p;
        Set<TransactionPartitionAndLeaderEpoch> set = $this.loadingPartitions();
        Function1<TransactionPartitionAndLeaderEpoch, Object> & Serializable intersect = (Function1<TransactionPartitionAndLeaderEpoch, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$4));
        if (set == null) {
            throw null;
        }
        set.filterInPlace((Function1<TransactionPartitionAndLeaderEpoch, Object>)retain_p);
        intersect = null;
        Option option = $this.transactionMetadataCache().remove(partitionId$2);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            $this.info((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").toString()).append("local partition deletion").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove(partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove(partitionId$3);
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String> & Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String> & Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$4, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$4).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$4, Errors err$1) {
        return new StringBuilder(0).append(new StringBuilder(63).append("Accessing the cached transaction metadata for ").append(transactionalId$4).append(" returns ").append((Object)err$1).append(" error; ").toString()).append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(83).append("The cached coordinator epoch for ").append(transactionalId$4).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append((Object)Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String> & Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$4).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$4).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(0).append(new StringBuilder(106).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$4).append(" after appended its new metadata ").append(newMetadata$1).append(" ").toString()).append(new StringBuilder(78).append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").toString()).append(new StringBuilder(70).append("aborting transition to the new metadata and returning ").append((Object)Errors.NOT_COORDINATOR).append(" in the callback").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean(retryOnError$1.apply((Errors)((Object)responseError$1.elem)))) {
                $this.info((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Object)((Errors)((Object)((Object)responseError$1.elem)))).append(", ").toString()).append(new StringBuilder(97).append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString()).toString());
                return;
            }
            $this.info((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Object)((Errors)((Object)((Object)responseError$1.elem)))).append(", ").toString()).append(new StringBuilder(87).append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Object)((Errors)((Object)((Object)responseError$1.elem)))).append(" in the callback").toString()).toString());
            metadata$2.pendingState_$eq(None$.MODULE$);
            return;
        }
        $this.info((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Object)((Errors)((Object)((Object)responseError$1.elem)))).append(", ").toString()).append(new StringBuilder(115).append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString()).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Object)((Errors)((Object)responseError$1.elem))).append(", ").toString()).append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(0).append(new StringBuilder(72).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Object)((Errors)((Object)responseError$1.elem))).append(", ").toString()).append(new StringBuilder(101).append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append((Object)error$1).toString()).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(rpl.shaded.scala.collection.Map responseStatus, TopicPartition topicPartition$6, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block15: {
            block13: {
                block17: {
                    block16: {
                        block14: {
                            if (responseStatus.size() != 1 || !responseStatus.contains(topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension("Append status %s should only have one partition %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply(topicPartition$6);
                            v0 = status.error;
                            var14_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals((Object)var14_9) == false : var14_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata rpl.shaded.org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var15_10 = status.error;
                                var11_11 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals((Object)var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals((Object)var15_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals((Object)var15_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals((Object)var15_10) != false));
                                if (var11_11) {
                                    var8_12 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_13 = Errors.NOT_LEADER_FOR_PARTITION.equals((Object)var15_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals((Object)var15_10) != false;
                                    if (var10_13) {
                                        var8_12 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_14 = Errors.MESSAGE_TOO_LARGE.equals((Object)var15_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals((Object)var15_10) != false;
                                        var8_12 = var9_14 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_10;
                                    }
                                }
                                v1 = var8_12;
                            }
                            create_e = v1;
                            var33_15 = null;
                            responseError = new ObjectRef<Errors>(create_e);
                            v2 = (Errors)responseError.elem;
                            var16_17 = Errors.NONE;
                            if (v2 != null ? v2.equals((Object)var16_17) == false : var16_17 != null) break block13;
                            var17_18 = false;
                            var18_19 = null;
                            var19_20 = this.getTransactionState(transactionalId$4);
                            if (!(var19_20 instanceof Left)) break block14;
                            err = (Errors)((Left)var19_20).value();
                            this.info((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String rpl.shaded.org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)err));
                            responseError.elem = err;
                            break block15;
                        }
                        if (!(var19_20 instanceof Right)) break block16;
                        var17_18 = true;
                        var18_19 = (Right)var19_20;
                        var21_22 = (Option)var18_19.value();
                        if (!(var21_22 instanceof Some)) break block16;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_22).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0$mcV$sp)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(rpl.shaded.kafka.coordinator.transaction.TransactionStateManager rpl.shaded.kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata rpl.shaded.scala.runtime.ObjectRef rpl.shaded.kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, responseError, (TransactionMetadata)metadata));
                        break block15;
                    }
                    if (!var17_18 || !None$.MODULE$.equals(var24_25 = (Option)var18_19.value())) break block17;
                    this.info((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(rpl.shaded.kafka.coordinator.transaction.TransactionStateManager java.lang.String rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block15;
                }
                throw new MatchError(var19_20);
            }
            var25_26 = false;
            var26_27 = null;
            var27_28 = this.getTransactionState(transactionalId$4);
            if (!(var27_28 instanceof Right)) ** GOTO lbl-1000
            var25_26 = true;
            var26_27 = (Right)var27_28;
            var28_29 = (Option)var26_27.value();
            if (var28_29 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_29).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0$mcV$sp)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(rpl.shaded.kafka.coordinator.transaction.TransactionStateManager rpl.shaded.kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int rpl.shaded.scala.Function1 rpl.shaded.scala.runtime.ObjectRef rpl.shaded.kafka.coordinator.transaction.TransactionMetadata rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_26 && None$.MODULE$.equals(var31_32 = (Option)var26_27.value())) {
                this.info((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata rpl.shaded.scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, responseError));
            } else if (var27_28 instanceof Left) {
                error = (Errors)((Left)var27_28).value();
                this.info((Function0<String> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String rpl.shaded.kafka.coordinator.transaction.TxnTransitMetadata rpl.shaded.scala.runtime.ObjectRef rpl.shaded.org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, responseError, (Errors)error));
            } else {
                throw new MatchError(var27_28);
            }
        }
        responseCallback$1.apply((Errors)responseError.elem);
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$4, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, rpl.shaded.scala.collection.immutable.Map recordsPerPartition$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$4);
        if (either instanceof Left) {
            Errors err = (Errors)((Object)((Left)either).value());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply(err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply(Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock(() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply(Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                $this.replicaManager.appendRecords(newMetadata$1.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, recordsPerPartition$1, (Function1<rpl.shaded.scala.collection.Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1<rpl.shaded.scala.collection.Map, Object> & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, topicPartition$6, transactionalId$4, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                }, new Some<Lock>($this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
                $this.trace((Function0<String> & Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$4).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$5) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics, ApiVersion interBrokerProtocolVersion) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        this.transactionMetadataCache = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        this.partitionLoadSensor = metrics.sensor("PartitionLoadTime");
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", "transaction-coordinator-metrics", "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", "transaction-coordinator-metrics", "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    public static final /* synthetic */ Object $anonfun$addLoadedTransactionsToCache$1$adapted(TransactionStateManager $this, int txnTopicPartition$1, int coordinatorEpoch$2, TxnMetadataCacheEntry previousTxnMetadataCacheEntry) {
        $this.warn((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").toString()).append(new StringBuilder(26).append("loading metadata at epoch ").append(coordinatorEpoch$2).toString()).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$enableTransactionalIdExpiration$13$adapted(TransactionStateManager $this, rpl.shaded.scala.collection.mutable.Iterable toRemove$1, ProduceResponse.PartitionResponse response$1, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        toRemove$1.foreach((Function1<TransactionalIdCoordinatorEpochAndMetadata, Object> & Serializable)idCoordinatorEpochAndMetadata -> {
            String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
            TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
            return txnMetadata.inLock((Function0<Object> & Serializable)() -> {
                if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains(Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                    Errors errors = response$1.error;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                        return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                    }
                }
                $this.warn((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Failed to remove expired transactionalId: ").append(transactionalId).toString()).append(new StringBuilder(43).append(" from cache. Tombstone append error code: ").append((Object)response$1.error).append(",").toString()).append(new StringBuilder(33).append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").toString()).append(new StringBuilder(26).append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").toString()).append(new StringBuilder(48).append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").toString()).append(String.valueOf((Object)idCoordinatorEpochAndMetadata.coordinatorEpoch())).toString());
                txnMetadata.pendingState_$eq(None$.MODULE$);
                return BoxedUnit.UNIT;
            });
        });
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$removeTransactionsForTxnTopicPartition$3$adapted(TransactionStateManager $this, TopicPartition topicPartition$4, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        $this.info((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").toString()).append("local partition deletion").toString());
        return BoxedUnit.UNIT;
    }
}

