/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.coordinator.group;

import rpl.shaded.kafka.coordinator.group.DelayedHeartbeat;
import rpl.shaded.kafka.coordinator.group.DelayedJoin;
import rpl.shaded.kafka.coordinator.group.GroupConfig;
import rpl.shaded.kafka.coordinator.group.GroupCoordinator;
import rpl.shaded.kafka.coordinator.group.GroupMetadataManager;
import rpl.shaded.kafka.coordinator.group.GroupSummary;
import rpl.shaded.kafka.coordinator.group.LeaveGroupResult;
import rpl.shaded.kafka.coordinator.group.LeaveMemberResponse;
import rpl.shaded.kafka.coordinator.group.MemberSummary;
import rpl.shaded.kafka.coordinator.group.OffsetConfig;
import rpl.shaded.kafka.server.DelayedOperationPurgatory;
import rpl.shaded.kafka.server.DelayedOperationPurgatory$;
import rpl.shaded.kafka.server.KafkaConfig;
import rpl.shaded.kafka.server.ReplicaManager;
import rpl.shaded.kafka.zk.KafkaZkClient;
import rpl.shaded.org.apache.kafka.common.message.LeaveGroupRequestData;
import rpl.shaded.org.apache.kafka.common.metrics.Metrics;
import rpl.shaded.org.apache.kafka.common.protocol.Errors;
import rpl.shaded.org.apache.kafka.common.utils.Time;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.collection.immutable.List;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.runtime.BoxesRunTime;

public final class GroupCoordinator$ {
    public static final GroupCoordinator$ MODULE$ = new GroupCoordinator$();
    private static final String NoState = "";
    private static final String NoProtocolType = "";
    private static final String NoProtocol = "";
    private static final String NoLeader = "";
    private static final int NoGeneration = -1;
    private static final List<MemberSummary> NoMembers = Nil$.MODULE$;
    private static final GroupSummary EmptyGroup = new GroupSummary(MODULE$.NoState(), MODULE$.NoProtocolType(), MODULE$.NoProtocol(), MODULE$.NoMembers());
    private static final GroupSummary DeadGroup = new GroupSummary("Dead", MODULE$.NoProtocolType(), MODULE$.NoProtocol(), MODULE$.NoMembers());
    private static final int NewMemberJoinTimeoutMs = 300000;

    public String NoState() {
        return NoState;
    }

    public String NoProtocolType() {
        return NoProtocolType;
    }

    public String NoProtocol() {
        return NoProtocol;
    }

    public String NoLeader() {
        return NoLeader;
    }

    public int NoGeneration() {
        return NoGeneration;
    }

    public List<MemberSummary> NoMembers() {
        return NoMembers;
    }

    public GroupSummary EmptyGroup() {
        return EmptyGroup;
    }

    public GroupSummary DeadGroup() {
        return DeadGroup;
    }

    public int NewMemberJoinTimeoutMs() {
        return NewMemberJoinTimeoutMs;
    }

    public GroupCoordinator apply(KafkaConfig config, KafkaZkClient zkClient, ReplicaManager replicaManager, Time time, Metrics metrics) {
        DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory = DelayedOperationPurgatory$.MODULE$.apply("Heartbeat", config.brokerId(), 1000, true, true);
        DelayedOperationPurgatory<DelayedJoin> joinPurgatory = DelayedOperationPurgatory$.MODULE$.apply("Rebalance", config.brokerId(), 1000, true, true);
        return this.apply(config, zkClient, replicaManager, heartbeatPurgatory, joinPurgatory, time, metrics);
    }

    public OffsetConfig offsetConfig(KafkaConfig config) {
        return new OffsetConfig(BoxesRunTime.unboxToInt(config.offsetMetadataMaxSize()), BoxesRunTime.unboxToInt(config.offsetsLoadBufferSize()), (long)BoxesRunTime.unboxToInt(config.offsetsRetentionMinutes()) * 60L * 1000L, BoxesRunTime.unboxToLong(config.offsetsRetentionCheckIntervalMs()), BoxesRunTime.unboxToInt(config.offsetsTopicPartitions()), BoxesRunTime.unboxToInt(config.offsetsTopicSegmentBytes()), BoxesRunTime.unboxToShort(config.offsetsTopicReplicationFactor()), config.offsetsTopicCompressionCodec(), BoxesRunTime.unboxToInt(config.offsetCommitTimeoutMs()), BoxesRunTime.unboxToShort(config.offsetCommitRequiredAcks()));
    }

    public GroupCoordinator apply(KafkaConfig config, KafkaZkClient zkClient, ReplicaManager replicaManager, DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory, DelayedOperationPurgatory<DelayedJoin> joinPurgatory, Time time, Metrics metrics) {
        OffsetConfig offsetConfig = this.offsetConfig(config);
        GroupConfig groupConfig = new GroupConfig(BoxesRunTime.unboxToInt(config.groupMinSessionTimeoutMs()), BoxesRunTime.unboxToInt(config.groupMaxSessionTimeoutMs()), BoxesRunTime.unboxToInt(config.groupMaxSize()), BoxesRunTime.unboxToInt(config.groupInitialRebalanceDelay()));
        GroupMetadataManager groupMetadataManager = new GroupMetadataManager(config.brokerId(), config.interBrokerProtocolVersion(), offsetConfig, replicaManager, zkClient, time, metrics);
        return new GroupCoordinator(config.brokerId(), groupConfig, offsetConfig, groupMetadataManager, heartbeatPurgatory, joinPurgatory, time, metrics);
    }

    public LeaveMemberResponse kafka$coordinator$group$GroupCoordinator$$memberLeaveError(LeaveGroupRequestData.MemberIdentity memberIdentity, Errors error) {
        return new LeaveMemberResponse(memberIdentity.memberId(), Option$.MODULE$.apply(memberIdentity.groupInstanceId()), error);
    }

    public LeaveGroupResult kafka$coordinator$group$GroupCoordinator$$leaveError(Errors topLevelError, List<LeaveMemberResponse> memberResponses) {
        return new LeaveGroupResult(topLevelError, memberResponses);
    }

    private GroupCoordinator$() {
    }
}

