/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.controller;

import java.io.Serializable;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.api.LeaderAndIsr;
import rpl.shaded.kafka.controller.ControllerContext;
import rpl.shaded.kafka.controller.LeaderIsrAndControllerEpoch;
import rpl.shaded.kafka.controller.NewPartition$;
import rpl.shaded.kafka.controller.OfflinePartition$;
import rpl.shaded.kafka.controller.OfflinePartitionLeaderElectionStrategy;
import rpl.shaded.kafka.controller.OnlinePartition$;
import rpl.shaded.kafka.controller.PartitionLeaderElectionStrategy;
import rpl.shaded.kafka.controller.PartitionState;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.collection.IterableFactory;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.Map;
import rpl.shaded.scala.collection.Set;
import rpl.shaded.scala.collection.immutable.ArraySeq;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.immutable.Set$;
import rpl.shaded.scala.reflect.ScalaSignature;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.ScalaRunTime$;
import rpl.shaded.scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005u4Qa\u0003\u0007\u0002\u0002EA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006Y\u0001!\t\u0001\u000b\u0005\u0006[\u0001!\t\u0001\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0006y\u0001!I!\u0010\u0005\u0006#\u0002!I\u0001\u000b\u0005\u0006%\u0002!\ta\u0015\u0005\u0006%\u00021\tA\u001d\u0002\u0016!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0015\tia\"\u0001\u0006d_:$(o\u001c7mKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005eaR\"\u0001\u000e\u000b\u0005mq\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005\u001daunZ4j]\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\t\u0001\u0013%D\u0001\r\u0013\t\u0011CBA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\fa\u0001P5oSRtDCA\u0013'!\t\u0001\u0003\u0001C\u0003\u001f\u0005\u0001\u0007q$A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003%\u0002\"a\u0005\u0016\n\u0005-\"\"\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\"iJLwmZ3s\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]N#\u0018\r^3DQ\u0006tw-\u001a\u000b\u0003S=BQ\u0001\r\u0004A\u0002E\nQ\u0001^8qS\u000e\u0004\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b\u0015\u001b\u0005)$B\u0001\u001c\u0011\u0003\u0019a$o\\8u}%\u0011\u0001\bF\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029)\u0005)CO]5hO\u0016\u0014xJ\u001c7j]\u0016\u001cF/\u0019;f\u0007\"\fgnZ3G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003SyBQaP\u0004A\u0002\u0001\u000b!\u0002]1si&$\u0018n\u001c8t!\r\tEIR\u0007\u0002\u0005*\u00111\tF\u0001\u000bG>dG.Z2uS>t\u0017BA#C\u0005\r\u0019V\r\u001e\t\u0003\u000f>k\u0011\u0001\u0013\u0006\u0003\u0013*\u000baaY8n[>t'BA\bL\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005AC%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0019S:LG/[1mSj,\u0007+\u0019:uSRLwN\\*uCR,\u0017A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$2\u0001V5n!\u0011\tUKR,\n\u0005Y\u0013%aA'baB!\u0001,\u00181d\u001d\tI6L\u0004\u000255&\tQ#\u0003\u0002])\u00059\u0001/Y2lC\u001e,\u0017B\u00010`\u0005\u0019)\u0015\u000e\u001e5fe*\u0011A\f\u0006\t\u00031\u0006L!AY0\u0003\u0013QC'o\\<bE2,\u0007C\u00013h\u001b\u0005)'B\u00014\u000f\u0003\r\t\u0007/[\u0005\u0003Q\u0016\u0014A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJDQaP\u0005A\u0002)\u00042!Q6G\u0013\ta'IA\u0002TKFDQA\\\u0005A\u0002=\f1\u0002^1sO\u0016$8\u000b^1uKB\u0011\u0001\u0005]\u0005\u0003c2\u0011a\u0002U1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003UgR,\b\"B \u000b\u0001\u0004Q\u0007\"\u00028\u000b\u0001\u0004y\u0007\"\u0002<\u000b\u0001\u00049\u0018A\u00067fC\u0012,'/\u00127fGRLwN\\*ue\u0006$XmZ=\u0011\u0007MA(0\u0003\u0002z)\t1q\n\u001d;j_:\u0004\"\u0001I>\n\u0005qd!a\b)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o'R\u0014\u0018\r^3hs\u0002")
public abstract class PartitionStateMachine
implements Logging {
    private final ControllerContext controllerContext;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void startup() {
        this.info((Function0<String> & Serializable)() -> "Initializing partition state");
        this.initializePartitionState();
        this.info((Function0<String> & Serializable)() -> "Triggering online partition state changes");
        this.triggerOnlinePartitionStateChange();
        this.debug((Function0<String> & Serializable)() -> new StringBuilder(54).append("Started partition state machine with initial state -> ").append($this.controllerContext.partitionStates()).toString());
    }

    public void shutdown() {
        this.info((Function0<String> & Serializable)() -> "Stopped partition state machine");
    }

    /*
     * WARNING - void declaration
     */
    public void triggerOnlinePartitionStateChange() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq<PartitionState> arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(new PartitionState[]{OfflinePartition$.MODULE$, NewPartition$.MODULE$});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set<TopicPartition> partitions = this.controllerContext.partitionsInStates((Set)IterableFactory.apply$(set$, (Seq)apply_elems));
        this.triggerOnlineStateChangeForPartitions(partitions);
    }

    /*
     * WARNING - void declaration
     */
    public void triggerOnlinePartitionStateChange(String topic) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq<PartitionState> arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(new PartitionState[]{OfflinePartition$.MODULE$, NewPartition$.MODULE$});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set<TopicPartition> partitions = this.controllerContext.partitionsInStates(topic, (Set)IterableFactory.apply$(set$, (Seq)apply_elems));
        this.triggerOnlineStateChangeForPartitions(partitions);
    }

    private void triggerOnlineStateChangeForPartitions(Set<TopicPartition> partitions) {
        Seq<TopicPartition> partitionsToTrigger = ((IterableOnceOps)partitions.filter((Function1<TopicPartition, Object> & Serializable)partition -> BoxesRunTime.boxToBoolean(PartitionStateMachine.$anonfun$triggerOnlineStateChangeForPartitions$1(this, partition)))).toSeq();
        this.handleStateChanges(partitionsToTrigger, OnlinePartition$.MODULE$, new Some<PartitionLeaderElectionStrategy>(new OfflinePartitionLeaderElectionStrategy(false)));
    }

    private void initializePartitionState() {
        this.controllerContext.allPartitions().foreach((Function1<TopicPartition, Object> & Serializable)topicPartition -> {
            PartitionStateMachine.$anonfun$initializePartitionState$1(this, topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(rpl.shaded.scala.collection.Seq<TopicPartition> partitions, PartitionState targetState) {
        return this.handleStateChanges(partitions, targetState, None$.MODULE$);
    }

    public abstract Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(rpl.shaded.scala.collection.Seq<TopicPartition> var1, PartitionState var2, Option<PartitionLeaderElectionStrategy> var3);

    public static final /* synthetic */ boolean $anonfun$triggerOnlineStateChangeForPartitions$1(PartitionStateMachine $this, TopicPartition partition) {
        return !$this.controllerContext.isTopicQueuedUpForDeletion(partition.topic());
    }

    public static final /* synthetic */ void $anonfun$initializePartitionState$1(PartitionStateMachine $this, TopicPartition topicPartition) {
        Option option = $this.controllerContext.partitionLeadershipInfo().get(topicPartition);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch currentLeaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
            if ($this.controllerContext.isReplicaOnline(currentLeaderIsrAndEpoch.leaderAndIsr().leader(), topicPartition, $this.controllerContext.isReplicaOnline$default$3())) {
                $this.controllerContext.putPartitionState(topicPartition, OnlinePartition$.MODULE$);
                return;
            }
            $this.controllerContext.putPartitionState(topicPartition, OfflinePartition$.MODULE$);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.controllerContext.putPartitionState(topicPartition, NewPartition$.MODULE$);
            return;
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
    }
}

