/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.cluster;

import java.io.Serializable;
import java.nio.ByteBuffer;
import rpl.shaded.kafka.api.ApiUtils$;
import rpl.shaded.kafka.cluster.BrokerEndPoint;
import rpl.shaded.org.apache.kafka.common.KafkaException;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.Tuple3;
import rpl.shaded.scala.collection.LinearSeqOps;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.immutable.List;
import rpl.shaded.scala.runtime.ModuleSerializationProxy;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.util.matching.Regex;

public final class BrokerEndPoint$
implements Serializable {
    public static final BrokerEndPoint$ MODULE$ = new BrokerEndPoint$();
    private static final Regex uriParseExp = StringOps$.MODULE$.r$extension("\\[?([0-9a-zA-Z\\-%._:]*)\\]?:([0-9]+)");

    private Regex uriParseExp() {
        return uriParseExp;
    }

    public Option<Tuple2<String, Object>> parseHostPort(String connectionString) {
        Option option;
        Option<List<String>> option2;
        if (connectionString != null && !(option2 = this.uriParseExp().unapplySeq(connectionString)).isEmpty() && option2.get() != null && option2.get().lengthCompare(2) == 0) {
            Option option3;
            String host = (String)((LinearSeqOps)option2.get()).apply(0);
            String port = (String)((LinearSeqOps)option2.get()).apply(1);
            try {
                option3 = new Some<Tuple2<String, Integer>>(new Tuple2<String, Integer>(host, Integer.parseInt(port)));
            }
            catch (NumberFormatException numberFormatException) {
                option3 = None$.MODULE$;
            }
            option = option3;
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public BrokerEndPoint createBrokerEndPoint(int brokerId, String connectionString) {
        Option option;
        Option<Tuple2<String, Object>> option2 = this.parseHostPort(connectionString);
        if (option2 == null) {
            throw null;
        }
        Option<Tuple2<String, Object>> map_this = option2;
        if (map_this.isEmpty()) {
            option = None$.MODULE$;
        } else {
            Tuple2<String, Object> tuple2 = map_this.get();
            option = new Some<BrokerEndPoint>(BrokerEndPoint$.$anonfun$createBrokerEndPoint$1(brokerId, tuple2));
        }
        None$ none$ = option;
        Object var3_3 = null;
        option = null;
        None$ getOrElse_this = none$;
        if (getOrElse_this.isEmpty()) {
            throw BrokerEndPoint$.$anonfun$createBrokerEndPoint$2(connectionString);
        }
        return (BrokerEndPoint)((Option)getOrElse_this).get();
    }

    public BrokerEndPoint readFrom(ByteBuffer buffer) {
        int brokerId = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new BrokerEndPoint(brokerId, host, port);
    }

    public BrokerEndPoint apply(int id, String host, int port) {
        return new BrokerEndPoint(id, host, port);
    }

    public Option<Tuple3<Object, String, Object>> unapply(BrokerEndPoint x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some<Tuple3<Object, String, Object>>(new Tuple3<Integer, String, Integer>(x$0.id(), x$0.host(), x$0.port()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BrokerEndPoint$.class);
    }

    public static final /* synthetic */ BrokerEndPoint $anonfun$createBrokerEndPoint$1(int brokerId$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        String host = (String)x0$1._1();
        int port = x0$1._2$mcI$sp();
        BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId$1, host, port);
        return brokerEndPoint;
    }

    public static final /* synthetic */ Nothing$ $anonfun$createBrokerEndPoint$2(String connectionString$1) {
        throw new KafkaException(new StringBuilder(37).append("Unable to parse ").append(connectionString$1).append(" to a broker endpoint").toString());
    }

    private BrokerEndPoint$() {
    }
}

