/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.admin;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import rpl.shaded.com.fasterxml.jackson.databind.JsonNode;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.admin.AdminOperationException;
import rpl.shaded.kafka.admin.AdminUtils$;
import rpl.shaded.kafka.admin.BrokerMetadata;
import rpl.shaded.kafka.admin.RackAwareMode;
import rpl.shaded.kafka.admin.RackAwareMode$Disabled$;
import rpl.shaded.kafka.admin.RackAwareMode$Enforced$;
import rpl.shaded.kafka.admin.ReassignPartitionsCommand;
import rpl.shaded.kafka.admin.ReassignPartitionsCommand$Throttle$;
import rpl.shaded.kafka.admin.ReassignmentCompleted$;
import rpl.shaded.kafka.admin.ReassignmentFailed$;
import rpl.shaded.kafka.admin.ReassignmentInProgress$;
import rpl.shaded.kafka.admin.ReassignmentStatus;
import rpl.shaded.kafka.cluster.Broker;
import rpl.shaded.kafka.common.AdminCommandFailedException;
import rpl.shaded.kafka.log.LogConfig$;
import rpl.shaded.kafka.server.ConfigType$;
import rpl.shaded.kafka.server.DynamicConfig$Broker$;
import rpl.shaded.kafka.utils.CommandLineUtils$;
import rpl.shaded.kafka.utils.CoreUtils$;
import rpl.shaded.kafka.utils.Json$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.kafka.utils.json.DecodeJson;
import rpl.shaded.kafka.utils.json.DecodeJson$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeInt$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeString$;
import rpl.shaded.kafka.utils.json.JsonObject;
import rpl.shaded.kafka.utils.json.JsonValue;
import rpl.shaded.kafka.zk.AdminZkClient;
import rpl.shaded.kafka.zk.KafkaZkClient;
import rpl.shaded.kafka.zk.KafkaZkClient$;
import rpl.shaded.org.apache.kafka.clients.admin.Admin;
import rpl.shaded.org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.TopicPartitionReplica;
import rpl.shaded.org.apache.kafka.common.security.JaasUtils;
import rpl.shaded.org.apache.kafka.common.utils.Time;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Console$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.Factory;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableFactory;
import rpl.shaded.scala.collection.IterableOnce;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.Iterator;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.Map$;
import rpl.shaded.scala.collection.MapOps;
import rpl.shaded.scala.collection.Seq;
import rpl.shaded.scala.collection.Seq$;
import rpl.shaded.scala.collection.SeqOps;
import rpl.shaded.scala.collection.Set;
import rpl.shaded.scala.collection.Set$;
import rpl.shaded.scala.collection.SetOps;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.mutable.ListBuffer;
import rpl.shaded.scala.runtime.BooleanRef;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.ScalaRunTime$;
import rpl.shaded.scala.util.Either;

public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$ = new ReassignPartitionsCommand$();
    private static final ReassignPartitionsCommand.Throttle NoThrottle = new ReassignPartitionsCommand.Throttle(-1L, -1L, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3());
    private static final String AnyLogDir = "any";
    private static final int EarliestVersion = 1;
    private static final String helpText = "This tool helps to moves topic partitions between replicas.";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public rpl.shaded.scala.collection.Map<TopicPartitionReplica, String> $lessinit$greater$default$4() {
        return (rpl.shaded.scala.collection.Map)Map$.MODULE$.empty();
    }

    public ReassignPartitionsCommand.Throttle NoThrottle() {
        return NoThrottle;
    }

    public String AnyLogDir() {
        return AnyLogDir;
    }

    public int EarliestVersion() {
        return EarliestVersion;
    }

    public String helpText() {
        return helpText;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        String zkConnect = (String)opts.options().valueOf(opts.zkConnectOpt());
        Time time = Time.SYSTEM;
        Option<Admin> adminClientOpt = this.createAdminClient(opts);
        try (KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnect, JaasUtils.isZkSaslEnabled(), 30000, 30000, Integer.MAX_VALUE, time, "rpl.shaded.kafka.server", "SessionExpireListener", None$.MODULE$, None$.MODULE$);){
            try {
                if (opts.options().has((OptionSpec)opts.verifyOpt())) {
                    this.verifyAssignment(zkClient, adminClientOpt, opts);
                } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
                    this.generateAssignment(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
                    this.executeAssignment(zkClient, adminClientOpt, opts);
                }
            }
            catch (Throwable e) {
                String println_x = new StringBuilder(38).append("Partitions reassignment failed due to ").append(e.getMessage()).toString();
                Console$.MODULE$.println(println_x);
                Object var9_8 = null;
                String println_x2 = Utils.stackTrace(e);
                Console$.MODULE$.println(println_x2);
                Object var10_9 = null;
            }
        }
    }

    private Option<Admin> createAdminClient(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has(opts.bootstrapServerOpt())) {
            Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options().valueOf(opts.commandConfigOpt()), null) : new Properties();
            props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
            props.putIfAbsent("client.id", "reassign-partitions-tool");
            return new Some<Admin>(Admin.create(props));
        }
        return None$.MODULE$;
    }

    public void verifyAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String jsonString = Utils.readFileAsString((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()));
        this.verifyAssignment(zkClient, adminClientOpt, jsonString);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, String jsonString) {
        void var7_8;
        void var6_7;
        String println_x = "Status of partition reassignment: ";
        Console$.MODULE$.println(println_x);
        Object var10_4 = null;
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionsToBeReassigned = tuple2._1();
        rpl.shaded.scala.collection.Map<TopicPartitionReplica, String> replicaAssignment = tuple2._2();
        rpl.shaded.scala.collection.Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfPartitionReassignmentSucceeded(zkClient, var6_7.toMap($less$colon$less$.MODULE$.refl()));
        rpl.shaded.scala.collection.Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus = this.checkIfReplicaReassignmentSucceeded(adminClientOpt, (rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>)var7_8);
        reassignedPartitionsStatus.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$1(x0$1);
            return BoxedUnit.UNIT;
        });
        replicasReassignmentStatus.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$2(x0$2);
            return BoxedUnit.UNIT;
        });
        this.removeThrottle(zkClient, reassignedPartitionsStatus, replicasReassignmentStatus, adminZkClient);
    }

    /*
     * WARNING - void declaration
     */
    public void removeThrottle(KafkaZkClient zkClient, rpl.shaded.scala.collection.Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus, rpl.shaded.scala.collection.Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus, AdminZkClient adminZkClient) {
        if (reassignedPartitionsStatus.forall((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$removeThrottle$1(x0$1))) && replicasReassignmentStatus.forall((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$removeThrottle$2(x0$2)))) {
            void $plus$plus_that;
            BooleanRef booleanRef;
            boolean create_e = false;
            BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
            booleanRef = null;
            BooleanRef changed = booleanRef2;
            ((IterableOnceOps)zkClient.getAllBrokersInCluster().map((Function1<Broker, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.id()))).foreach(brokerId -> {
                Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)brokerId).toString());
                if (configs.remove(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()) != null) {
                    adminZkClient.changeBrokerConfig((Seq)Seq$.MODULE$.apply((rpl.shaded.scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})), configs);
                    changed$1.elem = true;
                }
            });
            SetOps setOps = (SetOps)reassignedPartitionsStatus.keySet().map((Function1<TopicPartition, String> & Serializable)tp -> tp.topic());
            IterableOnce iterableOnce = (IterableOnce)replicasReassignmentStatus.keySet().map((Function1<TopicPartitionReplica, String> & Serializable)replica -> replica.topic());
            if (setOps == null) {
                throw null;
            }
            iterableOnce = null;
            ((rpl.shaded.scala.collection.immutable.Seq)setOps.concat($plus$plus_that).toSeq().distinct()).foreach((Function1<String, Object> & Serializable)topic -> {
                ReassignPartitionsCommand$.$anonfun$removeThrottle$7(adminZkClient, changed, topic);
                return BoxedUnit.UNIT;
            });
            if (changed.elem) {
                String println_x = "Throttle was removed.";
                Console$.MODULE$.println(println_x);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateAssignment(KafkaZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        void var9_17;
        void var10_18;
        Object var13_8;
        int[] nArray;
        int[] nArray2;
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        String[] map$extension_$this = StringOps$.MODULE$.split$extension((String)opts.options().valueOf(opts.brokerListOpt()), ',');
        int n = map$extension_$this.length;
        int[] nArray3 = nArray2 = new int[n];
        nArray2 = null;
        int[] nArray4 = nArray = nArray3;
        nArray = null;
        int[] map$extension_ys = nArray4;
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                int n2;
                map$extension_ys[map$extension_i] = n2 = ReassignPartitionsCommand$.$anonfun$generateAssignment$1(map$extension_$this[map$extension_i]);
            }
        }
        void v2 = var13_8;
        Object var12_4 = null;
        var13_8 = null;
        void brokerListToReassign = v2;
        Iterable<Object> duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray((int[])brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            Object[] objectArray = new Object[1];
            String mkString_sep = ",";
            Object var11_13 = null;
            objectArray[0] = duplicateReassignments.mkString("", mkString_sep, "");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("Broker list contains duplicate entries: %s", ScalaRunTime$.MODULE$.genericWrapArray(objectArray)));
        }
        String topicsToMoveJsonString = Utils.readFileAsString(topicsToMoveJsonFile);
        boolean disableRackAware = opts.options().has((OptionSpec)opts.disableRackAware());
        Tuple2<rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>>, rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkClient, Predef$.MODULE$.wrapIntArray((int[])brokerListToReassign), topicsToMoveJsonString, disableRackAware);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> proposedAssignments = tuple2._1();
        rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> currentAssignments = tuple2._2();
        String println_x = StringOps$.MODULE$.format$extension("Current partition replica assignment\n%s\n", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson((rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>>)var10_18, (rpl.shaded.scala.collection.Map)Map$.MODULE$.empty())}));
        Console$.MODULE$.println(println_x);
        Object var16_19 = null;
        String println_x2 = StringOps$.MODULE$.format$extension("Proposed partition reassignment configuration\n%s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson((rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>>)var9_17, (rpl.shaded.scala.collection.Map)Map$.MODULE$.empty())}));
        Console$.MODULE$.println(println_x2);
    }

    public Tuple2<rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>>, rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>>> generateAssignment(KafkaZkClient zkClient, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = this.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            Object[] objectArray = new Object[1];
            String mkString_sep = ",";
            Object var12_7 = null;
            objectArray[0] = duplicateTopicsToReassign.mkString("", mkString_sep, "");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("List of topics to reassign contains duplicate entries: %s", ScalaRunTime$.MODULE$.genericWrapArray(objectArray)));
        }
        rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> currentAssignment = zkClient.getReplicaAssignmentForTopics(topicsToReassign.toSet());
        rpl.shaded.scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1<Tuple2, String> & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String string = ((TopicPartition)x0$1._1()).topic();
            return string;
        });
        RackAwareMode rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        Seq<BrokerMetadata> brokerMetadatas = new AdminZkClient(zkClient).getBrokerMetadatas(rackAwareMode, new Some<Seq<Object>>(brokerListToReassign));
        rpl.shaded.scala.collection.mutable.Map partitionsToBeReassigned = (rpl.shaded.scala.collection.mutable.Map)rpl.shaded.scala.collection.mutable.Map$.MODULE$.apply(Nil$.MODULE$);
        groupedByTopic.foreach((Function1<Tuple2, rpl.shaded.scala.collection.mutable.Map> & Serializable)x0$2 -> {
            void $plus$plus$eq_xs;
            Object CC;
            if (x0$2 != null) {
                void var7_6;
                String topic = (String)x0$2._1();
                rpl.shaded.scala.collection.Map assignment = (rpl.shaded.scala.collection.Map)x0$2._2();
                Tuple2 tuple2 = (Tuple2)assignment.head();
                if (tuple2 == null) {
                    throw new MatchError((Object)null);
                }
                Seq replicas = (Seq)tuple2._2();
                if (var7_6 == null) {
                    throw null;
                }
                rpl.shaded.scala.collection.Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), var7_6.length(), -1, -1);
                CC = assignedReplicas.map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
                    Tuple2<TopicPartition, Seq> tuple2;
                    TopicPartition topicPartition;
                    if (x0$3 == null) {
                        throw new MatchError((Object)null);
                    }
                    int partition = x0$3._1$mcI$sp();
                    Seq replicas = (Seq)x0$3._2();
                    TopicPartition topicPartition2 = topicPartition = new TopicPartition(topic, partition);
                    topicPartition = null;
                    TopicPartition $minus$greater$extension_$this = topicPartition2;
                    Tuple2<TopicPartition, Seq> tuple22 = tuple2 = new Tuple2<TopicPartition, Seq>($minus$greater$extension_$this, replicas);
                    Object var5_5 = null;
                    tuple2 = null;
                    Tuple2<TopicPartition, Seq> tuple23 = tuple22;
                    return tuple23;
                });
                if (partitionsToBeReassigned == null) {
                    throw null;
                }
            } else {
                throw new MatchError((Object)null);
            }
            CC = null;
            rpl.shaded.scala.collection.mutable.Map map = (rpl.shaded.scala.collection.mutable.Map)partitionsToBeReassigned.addAll($plus$plus$eq_xs);
            return map;
        });
        return new Tuple2<rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>>, rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>>>(partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonString = Utils.readFileAsString((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()));
        long interBrokerThrottle = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.interBrokerThrottleOpt()));
        long replicaAlterLogDirsThrottle = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.replicaAlterLogDirsThrottleOpt()));
        long timeoutMs = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.timeoutOpt()));
        this.executeAssignment(zkClient, adminClientOpt, reassignmentJsonString, new ReassignPartitionsCommand.Throttle(interBrokerThrottle, replicaAlterLogDirsThrottle, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3()), timeoutMs);
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, String reassignmentJsonString, ReassignPartitionsCommand.Throttle throttle, long timeoutMs) {
        void var9_8;
        void var8_7;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>> tuple2 = this.parseAndValidate(zkClient, reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionAssignment = tuple2._1();
        rpl.shaded.scala.collection.Map<TopicPartitionReplica, String> replicaAssignment = tuple2._2();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, adminClientOpt, var8_7.toMap($less$colon$less$.MODULE$.refl()), (rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>)var9_8, adminZkClient);
        if (zkClient.reassignPartitionsInProgress()) {
            String println_x = "There is an existing assignment running.";
            Console$.MODULE$.println(println_x);
            Object var12_11 = null;
            reassignPartitionsCommand.maybeLimit(throttle);
            return;
        }
        this.printCurrentAssignment(zkClient, (Seq)var8_7.map((Function1<Tuple2, String> & Serializable)x$6 -> ((TopicPartition)x$6._1()).topic()));
        if (throttle.interBrokerLimit() >= 0L || throttle.replicaAlterLogDirsLimit() >= 0L) {
            String println_x = String.format("Warning: You must run Verify periodically, until the reassignment completes, to ensure the throttle is removed. You can also alter the throttle by rerunning the Execute command passing a new value.", new Object[0]);
            Console$.MODULE$.println(println_x);
            Object var13_12 = null;
        }
        if (reassignPartitionsCommand.reassignPartitions(throttle, timeoutMs)) {
            String println_x = "Successfully started reassignment of partitions.";
            Console$.MODULE$.println(println_x);
            return;
        }
        String println_x = StringOps$.MODULE$.format$extension("Failed to reassign partitions %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{var8_7}));
        Console$.MODULE$.println(println_x);
    }

    public long executeAssignment$default$5() {
        return 10000L;
    }

    public void printCurrentAssignment(KafkaZkClient zkClient, Seq<String> topics) {
        rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> currentPartitionReplicaAssignment = zkClient.getReplicaAssignmentForTopics(topics.toSet());
        String println_x = StringOps$.MODULE$.format$extension("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(currentPartitionReplicaAssignment, (rpl.shaded.scala.collection.Map)Map$.MODULE$.empty())}));
        Console$.MODULE$.println(println_x);
    }

    /*
     * WARNING - void declaration
     */
    public String formatAsReassignmentJson(rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        Integer n;
        Tuple2[] tuple2Array = new Tuple2[2];
        Integer n2 = n = Integer.valueOf(1);
        n = null;
        Integer n3 = n2;
        String $minus$greater$extension_$this = "version";
        Object var3_5 = null;
        n3 = null;
        tuple2Array[0] = new Tuple2<String, void>($minus$greater$extension_$this, $minus$greater$extension_y2);
        java.lang.Iterable iterable = JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)partitionsToBeReassigned.map((Function1<Tuple2, Map> & Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_y3;
            Integer n;
            void $minus$greater$extension_y4;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Tuple2[] tuple2Array = new Tuple2[4];
            String string = tp.topic();
            String $minus$greater$extension_$this = "topic";
            Object var5_5 = null;
            string = null;
            tuple2Array[0] = new Tuple2<String, void>($minus$greater$extension_$this, $minus$greater$extension_y4);
            Integer n2 = n = Integer.valueOf(tp.partition());
            n = null;
            Integer n3 = n2;
            String $minus$greater$extension_$this2 = "partition";
            Object var7_8 = null;
            n3 = null;
            tuple2Array[1] = new Tuple2<String, void>($minus$greater$extension_$this2, $minus$greater$extension_y3);
            List list = JavaConverters$.MODULE$.seqAsJavaListConverter(replicas).asJava();
            String $minus$greater$extension_$this3 = "replicas";
            Object var9_10 = null;
            list = null;
            tuple2Array[2] = new Tuple2<String, void>($minus$greater$extension_$this3, $minus$greater$extension_y2);
            List list2 = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1<Object, String> & Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$2(replicaLogDirAssignment, tp, BoxesRunTime.unboxToInt(r)))).asJava();
            String $minus$greater$extension_$this4 = "log_dirs";
            Object var11_12 = null;
            list2 = null;
            tuple2Array[3] = new Tuple2<String, void>($minus$greater$extension_$this4, $minus$greater$extension_y);
            Map map = JavaConverters$.MODULE$.mapAsJavaMapConverter((rpl.shaded.scala.collection.Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).asJava();
            return map;
        })).asJava();
        String $minus$greater$extension_$this2 = "partitions";
        Object var5_7 = null;
        iterable = null;
        tuple2Array[1] = new Tuple2<String, void>($minus$greater$extension_$this2, $minus$greater$extension_y);
        return Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((rpl.shaded.scala.collection.Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array))).asJava());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> parseTopicsData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt(((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parseTopicsData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            return this.parseTopicsData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<String> parseTopicsData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                return (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1<JsonValue, Iterator> & Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1<JsonValue, String> & Serializable)p -> p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$)));
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt(((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parsePartitionReassignmentData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            return this.parsePartitionReassignmentData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(int version, JsonValue jsonData) {
        switch (version) {
            case 1: {
                ListBuffer listBuffer;
                ListBuffer listBuffer2 = listBuffer = new ListBuffer();
                listBuffer = null;
                ListBuffer partitionAssignment = listBuffer2;
                rpl.shaded.scala.collection.mutable.Map replicaAssignment = (rpl.shaded.scala.collection.mutable.Map)rpl.shaded.scala.collection.mutable.Map$.MODULE$.empty();
                Option$.MODULE$.option2Iterable(jsonData.asJsonObject().get("partitions")).toSeq().foreach((Function1<JsonValue, Object> & Serializable)partitionsSeq -> {
                    ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment, replicaAssignment, partitionsSeq);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>>(partitionAssignment, replicaAssignment);
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>> parseAndValidate(KafkaZkClient zkClient, String reassignmentJsonString) {
        void var5_5;
        void var4_4;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionsToBeReassigned = tuple2._1();
        rpl.shaded.scala.collection.Map<TopicPartitionReplica, String> replicaAssignment = tuple2._2();
        if (var4_4.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment data file is empty");
        }
        if (var4_4.exists((Function1<Tuple2, Object> & Serializable)x$10 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parseAndValidate$1(x$10)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Iterable)var4_4.map((Function1<Tuple2, TopicPartition> & Serializable)x0$1 -> {
            void var1_1;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            return var1_1;
        }));
        if (duplicateReassignedPartitions.nonEmpty()) {
            Object[] objectArray = new Object[1];
            String mkString_sep = ",";
            Object var14_7 = null;
            objectArray[0] = duplicateReassignedPartitions.mkString("", mkString_sep, "");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("Partition reassignment contains duplicate topic partitions: %s", ScalaRunTime$.MODULE$.genericWrapArray(objectArray)));
        }
        Seq duplicateEntries = (Seq)((IterableOps)var4_4.map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Tuple2 tuple2 = new Tuple2(tp, CoreUtils$.MODULE$.duplicates(replicas));
            return tuple2;
        })).filter((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parseAndValidate$4(x0$3)));
        if (duplicateEntries.nonEmpty()) {
            void mkString_sep;
            String string;
            IterableOnceOps iterableOnceOps = (IterableOnceOps)duplicateEntries.map((Function1<Tuple2, String> & Serializable)x0$4 -> {
                void mkString_sep;
                String string;
                Object[] objectArray;
                Iterable duplicateReplicas;
                if (x0$4 != null) {
                    TopicPartition tp = (TopicPartition)x0$4._1();
                    duplicateReplicas = (Iterable)x0$4._2();
                    objectArray = new Object[2];
                    objectArray[0] = tp;
                    string = ",";
                    if (duplicateReplicas == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError((Object)null);
                }
                string = null;
                objectArray[1] = duplicateReplicas.mkString("", (String)mkString_sep, "");
                String string2 = StringOps$.MODULE$.format$extension("%s contains multiple entries for %s", ScalaRunTime$.MODULE$.genericWrapArray(objectArray));
                return string2;
            });
            String string2 = ". ";
            if (iterableOnceOps == null) {
                throw null;
            }
            IterableOnceOps mkString_this = iterableOnceOps;
            String string3 = string = mkString_this.mkString("", (String)mkString_sep, "");
            Object var15_10 = null;
            string2 = null;
            string = null;
            String duplicatesMsg = string3;
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("Partition replica lists may not contain duplicate entries: %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{duplicatesMsg})));
        }
        Seq proposedTopics = (Seq)((SeqOps)var4_4.map((Function1<Tuple2, String> & Serializable)x0$5 -> {
            if (x0$5 == null) {
                throw new MatchError((Object)null);
            }
            String string = ((TopicPartition)x0$5._1()).topic();
            return string;
        })).distinct();
        rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> existingAssignment = zkClient.getReplicaAssignmentForTopics(proposedTopics.toSet());
        Seq nonExistentPartitions = (Seq)((IterableOps)var4_4.map((Function1<Tuple2, TopicPartition> & Serializable)x0$6 -> {
            void var1_1;
            if (x0$6 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$6._1();
            return var1_1;
        })).filterNot((Function1<TopicPartition, Object> & Serializable)key -> BoxesRunTime.boxToBoolean(existingAssignment.contains(key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(58).append("The proposed assignment contains non-existent partitions: ").append(nonExistentPartitions).toString());
        }
        Seq<Object> existingBrokerIDs = zkClient.getSortedBrokerList();
        rpl.shaded.scala.collection.immutable.Set nonExistingBrokerIDs = ((IterableOnceOps)((IterableOps)var4_4.toMap($less$colon$less$.MODULE$.refl()).values().flatten($less$colon$less$.MODULE$.refl())).filterNot((Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(existingBrokerIDs.contains(elem)))).toSet();
        if (nonExistingBrokerIDs.nonEmpty()) {
            String mkString_sep = ",";
            Object var18_18 = null;
            throw new AdminCommandFailedException(new StringBuilder(57).append("The proposed assignment contains non-existent brokerIDs: ").append(nonExistingBrokerIDs.mkString("", mkString_sep, "")).toString());
        }
        return new Tuple2<void, void>(var4_4, var5_5);
    }

    /*
     * WARNING - void declaration
     */
    public rpl.shaded.scala.collection.Map<TopicPartition, ReassignmentStatus> checkIfPartitionReassignmentSucceeded(KafkaZkClient zkClient, rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> partitionsToBeReassigned) {
        void var5_5;
        void var6_6;
        rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> partitionsBeingReassigned = zkClient.getPartitionReassignment();
        Tuple2 tuple2 = partitionsToBeReassigned.keys().partition((Function1<TopicPartition, Object> & Serializable)topicAndPartition -> BoxesRunTime.boxToBoolean(partitionsBeingReassigned.contains(topicAndPartition)));
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Iterable beingReassigned = (Iterable)tuple2._1();
        Iterable notBeingReassigned = (Iterable)tuple2._2();
        return (rpl.shaded.scala.collection.Map)((MapOps)var6_6.groupBy((Function1<TopicPartition, String> & Serializable)x$12 -> x$12.topic()).flatMap((Function1<Tuple2, Iterable> & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String topic = (String)x0$1._1();
            Iterable partitions = (Iterable)x0$1._2();
            rpl.shaded.scala.collection.Map<TopicPartition, Seq<Object>> replicasForTopic = zkClient.getReplicaAssignmentForTopics((rpl.shaded.scala.collection.immutable.Set)IterableFactory.apply$(rpl.shaded.scala.collection.immutable.Set$.MODULE$, ScalaRunTime$.MODULE$.wrapRefArray(new String[]{topic})));
            Iterable iterable = (Iterable)partitions.map((Function1<TopicPartition, Tuple2> & Serializable)topicAndPartition -> {
                void var3_7;
                Seq newReplicas = (Seq)partitionsToBeReassigned.apply((TopicPartition)topicAndPartition);
                Option option = replicasForTopic.get((TopicPartition)topicAndPartition);
                if (option instanceof Some) {
                    Seq seq = (Seq)((Some)option).value();
                    if (!(seq != null ? !((Object)seq).equals(newReplicas) : newReplicas != null)) {
                        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                        return new Tuple2<TopicPartition, void>((TopicPartition)topicAndPartition, var3_7);
                    }
                }
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return new Tuple2<TopicPartition, void>((TopicPartition)topicAndPartition, var3_7);
            });
            return iterable;
        })).$plus$plus(((IterableOnceOps)var5_5.map((Function1<TopicPartition, Tuple2> & Serializable)topicAndPartition -> new Tuple2<TopicPartition, ReassignmentInProgress$>((TopicPartition)topicAndPartition, ReassignmentInProgress$.MODULE$))).toMap($less$colon$less$.MODULE$.refl()));
    }

    private rpl.shaded.scala.collection.Map<TopicPartitionReplica, ReassignmentStatus> checkIfReplicaReassignmentSucceeded(Option<Admin> adminClientOpt, rpl.shaded.scala.collection.Map<TopicPartitionReplica, String> replicaAssignment) {
        rpl.shaded.scala.collection.Map map;
        if (replicaAssignment.nonEmpty()) {
            if (adminClientOpt == null) {
                throw null;
            }
            if (adminClientOpt.isEmpty()) {
                throw new AdminCommandFailedException("bootstrap-server needs to be provided in order to reassign replica to the specified log directory");
            }
            Admin adminClient = adminClientOpt.get();
            map = JavaConverters$.MODULE$.mapAsScalaMapConverter(adminClient.describeReplicaLogDirs(JavaConverters$.MODULE$.setAsJavaSetConverter(replicaAssignment.keySet()).asJava()).all().get()).asScala();
        } else {
            map = (rpl.shaded.scala.collection.Map)Map$.MODULE$.empty();
        }
        rpl.shaded.scala.collection.Map replicaLogDirInfos = map;
        return (rpl.shaded.scala.collection.Map)replicaAssignment.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            void var3_11;
            if (x0$1 == null) throw new MatchError((Object)null);
            TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
            String newLogDir = (String)x0$1._2();
            Option option = replicaLogDirInfos.get(replica);
            if (option instanceof Some) {
                ReassignmentStatus reassignmentStatus;
                DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaLogDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((Some)option).value();
                if (replicaLogDirInfo.getCurrentReplicaLogDir() == null) {
                    String println_x = new StringBuilder(0).append(new StringBuilder(48).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" is not found in any live log dir on ").toString()).append(new StringBuilder(61).append("broker ").append(replica.brokerId()).append(". There is likely offline log directory on the broker.").toString()).toString();
                    Console$.MODULE$.println(println_x);
                    Object var8_6 = null;
                    reassignmentStatus = ReassignmentFailed$.MODULE$;
                } else {
                    String string = replicaLogDirInfo.getFutureReplicaLogDir();
                    if (!(string != null ? !string.equals(newLogDir) : newLogDir != null)) {
                        reassignmentStatus = ReassignmentInProgress$.MODULE$;
                    } else if (replicaLogDirInfo.getFutureReplicaLogDir() != null) {
                        String println_x = new StringBuilder(0).append(new StringBuilder(23).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" ").toString()).append(new StringBuilder(38).append("is being moved to log dir ").append(replicaLogDirInfo.getFutureReplicaLogDir()).append(" instead of ").append(newLogDir).toString()).toString();
                        Console$.MODULE$.println(println_x);
                        Object var9_7 = null;
                        reassignmentStatus = ReassignmentFailed$.MODULE$;
                    } else {
                        String string2 = replicaLogDirInfo.getCurrentReplicaLogDir();
                        if (!(string2 != null ? !string2.equals(newLogDir) : newLogDir != null)) {
                            reassignmentStatus = ReassignmentCompleted$.MODULE$;
                        } else {
                            String println_x = new StringBuilder(0).append(new StringBuilder(23).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" ").toString()).append(new StringBuilder(36).append("is not being moved from log dir ").append(replicaLogDirInfo.getCurrentReplicaLogDir()).append(" to ").append(newLogDir).toString()).toString();
                            Console$.MODULE$.println(println_x);
                            Object var10_8 = null;
                            reassignmentStatus = ReassignmentFailed$.MODULE$;
                        }
                    }
                }
                ReassignmentInProgress$ reassignmentInProgress$ = reassignmentStatus;
                return new Tuple2<TopicPartitionReplica, void>(replica, var3_11);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                String println_x = new StringBuilder(56).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" is not found in any live log dir on broker ").append(replica.brokerId()).append(".").toString();
                Console$.MODULE$.println(println_x);
                Object var11_12 = null;
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
            }
            return new Tuple2<TopicPartitionReplica, void>(replica, var3_11);
        });
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.helpText());
        if (Seq$.MODULE$.apply((rpl.shaded.scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()})).count(arg_0 -> ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$1$adapted(opts.options(), arg_0)) != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), ScalaRunTime$.MODULE$.wrapRefArray(new OptionSpec[]{opts.zkConnectOpt()}));
        if (opts.options().has((OptionSpec)opts.verifyOpt())) {
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.verifyOpt(), (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()})));
        } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
            if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.generateOpt(), (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.reassignmentJsonFileOpt()})));
        } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.executeOpt(), (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new OptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()})));
        }
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$verifyAssignment$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ReassignmentStatus status = (ReassignmentStatus)x0$1._2();
            if (ReassignmentCompleted$.MODULE$.equals(status)) {
                String println_x = StringOps$.MODULE$.format$extension("Reassignment of partition %s completed successfully", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topicPartition}));
                Console$.MODULE$.println(println_x);
                return;
            }
            if (ReassignmentFailed$.MODULE$.equals(status)) {
                String println_x = StringOps$.MODULE$.format$extension("Reassignment of partition %s failed", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topicPartition}));
                Console$.MODULE$.println(println_x);
                return;
            }
            if (ReassignmentInProgress$.MODULE$.equals(status)) {
                String println_x = StringOps$.MODULE$.format$extension("Reassignment of partition %s is still in progress", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topicPartition}));
                Console$.MODULE$.println(println_x);
                return;
            }
            throw new MatchError(status);
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$verifyAssignment$2(Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartitionReplica replica = (TopicPartitionReplica)x0$2._1();
            ReassignmentStatus status = (ReassignmentStatus)x0$2._2();
            if (ReassignmentCompleted$.MODULE$.equals(status)) {
                String println_x = StringOps$.MODULE$.format$extension("Reassignment of replica %s completed successfully", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{replica}));
                Console$.MODULE$.println(println_x);
                return;
            }
            if (ReassignmentFailed$.MODULE$.equals(status)) {
                String println_x = StringOps$.MODULE$.format$extension("Reassignment of replica %s failed", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{replica}));
                Console$.MODULE$.println(println_x);
                return;
            }
            if (ReassignmentInProgress$.MODULE$.equals(status)) {
                String println_x = StringOps$.MODULE$.format$extension("Reassignment of replica %s is still in progress", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{replica}));
                Console$.MODULE$.println(println_x);
                return;
            }
            throw new MatchError(status);
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError((Object)null);
        }
        ReassignmentStatus reassignmentStatus = (ReassignmentStatus)x0$1._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = reassignmentStatus != null && reassignmentStatus.equals(reassignmentCompleted$);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError((Object)null);
        }
        ReassignmentStatus reassignmentStatus = (ReassignmentStatus)x0$2._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = reassignmentStatus != null && reassignmentStatus.equals(reassignmentCompleted$);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeThrottle$7(AdminZkClient adminZkClient$1, BooleanRef changed$1, String topic) {
        Properties configs = adminZkClient$1.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        if (configs.remove(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) != null | configs.remove(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()) != null) {
            adminZkClient$1.changeTopicConfig(topic, configs);
            changed$1.elem = true;
        }
    }

    public static final /* synthetic */ int $anonfun$generateAssignment$1(String x$3) {
        return Integer.parseInt(x$3);
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$2(rpl.shaded.scala.collection.Map replicaLogDirAssignment$1, TopicPartition tp$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse(new TopicPartitionReplica(tp$1.topic(), tp$1.partition(), r), (Function0<String> & Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$5(Tuple2 x$8) {
        Object T2 = x$8._2();
        String string = MODULE$.AnyLogDir();
        return T2 == null ? string != null : !T2.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, rpl.shaded.scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1<JsonValue, rpl.shaded.scala.collection.mutable.Map> & Serializable)p -> {
            void $plus$plus$eq_xs;
            Tuple2<TopicPartition, Seq> tuple2;
            TopicPartition topicPartition;
            Seq seq;
            void decodeSeq_factory;
            Factory factory;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt(partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Seq$ iterableFactory_this = Seq$.MODULE$;
            Factory factory2 = factory = IterableFactory.iterableFactory$(iterableFactory_this);
            Object var13_6 = null;
            factory = null;
            Factory factory3 = factory2;
            DecodeJson$DecodeInt$ decodeSeq_decodeJson = DecodeJson$DecodeInt$.MODULE$;
            Object var17_9 = null;
            factory3 = null;
            Seq newReplicas = (Seq)partitionFields.apply("replicas").to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                private final DecodeJson decodeJson$2;
                private final Factory factory$1;

                public Object decode(JsonNode node) {
                    return DecodeJson.decode$(this, node);
                }

                public final Either<String, S> decodeEither(JsonNode node) {
                    return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                }
                {
                    this.decodeJson$2 = decodeJson$2;
                    this.factory$1 = factory$1;
                }
            });
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                void decodeSeq_factory2;
                Factory factory4;
                Seq$ iterableFactory_this2 = Seq$.MODULE$;
                Factory factory5 = factory4 = IterableFactory.iterableFactory$(iterableFactory_this2);
                Object var15_12 = null;
                factory4 = null;
                Factory factory6 = factory5;
                DecodeJson$DecodeString$ decodeSeq_decodeJson2 = DecodeJson$DecodeString$.MODULE$;
                Object var19_15 = null;
                factory6 = null;
                seq = (Seq)((JsonValue)((Some)option).value()).to(new /* invalid duplicate definition of identical inner class */);
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)newReplicas.map((Function1<Object, String> & Serializable)x$7 -> ReassignPartitionsCommand$.MODULE$.AnyLogDir());
            } else {
                throw new MatchError(option);
            }
            if (newReplicas == null) {
                throw null;
            }
            if (seq == null) {
                throw null;
            }
            if (newReplicas.length() != seq.length()) {
                throw new AdminCommandFailedException(new StringBuilder(0).append(new StringBuilder(41).append("Size of replicas list ").append(newReplicas).append(" is different from ").toString()).append(new StringBuilder(37).append("size of log dirs list ").append(seq).append(" for partition ").append(new TopicPartition(topic, partition)).toString()).toString());
            }
            TopicPartition topicPartition2 = topicPartition = new TopicPartition(topic, partition);
            topicPartition = null;
            TopicPartition $minus$greater$extension_$this = topicPartition2;
            Tuple2<TopicPartition, Seq> tuple22 = tuple2 = new Tuple2<TopicPartition, Seq>($minus$greater$extension_$this, newReplicas);
            Object var9_18 = null;
            tuple2 = null;
            Tuple2<TopicPartition, Seq> $plus$eq_elem = tuple22;
            partitionAssignment$1.addOne($plus$eq_elem);
            Object var11_20 = null;
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)((IterableOps)newReplicas.zip(seq)).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                Tuple2<TopicPartitionReplica, String> tuple2;
                TopicPartitionReplica topicPartitionReplica;
                if (x0$1 == null) {
                    throw new MatchError((Object)null);
                }
                int replica = x0$1._1$mcI$sp();
                String logDir = (String)x0$1._2();
                TopicPartitionReplica topicPartitionReplica2 = topicPartitionReplica = new TopicPartitionReplica(topic, partition, replica);
                topicPartitionReplica = null;
                TopicPartitionReplica $minus$greater$extension_$this = topicPartitionReplica2;
                Tuple2<TopicPartitionReplica, String> tuple22 = tuple2 = new Tuple2<TopicPartitionReplica, String>($minus$greater$extension_$this, logDir);
                Object var6_6 = null;
                tuple2 = null;
                Tuple2<TopicPartitionReplica, String> tuple23 = tuple22;
                return tuple23;
            })).filter((Function1<Tuple2, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$5(x$8)));
            if (replicaAssignment$1 == null) {
                throw null;
            }
            return (rpl.shaded.scala.collection.mutable.Map)replicaAssignment$1.addAll($plus$plus$eq_xs);
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$1(Tuple2 x$10) {
        return ((SeqOps)x$10._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError((Object)null);
        }
        boolean bl = ((Iterable)x0$3._2()).nonEmpty();
        return bl;
    }

    public static final /* synthetic */ Nothing$ $anonfun$checkIfReplicaReassignmentSucceeded$1() {
        throw new AdminCommandFailedException("bootstrap-server needs to be provided in order to reassign replica to the specified log directory");
    }

    private ReassignPartitionsCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$generateAssignment$1$adapted(String x$3) {
        return BoxesRunTime.boxToInteger(ReassignPartitionsCommand$.$anonfun$generateAssignment$1(x$3));
    }

    public static final /* synthetic */ Object $anonfun$validateAndParseArgs$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.has(x$1));
    }
}

