/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import rpl.shaded.kafka.admin.AdminOperationException;
import rpl.shaded.kafka.admin.DeleteRecordsCommand;
import rpl.shaded.kafka.common.AdminCommandFailedException;
import rpl.shaded.kafka.utils.CoreUtils$;
import rpl.shaded.kafka.utils.Json$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeInt$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeLong$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeString$;
import rpl.shaded.kafka.utils.json.JsonObject;
import rpl.shaded.kafka.utils.json.JsonValue;
import rpl.shaded.org.apache.kafka.clients.admin.Admin;
import rpl.shaded.org.apache.kafka.clients.admin.DeleteRecordsResult;
import rpl.shaded.org.apache.kafka.clients.admin.DeletedRecords;
import rpl.shaded.org.apache.kafka.clients.admin.RecordsToDelete;
import rpl.shaded.org.apache.kafka.common.KafkaFuture;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableOnce;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.Iterator;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.Seq;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.mutable.Buffer;
import rpl.shaded.scala.collection.mutable.Buffer$;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class DeleteRecordsCommand$ {
    public static final DeleteRecordsCommand$ MODULE$ = new DeleteRecordsCommand$();
    private static final int EarliestVersion = 1;

    public int EarliestVersion() {
        return EarliestVersion;
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt(((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parseJsonData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            return this.parseJsonData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<Tuple2<TopicPartition, Object>> parseJsonData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                Buffer buffer;
                Iterator iterator;
                Option<JsonValue> option = js.asJsonObject().get("partitions");
                if (option instanceof Some) {
                    iterator = ((JsonValue)((Some)option).value()).asJsonArray().iterator().map((Function1<JsonValue, JsonObject> & Serializable)x$1 -> x$1.asJsonObject()).map((Function1<JsonObject, Tuple2> & Serializable)partitionJs -> {
                        void $minus$greater$extension_y;
                        Long l;
                        String topic = partitionJs.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                        int partition = BoxesRunTime.unboxToInt(partitionJs.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                        long offset = BoxesRunTime.unboxToLong(partitionJs.apply("offset").to(DecodeJson$DecodeLong$.MODULE$));
                        Long l2 = l = Long.valueOf(offset);
                        l = null;
                        Long l3 = l2;
                        TopicPartition $minus$greater$extension_$this = new TopicPartition(topic, partition);
                        return new Tuple2<TopicPartition, void>($minus$greater$extension_$this, $minus$greater$extension_y);
                    });
                    if (iterator == null) {
                        throw null;
                    }
                } else {
                    throw new AdminOperationException("Missing partitions field");
                }
                Iterator toBuffer_this = iterator;
                Buffer buffer2 = buffer = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
                Object var5_4 = null;
                buffer = null;
                Buffer buffer3 = buffer2;
                return buffer3;
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        Admin adminClient = this.createAdminClient(opts);
        String offsetJsonString = Utils.readFileAsString((String)opts.options().valueOf(opts.offsetJsonFileOpt()));
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates((Iterable)offsetSeq.map((Function1<Tuple2, TopicPartition> & Serializable)x0$1 -> {
            void var1_1;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            return var1_1;
        }));
        if (duplicatePartitions.nonEmpty()) {
            Object[] objectArray = new Object[1];
            String mkString_sep = ",";
            Object var10_8 = null;
            objectArray[0] = duplicatePartitions.mkString("", mkString_sep, "");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("Offset json file contains duplicate topic partitions: %s", ScalaRunTime$.MODULE$.genericWrapArray(objectArray)));
        }
        Map<TopicPartition, RecordsToDelete> recordsToDelete = JavaConverters$.MODULE$.mapAsJavaMapConverter(((IterableOnceOps)offsetSeq.map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            long offset = x0$2._2$mcJ$sp();
            Tuple2<TopicPartition, RecordsToDelete> tuple2 = new Tuple2<TopicPartition, RecordsToDelete>(topicPartition, RecordsToDelete.beforeOffset(offset));
            return tuple2;
        })).toMap($less$colon$less$.MODULE$.refl())).asJava();
        out.println("Executing records delete operation");
        DeleteRecordsResult deleteRecordsResult = adminClient.deleteRecords(recordsToDelete);
        out.println("Records delete operation completed:");
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(deleteRecordsResult.lowWatermarks()).asScala()).foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> {
            DeleteRecordsCommand$.$anonfun$execute$3(out, x0$3);
            return BoxedUnit.UNIT;
        });
        adminClient.close();
    }

    private Admin createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)opts.options().valueOf(opts.commandConfigOpt()), null) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return Admin.create(props);
    }

    public static final /* synthetic */ void $anonfun$execute$3(PrintStream out$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition tp = (TopicPartition)x0$3._1();
            KafkaFuture partitionResult = (KafkaFuture)x0$3._2();
            try {
                out$1.println(new StringBuilder(27).append("partition: ").append(tp).append("\tlow_watermark: ").append(((DeletedRecords)partitionResult.get()).lowWatermark()).toString());
                return;
            }
            catch (Exception e) {
                out$1.println(new StringBuilder(19).append("partition: ").append(tp).append("\terror: ").append(e.getMessage()).toString());
                return;
            }
        }
        throw new MatchError((Object)null);
    }

    private DeleteRecordsCommand$() {
    }
}

