/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.unpacker;

import java.math.BigInteger;
import org.msgpack.unpacker.Accept;

final class BigIntegerAccept
extends Accept {
    BigInteger value;

    BigIntegerAccept() {
        super("integer");
    }

    @Override
    void acceptInteger(byte v) {
        this.value = BigInteger.valueOf(v);
    }

    @Override
    void acceptInteger(short v) {
        this.value = BigInteger.valueOf(v);
    }

    @Override
    void acceptInteger(int v) {
        this.value = BigInteger.valueOf(v);
    }

    @Override
    void acceptInteger(long v) {
        this.value = BigInteger.valueOf(v);
    }

    @Override
    void acceptUnsignedInteger(byte v) {
        this.value = BigInteger.valueOf(v & 0xFF);
    }

    @Override
    void acceptUnsignedInteger(short v) {
        this.value = BigInteger.valueOf(v & 0xFFFF);
    }

    @Override
    void acceptUnsignedInteger(int v) {
        this.value = v < 0 ? BigInteger.valueOf((long)(v & Integer.MAX_VALUE) + 0x80000000L) : BigInteger.valueOf(v);
    }

    @Override
    void acceptUnsignedInteger(long v) {
        this.value = v < 0L ? BigInteger.valueOf(v + Long.MAX_VALUE + 1L).setBit(63) : BigInteger.valueOf(v);
    }
}

