/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.ReadHandler;
import com.cognitect.transit.impl.ReaderFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ReadHandlerMap
implements Map<String, ReadHandler<?, ?>> {
    private final Map<String, ReadHandler<?, ?>> handlers = ReaderFactory.defaultHandlers();

    public ReadHandlerMap(Map<String, ReadHandler<?, ?>> customHandlers) {
        if (customHandlers != null) {
            ReadHandlerMap.disallowOverridingGroundTypes(customHandlers);
            this.handlers.putAll(customHandlers);
        }
    }

    private static void disallowOverridingGroundTypes(Map<String, ReadHandler<?, ?>> handlers) {
        if (handlers != null) {
            String[] groundTypeTags;
            for (String tag : groundTypeTags = new String[]{"_", "s", "?", "i", "d", "b", "'", "map", "array"}) {
                if (!handlers.containsKey(tag)) continue;
                throw new IllegalArgumentException("Cannot override decoding for transit ground type, tag " + tag);
            }
        }
    }

    private Map<String, ReadHandler<?, ?>> getUnderlyingMap() {
        return this.handlers;
    }

    @Override
    public int size() {
        return this.handlers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.handlers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.handlers.containsValue(value);
    }

    @Override
    public ReadHandler<?, ?> get(Object key) {
        return this.handlers.get(key);
    }

    @Override
    public ReadHandler<?, ?> put(String key, ReadHandler<?, ?> value) {
        throw new UnsupportedOperationException("ReadHandlerMap is read-only");
    }

    @Override
    public ReadHandler<?, ?> remove(Object key) {
        throw new UnsupportedOperationException("ReadHandlerMap is read-only");
    }

    @Override
    public void putAll(Map<? extends String, ? extends ReadHandler<?, ?>> m) {
        throw new UnsupportedOperationException("ReadHandlerMap is read-only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ReadHandlerMap is read-only");
    }

    @Override
    public Set<String> keySet() {
        return this.handlers.keySet();
    }

    @Override
    public Collection<ReadHandler<?, ?>> values() {
        return this.handlers.values();
    }

    @Override
    public Set<Map.Entry<String, ReadHandler<?, ?>>> entrySet() {
        return this.handlers.entrySet();
    }

    @Override
    public int hashCode() {
        return this.handlers.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ReadHandlerMap && this.getUnderlyingMap().equals(((ReadHandlerMap)other).getUnderlyingMap());
    }
}

