/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import org.threeten.extra.PeriodDuration;

public final class Interval
implements Serializable {
    public static final Interval ALL = new Interval(Instant.MIN, Instant.MAX);
    private static final long serialVersionUID = 8375285238652L;
    private final Instant start;
    private final Instant end;

    public static Interval of(Instant startInclusive, Instant endExclusive) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(endExclusive, "endExclusive");
        if (endExclusive.isBefore(startInclusive)) {
            throw new DateTimeException("End instant must on or after start instant");
        }
        return new Interval(startInclusive, endExclusive);
    }

    public static Interval of(Instant startInclusive, Duration duration) {
        Objects.requireNonNull(startInclusive, "startInclusive");
        Objects.requireNonNull(duration, "duration");
        if (duration.isNegative()) {
            throw new DateTimeException("Duration must not be zero or negative");
        }
        return new Interval(startInclusive, startInclusive.plus(duration));
    }

    public static Interval parse(CharSequence text) {
        Objects.requireNonNull(text, "text");
        for (int i = 0; i < text.length(); ++i) {
            char c;
            if (text.charAt(i) != '/') continue;
            char firstChar = text.charAt(0);
            if (firstChar == 'P' || firstChar == 'p') {
                PeriodDuration amount = PeriodDuration.parse(text.subSequence(0, i));
                OffsetDateTime end = OffsetDateTime.parse(text.subSequence(i + 1, text.length()));
                return Interval.of(end.minus(amount).toInstant(), end.toInstant());
            }
            OffsetDateTime start = OffsetDateTime.parse(text.subSequence(0, i));
            if (i + 1 < text.length() && ((c = text.charAt(i + 1)) == 'P' || c == 'p')) {
                PeriodDuration amount = PeriodDuration.parse(text.subSequence(i + 1, text.length()));
                return Interval.of(start.toInstant(), start.plus(amount).toInstant());
            }
            String remStr = text.subSequence(i + 1, text.length()).toString();
            TemporalAccessor temporal = DateTimeFormatter.ISO_DATE_TIME.parseBest(remStr, OffsetDateTime::from, LocalDateTime::from);
            if (temporal instanceof OffsetDateTime) {
                OffsetDateTime odt = (OffsetDateTime)temporal;
                return Interval.of(start.toInstant(), odt.toInstant());
            }
            LocalDateTime ldt = (LocalDateTime)temporal;
            return Interval.of(start.toInstant(), ldt.toInstant(start.getOffset()));
        }
        throw new DateTimeParseException("Interval cannot be parsed, no forward slash found", text, 0);
    }

    private Interval(Instant startInclusive, Instant endExclusive) {
        this.start = startInclusive;
        this.end = endExclusive;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public boolean isEmpty() {
        return this.start.equals(this.end);
    }

    public boolean isUnboundedStart() {
        return this.start.equals(Instant.MIN);
    }

    public boolean isUnboundedEnd() {
        return this.end.equals(Instant.MAX);
    }

    public Interval withStart(Instant start) {
        return Interval.of(start, this.end);
    }

    public Interval withEnd(Instant end) {
        return Interval.of(this.start, end);
    }

    public boolean contains(Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return this.start.compareTo(instant) <= 0 && (instant.compareTo(this.end) < 0 || this.isUnboundedEnd());
    }

    public boolean encloses(Interval other) {
        Objects.requireNonNull(other, "other");
        return this.start.compareTo(other.start) <= 0 && other.end.compareTo(this.end) <= 0;
    }

    public boolean abuts(Interval other) {
        Objects.requireNonNull(other, "other");
        return this.end.equals(other.start) ^ this.start.equals(other.end);
    }

    public boolean isConnected(Interval other) {
        Objects.requireNonNull(other, "other");
        return this.equals(other) || this.start.compareTo(other.end) <= 0 && other.start.compareTo(this.end) <= 0;
    }

    public boolean overlaps(Interval other) {
        Objects.requireNonNull(other, "other");
        return other.equals(this) || this.start.compareTo(other.end) < 0 && other.start.compareTo(this.end) < 0;
    }

    public Interval intersection(Interval other) {
        Objects.requireNonNull(other, "other");
        if (!this.isConnected(other)) {
            throw new DateTimeException("Intervals do not connect: " + this + " and " + other);
        }
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        if (cmpStart >= 0 && cmpEnd <= 0) {
            return this;
        }
        if (cmpStart <= 0 && cmpEnd >= 0) {
            return other;
        }
        Instant newStart = cmpStart >= 0 ? this.start : other.start;
        Instant newEnd = cmpEnd <= 0 ? this.end : other.end;
        return Interval.of(newStart, newEnd);
    }

    public Interval union(Interval other) {
        Objects.requireNonNull(other, "other");
        if (!this.isConnected(other)) {
            throw new DateTimeException("Intervals do not connect: " + this + " and " + other);
        }
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        if (cmpStart >= 0 && cmpEnd <= 0) {
            return other;
        }
        if (cmpStart <= 0 && cmpEnd >= 0) {
            return this;
        }
        Instant newStart = cmpStart >= 0 ? other.start : this.start;
        Instant newEnd = cmpEnd <= 0 ? other.end : this.end;
        return Interval.of(newStart, newEnd);
    }

    public Interval span(Interval other) {
        Objects.requireNonNull(other, "other");
        int cmpStart = this.start.compareTo(other.start);
        int cmpEnd = this.end.compareTo(other.end);
        Instant newStart = cmpStart >= 0 ? other.start : this.start;
        Instant newEnd = cmpEnd <= 0 ? other.end : this.end;
        return Interval.of(newStart, newEnd);
    }

    public boolean isAfter(Instant instant) {
        return this.start.compareTo(instant) > 0;
    }

    public boolean isBefore(Instant instant) {
        return this.end.compareTo(instant) <= 0 && this.start.compareTo(instant) < 0;
    }

    public boolean isAfter(Interval interval) {
        return this.start.compareTo(interval.end) >= 0 && !interval.equals(this);
    }

    public boolean isBefore(Interval interval) {
        return this.end.compareTo(interval.start) <= 0 && !interval.equals(this);
    }

    public Duration toDuration() {
        return Duration.between(this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Interval) {
            Interval other = (Interval)obj;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        return this.start.toString() + '/' + this.end.toString();
    }
}

