/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.security.scram.internals;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.sasl.SaslException;
import rpl.shaded.org.apache.kafka.common.security.scram.internals.ScramExtensions;
import rpl.shaded.org.apache.kafka.common.utils.Utils;

public class ScramMessages {

    public static class ServerFinalMessage
    extends AbstractScramMessage {
        private static final Pattern PATTERN = Pattern.compile(String.format("(?:e=(?<error>%s))|(?:v=(?<signature>%s))%s", "[\\x01-\\x7F&&[^=,]]+", BASE64, EXTENSIONS));
        private final String error;
        private final byte[] serverSignature;

        public ServerFinalMessage(byte[] messageBytes) throws SaslException {
            String message = this.toMessage(messageBytes);
            Matcher matcher = PATTERN.matcher(message);
            if (!matcher.matches()) {
                throw new SaslException("Invalid SCRAM server final message format: " + message);
            }
            String error = null;
            try {
                error = matcher.group("error");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (error == null) {
                this.serverSignature = Base64.getDecoder().decode(matcher.group("signature"));
                this.error = null;
            } else {
                this.serverSignature = null;
                this.error = error;
            }
        }

        public ServerFinalMessage(String error, byte[] serverSignature) {
            this.error = error;
            this.serverSignature = serverSignature;
        }

        public String error() {
            return this.error;
        }

        public byte[] serverSignature() {
            return this.serverSignature;
        }

        @Override
        String toMessage() {
            if (this.error != null) {
                return "e=" + this.error;
            }
            return "v=" + Base64.getEncoder().encodeToString(this.serverSignature);
        }
    }

    public static class ClientFinalMessage
    extends AbstractScramMessage {
        private static final Pattern PATTERN = Pattern.compile(String.format("c=(?<channel>%s),r=(?<nonce>%s)%s,p=(?<proof>%s)", BASE64, "[\\x21-\\x7E&&[^,]]+", EXTENSIONS, BASE64));
        private final byte[] channelBinding;
        private final String nonce;
        private byte[] proof;

        public ClientFinalMessage(byte[] messageBytes) throws SaslException {
            String message = this.toMessage(messageBytes);
            Matcher matcher = PATTERN.matcher(message);
            if (!matcher.matches()) {
                throw new SaslException("Invalid SCRAM client final message format: " + message);
            }
            this.channelBinding = Base64.getDecoder().decode(matcher.group("channel"));
            this.nonce = matcher.group("nonce");
            this.proof = Base64.getDecoder().decode(matcher.group("proof"));
        }

        public ClientFinalMessage(byte[] channelBinding, String nonce) {
            this.channelBinding = channelBinding;
            this.nonce = nonce;
        }

        public byte[] channelBinding() {
            return this.channelBinding;
        }

        public String nonce() {
            return this.nonce;
        }

        public byte[] proof() {
            return this.proof;
        }

        public void proof(byte[] proof) {
            this.proof = proof;
        }

        public String clientFinalMessageWithoutProof() {
            return String.format("c=%s,r=%s", Base64.getEncoder().encodeToString(this.channelBinding), this.nonce);
        }

        @Override
        String toMessage() {
            return String.format("%s,p=%s", this.clientFinalMessageWithoutProof(), Base64.getEncoder().encodeToString(this.proof));
        }
    }

    public static class ServerFirstMessage
    extends AbstractScramMessage {
        private static final Pattern PATTERN = Pattern.compile(String.format("%sr=(?<nonce>%s),s=(?<salt>%s),i=(?<iterations>[0-9]+)%s", RESERVED, "[\\x21-\\x7E&&[^,]]+", BASE64, EXTENSIONS));
        private final String nonce;
        private final byte[] salt;
        private final int iterations;

        public ServerFirstMessage(byte[] messageBytes) throws SaslException {
            String message = this.toMessage(messageBytes);
            Matcher matcher = PATTERN.matcher(message);
            if (!matcher.matches()) {
                throw new SaslException("Invalid SCRAM server first message format: " + message);
            }
            try {
                this.iterations = Integer.parseInt(matcher.group("iterations"));
                if (this.iterations <= 0) {
                    throw new SaslException("Invalid SCRAM server first message format: invalid iterations " + this.iterations);
                }
            }
            catch (NumberFormatException e) {
                throw new SaslException("Invalid SCRAM server first message format: invalid iterations");
            }
            this.nonce = matcher.group("nonce");
            String salt = matcher.group("salt");
            this.salt = Base64.getDecoder().decode(salt);
        }

        public ServerFirstMessage(String clientNonce, String serverNonce, byte[] salt, int iterations) {
            this.nonce = clientNonce + serverNonce;
            this.salt = salt;
            this.iterations = iterations;
        }

        public String nonce() {
            return this.nonce;
        }

        public byte[] salt() {
            return this.salt;
        }

        public int iterations() {
            return this.iterations;
        }

        @Override
        String toMessage() {
            return String.format("r=%s,s=%s,i=%d", this.nonce, Base64.getEncoder().encodeToString(this.salt), this.iterations);
        }
    }

    public static class ClientFirstMessage
    extends AbstractScramMessage {
        private static final Pattern PATTERN = Pattern.compile(String.format("n,(a=(?<authzid>%s))?,%sn=(?<saslname>%s),r=(?<nonce>%s)(?<extensions>%s)", "(?:[\\x01-\\x7F&&[^=,]]|=2C|=3D)+", RESERVED, "(?:[\\x01-\\x7F&&[^=,]]|=2C|=3D)+", "[\\x21-\\x7E&&[^,]]+", EXTENSIONS));
        private final String saslName;
        private final String nonce;
        private final String authorizationId;
        private final ScramExtensions extensions;

        public ClientFirstMessage(byte[] messageBytes) throws SaslException {
            String message = this.toMessage(messageBytes);
            Matcher matcher = PATTERN.matcher(message);
            if (!matcher.matches()) {
                throw new SaslException("Invalid SCRAM client first message format: " + message);
            }
            String authzid = matcher.group("authzid");
            this.authorizationId = authzid != null ? authzid : "";
            this.saslName = matcher.group("saslname");
            this.nonce = matcher.group("nonce");
            String extString = matcher.group("extensions");
            this.extensions = extString.startsWith(",") ? new ScramExtensions(extString.substring(1)) : new ScramExtensions();
        }

        public ClientFirstMessage(String saslName, String nonce, Map<String, String> extensions) {
            this.saslName = saslName;
            this.nonce = nonce;
            this.extensions = new ScramExtensions(extensions);
            this.authorizationId = "";
        }

        public String saslName() {
            return this.saslName;
        }

        public String nonce() {
            return this.nonce;
        }

        public String authorizationId() {
            return this.authorizationId;
        }

        public String gs2Header() {
            return "n," + this.authorizationId + ",";
        }

        public ScramExtensions extensions() {
            return this.extensions;
        }

        public String clientFirstMessageBare() {
            String extensionStr = Utils.mkString(this.extensions.map(), "", "", "=", ",");
            if (extensionStr.isEmpty()) {
                return String.format("n=%s,r=%s", this.saslName, this.nonce);
            }
            return String.format("n=%s,r=%s,%s", this.saslName, this.nonce, extensionStr);
        }

        @Override
        String toMessage() {
            return this.gs2Header() + this.clientFirstMessageBare();
        }
    }

    static abstract class AbstractScramMessage {
        static final String ALPHA = "[A-Za-z]+";
        static final String VALUE_SAFE = "[\\x01-\\x7F&&[^=,]]+";
        static final String VALUE = "[\\x01-\\x7F&&[^,]]+";
        static final String PRINTABLE = "[\\x21-\\x7E&&[^,]]+";
        static final String SASLNAME = "(?:[\\x01-\\x7F&&[^=,]]|=2C|=3D)+";
        static final String BASE64_CHAR = "[a-zA-Z0-9/+]";
        static final String BASE64 = String.format("(?:%s{4})*(?:%s{3}=|%s{2}==)?", "[a-zA-Z0-9/+]", "[a-zA-Z0-9/+]", "[a-zA-Z0-9/+]");
        static final String RESERVED = String.format("(m=%s,)?", "[\\x01-\\x7F&&[^,]]+");
        static final String EXTENSIONS = String.format("(,%s=%s)*", "[A-Za-z]+", "[\\x01-\\x7F&&[^,]]+");

        AbstractScramMessage() {
        }

        abstract String toMessage();

        public byte[] toBytes() {
            return this.toMessage().getBytes(StandardCharsets.UTF_8);
        }

        protected String toMessage(byte[] messageBytes) {
            return new String(messageBytes, StandardCharsets.UTF_8);
        }
    }
}

