/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.security.plain.internals;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import rpl.shaded.org.apache.kafka.common.errors.SaslAuthenticationException;
import rpl.shaded.org.apache.kafka.common.security.plain.PlainAuthenticateCallback;

public class PlainSaslServer
implements SaslServer {
    public static final String PLAIN_MECHANISM = "PLAIN";
    private final CallbackHandler callbackHandler;
    private boolean complete;
    private String authorizationId;

    public PlainSaslServer(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public byte[] evaluateResponse(byte[] responseBytes) throws SaslAuthenticationException {
        String response = new String(responseBytes, StandardCharsets.UTF_8);
        List<String> tokens = this.extractTokens(response);
        String authorizationIdFromClient = tokens.get(0);
        String username = tokens.get(1);
        String password = tokens.get(2);
        if (username.isEmpty()) {
            throw new SaslAuthenticationException("Authentication failed: username not specified");
        }
        if (password.isEmpty()) {
            throw new SaslAuthenticationException("Authentication failed: password not specified");
        }
        NameCallback nameCallback = new NameCallback("username", username);
        PlainAuthenticateCallback authenticateCallback = new PlainAuthenticateCallback(password.toCharArray());
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback, authenticateCallback});
        }
        catch (Throwable e) {
            throw new SaslAuthenticationException("Authentication failed: credentials for user could not be verified", e);
        }
        if (!authenticateCallback.authenticated()) {
            throw new SaslAuthenticationException("Authentication failed: Invalid username or password");
        }
        if (!authorizationIdFromClient.isEmpty() && !authorizationIdFromClient.equals(username)) {
            throw new SaslAuthenticationException("Authentication failed: Client requested an authorization id that is different from username");
        }
        this.authorizationId = username;
        this.complete = true;
        return new byte[0];
    }

    private List<String> extractTokens(String string) {
        ArrayList<String> tokens = new ArrayList<String>();
        int startIndex = 0;
        for (int i = 0; i < 4; ++i) {
            int endIndex = string.indexOf("\u0000", startIndex);
            if (endIndex == -1) {
                tokens.add(string.substring(startIndex));
                break;
            }
            tokens.add(string.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
        }
        if (tokens.size() != 3) {
            throw new SaslAuthenticationException("Invalid SASL/PLAIN response: expected 3 tokens, got " + tokens.size());
        }
        return tokens;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return this.authorizationId;
    }

    @Override
    public String getMechanismName() {
        return PLAIN_MECHANISM;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public void dispose() {
    }

    public static class PlainSaslServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            if (!PlainSaslServer.PLAIN_MECHANISM.equals(mechanism)) {
                throw new SaslException(String.format("Mechanism '%s' is not supported. Only PLAIN is supported.", mechanism));
            }
            return new PlainSaslServer(cbh);
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            if (props == null) {
                return new String[]{PlainSaslServer.PLAIN_MECHANISM};
            }
            String noPlainText = (String)props.get("javax.security.sasl.policy.noplaintext");
            if ("true".equals(noPlainText)) {
                return new String[0];
            }
            return new String[]{PlainSaslServer.PLAIN_MECHANISM};
        }
    }
}

