/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.security.oauthbearer.internals;

import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpl.shaded.org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import rpl.shaded.org.apache.kafka.common.security.auth.SaslExtensions;
import rpl.shaded.org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import rpl.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import rpl.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;

public class OAuthBearerSaslClientCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerSaslClientCallbackHandler.class);
    private boolean configured = false;

    public boolean configured() {
        return this.configured;
    }

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        this.configured = true;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.configured()) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                this.handleCallback((OAuthBearerTokenCallback)callback);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                OAuthBearerSaslClientCallbackHandler.handleCallback((SaslExtensionsCallback)callback, Subject.getSubject(AccessController.getContext()));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void close() {
    }

    private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
        Set privateCredentials;
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        Subject subject = Subject.getSubject(AccessController.getContext());
        Set<Object> set = privateCredentials = subject != null ? subject.getPrivateCredentials(OAuthBearerToken.class) : Collections.emptySet();
        if (privateCredentials.size() == 0) {
            throw new IOException("No OAuth Bearer tokens in Subject's private credentials");
        }
        if (privateCredentials.size() == 1) {
            callback.token((OAuthBearerToken)privateCredentials.iterator().next());
        } else {
            TreeSet<OAuthBearerToken> sortedByLifetime = new TreeSet<OAuthBearerToken>(new Comparator<OAuthBearerToken>(){

                @Override
                public int compare(OAuthBearerToken o1, OAuthBearerToken o2) {
                    return Long.compare(o1.lifetimeMs(), o2.lifetimeMs());
                }
            });
            sortedByLifetime.addAll(privateCredentials);
            log.warn("Found {} OAuth Bearer tokens in Subject's private credentials; the oldest expires at {}, will use the newest, which expires at {}", new Object[]{sortedByLifetime.size(), new Date(((OAuthBearerToken)sortedByLifetime.first()).lifetimeMs()), new Date(((OAuthBearerToken)sortedByLifetime.last()).lifetimeMs())});
            callback.token((OAuthBearerToken)sortedByLifetime.last());
        }
    }

    private static void handleCallback(SaslExtensionsCallback extensionsCallback, Subject subject) {
        if (subject != null && !subject.getPublicCredentials(SaslExtensions.class).isEmpty()) {
            SaslExtensions extensions = subject.getPublicCredentials(SaslExtensions.class).iterator().next();
            extensionsCallback.extensions(extensions);
        }
    }
}

