/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import rpl.shaded.org.apache.kafka.common.message.SyncGroupResponseData;
import rpl.shaded.org.apache.kafka.common.protocol.ApiKeys;
import rpl.shaded.org.apache.kafka.common.protocol.Errors;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class SyncGroupResponse
extends AbstractResponse {
    public final SyncGroupResponseData data;

    public SyncGroupResponse(SyncGroupResponseData data) {
        this.data = data;
    }

    public SyncGroupResponse(Struct struct) {
        short latestVersion = (short)(SyncGroupResponseData.SCHEMAS.length - 1);
        this.data = new SyncGroupResponseData(struct, latestVersion);
    }

    public SyncGroupResponse(Struct struct, short version) {
        this.data = new SyncGroupResponseData(struct, version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static SyncGroupResponse parse(ByteBuffer buffer, short version) {
        return new SyncGroupResponse(ApiKeys.SYNC_GROUP.parseResponse(version, buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }
}

