/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import rpl.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import rpl.shaded.org.apache.kafka.common.protocol.ApiMessage;
import rpl.shaded.org.apache.kafka.common.protocol.Message;
import rpl.shaded.org.apache.kafka.common.protocol.MessageUtil;
import rpl.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import rpl.shaded.org.apache.kafka.common.protocol.Readable;
import rpl.shaded.org.apache.kafka.common.protocol.Writable;
import rpl.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import rpl.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import rpl.shaded.org.apache.kafka.common.protocol.types.Field;
import rpl.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import rpl.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import rpl.shaded.org.apache.kafka.common.protocol.types.Schema;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.protocol.types.Type;
import rpl.shaded.org.apache.kafka.common.utils.ByteUtils;

public class LeaveGroupRequestData
implements ApiMessage {
    private String groupId;
    private String memberId;
    private List<MemberIdentity> members;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;

    public LeaveGroupRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaveGroupRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public LeaveGroupRequestData() {
        this.groupId = "";
        this.memberId = "";
        this.members = new ArrayList<MemberIdentity>();
    }

    @Override
    public short apiKey() {
        return 13;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        if (_version <= 2) {
            length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
        } else {
            this.memberId = "";
        }
        if (_version >= 3) {
            int i;
            ArrayList<MemberIdentity> newCollection;
            int arrayLength;
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field members was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MemberIdentity(_readable, _version));
                }
                this.members = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field members was serialized as null");
                }
                newCollection = new ArrayList<MemberIdentity>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MemberIdentity(_readable, _version));
                }
                this.members = newCollection;
            }
        } else {
            this.members = new ArrayList<MemberIdentity>();
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        if (_version >= 4) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        if (_version <= 2) {
            _stringBytes = _cache.getSerializedValue(this.memberId);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        } else if (!this.memberId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default memberId at version " + _version);
        }
        if (_version >= 3) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.members.size() + 1);
                _stringBytes = this.members.iterator();
                while (_stringBytes.hasNext()) {
                    MemberIdentity membersElement = (MemberIdentity)_stringBytes.next();
                    membersElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.members.size());
                _stringBytes = this.members.iterator();
                while (_stringBytes.hasNext()) {
                    MemberIdentity membersElement = (MemberIdentity)_stringBytes.next();
                    membersElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.members.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default members at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.groupId = struct.getString("group_id");
        this.memberId = _version <= 2 ? struct.getString("member_id") : "";
        if (_version >= 3) {
            Object[] _nestedObjects = struct.getArray("members");
            this.members = new ArrayList<MemberIdentity>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.members.add(new MemberIdentity((Struct)nestedObject, _version));
            }
        } else {
            this.members = new ArrayList<MemberIdentity>();
        }
        if (_version >= 4 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 4) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("group_id", (Object)this.groupId);
        if (_version <= 2) {
            struct.set("member_id", (Object)this.memberId);
        } else if (!this.memberId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default memberId at version " + _version);
        }
        if (_version >= 3) {
            Struct[] _nestedObjects = new Struct[this.members.size()];
            int i = 0;
            for (MemberIdentity element : this.members) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("members", (Object)_nestedObjects);
        } else if (!this.members.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default members at version " + _version);
        }
        if (_version >= 4) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        if (_version <= 2) {
            _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        if (_version >= 3) {
            int _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.members.size() + 1)) : (_arraySize += 4);
            for (MemberIdentity membersElement : this.members) {
                _arraySize += membersElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 4) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaveGroupRequestData)) {
            return false;
        }
        LeaveGroupRequestData other = (LeaveGroupRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        return !(this.members == null ? other.members != null : !this.members.equals(other.members));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
        return hashCode;
    }

    public String toString() {
        return "LeaveGroupRequestData(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public List<MemberIdentity> members() {
        return this.members;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaveGroupRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public LeaveGroupRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public LeaveGroupRequestData setMembers(List<MemberIdentity> v) {
        this.members = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The ID of the group to leave."), new Field("member_id", Type.STRING, "The member ID to remove from the group.")));
        SCHEMA_3 = new Schema(new Field("group_id", Type.STRING, "The ID of the group to leave."), new Field("members", new ArrayOf(MemberIdentity.SCHEMA_3), "List of leaving member identities."));
        SCHEMA_4 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The ID of the group to leave."), new Field("members", new CompactArrayOf(MemberIdentity.SCHEMA_4), "List of leaving member identities."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class MemberIdentity
    implements Message {
        private String memberId;
        private String groupInstanceId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_3 = new Schema(new Field("member_id", Type.STRING, "The member ID to remove from the group."), new Field("group_instance_id", Type.NULLABLE_STRING, "The group instance ID to remove from the group."));
        public static final Schema SCHEMA_4 = new Schema(new Field("member_id", Type.COMPACT_STRING, "The member ID to remove from the group."), new Field("group_instance_id", Type.COMPACT_NULLABLE_STRING, "The group instance ID to remove from the group."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, SCHEMA_3, SCHEMA_4};

        public MemberIdentity(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MemberIdentity(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public MemberIdentity() {
            this.memberId = "";
            this.groupInstanceId = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MemberIdentity");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.groupInstanceId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                }
                this.groupInstanceId = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MemberIdentity");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.memberId);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (this.groupInstanceId == null) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.groupInstanceId);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MemberIdentity");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.memberId = struct.getString("member_id");
            this.groupInstanceId = struct.getString("group_instance_id");
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MemberIdentity");
            }
            TreeMap _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("member_id", (Object)this.memberId);
            struct.set("group_instance_id", (Object)this.groupInstanceId);
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MemberIdentity");
            }
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (this.groupInstanceId == null) {
                _size = _version >= 4 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.groupInstanceId, _stringBytes);
                _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MemberIdentity)) {
                return false;
            }
            MemberIdentity other = (MemberIdentity)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            return !(this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
            return hashCode;
        }

        public String toString() {
            return "MemberIdentity(memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String groupInstanceId() {
            return this.groupInstanceId;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MemberIdentity setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public MemberIdentity setGroupInstanceId(String v) {
            this.groupInstanceId = v;
            return this;
        }
    }
}

