/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import rpl.shaded.org.apache.kafka.clients.admin.MemberAssignment;

public class MemberDescription {
    private final String memberId;
    private final Optional<String> groupInstanceId;
    private final String clientId;
    private final String host;
    private final MemberAssignment assignment;

    public MemberDescription(String memberId, Optional<String> groupInstanceId, String clientId, String host, MemberAssignment assignment) {
        this.memberId = memberId == null ? "" : memberId;
        this.groupInstanceId = groupInstanceId;
        this.clientId = clientId == null ? "" : clientId;
        this.host = host == null ? "" : host;
        this.assignment = assignment == null ? new MemberAssignment(Collections.emptySet()) : assignment;
    }

    public MemberDescription(String memberId, String clientId, String host, MemberAssignment assignment) {
        this(memberId, Optional.empty(), clientId, host, assignment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberDescription that = (MemberDescription)o;
        return this.memberId.equals(that.memberId) && this.groupInstanceId.equals(that.groupInstanceId) && this.clientId.equals(that.clientId) && this.host.equals(that.host) && this.assignment.equals(that.assignment);
    }

    public int hashCode() {
        return Objects.hash(this.memberId, this.groupInstanceId, this.clientId, this.host, this.assignment);
    }

    public String consumerId() {
        return this.memberId;
    }

    public Optional<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String host() {
        return this.host;
    }

    public MemberAssignment assignment() {
        return this.assignment;
    }

    public String toString() {
        return "(memberId=" + this.memberId + ", groupInstanceId=" + this.groupInstanceId.orElse("null") + ", clientId=" + this.clientId + ", host=" + this.host + ", assignment=" + this.assignment + ")";
    }
}

