/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Set;
import rpl.shaded.org.apache.kafka.clients.admin.KafkaAdminClient;
import rpl.shaded.org.apache.kafka.common.KafkaFuture;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import rpl.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import rpl.shaded.org.apache.kafka.common.protocol.Errors;

@InterfaceStability.Evolving
public class DeleteConsumerGroupOffsetsResult {
    private final KafkaFuture<Map<TopicPartition, Errors>> future;
    private final Set<TopicPartition> partitions;

    DeleteConsumerGroupOffsetsResult(KafkaFuture<Map<TopicPartition, Errors>> future, Set<TopicPartition> partitions) {
        this.future = future;
        this.partitions = partitions;
    }

    public KafkaFuture<Void> partitionResult(TopicPartition partition) {
        if (!this.partitions.contains(partition)) {
            throw new IllegalArgumentException("Partition " + partition + " was not included in the original request");
        }
        KafkaFutureImpl<Void> result2 = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicPartitions, throwable) -> {
            if (throwable != null) {
                result2.completeExceptionally((Throwable)throwable);
            } else if (!this.maybeCompleteExceptionally((Map<TopicPartition, Errors>)topicPartitions, partition, result2)) {
                result2.complete(null);
            }
        });
        return result2;
    }

    public KafkaFuture<Void> all() {
        KafkaFutureImpl<Void> result2 = new KafkaFutureImpl<Void>();
        this.future.whenComplete((topicPartitions, throwable) -> {
            if (throwable != null) {
                result2.completeExceptionally((Throwable)throwable);
            } else {
                for (TopicPartition partition : this.partitions) {
                    if (!this.maybeCompleteExceptionally((Map<TopicPartition, Errors>)topicPartitions, partition, result2)) continue;
                    return;
                }
                result2.complete(null);
            }
        });
        return result2;
    }

    private boolean maybeCompleteExceptionally(Map<TopicPartition, Errors> partitionLevelErrors, TopicPartition partition, KafkaFutureImpl<Void> result2) {
        Throwable exception = KafkaAdminClient.getSubLevelError(partitionLevelErrors, partition, "Offset deletion result for partition \"" + partition + "\" was not included in the response");
        if (exception != null) {
            result2.completeExceptionally(exception);
            return true;
        }
        return false;
    }
}

