/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.zk;

import java.io.Serializable;
import java.util.Properties;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.admin.AdminOperationException;
import rpl.shaded.kafka.admin.AdminUtils$;
import rpl.shaded.kafka.admin.BrokerMetadata;
import rpl.shaded.kafka.admin.RackAwareMode;
import rpl.shaded.kafka.admin.RackAwareMode$Disabled$;
import rpl.shaded.kafka.admin.RackAwareMode$Enforced$;
import rpl.shaded.kafka.admin.RackAwareMode$Safe$;
import rpl.shaded.kafka.cluster.Broker;
import rpl.shaded.kafka.common.TopicAlreadyMarkedForDeletionException;
import rpl.shaded.kafka.controller.ReplicaAssignment;
import rpl.shaded.kafka.controller.ReplicaAssignment$;
import rpl.shaded.kafka.log.LogConfig$;
import rpl.shaded.kafka.server.ConfigEntityName$;
import rpl.shaded.kafka.server.ConfigType$;
import rpl.shaded.kafka.server.DynamicConfig$Broker$;
import rpl.shaded.kafka.server.DynamicConfig$Client$;
import rpl.shaded.kafka.server.DynamicConfig$User$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.kafka.zk.KafkaZkClient;
import rpl.shaded.kafka.zk.TopicZNode$;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.errors.BrokerNotAvailableException;
import rpl.shaded.org.apache.kafka.common.errors.InvalidPartitionsException;
import rpl.shaded.org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import rpl.shaded.org.apache.kafka.common.errors.InvalidTopicException;
import rpl.shaded.org.apache.kafka.common.errors.TopicExistsException;
import rpl.shaded.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import rpl.shaded.org.apache.kafka.common.internals.Topic;
import rpl.shaded.org.apache.zookeeper.KeeperException;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.immutable.Map;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.immutable.Set;
import rpl.shaded.scala.math.Numeric$IntIsIntegral$;
import rpl.shaded.scala.math.Ordering$Int$;
import rpl.shaded.scala.reflect.ScalaSignature;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}a\u0001\u0002\u0011\"\u0001\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006q\u0001!\t!\u000f\u0005\u0006y\u0001!\t!\u0010\u0005\bO\u0002\t\n\u0011\"\u0001i\u0011\u001d\u0019\b!%A\u0005\u0002QDQA\u001e\u0001\u0005\u0002]D\u0001\"!\u0005\u0001#\u0003%\t\u0001\u001e\u0005\n\u0003'\u0001\u0011\u0013!C\u0001\u0003+Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wB\u0011\"a \u0001#\u0003%\t!!!\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0005bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!/\u0001\t\u0003\tY\fC\u0004\u0002D\u0002!\t!!2\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003;\u0004A\u0011AAt\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!a=\u0001\t\u0013\t)\u0010C\u0004\u0003\u0002\u0001!\tAa\u0001\t\u000f\t%\u0001\u0001\"\u0001\u0003\f!9!q\u0002\u0001\u0005\u0002\tE\u0001b\u0002B\u000b\u0001\u0011\u0005!q\u0003\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u000b\u0005\t\u001a\u0013A\u0001>l\u0015\u0005!\u0013!B6bM.\f7\u0001A\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/c5\tqF\u0003\u00021G\u0005)Q\u000f^5mg&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0003!Q8n\u00117jK:$\bCA\u001b7\u001b\u0005\t\u0013BA\u001c\"\u00055Y\u0015MZ6b5.\u001cE.[3oi\u00061A(\u001b8jiz\"\"AO\u001e\u0011\u0005U\u0002\u0001\"B\u001a\u0003\u0001\u0004!\u0014aC2sK\u0006$X\rV8qS\u000e$bAP!O'V{\u0006C\u0001\u0015@\u0013\t\u0001\u0015F\u0001\u0003V]&$\b\"\u0002\"\u0004\u0001\u0004\u0019\u0015!\u0002;pa&\u001c\u0007C\u0001#L\u001d\t)\u0015\n\u0005\u0002GS5\tqI\u0003\u0002IK\u00051AH]8pizJ!AS\u0015\u0002\rA\u0013X\rZ3g\u0013\taUJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0015&BQaT\u0002A\u0002A\u000b!\u0002]1si&$\u0018n\u001c8t!\tA\u0013+\u0003\u0002SS\t\u0019\u0011J\u001c;\t\u000bQ\u001b\u0001\u0019\u0001)\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004W\u0007A\u0005\t\u0019A,\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u00031vk\u0011!\u0017\u0006\u00035n\u000bA!\u001e;jY*\tA,\u0001\u0003kCZ\f\u0017B\u00010Z\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\bA\u000e\u0001\n\u00111\u0001b\u00035\u0011\u0018mY6Bo\u0006\u0014X-T8eKB\u0011!-Z\u0007\u0002G*\u0011AmI\u0001\u0006C\u0012l\u0017N\\\u0005\u0003M\u000e\u0014QBU1dW\u0006;\u0018M]3N_\u0012,\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0002S*\u0012qK[\u0016\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001]\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%kU\tQO\u000b\u0002bU\u0006\u0011r-\u001a;Ce>\\WM]'fi\u0006$\u0017\r^1t)\u0015A\u00181AA\u0003!\rIHP`\u0007\u0002u*\u001110K\u0001\u000bG>dG.Z2uS>t\u0017BA?{\u0005\r\u0019V-\u001d\t\u0003E~L1!!\u0001d\u00059\u0011%o\\6fe6+G/\u00193bi\u0006Dq\u0001\u0019\u0004\u0011\u0002\u0003\u0007\u0011\rC\u0005\u0002\b\u0019\u0001\n\u00111\u0001\u0002\n\u0005Q!M]8lKJd\u0015n\u001d;\u0011\u000b!\nY!a\u0004\n\u0007\u00055\u0011F\u0001\u0004PaRLwN\u001c\t\u0004sr\u0004\u0016\u0001H4fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCN$C-\u001a4bk2$H%M\u0001\u001dO\u0016$(I]8lKJlU\r^1eCR\f7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t9BK\u0002\u0002\n)\f\u0011d\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oiR9a(!\b\u0002 \u0005\r\u0002\"\u0002\"\n\u0001\u0004\u0019\u0005BBA\u0011\u0013\u0001\u0007q+\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003KI\u0001\u0019AA\u0014\u0003i\u0001\u0018M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u0019I\u0018\u0011\u0006)\u0002\u0010%\u0019\u00111\u0006>\u0003\u00075\u000b\u0007/A\nwC2LG-\u0019;f)>\u0004\u0018nY\"sK\u0006$X\rF\u0004?\u0003c\t\u0019$!\u000e\t\u000b\tS\u0001\u0019A\"\t\u000f\u0005\u0015\"\u00021\u0001\u0002(!1\u0011\u0011\u0005\u0006A\u0002]\u000bQd\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u000b\b}\u0005m\u0012QHA(\u0011\u0015\u00115\u00021\u0001D\u0011\u001d\tyd\u0003a\u0001\u0003\u0003\n\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u0019I\u0018\u0011\u0006)\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002J\r\n!bY8oiJ|G\u000e\\3s\u0013\u0011\ti%a\u0012\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000fC\u0004\u0002R-\u0001\r!a\u0015\u0002\u0011%\u001cX\u000b\u001d3bi\u0016\u00042\u0001KA+\u0013\r\t9&\u000b\u0002\b\u0005>|G.Z1o\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0007y\ni\u0006C\u0003C\u0019\u0001\u00071)A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000f\u0003O\t\u0019'!\u001a\u0002j\u00055\u0014\u0011OA;\u0011\u0015\u0011U\u00021\u0001D\u0011\u001d\t9'\u0004a\u0001\u0003\u0003\n!#\u001a=jgRLgnZ!tg&<g.\\3oi\"1\u00111N\u0007A\u0002a\f!\"\u00197m\u0005J|7.\u001a:t\u0011!\ty'\u0004I\u0001\u0002\u0004\u0001\u0016!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0005\u0002@5\u0001\n\u00111\u0001\u0002tA)\u0001&a\u0003\u0002(!I\u0011qO\u0007\u0011\u0002\u0003\u0007\u00111K\u0001\rm\u0006d\u0017\u000eZ1uK>sG._\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIQ*\"!! +\u0005AS\u0017aF1eIB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t\u0019IK\u0002\u0002t)\fq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005%%fAA*U\u0006Ib/\u00197jI\u0006$XMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)\u001dq\u0014qRAI\u0003+Cq!a\u0010\u0012\u0001\u0004\t9\u0003\u0003\u0004\u0002\u0014F\u0001\r\u0001U\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0004\u0002\u0018F\u0001\r!!'\u0002%\u00054\u0018-\u001b7bE2,'I]8lKJLEm\u001d\t\u0005\t\u0006m\u0005+C\u0002\u0002\u001e6\u00131aU3u\u0003-\u0001\u0018M]:f\u0005J|7.\u001a:\u0015\t\u0005\r\u0016Q\u0015\t\u0005Q\u0005-\u0001\u000b\u0003\u0004\u0002(J\u0001\raQ\u0001\u0007EJ|7.\u001a:\u0002\u001b\rD\u0017M\\4f\u0007>tg-[4t)\u001dq\u0014QVAY\u0003kCa!a,\u0014\u0001\u0004\u0019\u0015AC3oi&$\u0018\u0010V=qK\"1\u00111W\nA\u0002\r\u000b!\"\u001a8uSRLh*Y7f\u0011\u0019\t9l\u0005a\u0001/\u000691m\u001c8gS\u001e\u001c\u0018\u0001F2iC:<Wm\u00117jK:$\u0018\nZ\"p]\u001aLw\rF\u0003?\u0003{\u000b\t\r\u0003\u0004\u0002@R\u0001\raQ\u0001\u0012g\u0006t\u0017\u000e^5{K\u0012\u001cE.[3oi&#\u0007BBA\\)\u0001\u0007q+\u0001\u0010dQ\u0006tw-Z+tKJ|%/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jOR)a(a2\u0002L\"1\u0011\u0011Z\u000bA\u0002\r\u000b1c]1oSRL'0\u001a3F]RLG/\u001f(b[\u0016Da!a.\u0016\u0001\u00049\u0016a\u0005<bY&$\u0017\r^3U_BL7mQ8oM&<G#\u0002 \u0002R\u0006M\u0007\"\u0002\"\u0017\u0001\u0004\u0019\u0005BBA\\-\u0001\u0007q+A\tdQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$RAPAm\u00037DQAQ\fA\u0002\rCa!a.\u0018\u0001\u00049\u0016AE2iC:<WM\u0011:pW\u0016\u00148i\u001c8gS\u001e$RAPAq\u0003KDq!a9\u0019\u0001\u0004\ty!A\u0004ce>\\WM]:\t\r\u0005]\u0006\u00041\u0001X)\u0015q\u0014\u0011^Av\u0011\u001d\t9+\u0007a\u0001\u0003GCa!a.\u001a\u0001\u00049\u0016\u0001\u0006<bY&$\u0017\r^3Ce>\\WM]\"p]\u001aLw\rF\u0002?\u0003cDa!a.\u001b\u0001\u00049\u0016AE2iC:<W-\u00128uSRL8i\u001c8gS\u001e$rAPA|\u0003w\fy\u0010\u0003\u0004\u0002zn\u0001\raQ\u0001\u000fe>|G/\u00128uSRLH+\u001f9f\u0011\u0019\tip\u0007a\u0001\u0007\u00069b-\u001e7m'\u0006t\u0017\u000e^5{K\u0012,e\u000e^5us:\u000bW.\u001a\u0005\u0007\u0003o[\u0002\u0019A,\u0002#\u0019,Go\u00195F]RLG/_\"p]\u001aLw\rF\u0003X\u0005\u000b\u00119\u0001\u0003\u0004\u0002zr\u0001\ra\u0011\u0005\u0007\u0003\u0013d\u0002\u0019A\"\u0002%\u001d,G/\u00117m)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0003\u0005\u001b\u0001R!_A\u0015\u0007^\u000bQCZ3uG\"\fE\u000e\\#oi&$\u0018pQ8oM&<7\u000f\u0006\u0003\u0003\u000e\tM\u0001BBAX=\u0001\u00071)\u0001\u000egKR\u001c\u0007.\u00117m\u0007\"LG\u000eZ#oi&$\u0018pQ8oM&<7\u000f\u0006\u0004\u0003\u000e\te!1\u0004\u0005\u0007\u0003s|\u0002\u0019A\"\t\r\tuq\u00041\u0001D\u0003=\u0019\u0007.\u001b7e\u000b:$\u0018\u000e^=UsB,\u0007")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        rpl.shaded.scala.collection.Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, -1, -1);
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public rpl.shaded.scala.collection.Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<rpl.shaded.scala.collection.Seq<Object>> brokerList) {
        rpl.shaded.scala.collection.Seq seq;
        void var8_6;
        rpl.shaded.scala.collection.Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        if (brokerList == null) {
            throw null;
        }
        if (brokerList.isEmpty()) {
            None$ none$ = None$.MODULE$;
        } else {
            rpl.shaded.scala.collection.Seq<Object> seq2 = brokerList.get();
            Some<rpl.shaded.scala.collection.Seq> some = new Some<rpl.shaded.scala.collection.Seq>(AdminZkClient.$anonfun$getBrokerMetadatas$1(allBrokers, seq2));
        }
        Object var8_7 = null;
        void getOrElse_this = var8_6;
        rpl.shaded.scala.collection.Seq<Broker> seq3 = getOrElse_this.isEmpty() ? allBrokers : getOrElse_this.get();
        rpl.shaded.scala.collection.Seq<Broker> seq4 = seq3;
        Object var9_9 = null;
        seq3 = null;
        rpl.shaded.scala.collection.Seq<Broker> brokers = seq4;
        rpl.shaded.scala.collection.Seq brokersWithRack = (rpl.shaded.scala.collection.Seq)brokers.filter((Function1<Broker, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.length() < brokers.length()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        if (RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode)) {
            seq = (rpl.shaded.scala.collection.Seq)brokers.map((Function1<Broker, BrokerMetadata> & Serializable)broker -> new BrokerMetadata(broker.id(), None$.MODULE$));
            return (rpl.shaded.scala.collection.Seq)seq.sortBy((Function1<BrokerMetadata, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.id()), Ordering$Int$.MODULE$);
        }
        if (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode)) {
            if (brokersWithRack == null) {
                throw null;
            }
            if (brokersWithRack.length() < brokers.length()) {
                seq = (rpl.shaded.scala.collection.Seq)brokers.map((Function1<Broker, BrokerMetadata> & Serializable)broker -> new BrokerMetadata(broker.id(), None$.MODULE$));
                return (rpl.shaded.scala.collection.Seq)seq.sortBy((Function1<BrokerMetadata, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.id()), Ordering$Int$.MODULE$);
            }
        }
        seq = (rpl.shaded.scala.collection.Seq)brokers.map((Function1<Broker, BrokerMetadata> & Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack()));
        return (rpl.shaded.scala.collection.Seq)seq.sortBy((Function1<BrokerMetadata, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.id()), Ordering$Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<rpl.shaded.scala.collection.Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> partitionReplicaAssignment) {
        this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        this.info((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(58).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").toString()).append(new StringBuilder(11).append("assignment ").append(partitionReplicaAssignment).toString()).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment.mapValues((Function1<rpl.shaded.scala.collection.Seq, ReplicaAssignment> & Serializable)x$3 -> ReplicaAssignment$.MODULE$.apply((rpl.shaded.scala.collection.Seq<Object>)x$3)).toMap($less$colon$less$.MODULE$.refl()), false);
    }

    public void validateTopicCreate(String topic, rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> partitionReplicaAssignment, Properties config) {
        Topic.validate(topic);
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars(topic)) {
            Set<String> allTopics = this.zkClient.getAllTopicsInCluster();
            if (allTopics.contains(topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Set collidingTopics = (Set)allTopics.filter((Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$4)));
            if (collidingTopics.nonEmpty()) {
                String mkString_sep = ", ";
                Object var8_6 = null;
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString("", mkString_sep, "")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1<rpl.shaded.scala.collection.Seq, Object> & Serializable)x$5 -> BoxesRunTime.boxToInteger(x$5.size()))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1<rpl.shaded.scala.collection.Seq, Object> & Serializable)reps -> {
            AdminZkClient.$anonfun$validateTopicCreate$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt(((IterableOnceOps)partitionReplicaAssignment.keys().filter(x$6 -> x$6 >= 0)).sum(Numeric$IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig$.MODULE$.validate(config);
    }

    private void writeTopicPartitionAssignment(String topic, rpl.shaded.scala.collection.Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate) {
        try {
            Map<TopicPartition, ReplicaAssignment> assignment = replicaAssignment.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError((Object)null);
                }
                int partitionId = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                Tuple2<TopicPartition, ReplicaAssignment> tuple2 = new Tuple2<TopicPartition, ReplicaAssignment>(new TopicPartition(topic, partitionId), replicas);
                return tuple2;
            }).toMap($less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                this.zkClient.createTopicAssignment(topic, assignment.mapValues((Function1<ReplicaAssignment, rpl.shaded.scala.collection.Seq> & Serializable)x$7 -> x$7.replicas()).toMap($less$colon$less$.MODULE$.refl()));
            } else {
                this.zkClient.setTopicAssignment(topic, assignment, this.zkClient.setTopicAssignment$default$3());
            }
            this.debug((Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension("Updated path %s with %s for replica assignment", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension("topic %s is already marked for deletion", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> addPartitions(String topic, rpl.shaded.scala.collection.Map<Object, ReplicaAssignment> existingAssignment, rpl.shaded.scala.collection.Seq<BrokerMetadata> allBrokers, int numPartitions, Option<rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>>> replicaAssignment, boolean validateOnly) {
        rpl.shaded.scala.collection.Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse(0, (Function0<Nothing$> & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(0).append(new StringBuilder(80).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").toString()).append(new StringBuilder(12).append("Assignment: ").append(existingAssignment).toString()).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(0).append("The number of partitions for a topic can only be increased. ").append(new StringBuilder(34).append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").toString()).append(new StringBuilder(26).append(numPartitions).append(" would not be an increase.").toString()).toString());
        }
        if (replicaAssignment == null) {
            throw null;
        }
        if (!replicaAssignment.isEmpty()) {
            rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> map = replicaAssignment.get();
            AdminZkClient.$anonfun$addPartitions$2(this, existingAssignmentPartition0, allBrokers, map);
        }
        rpl.shaded.scala.collection.Map map = replicaAssignment.isEmpty() ? AdminZkClient.$anonfun$addPartitions$4(allBrokers, existingAssignmentPartition0, partitionsToAdd, existingAssignment) : replicaAssignment.get();
        rpl.shaded.scala.collection.Map map2 = map;
        map = null;
        rpl.shaded.scala.collection.Map proposedAssignmentForNewPartitions = map2;
        rpl.shaded.scala.collection.Map proposedAssignment = (rpl.shaded.scala.collection.Map)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            Tuple2<Integer, void> tuple2;
            void apply_removingReplicas;
            ReplicaAssignment replicaAssignment;
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            int tp = x0$1._1$mcI$sp();
            rpl.shaded.scala.collection.Seq replicas = (rpl.shaded.scala.collection.Seq)x0$1._2();
            Nil$ nil$ = Nil$.MODULE$;
            Nil$ apply_addingReplicas = Nil$.MODULE$;
            ReplicaAssignment replicaAssignment2 = replicaAssignment = new ReplicaAssignment(replicas, apply_addingReplicas, (rpl.shaded.scala.collection.Seq<Object>)apply_removingReplicas);
            Object var7_4 = null;
            nil$ = null;
            replicaAssignment = null;
            ReplicaAssignment replicaAssignment3 = replicaAssignment2;
            Integer $minus$greater$extension_$this = tp;
            Tuple2<Integer, void> tuple22 = tuple2 = new Tuple2<Integer, void>($minus$greater$extension_$this, $minus$greater$extension_y);
            Object var4_7 = null;
            replicaAssignment3 = null;
            tuple2 = null;
            Tuple2<Integer, void> tuple23 = tuple22;
            return tuple23;
        }));
        if (!validateOnly) {
            this.info((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Creating ").append(partitionsToAdd).append(" partitions for '").append(topic).append("' with the following replica assignment: ").toString()).append(new StringBuilder(1).append(proposedAssignmentForNewPartitions).append(".").toString()).toString());
            this.writeTopicPartitionAssignment(topic, proposedAssignment, true);
        }
        return proposedAssignment.mapValues((Function1<ReplicaAssignment, rpl.shaded.scala.collection.Seq> & Serializable)x$10 -> x$10.replicas()).toMap($less$colon$less$.MODULE$.refl());
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void validateReplicaAssignment(rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            Tuple2<Integer, void> tuple2;
            Integer n;
            rpl.shaded.scala.collection.Seq replicas;
            int partitionId;
            if (x0$1 != null) {
                partitionId = x0$1._1$mcI$sp();
                replicas = (rpl.shaded.scala.collection.Seq)x0$1._2();
                if (replicas.isEmpty()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
                }
                if (replicas.length() != replicas.toSet().size()) {
                    String mkString_sep = ", ";
                    Object var5_4 = null;
                    throw new InvalidReplicaAssignmentException(new StringBuilder(0).append("Duplicate brokers not allowed in replica assignment: ").append(new StringBuilder(19).append(replicas.mkString("", mkString_sep, "")).append(" for partition id ").append(partitionId).append(".").toString()).toString());
                }
                if (!replicas.toSet().subsetOf(availableBrokerIds)) {
                    String mkString_sep = ", ";
                    Object var6_5 = null;
                    String mkString_sep2 = ", ";
                    Object var7_6 = null;
                    throw new BrokerNotAvailableException(new StringBuilder(0).append(new StringBuilder(60).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").toString()).append(new StringBuilder(21).append("Specified brokers: ").append(replicas.mkString("", mkString_sep, "")).append(", ").toString()).append(new StringBuilder(20).append("available brokers: ").append(availableBrokerIds.mkString("", mkString_sep2, "")).append(".").toString()).toString());
                }
            } else {
                throw new MatchError((Object)null);
            }
            Integer n2 = n = Integer.valueOf(replicas.length());
            n = null;
            Integer n3 = n2;
            Integer $minus$greater$extension_$this = partitionId;
            Tuple2<Integer, void> tuple22 = tuple2 = new Tuple2<Integer, void>($minus$greater$extension_$this, $minus$greater$extension_y);
            Object var8_9 = null;
            n3 = null;
            tuple2 = null;
            Tuple2<Integer, void> tuple23 = tuple22;
            return tuple23;
        });
        rpl.shaded.scala.collection.Map badRepFactors = (rpl.shaded.scala.collection.Map)replicaAssignment.collect(new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, rpl.shaded.scala.collection.Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_11;
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    rpl.shaded.scala.collection.Seq<Object> replicas = x1._2();
                    if (replicas == null) {
                        throw null;
                    }
                    if (replicas.length() != this.expectedReplicationFactor$1) {
                        void $minus$greater$extension_y;
                        Tuple2<Integer, void> tuple2;
                        Integer n;
                        Integer n2 = n = Integer.valueOf(replicas.length());
                        n = null;
                        Integer n3 = n2;
                        Integer $minus$greater$extension_$this = partition;
                        Tuple2<Integer, void> tuple22 = tuple2 = new Tuple2<Integer, void>($minus$greater$extension_$this, $minus$greater$extension_y);
                        Object var6_7 = null;
                        n3 = null;
                        tuple2 = null;
                        Tuple2<Integer, void> tuple23 = tuple22;
                        return var3_11;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var3_11;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Object, rpl.shaded.scala.collection.Seq<Object>> x1) {
                if (x1 == null) return false;
                rpl.shaded.scala.collection.Seq<Object> replicas = x1._2();
                if (replicas == null) {
                    throw null;
                }
                if (replicas.length() == this.expectedReplicationFactor$1) return false;
                return true;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            void mkString_sep;
            void mkString_sep2;
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToInteger(AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$2)), Ordering$Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToInteger(AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$3)));
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1<Tuple2, Object> & Serializable)x0$4 -> BoxesRunTime.boxToInteger(AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$4)));
            String string = ", ";
            if (partitions == null) {
                throw null;
            }
            string = null;
            String string2 = ", ";
            if (repFactors == null) {
                throw null;
            }
            string2 = null;
            throw new InvalidReplicaAssignmentException(new StringBuilder(0).append("Inconsistent replication factor between partitions, ").append(new StringBuilder(42).append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString("", (String)mkString_sep2, "")).append("] have ").toString()).append(new StringBuilder(37).append("replication factors [").append(repFactors.mkString("", (String)mkString_sep, "")).append("], respectively.").toString()).toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        Option option;
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            option = None$.MODULE$;
        } else {
            Some<Integer> some;
            try {
                some = new Some<Integer>(Integer.parseInt(broker));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
            }
            option = some;
        }
        return option;
    }

    public void changeConfigs(String entityType, String entityName, Properties configs) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(49).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.Topic()).append(", ").append(ConfigType$.MODULE$.Client()).append(", ").append(ConfigType$.MODULE$.Broker()).toString());
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate(topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new AdminOperationException(StringOps$.MODULE$.format$extension("Topic \"%s\" does not exist.", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
        LogConfig$.MODULE$.validate(configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs);
    }

    public void changeBrokerConfig(rpl.shaded.scala.collection.Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach(broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)broker).toString(), configs));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        Object object;
        this.validateBrokerConfig(configs);
        String string = ConfigType$.MODULE$.Broker();
        if (broker == null) {
            throw null;
        }
        Option option = broker.isEmpty() ? None$.MODULE$ : new Some<String>(((Object)BoxesRunTime.unboxToInt(broker.get())).toString());
        None$ none$ = option;
        option = null;
        None$ getOrElse_this = none$;
        if (getOrElse_this.isEmpty()) {
            String string2;
            String string3 = string2 = ConfigEntityName$.MODULE$.Default();
            string2 = null;
            object = string3;
        } else {
            object = ((Option)getOrElse_this).get();
        }
        Object a = object;
        Object var4_4 = null;
        object = null;
        this.changeEntityConfig(string, (String)a, configs);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public rpl.shaded.scala.collection.Map<String, Properties> getAllTopicConfigs() {
        return ((IterableOnceOps)this.zkClient.getAllTopicsInCluster().map((Function1<String, Tuple2> & Serializable)topic -> new Tuple2<String, Properties>((String)topic, this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)))).toMap($less$colon$less$.MODULE$.refl());
    }

    public rpl.shaded.scala.collection.Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1<String, Tuple2> & Serializable)entity -> new Tuple2<String, Properties>((String)entity, this.fetchEntityConfig(entityType, (String)entity)))).toMap($less$colon$less$.MODULE$.refl());
    }

    public rpl.shaded.scala.collection.Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1(None$.MODULE$, rootEntityType).flatMap((Function1<String, rpl.shaded.scala.collection.Seq> & Serializable)entity -> this.entityPaths$1(new Some<String>(new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1<String, Tuple2> & Serializable)entityPath -> new Tuple2<String, Properties>((String)entityPath, this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap($less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ rpl.shaded.scala.collection.Seq $anonfun$getBrokerMetadatas$1(rpl.shaded.scala.collection.Seq allBrokers$1, rpl.shaded.scala.collection.Seq brokerIds) {
        return (rpl.shaded.scala.collection.Seq)allBrokers$1.filter((Function1<Broker, Object> & Serializable)b -> BoxesRunTime.boxToBoolean(brokerIds.contains(b.id())));
    }

    public static final /* synthetic */ rpl.shaded.scala.collection.Seq $anonfun$getBrokerMetadatas$3(rpl.shaded.scala.collection.Seq allBrokers$1) {
        return allBrokers$1;
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        Option<String> option = x$1.rack();
        if (option == null) {
            throw null;
        }
        return option.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$4) {
        return Topic.hasCollision(topic$2, x$4);
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$3(rpl.shaded.scala.collection.Map partitionReplicaAssignment$2, rpl.shaded.scala.collection.Seq reps) {
        if (reps == null) {
            throw null;
        }
        if (reps.length() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$addPartitions$2(AdminZkClient $this, rpl.shaded.scala.collection.Seq existingAssignmentPartition0$1, rpl.shaded.scala.collection.Seq allBrokers$2, rpl.shaded.scala.collection.Map proposedReplicaAssignment) {
        if (existingAssignmentPartition0$1 == null) {
            throw null;
        }
        $this.validateReplicaAssignment(proposedReplicaAssignment, existingAssignmentPartition0$1.length(), ((IterableOnceOps)allBrokers$2.map((Function1<BrokerMetadata, Object> & Serializable)x$8 -> BoxesRunTime.boxToInteger(x$8.id()))).toSet());
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$5(rpl.shaded.scala.collection.Seq existingAssignmentPartition0$1, BrokerMetadata x$9) {
        return x$9.id() >= BoxesRunTime.unboxToInt(existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ rpl.shaded.scala.collection.Map $anonfun$addPartitions$4(rpl.shaded.scala.collection.Seq allBrokers$2, rpl.shaded.scala.collection.Seq existingAssignmentPartition0$1, int partitionsToAdd$1, rpl.shaded.scala.collection.Map existingAssignment$1) {
        int n = Math.max(0, allBrokers$2.indexWhere((Function1<BrokerMetadata, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(AdminZkClient.$anonfun$addPartitions$5(existingAssignmentPartition0$1, x$9))));
        if (existingAssignmentPartition0$1 == null) {
            throw null;
        }
        return AdminUtils$.MODULE$.assignReplicasToBrokers(allBrokers$2, partitionsToAdd$1, existingAssignmentPartition0$1.length(), n, existingAssignment$1.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError((Object)null);
        }
        int partitionId = x0$2._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$3) {
        void var1_1;
        if (x0$3 == null) {
            throw new MatchError((Object)null);
        }
        int partitionId = x0$3._1$mcI$sp();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$4) {
        void var1_1;
        if (x0$4 == null) {
            throw new MatchError((Object)null);
        }
        int rf = x0$4._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$11) {
        return ((Object)BoxesRunTime.boxToInteger(x$11)).toString();
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$3() {
        return ConfigEntityName$.MODULE$.Default();
    }

    private final rpl.shaded.scala.collection.Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        rpl.shaded.scala.collection.Seq seq;
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError(rootPath);
        }
        rpl.shaded.scala.collection.Seq entityNames = this.zkClient.getAllEntitiesWithConfig(string);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            seq = (rpl.shaded.scala.collection.Seq)entityNames.map((Function1<String, String> & Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString());
        } else if (None$.MODULE$.equals(rootPath)) {
            seq = entityNames;
        } else {
            throw new MatchError(rootPath);
        }
        return seq;
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public static final /* synthetic */ Object $anonfun$addPartitions$2$adapted(AdminZkClient $this, rpl.shaded.scala.collection.Seq existingAssignmentPartition0$1, rpl.shaded.scala.collection.Seq allBrokers$2, rpl.shaded.scala.collection.Map proposedReplicaAssignment) {
        AdminZkClient.$anonfun$addPartitions$2($this, existingAssignmentPartition0$1, allBrokers$2, proposedReplicaAssignment);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2$adapted(Object x$11) {
        return AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt(x$11));
    }
}

