/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.tools;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import rpl.shaded.kafka.utils.CommandLineUtils$;
import rpl.shaded.kafka.utils.Exit$;
import rpl.shaded.kafka.utils.ToolsUtils$;
import rpl.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import rpl.shaded.org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import rpl.shaded.org.apache.kafka.common.PartitionInfo;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.serialization.ByteArrayDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.Deserializer;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Console$;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.IterableOnce;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.MapOps;
import rpl.shaded.scala.collection.Seq;
import rpl.shaded.scala.collection.immutable.Set;
import rpl.shaded.scala.collection.immutable.Set$EmptySet$;
import rpl.shaded.scala.collection.mutable.ArraySeq;
import rpl.shaded.scala.collection.mutable.Buffer;
import rpl.shaded.scala.collection.mutable.Buffer$;
import rpl.shaded.scala.math.Ordering$Int$;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class GetOffsetShell$ {
    public static final GetOffsetShell$ MODULE$ = new GetOffsetShell$();

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        rpl.shaded.scala.collection.Map map;
        void var21_30;
        Set<Object> set;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that. [Note: No offset is returned, if the timestamp greater than recently commited record timestamp is given.]").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)-1L, (Object[])new Long[0]);
        parser.accepts("offsets", "DEPRECATED AND IGNORED: number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
        parser.accepts("max-wait-ms", "DEPRECATED AND IGNORED: The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)1000, (Object[])new Integer[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting topic offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, ScalaRunTime$.MODULE$.wrapRefArray(new OptionSpec[]{brokerListOpt, topicOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        String partitionsString = (String)options.valueOf((OptionSpec)partitionOpt);
        if (partitionsString.isEmpty()) {
            if (Predef$.MODULE$.Set() == null) {
                throw null;
            }
            set = Set$EmptySet$.MODULE$;
        } else {
            Object var28_16;
            int[] nArray;
            int[] nArray2;
            String[] map$extension_$this = partitionsString.split(",");
            int n = map$extension_$this.length;
            int[] nArray3 = nArray2 = new int[n];
            nArray2 = null;
            int[] nArray4 = nArray = nArray3;
            nArray = null;
            int[] map$extension_ys = nArray4;
            if (n > 0) {
                for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                    int n2;
                    String string = map$extension_$this[map$extension_i];
                    map$extension_ys[map$extension_i] = n2 = GetOffsetShell$.$anonfun$main$1(partitionsString, string);
                }
            }
            void v3 = var28_16;
            Object var27_12 = null;
            var28_16 = null;
            ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray((int[])v3);
            if (ofInt2 == null) {
                throw null;
            }
            ArraySeq.ofInt toSet_this = ofInt2;
            Set set2 = IterableOnceOps.toSet$(toSet_this);
            set = set2;
            Object var25_20 = null;
            set2 = null;
        }
        Set$EmptySet$ partitionIdsRequested = set;
        long listOffsetsTimestamp = (Long)options.valueOf((OptionSpec)timeOpt);
        Properties config = new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId);
        KafkaConsumer<byte[], byte[]> consumer = new KafkaConsumer<byte[], byte[]>(config, (Deserializer<byte[]>)new ByteArrayDeserializer(), (Deserializer<byte[]>)new ByteArrayDeserializer());
        boolean bl = false;
        Some some = null;
        Option<Seq<PartitionInfo>> option = this.listPartitionInfos(consumer, topic, partitionIdsRequested);
        if (None$.MODULE$.equals(option)) {
            System.err.println(new StringBuilder(21).append("Topic ").append(topic).append(" does not exist").toString());
            throw Exit$.MODULE$.exit(1, None$.MODULE$);
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            if (((Seq)some.value()).isEmpty()) {
                if (partitionIdsRequested.isEmpty()) {
                    System.err.println(new StringBuilder(23).append("Topic ").append(topic).append(" has 0 partitions").toString());
                } else {
                    String mkString_sep = ",";
                    Object var24_29 = null;
                    System.err.println(new StringBuilder(53).append("Topic ").append(topic).append(" does not have any of the requested partitions ").append(partitionIdsRequested.mkString("", mkString_sep, "")).toString());
                }
                throw Exit$.MODULE$.exit(1, None$.MODULE$);
            }
        }
        if (!bl) {
            throw new MatchError(option);
        }
        Seq p2 = (Seq)some.value();
        if (partitionIdsRequested.nonEmpty()) {
            IterableOnce $minus$minus_that = (IterableOnce)var21_30.map((Function1<PartitionInfo, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.partition()));
            Object var31_31 = null;
            partitionIdsRequested.removedAll($minus$minus_that).foreach(partitionId -> System.err.println(new StringBuilder(32).append("Error: partition ").append(partitionId).append(" does not exist").toString()));
        }
        Seq topicPartitions = (Seq)((IterableOps)var21_30.sortBy((Function1<PartitionInfo, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.partition()), Ordering$Int$.MODULE$)).flatMap((Function1<PartitionInfo, Option> & Serializable)p -> {
            if (p.leader() == null) {
                System.err.println(new StringBuilder(62).append("Error: partition ").append(p.partition()).append(" does not have a leader. Skip getting offsets").toString());
                return None$.MODULE$;
            }
            return new Some<TopicPartition>(new TopicPartition(p.topic(), p.partition()));
        });
        if (-2L == listOffsetsTimestamp) {
            map = JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets(JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
        } else if (-1L == listOffsetsTimestamp) {
            map = JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets(JavaConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
        } else {
            Map<TopicPartition, Long> timestampsToSearch = JavaConverters$.MODULE$.mapAsJavaMapConverter(((IterableOnceOps)topicPartitions.map((Function1<TopicPartition, Tuple2> & Serializable)tp -> {
                Long l;
                Long l2 = l = Long.valueOf(listOffsetsTimestamp);
                l = null;
                Long $minus$greater$extension_y = l2;
                return new Tuple2<TopicPartition, Long>((TopicPartition)tp, $minus$greater$extension_y);
            })).toMap($less$colon$less$.MODULE$.refl())).asJava();
            map = (rpl.shaded.scala.collection.Map)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes(timestampsToSearch)).asScala()).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError((Object)null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                OffsetAndTimestamp x = (OffsetAndTimestamp)x0$1._2();
                Tuple2<TopicPartition, Object> tuple2 = x == null ? new Tuple2<TopicPartition, Object>(k, null) : new Tuple2<TopicPartition, Long>(k, x.offset());
                return tuple2;
            });
        }
        ((IterableOnceOps)map.toSeq().sortBy((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToInteger(GetOffsetShell$.$anonfun$main$8(x0$2)), Ordering$Int$.MODULE$)).foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> {
            GetOffsetShell$.$anonfun$main$9(topic, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<PartitionInfo>> listPartitionInfos(KafkaConsumer<?, ?> consumer, String topic, Set<Object> partitionIds) {
        IterableOnceOps iterableOnceOps = (IterableOnceOps)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(consumer.listTopics()).asScala()).filterKeys((Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(GetOffsetShell$.$anonfun$listPartitionInfos$1(topic, x$3))).values().flatMap((Function1<List, Buffer> & Serializable)x$4 -> JavaConverters$.MODULE$.asScalaBufferConverter(x$4).asScala());
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps toBuffer_this = iterableOnceOps;
        Object var5_4 = null;
        Buffer partitionInfos = (Buffer)Buffer$.MODULE$.from((IterableOnce)((Object)toBuffer_this));
        if (partitionInfos.isEmpty()) {
            return None$.MODULE$;
        }
        if (partitionIds.isEmpty()) {
            return new Some<Seq<PartitionInfo>>(partitionInfos);
        }
        return new Some<Seq<PartitionInfo>>((Seq<PartitionInfo>)partitionInfos.filter((Function1<PartitionInfo, Object> & Serializable)p -> BoxesRunTime.boxToBoolean(partitionIds.contains(p.partition()))));
    }

    public static final /* synthetic */ int $anonfun$main$1(String partitionsString$1, String partitionString) {
        try {
            return Integer.parseInt(partitionString);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(new StringBuilder(84).append("--partitions expects a comma separated list of numeric partition ids, but received: ").append(partitionsString$1).toString());
            throw Exit$.MODULE$.exit(1, None$.MODULE$);
        }
    }

    public static final /* synthetic */ int $anonfun$main$8(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError((Object)null);
        }
        int n = ((TopicPartition)x0$2._1()).partition();
        return n;
    }

    public static final /* synthetic */ String $anonfun$main$10() {
        return "";
    }

    public static final /* synthetic */ void $anonfun$main$9(String topic$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Object object;
            TopicPartition tp = (TopicPartition)x0$3._1();
            Long offset = (Long)x0$3._2();
            StringBuilder stringBuilder = new StringBuilder(2).append(topic$1).append(":").append(tp.partition()).append(":");
            Option<Long> option = Option$.MODULE$.apply(offset);
            if (option == null) {
                throw null;
            }
            Option<Long> getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string;
                String string2 = string = "";
                string = null;
                object = string2;
            } else {
                object = getOrElse_this.get();
            }
            Long l = object;
            Object var4_4 = null;
            object = null;
            String println_x = stringBuilder.append(l).toString();
            Console$.MODULE$.println(println_x);
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ boolean $anonfun$listPartitionInfos$1(String topic$2, String x$3) {
        String string = x$3;
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    private GetOffsetShell$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(String partitionsString$1, String partitionString) {
        return BoxesRunTime.boxToInteger(GetOffsetShell$.$anonfun$main$1(partitionsString$1, partitionString));
    }
}

