/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.server;

import java.util.concurrent.TimeUnit;
import rpl.shaded.kafka.network.RequestChannel;
import rpl.shaded.kafka.server.ClientQuotaManager;
import rpl.shaded.kafka.server.ClientQuotaManagerConfig;
import rpl.shaded.kafka.server.ClientQuotaManagerConfig$;
import rpl.shaded.kafka.server.QuotaType$Request$;
import rpl.shaded.org.apache.kafka.common.MetricName;
import rpl.shaded.org.apache.kafka.common.metrics.KafkaMetric;
import rpl.shaded.org.apache.kafka.common.metrics.Metrics;
import rpl.shaded.org.apache.kafka.common.metrics.Sensor;
import rpl.shaded.org.apache.kafka.common.utils.Time;
import rpl.shaded.org.apache.kafka.server.quota.ClientQuotaCallback;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.immutable.Map;
import rpl.shaded.scala.reflect.ScalaSignature;
import rpl.shaded.scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\u000b\u0017\u0001mA\u0001\u0002\t\u0001\u0003\u0006\u0004%I!\t\u0005\tK\u0001\u0011\t\u0011)A\u0005E!Aa\u0005\u0001BC\u0002\u0013%q\u0005\u0003\u00055\u0001\t\u0005\t\u0015!\u0003)\u0011!)\u0004A!b\u0001\n\u00131\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u00061\u0002!\t!\u0017\u0005\bA\u0002\u0011\r\u0011\"\u0001b\u0011\u0019)\u0007\u0001)A\u0005E\")a\r\u0001C\u0001O\")1\u000e\u0001C\u0001Y\")Q\u000f\u0001C\u0001m\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\n\u0001\u0011E\u0013Q\u0003\u0005\b\u0003C\u0001A\u0011KA\u0012\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002@\u0001!I!!\u0011\u00033\rc\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM\u001d\u0006\u0003/a\taa]3sm\u0016\u0014(\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;yi\u0011AF\u0005\u0003?Y\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000611m\u001c8gS\u001e,\u0012A\t\t\u0003;\rJ!\u0001\n\f\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u000f5,GO]5dgV\t\u0001\u0006\u0005\u0002*e5\t!F\u0003\u0002'W)\u0011A&L\u0001\u0007G>lWn\u001c8\u000b\u0005eq#BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,W#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005iZ\u0013!B;uS2\u001c\u0018B\u0001\u001f:\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bC\u0001!J\u001d\t\tu\t\u0005\u0002C\u000b6\t1I\u0003\u0002E5\u00051AH]8pizR\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u000ba\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001*R\u0001\u000ecV|G/Y\"bY2\u0014\u0017mY6\u0011\u00079{\u0015+D\u0001F\u0013\t\u0001VI\u0001\u0004PaRLwN\u001c\t\u0003%Zk\u0011a\u0015\u0006\u0003)V\u000bQ!];pi\u0006T!aF\u0017\n\u0005]\u001b&aE\"mS\u0016tG/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017A\u0002\u001fj]&$h\b\u0006\u0004[7rkfl\u0018\t\u0003;\u0001AQ\u0001I\u0005A\u0002\tBQAJ\u0005A\u0002!BQ!N\u0005A\u0002]BQAP\u0005A\u0002}BQ\u0001T\u0005A\u00025\u000b\u0011#\\1y)\"\u0014x\u000e\u001e;mKRKW.Z't+\u0005\u0011\u0007C\u0001(d\u0013\t!WI\u0001\u0003M_:<\u0017AE7bqRC'o\u001c;uY\u0016$\u0016.\\3Ng\u0002\nA\"\u001a=f[B$8+\u001a8t_J,\u0012\u0001\u001b\t\u0003S%L!A\u001b\u0016\u0003\rM+gn]8s\u00031\u0011XmY8sI\u0016CX-\u001c9u)\ti\u0007\u000f\u0005\u0002O]&\u0011q.\u0012\u0002\u0005+:LG\u000fC\u0003r\u001b\u0001\u0007!/A\u0003wC2,X\r\u0005\u0002Og&\u0011A/\u0012\u0002\u0007\t>,(\r\\3\u0002?5\f\u0017PY3SK\u000e|'\u000fZ!oI\u001e+G\u000f\u00165s_R$H.\u001a+j[\u0016l5\u000f\u0006\u0002xuB\u0011a\n_\u0005\u0003s\u0016\u00131!\u00138u\u0011\u0015Yh\u00021\u0001}\u0003\u001d\u0011X-];fgR\u00042!`A\u0004\u001d\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\r\u0002\u000f9,Go^8sW&\u0019\u0011QA@\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011\u0011BA\u0006\u0005\u001d\u0011V-];fgRT1!!\u0002\u0000\u0003Ei\u0017-\u001f2f%\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f\u001e\u000b\u0004[\u0006E\u0001\"B>\u0010\u0001\u0004a\u0018\u0001\u0004;ie>$H\u000f\\3US6,Gc\u00012\u0002\u0018!9\u0011\u0011\u0004\tA\u0002\u0005m\u0011\u0001D2mS\u0016tG/T3ue&\u001c\u0007cA\u0015\u0002\u001e%\u0019\u0011q\u0004\u0016\u0003\u0017-\u000bgm[1NKR\u0014\u0018nY\u0001\u0015G2LWM\u001c;SCR,W*\u001a;sS\u000et\u0015-\\3\u0015\t\u0005\u0015\u0012Q\u0006\t\u0005\u0003O\tI#D\u0001,\u0013\r\tYc\u000b\u0002\u000b\u001b\u0016$(/[2OC6,\u0007bBA\u0018#\u0001\u0007\u0011\u0011G\u0001\u0010cV|G/Y'fiJL7\rV1hgB)\u0001)a\r@\u007f%\u0019\u0011QG&\u0003\u00075\u000b\u0007/\u0001\tfq\u0016l\u0007\u000f^'fiJL7MT1nKV\u0011\u0011QE\u0001\u0011Kb,W\u000e\u001d;TK:\u001cxN\u001d(b[\u0016,\u0012aP\u0001\u0012]\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,Gc\u0001:\u0002D!1\u0011Q\t\u000bA\u0002\t\fQA\\1o_N\u0004")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        if (request.apiRemoteCompleteTimeNanos() == -1L) {
            request.apiRemoteCompleteTimeNanos_$eq(this.time().nanoseconds());
        }
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq(new Some<Function1<Object, BoxedUnit>>(timeNanos -> this.recordNoThrottle(this.getOrCreateQuotaSensors(request.session(), request.header().clientId()), (double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond())));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), (double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond(), this.time().milliseconds());
        }
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq(new Some<Function1<Object, BoxedUnit>>(timeNanos -> this.recordExempt((double)timeNanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond())));
            this.recordExempt((double)request.requestThreadTimeNanos() * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond());
        }
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric) {
        return Math.min(super.throttleTime(clientMetric), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", "Request", "Tracking request-time per user/client-id", JavaConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", "Request", "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return new StringBuilder(7).append("exempt-").append(QuotaType$Request$.MODULE$).toString();
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

