/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import rpl.shaded.kafka.log.BatchMetadata;
import rpl.shaded.kafka.log.CorruptSnapshotException;
import rpl.shaded.kafka.log.Log$;
import rpl.shaded.kafka.log.ProducerStateEntry;
import rpl.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import rpl.shaded.org.apache.kafka.common.protocol.types.Field;
import rpl.shaded.org.apache.kafka.common.protocol.types.Schema;
import rpl.shaded.org.apache.kafka.common.protocol.types.SchemaException;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.protocol.types.Type;
import rpl.shaded.org.apache.kafka.common.utils.Crc32C;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.ArrayOps$;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.immutable.Seq$;
import rpl.shaded.scala.collection.mutable.ArrayBuilder;
import rpl.shaded.scala.collection.mutable.Map;
import rpl.shaded.scala.collection.mutable.Queue;
import rpl.shaded.scala.reflect.ClassTag;
import rpl.shaded.scala.reflect.ClassTag$;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.java8.JFunction1$mcZJ$sp;

public final class ProducerStateManager$ {
    public static final ProducerStateManager$ MODULE$ = new ProducerStateManager$();
    private static final short ProducerSnapshotVersion = 1;
    private static final String VersionField = "version";
    private static final String CrcField = "crc";
    private static final String ProducerIdField = "producer_id";
    private static final String LastSequenceField = "last_sequence";
    private static final String ProducerEpochField = "epoch";
    private static final String LastOffsetField = "last_offset";
    private static final String OffsetDeltaField = "offset_delta";
    private static final String TimestampField = "timestamp";
    private static final String ProducerEntriesField = "producer_entries";
    private static final String CoordinatorEpochField = "coordinator_epoch";
    private static final String CurrentTxnFirstOffsetField = "current_txn_first_offset";
    private static final int VersionOffset = 0;
    private static final int CrcOffset = MODULE$.VersionOffset() + 2;
    private static final int ProducerEntriesOffset = MODULE$.CrcOffset() + 4;
    private static final Schema ProducerSnapshotEntrySchema = new Schema(new Field(MODULE$.ProducerIdField(), Type.INT64, "The producer ID"), new Field(MODULE$.ProducerEpochField(), Type.INT16, "Current epoch of the producer"), new Field(MODULE$.LastSequenceField(), Type.INT32, "Last written sequence of the producer"), new Field(MODULE$.LastOffsetField(), Type.INT64, "Last written offset of the producer"), new Field(MODULE$.OffsetDeltaField(), Type.INT32, "The difference of the last sequence and first sequence in the last written batch"), new Field(MODULE$.TimestampField(), Type.INT64, "Max timestamp from the last written entry"), new Field(MODULE$.CoordinatorEpochField(), Type.INT32, "The epoch of the last transaction coordinator to send an end transaction marker"), new Field(MODULE$.CurrentTxnFirstOffsetField(), Type.INT64, "The first offset of the on-going transaction (-1 if there is none)"));
    private static final Schema PidSnapshotMapSchema = new Schema(new Field(MODULE$.VersionField(), Type.INT16, "Version of the snapshot file"), new Field(MODULE$.CrcField(), Type.UNSIGNED_INT32, "CRC of the snapshot data"), new Field(MODULE$.ProducerEntriesField(), new ArrayOf(MODULE$.ProducerSnapshotEntrySchema()), "The entries in the producer table"));

    public int $lessinit$greater$default$3() {
        return 3600000;
    }

    private short ProducerSnapshotVersion() {
        return ProducerSnapshotVersion;
    }

    private String VersionField() {
        return VersionField;
    }

    private String CrcField() {
        return CrcField;
    }

    private String ProducerIdField() {
        return ProducerIdField;
    }

    private String LastSequenceField() {
        return LastSequenceField;
    }

    private String ProducerEpochField() {
        return ProducerEpochField;
    }

    private String LastOffsetField() {
        return LastOffsetField;
    }

    private String OffsetDeltaField() {
        return OffsetDeltaField;
    }

    private String TimestampField() {
        return TimestampField;
    }

    private String ProducerEntriesField() {
        return ProducerEntriesField;
    }

    private String CoordinatorEpochField() {
        return CoordinatorEpochField;
    }

    private String CurrentTxnFirstOffsetField() {
        return CurrentTxnFirstOffsetField;
    }

    private int VersionOffset() {
        return VersionOffset;
    }

    private int CrcOffset() {
        return CrcOffset;
    }

    private int ProducerEntriesOffset() {
        return ProducerEntriesOffset;
    }

    public Schema ProducerSnapshotEntrySchema() {
        return ProducerSnapshotEntrySchema;
    }

    public Schema PidSnapshotMapSchema() {
        return PidSnapshotMapSchema;
    }

    public Iterable<ProducerStateEntry> readSnapshot(File file) {
        try {
            Object var10_9;
            long computedCrc;
            byte[] buffer = Files.readAllBytes(file.toPath());
            Struct struct = this.PidSnapshotMapSchema().read(ByteBuffer.wrap(buffer));
            Short version = struct.getShort(this.VersionField());
            if (!BoxesRunTime.equalsNumObject(version, this.ProducerSnapshotVersion())) {
                throw new CorruptSnapshotException(new StringBuilder(43).append("Snapshot contained an unknown file version ").append(version).toString());
            }
            Long crc = struct.getUnsignedInt(this.CrcField());
            if (!BoxesRunTime.equalsNumObject(crc, computedCrc = Crc32C.compute(buffer, this.ProducerEntriesOffset(), buffer.length - this.ProducerEntriesOffset()))) {
                throw new CorruptSnapshotException(new StringBuilder(0).append("Snapshot is corrupt (CRC is no longer valid). ").append(new StringBuilder(28).append("Stored crc: ").append(crc).append(". Computed crc: ").append(computedCrc).toString()).toString());
            }
            Object[] map$extension_$this = struct.getArray(this.ProducerEntriesField());
            int n = map$extension_$this.length;
            ProducerStateEntry[] map$extension_ys = new ProducerStateEntry[n];
            if (n > 0) {
                for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                    ProducerStateEntry array_update_value;
                    map$extension_ys[map$extension_i] = array_update_value = ProducerStateManager$.$anonfun$readSnapshot$1(map$extension_$this[map$extension_i]);
                    Object var13_11 = null;
                }
            }
            void v0 = var10_9;
            Object var9_7 = null;
            var10_9 = null;
            return Predef$.MODULE$.wrapRefArray((T[])v0);
        }
        catch (SchemaException e) {
            throw new CorruptSnapshotException(new StringBuilder(35).append("Snapshot failed schema validation: ").append(e.getMessage()).toString());
        }
    }

    public void kafka$log$ProducerStateManager$$writeSnapshot(File file, Map<Object, ProducerStateEntry> entries) {
        Struct struct = new Struct(this.PidSnapshotMapSchema());
        struct.set(this.VersionField(), (Object)this.ProducerSnapshotVersion());
        struct.set(this.CrcField(), (Object)0L);
        Struct[] entriesArray = (Struct[])((IterableOnceOps)entries.map((Function1<Tuple2, Struct> & Serializable)x0$1 -> {
            void var5_4;
            Object object;
            String string;
            Struct struct;
            if (x0$1 != null) {
                long producerId = x0$1._1$mcJ$sp();
                ProducerStateEntry entry = (ProducerStateEntry)x0$1._2();
                Struct producerEntryStruct = struct.instance(MODULE$.ProducerEntriesField());
                struct = producerEntryStruct.set(MODULE$.ProducerIdField(), (Object)producerId).set(MODULE$.ProducerEpochField(), (Object)entry.producerEpoch()).set(MODULE$.LastSequenceField(), (Object)entry.lastSeq()).set(MODULE$.LastOffsetField(), (Object)entry.lastDataOffset()).set(MODULE$.OffsetDeltaField(), (Object)entry.lastOffsetDelta()).set(MODULE$.TimestampField(), (Object)entry.lastTimestamp()).set(MODULE$.CoordinatorEpochField(), (Object)entry.coordinatorEpoch());
                string = MODULE$.CurrentTxnFirstOffsetField();
                Option<Object> option = entry.currentTxnFirstOffset();
                if (option == null) {
                    throw null;
                }
                Option<Object> getOrElse_this = option;
                if (getOrElse_this.isEmpty()) {
                    Long l;
                    Long l2 = l = Long.valueOf(-1L);
                    l = null;
                    object = l2;
                } else {
                    object = getOrElse_this.get();
                }
            } else {
                throw new MatchError((Object)null);
            }
            Object object2 = object;
            Object var6_5 = null;
            object = null;
            struct.set(string, object2);
            return var5_4;
        })).toArray(ClassTag$.MODULE$.apply(Struct.class));
        struct.set(this.ProducerEntriesField(), (Object)entriesArray);
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.flip();
        long crc = Crc32C.compute(buffer, this.ProducerEntriesOffset(), buffer.limit() - this.ProducerEntriesOffset());
        int writeUnsignedInt_index = this.CrcOffset();
        buffer.putInt(writeUnsignedInt_index, (int)(crc & 0xFFFFFFFFL));
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            fileChannel.write(buffer);
        }
    }

    private boolean isSnapshotFile(File file) {
        return file.getName().endsWith(Log$.MODULE$.ProducerSnapshotFileSuffix());
    }

    public Seq<File> listSnapshotFiles(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            Object object;
            Option<File[]> option = Option$.MODULE$.apply(dir.listFiles());
            if (option == null) {
                throw null;
            }
            Option<File[]> map_this = option;
            Option option2 = map_this.isEmpty() ? None$.MODULE$ : new Some<Seq>(ProducerStateManager$.$anonfun$listSnapshotFiles$1(map_this.get()));
            None$ none$ = option2;
            Object var2_2 = null;
            option2 = null;
            None$ getOrElse_this = none$;
            if (getOrElse_this.isEmpty()) {
                Seq seq;
                Seq seq2 = seq = (Seq)Seq$.MODULE$.empty();
                seq = null;
                object = seq2;
            } else {
                object = ((Option)getOrElse_this).get();
            }
            return (Seq)object;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public void deleteSnapshotsBefore(File dir, long offset) {
        JFunction1$mcZJ$sp kafka$log$ProducerStateManager$$deleteSnapshotFiles_predicate = x$1 -> x$1 < offset;
        ((IterableOnceOps)this.listSnapshotFiles(dir).filter((Function1<File, Object> & Serializable)file -> BoxesRunTime.boxToBoolean(kafka$log$ProducerStateManager$$deleteSnapshotFiles_predicate.apply$mcZJ$sp(Log$.MODULE$.offsetFromFile(file))))).foreach((Function1<File, Object> & Serializable)file -> BoxesRunTime.boxToBoolean(ProducerStateManager$.$anonfun$deleteSnapshotFiles$2(file)));
    }

    public void kafka$log$ProducerStateManager$$deleteSnapshotFiles(File dir, Function1<Object, Object> predicate) {
        ((IterableOnceOps)this.listSnapshotFiles(dir).filter((Function1<File, Object> & Serializable)file -> BoxesRunTime.boxToBoolean(kafka$log$ProducerStateManager$$deleteSnapshotFiles_predicate.apply$mcZJ$sp(Log$.MODULE$.offsetFromFile(file))))).foreach((Function1<File, Object> & Serializable)file -> BoxesRunTime.boxToBoolean(ProducerStateManager$.$anonfun$deleteSnapshotFiles$2(file)));
    }

    public Function1<Object, Object> kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2() {
        return x$2 -> true;
    }

    public static final /* synthetic */ ProducerStateEntry $anonfun$readSnapshot$1(Object producerEntryObj) {
        Queue<BatchMetadata> queue;
        Struct producerEntryStruct = (Struct)producerEntryObj;
        Long producerId = producerEntryStruct.getLong(MODULE$.ProducerIdField());
        Short producerEpoch = producerEntryStruct.getShort(MODULE$.ProducerEpochField());
        Integer seq = producerEntryStruct.getInt(MODULE$.LastSequenceField());
        Long offset = producerEntryStruct.getLong(MODULE$.LastOffsetField());
        Long timestamp = producerEntryStruct.getLong(MODULE$.TimestampField());
        Integer offsetDelta = producerEntryStruct.getInt(MODULE$.OffsetDeltaField());
        Integer coordinatorEpoch = producerEntryStruct.getInt(MODULE$.CoordinatorEpochField());
        Long currentTxnFirstOffset = producerEntryStruct.getLong(MODULE$.CurrentTxnFirstOffsetField());
        Queue<BatchMetadata> queue2 = queue = new Queue<BatchMetadata>(16);
        queue = null;
        Queue<BatchMetadata> lastAppendedDataBatches = queue2;
        if (BoxesRunTime.unboxToLong(offset) >= 0L) {
            BatchMetadata $plus$eq_elem = new BatchMetadata(BoxesRunTime.unboxToInt(seq), BoxesRunTime.unboxToLong(offset), BoxesRunTime.unboxToInt(offsetDelta), BoxesRunTime.unboxToLong(timestamp));
            lastAppendedDataBatches.addOne($plus$eq_elem);
            Object var11_12 = null;
        }
        return new ProducerStateEntry(BoxesRunTime.unboxToLong(producerId), lastAppendedDataBatches, BoxesRunTime.unboxToShort(producerEpoch), BoxesRunTime.unboxToInt(coordinatorEpoch), BoxesRunTime.unboxToLong(timestamp), BoxesRunTime.unboxToLong(currentTxnFirstOffset) >= 0L ? new Some<Long>(BoxesRunTime.unboxToLong(currentTxnFirstOffset)) : None$.MODULE$);
    }

    public static final /* synthetic */ long $anonfun$writeSnapshot$2() {
        return -1L;
    }

    public static final /* synthetic */ boolean $anonfun$listSnapshotFiles$2(File f) {
        return f.isFile() && MODULE$.isSnapshotFile(f);
    }

    public static final /* synthetic */ Seq $anonfun$listSnapshotFiles$1(File[] files2) {
        ArrayBuilder arrayBuilder;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(files2.getClass().getComponentType());
        Class<?> clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            arrayBuilder = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                arrayBuilder = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    arrayBuilder = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        arrayBuilder = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            arrayBuilder = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                arrayBuilder = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    arrayBuilder = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        arrayBuilder = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        arrayBuilder = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ArrayBuilder.ofByte ofByte2 = arrayBuilder;
        Object var4_1 = null;
        arrayBuilder = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = ofByte2;
        for (int filter$extension_i = 0; filter$extension_i < files2.length; ++filter$extension_i) {
            File filter$extension_x = files2[filter$extension_i];
            if (!ProducerStateManager$.$anonfun$listSnapshotFiles$2(filter$extension_x)) continue;
            filter$extension_res.addOne(filter$extension_x);
        }
        Object var1_4 = null;
        Object var3_6 = null;
        return ArrayOps$.MODULE$.toIndexedSeq$extension((Object[])filter$extension_res.result());
    }

    public static final /* synthetic */ Seq $anonfun$listSnapshotFiles$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$2(File file) {
        return Files.deleteIfExists(file.toPath());
    }

    private ProducerStateManager$() {
    }

    public static final /* synthetic */ Object $anonfun$listSnapshotFiles$2$adapted(File f) {
        return BoxesRunTime.boxToBoolean(ProducerStateManager$.$anonfun$listSnapshotFiles$2(f));
    }
}

