/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.log;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import org.slf4j.event.Level;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.common.LogSegmentOffsetOverflowException;
import rpl.shaded.kafka.log.AbortedTxn;
import rpl.shaded.kafka.log.AppendOrigin$Replication$;
import rpl.shaded.kafka.log.CompletedTxn;
import rpl.shaded.kafka.log.LazyIndex;
import rpl.shaded.kafka.log.LogConfig;
import rpl.shaded.kafka.log.LogFlushStats$;
import rpl.shaded.kafka.log.LogSegment$;
import rpl.shaded.kafka.log.OffsetIndex;
import rpl.shaded.kafka.log.OffsetPosition;
import rpl.shaded.kafka.log.ProducerAppendInfo;
import rpl.shaded.kafka.log.ProducerStateManager;
import rpl.shaded.kafka.log.RollParams;
import rpl.shaded.kafka.log.TimeIndex;
import rpl.shaded.kafka.log.TimestampOffset;
import rpl.shaded.kafka.log.TransactionIndex;
import rpl.shaded.kafka.log.TxnIndexSearchResult;
import rpl.shaded.kafka.server.FetchDataInfo;
import rpl.shaded.kafka.server.LogOffsetMetadata;
import rpl.shaded.kafka.server.epoch.LeaderEpochFileCache;
import rpl.shaded.kafka.utils.CoreUtils$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.org.apache.kafka.common.InvalidRecordException;
import rpl.shaded.org.apache.kafka.common.errors.CorruptRecordException;
import rpl.shaded.org.apache.kafka.common.record.BufferSupplier;
import rpl.shaded.org.apache.kafka.common.record.FileLogInputStream;
import rpl.shaded.org.apache.kafka.common.record.FileRecords;
import rpl.shaded.org.apache.kafka.common.record.MemoryRecords;
import rpl.shaded.org.apache.kafka.common.record.RecordBatch;
import rpl.shaded.org.apache.kafka.common.utils.Time;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.collection.IterableOnce;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.immutable.Seq$;
import rpl.shaded.scala.reflect.ScalaSignature;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.IntRef;
import rpl.shaded.scala.runtime.LongRef;
import rpl.shaded.scala.runtime.ObjectRef;
import rpl.shaded.scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00115a\u0001B-[\u0001}C\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\tu\u0002\u0011\t\u0011)A\u0005[\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\n\u0001\u0011\t\u0011)A\u0005{\"Q\u00111\u0002\u0001\u0003\u0006\u0004%\t!!\u0004\t\u0015\u0005]\u0001A!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u001a\u0001\u0011)\u0019!C\u0001\u00037A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\t)\u0003\u0001BC\u0002\u0013\u0005\u0011q\u0005\u0005\u000b\u0003_\u0001!\u0011!Q\u0001\n\u0005%\u0002BCA\u0019\u0001\t\u0015\r\u0011\"\u0001\u00024!Q\u00111\b\u0001\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\u0005u\u0002A!b\u0001\n\u0003\t9\u0003\u0003\u0006\u0002@\u0001\u0011\t\u0011)A\u0005\u0003SA!\"!\u0011\u0001\u0005\u000b\u0007I\u0011AA\"\u0011)\ty\u0005\u0001B\u0001B\u0003%\u0011Q\t\u0005\t\u0003#\u0002A\u0011\u0001.\u0002T!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!!%\u0001\t\u0003\t\u0019\nC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0003\u0002(!I\u00111\u0014\u0001A\u0002\u0013%\u0011Q\u0014\u0005\t\u0003G\u0003\u0001\u0015)\u0003\u0002*!I\u0011Q\u0015\u0001A\u0002\u0013%\u00111\u0007\u0005\n\u0003O\u0003\u0001\u0019!C\u0005\u0003SC\u0001\"!,\u0001A\u0003&\u0011Q\u0007\u0005\n\u0003_\u0003\u0001\u0019!C\u0005\u0003cC\u0011\"!/\u0001\u0001\u0004%I!a/\t\u0011\u0005}\u0006\u0001)Q\u0005\u0003gC\u0011\"!3\u0001\u0001\u0004%I!!-\t\u0013\u0005-\u0007\u00011A\u0005\n\u00055\u0007\u0002CAi\u0001\u0001\u0006K!a-\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u0011Q\u001c\u0001\u0005\u0002\u0005\u001d\u0002\"CAp\u0001\u0001\u0007I\u0011BAY\u0011%\t\t\u000f\u0001a\u0001\n\u0013\t\u0019\u000f\u0003\u0005\u0002h\u0002\u0001\u000b\u0015BAZ\u0011\u001d\tY\u000f\u0001C\u0001\u0003[Dq!a=\u0001\t\u0003\t9\u0003C\u0004\u0002\u0010\u0002!\t!a\r\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9\u00111 \u0001\u0005\u0002\u0005u\bb\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u00119\u0004\u0001C\u0001\u0005sAqA!\u0011\u0001\t\u0003\u0011\u0019\u0005C\u0004\u0003V\u0001!IAa\u0016\t\u0011\t5\u0004\u0001\"\u0001[\u0005_B!Ba*\u0001#\u0003%\tA\u0017BU\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u0003D\u0011B!9\u0001#\u0003%\tAa9\t\u0013\t\u001d\b!%A\u0005\u0002\t%\bb\u0002Bw\u0001\u0011\u0005!q\u001e\u0005\b\u0005\u007f\u0004A\u0011AB\u0001\u0011%\u0019I\u0002AI\u0001\n\u0003\u0019Y\u0002C\u0004\u0004 \u0001!Ia!\t\t\u000f\r\r\u0002\u0001\"\u0001\u0004&!91q\u0005\u0001\u0005\u0002\r%\u0002bBB\u001d\u0001\u0011\u000531\b\u0005\b\u0007\u001b\u0002A\u0011AB(\u0011\u001d\u0019)\u0006\u0001C\u0001\u0003OAqa!\u0017\u0001\t\u0003\u0019\t\u0003C\u0004\u0004^\u0001!\taa\u0018\t\u000f\rU\u0004\u0001\"\u0001\u0004x!91\u0011\u0011\u0001\u0005\u0002\r\u0005\u0002bBBB\u0001\u0011%1\u0011\u0005\u0005\b\u0007\u000b\u0003A\u0011ABD\u0011\u001d\u0019\t\n\u0001C\u0001\u0007'Cqa!&\u0001\t\u0003\u00199\nC\u0005\u0004(\u0002\t\n\u0011\"\u0001\u0003d\"91\u0011\u0016\u0001\u0005\u0002\r\u0005\u0002bBBV\u0001\u0011\u00051\u0011\u0005\u0005\b\u0007[\u0003A\u0011AB\u0011\u0011\u001d\u0019y\u000b\u0001C\u0001\u0003OAqA!\u0002\u0001\t\u0003\t9\u0003C\u0004\u00042\u0002!\taa-\b\u000f\r-'\f#\u0001\u0004N\u001a1\u0011L\u0017E\u0001\u0007\u001fDq!!\u0015Q\t\u0003\u0019\t\u000eC\u0004\u0004TB#\ta!6\t\u0013\r]\b+%A\u0005\u0002\t%\b\"CB}!F\u0005I\u0011\u0001BU\u0011%\u0019Y\u0010UI\u0001\n\u0003\u0011I\u000fC\u0005\u0004~B\u000b\n\u0011\"\u0001\u0004\u0000\"91Q\u0016)\u0005\u0002\u0011\r\u0001\"\u0003C\u0006!F\u0005I\u0011AB\u0000\u0005)aunZ*fO6,g\u000e\u001e\u0006\u00037r\u000b1\u0001\\8h\u0015\u0005i\u0016!B6bM.\f7\u0001A\n\u0004\u0001\u00014\u0007CA1e\u001b\u0005\u0011'\"A2\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0014'AB!osJ+g\r\u0005\u0002hU6\t\u0001N\u0003\u0002j9\u0006)Q\u000f^5mg&\u00111\u000e\u001b\u0002\b\u0019><w-\u001b8h+\u0005i\u0007C\u00018y\u001b\u0005y'B\u00019r\u0003\u0019\u0011XmY8sI*\u0011!o]\u0001\u0007G>lWn\u001c8\u000b\u0005u#(BA;w\u0003\u0019\t\u0007/Y2iK*\tq/A\u0002pe\u001eL!!_8\u0003\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0001\u0005Y><\u0007%A\bmCjLxJ\u001a4tKRLe\u000eZ3y+\u0005i\b\u0003\u0002@\u0000\u0003\u0007i\u0011AW\u0005\u0004\u0003\u0003Q&!\u0003'bufLe\u000eZ3y!\rq\u0018QA\u0005\u0004\u0003\u000fQ&aC(gMN,G/\u00138eKb\f\u0001\u0003\\1{s>3gm]3u\u0013:$W\r\u001f\u0011\u0002\u001b1\f'0\u001f+j[\u0016Le\u000eZ3y+\t\ty\u0001\u0005\u0003\u007f\u007f\u0006E\u0001c\u0001@\u0002\u0014%\u0019\u0011Q\u0003.\u0003\u0013QKW.Z%oI\u0016D\u0018A\u00047buf$\u0016.\\3J]\u0012,\u0007\u0010I\u0001\tibt\u0017J\u001c3fqV\u0011\u0011Q\u0004\t\u0004}\u0006}\u0011bAA\u00115\n\u0001BK]1og\u0006\u001cG/[8o\u0013:$W\r_\u0001\nibt\u0017J\u001c3fq\u0002\n!BY1tK>3gm]3u+\t\tI\u0003E\u0002b\u0003WI1!!\fc\u0005\u0011auN\\4\u0002\u0017\t\f7/Z(gMN,G\u000fI\u0001\u0013S:$W\r_%oi\u0016\u0014h/\u00197CsR,7/\u0006\u0002\u00026A\u0019\u0011-a\u000e\n\u0007\u0005e\"MA\u0002J]R\f1#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fg\u0002\nAB]8mY*KG\u000f^3s\u001bN\fQB]8mY*KG\u000f^3s\u001bN\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0012\u0011\t\u0005\u001d\u00131J\u0007\u0003\u0003\u0013R!![9\n\t\u00055\u0013\u0011\n\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003+\n9&!\u0017\u0002\\\u0005u\u0013qLA1\u0003G\n)\u0007\u0005\u0002\u007f\u0001!)1,\u0005a\u0001[\")10\u0005a\u0001{\"9\u00111B\tA\u0002\u0005=\u0001bBA\r#\u0001\u0007\u0011Q\u0004\u0005\b\u0003K\t\u0002\u0019AA\u0015\u0011\u001d\t\t$\u0005a\u0001\u0003kAq!!\u0010\u0012\u0001\u0004\tI\u0003C\u0004\u0002BE\u0001\r!!\u0012\u0002\u0017=4gm]3u\u0013:$W\r_\u000b\u0003\u0003\u0007\t\u0011\u0002^5nK&sG-\u001a=\u0016\u0005\u0005E\u0011AC:i_VdGMU8mYR!\u00111OA=!\r\t\u0017QO\u0005\u0004\u0003o\u0012'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003w\"\u0002\u0019AA?\u0003)\u0011x\u000e\u001c7QCJ\fWn\u001d\t\u0004}\u0006}\u0014bAAA5\nQ!k\u001c7m!\u0006\u0014\u0018-\\:\u0002\u001bI,7/\u001b>f\u0013:$W\r_3t)\u0011\t9)!$\u0011\u0007\u0005\fI)C\u0002\u0002\f\n\u0014A!\u00168ji\"9\u0011qR\u000bA\u0002\u0005U\u0012\u0001B:ju\u0016\f1b]1oSRL8\t[3dWR!\u0011qQAK\u0011\u001d\t9J\u0006a\u0001\u0003g\n\u0011\u0004^5nK&sG-\u001a=GS2,g*Z<ms\u000e\u0013X-\u0019;fI\u000691M]3bi\u0016$\u0017aC2sK\u0006$X\rZ0%KF$B!a\"\u0002 \"I\u0011\u0011\u0015\r\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0004q\u0012\n\u0014\u0001C2sK\u0006$X\r\u001a\u0011\u00021\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u00180\u0001\u000fcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef|F%Z9\u0015\t\u0005\u001d\u00151\u0016\u0005\n\u0003C[\u0012\u0011!a\u0001\u0003k\t\u0011DY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:zA\u0005)\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004XCAAZ!\u0015\t\u0017QWA\u0015\u0013\r\t9L\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u00023I|G\u000e\\5oO\n\u000b7/\u001a3US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003\u000f\u000bi\fC\u0005\u0002\"z\t\t\u00111\u0001\u00024\u00061\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004\b\u0005K\u0002 \u0003\u0007\u00042!YAc\u0013\r\t9M\u0019\u0002\tm>d\u0017\r^5mK\u0006\u0011r,\\1y)&lWm\u001d;b[B\u001cvNR1s\u0003YyV.\u0019=US6,7\u000f^1naN{g)\u0019:`I\u0015\fH\u0003BAD\u0003\u001fD\u0011\"!)\"\u0003\u0003\u0005\r!a-\u0002'}k\u0017\r\u001f+j[\u0016\u001cH/Y7q'>4\u0015M\u001d\u0011)\u0007\t\n\u0019-A\u000bnCb$\u0016.\\3ti\u0006l\u0007oU8GCJ|F%Z9\u0015\t\u0005\u001d\u0015\u0011\u001c\u0005\b\u00037\u001c\u0003\u0019AA\u0015\u0003%!\u0018.\\3ti\u0006l\u0007/A\tnCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\f!dX8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\fadX8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJ|F%Z9\u0015\t\u0005\u001d\u0015Q\u001d\u0005\n\u0003C3\u0013\u0011!a\u0001\u0003g\u000b1dX8gMN,Go\u00144NCb$\u0016.\\3ti\u0006l\u0007oU8GCJ\u0004\u0003fA\u0014\u0002D\u0006irN\u001a4tKR|e-T1y)&lWm\u001d;b[B\u001cvNR1s?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0006=\bbBAyQ\u0001\u0007\u0011\u0011F\u0001\u0007_\u001a47/\u001a;\u00023=4gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7q'>4\u0015M]\u0001\u001bG\u0006t7i\u001c8wKJ$Hk\u001c*fY\u0006$\u0018N^3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003g\nI\u0010C\u0004\u0002r.\u0002\r!!\u000b\u0002\r\u0005\u0004\b/\u001a8e))\t9)a@\u0003\u0004\t\u001d!1\u0002\u0005\b\u0005\u0003a\u0003\u0019AA\u0015\u00035a\u0017M]4fgR|eMZ:fi\"9!Q\u0001\u0017A\u0002\u0005%\u0012\u0001\u00057be\u001e,7\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u001d\u0011I\u0001\fa\u0001\u0003S\t1d\u001d5bY2|wo\u00144gg\u0016$xJZ'bqRKW.Z:uC6\u0004\bb\u0002B\u0007Y\u0001\u0007!qB\u0001\be\u0016\u001cwN\u001d3t!\rq'\u0011C\u0005\u0004\u0005'y'!D'f[>\u0014\u0018PU3d_J$7\u000fK\u0002-\u0005/\u00012a\u001aB\r\u0013\r\u0011Y\u0002\u001b\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3\u0002'\u0015t7/\u001e:f\u001f\u001a47/\u001a;J]J\u000bgnZ3\u0015\t\u0005\u001d%\u0011\u0005\u0005\b\u0003cl\u0003\u0019AA\u0015\u0003M\t\u0007\u000f]3oI\u000eCWO\\6Ge>lg)\u001b7f)!\t)Da\n\u0003*\t5\u0002B\u0002B\u0007]\u0001\u0007Q\u000eC\u0004\u0003,9\u0002\r!!\u000e\u0002\u0011A|7/\u001b;j_:DqAa\f/\u0001\u0004\u0011\t$\u0001\bck\u001a4WM]*vaBd\u0017.\u001a:\u0011\u00079\u0014\u0019$C\u0002\u00036=\u0014aBQ;gM\u0016\u00148+\u001e9qY&,'/\u0001\bbaB,g\u000e\u001a$s_64\u0015\u000e\\3\u0015\r\u0005U\"1\bB\u001f\u0011\u0019\u0011ia\fa\u0001[\"9!qH\u0018A\u0002\u0005U\u0012!B:uCJ$\u0018AD;qI\u0006$X\r\u0016=o\u0013:$W\r\u001f\u000b\u0007\u0003\u000f\u0013)Ea\u0014\t\u000f\t\u001d\u0003\u00071\u0001\u0003J\u0005a1m\\7qY\u0016$X\r\u001a+y]B\u0019aPa\u0013\n\u0007\t5#L\u0001\u0007D_6\u0004H.\u001a;fIRCh\u000eC\u0004\u0003RA\u0002\r!!\u000b\u0002!1\f7\u000f^*uC\ndWm\u00144gg\u0016$\bf\u0001\u0019\u0003\u0018\u0005\u0019R\u000f\u001d3bi\u0016\u0004&o\u001c3vG\u0016\u00148\u000b^1uKR1\u0011q\u0011B-\u0005GBqAa\u00172\u0001\u0004\u0011i&\u0001\u000bqe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\t\u0004}\n}\u0013b\u0001B15\n!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJDqA!\u001a2\u0001\u0004\u00119'A\u0003cCR\u001c\u0007\u000eE\u0002o\u0005SJ1Aa\u001bp\u0005-\u0011VmY8sI\n\u000bGo\u00195\u0002\u001fQ\u0014\u0018M\\:mCR,wJ\u001a4tKR$bA!\u001d\u0003\u001a\nm\u0005\u0003\u0002B:\u0005'sAA!\u001e\u0003\u0010:!!q\u000fBG\u001d\u0011\u0011IHa#\u000f\t\tm$\u0011\u0012\b\u0005\u0005{\u00129I\u0004\u0003\u0003\u0000\t\u0015UB\u0001BA\u0015\r\u0011\u0019IX\u0001\u0007yI|w\u000e\u001e \n\u0003]L!!\u001e<\n\u0005u#\u0018B\u0001:t\u0013\t\u0001\u0018/C\u0002\u0003\u0012>\f1BR5mKJ+7m\u001c:eg&!!Q\u0013BL\u0005EaunZ(gMN,G\u000fU8tSRLwN\u001c\u0006\u0004\u0005#{\u0007bBAye\u0001\u0007\u0011\u0011\u0006\u0005\n\u0005;\u0013\u0004\u0013!a\u0001\u0003k\tAc\u001d;beRLgn\u001a$jY\u0016\u0004vn]5uS>t\u0007f\u0001\u001a\u0003\"B\u0019qMa)\n\u0007\t\u0015\u0006N\u0001\u0006uQJ,\u0017\rZ:bM\u0016\f\u0011\u0004\u001e:b]Nd\u0017\r^3PM\u001a\u001cX\r\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0016\u0016\u0005\u0003k\u0011ik\u000b\u0002\u00030B!!\u0011\u0017B^\u001b\t\u0011\u0019L\u0003\u0003\u00036\n]\u0016!C;oG\",7m[3e\u0015\r\u0011ILY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B_\u0005g\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0011\u0011X-\u00193\u0015\u0015\t\r'q\u001aBj\u0005/\u0014Y\u000e\u0005\u0003\u0003F\n-WB\u0001Bd\u0015\r\u0011I\rX\u0001\u0007g\u0016\u0014h/\u001a:\n\t\t5'q\u0019\u0002\u000e\r\u0016$8\r\u001b#bi\u0006LeNZ8\t\u000f\tEG\u00071\u0001\u0002*\u0005Y1\u000f^1si>3gm]3u\u0011\u001d\u0011)\u000e\u000ea\u0001\u0003k\tq!\\1y'&TX\rC\u0005\u0003ZR\u0002\n\u00111\u0001\u0002*\u0005YQ.\u0019=Q_NLG/[8o\u0011%\u0011i\u000e\u000eI\u0001\u0002\u0004\t\u0019(A\u0007nS:|e.Z'fgN\fw-\u001a\u0015\u0004i\t\u0005\u0016A\u0004:fC\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0005KTC!!\u000b\u0003.\u0006q!/Z1eI\u0011,g-Y;mi\u0012\"TC\u0001BvU\u0011\t\u0019H!,\u0002+\u0019,Go\u00195VaB,'OQ8v]\u0012|eMZ:fiR1\u00111\u0017By\u0005wDqAa=8\u0001\u0004\u0011)0A\nti\u0006\u0014Ho\u00144gg\u0016$\bk\\:ji&|g\u000eE\u0002\u007f\u0005oL1A!?[\u00059yeMZ:fiB{7/\u001b;j_:DqA!@8\u0001\u0004\t)$A\u0005gKR\u001c\u0007nU5{K\u00069!/Z2pm\u0016\u0014HCBA\u001b\u0007\u0007\u0019)\u0001C\u0004\u0003\\a\u0002\rA!\u0018\t\u0013\r\u001d\u0001\b%AA\u0002\r%\u0011\u0001\u00057fC\u0012,'/\u00129pG\"\u001c\u0015m\u00195f!\u0015\t\u0017QWB\u0006!\u0011\u0019iaa\u0005\u000e\u0005\r=!\u0002BB\t\u0005\u000f\fQ!\u001a9pG\"LAa!\u0006\u0004\u0010\t!B*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016D3\u0001\u000fB\f\u0003E\u0011XmY8wKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007;QCa!\u0003\u0003.\u0006!Bn\\1e\u0019\u0006\u0014x-Z:u)&lWm\u001d;b[B$\"!a\"\u0002\u0017!\f7o\u0014<fe\u001adwn^\u000b\u0003\u0003g\n!cY8mY\u0016\u001cG/\u00112peR,G\r\u0016=ogR111FB\u0019\u0007k\u00012A`B\u0017\u0013\r\u0019yC\u0017\u0002\u0015)bt\u0017J\u001c3fqN+\u0017M]2i%\u0016\u001cX\u000f\u001c;\t\u000f\rMB\b1\u0001\u0002*\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\u00199\u0004\u0010a\u0001\u0003S\t\u0001#\u001e9qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"a!\u0010\u0011\t\r}2q\t\b\u0005\u0007\u0003\u001a\u0019\u0005E\u0002\u0003\u0000\tL1a!\u0012c\u0003\u0019\u0001&/\u001a3fM&!1\u0011JB&\u0005\u0019\u0019FO]5oO*\u00191Q\t2\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u00026\rE\u0003bBAy}\u0001\u0007\u0011\u0011\u0006\u0015\u0004}\t]\u0011A\u0004:fC\u0012tU\r\u001f;PM\u001a\u001cX\r\u001e\u0015\u0004\u007f\t\u0005\u0016!\u00024mkND\u0007f\u0001!\u0003\"\u0006IQ\u000f\u001d3bi\u0016$\u0015N\u001d\u000b\u0005\u0003\u000f\u001b\t\u0007C\u0004\u0004d\u0005\u0003\ra!\u001a\u0002\u0007\u0011L'\u000f\u0005\u0003\u0004h\rETBAB5\u0015\u0011\u0019Yg!\u001c\u0002\u0005%|'BAB8\u0003\u0011Q\u0017M^1\n\t\rM4\u0011\u000e\u0002\u0005\r&dW-\u0001\ndQ\u0006tw-\u001a$jY\u0016\u001cVO\u001a4jq\u0016\u001cHCBAD\u0007s\u001ai\bC\u0004\u0004|\t\u0003\ra!\u0010\u0002\u0013=dGmU;gM&D\bbBB@\u0005\u0002\u00071QH\u0001\n]\u0016<8+\u001e4gSb\fqc\u001c8CK\u000e|W.Z%oC\u000e$\u0018N^3TK\u001elWM\u001c;\u0002/1|\u0017\r\u001a$jeN$()\u0019;dQRKW.Z:uC6\u0004\u0018!\u0005;j[\u0016<\u0016-\u001b;fI\u001a{'OU8mYR1\u0011\u0011FBE\u0007\u001bCqaa#F\u0001\u0004\tI#A\u0002o_^Dqaa$F\u0001\u0004\tI#\u0001\tnKN\u001c\u0018mZ3US6,7\u000f^1na\u00061r-\u001a;GSJ\u001cHOQ1uG\"$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0002\u0002*\u0005)b-\u001b8e\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004HCBBM\u0007C\u001b\u0019\u000bE\u0003b\u0003k\u001bY\n\u0005\u0003\u0003t\ru\u0015\u0002BBP\u0005/\u0013!\u0003V5nKN$\u0018-\u001c9B]\u0012|eMZ:fi\"9\u00111\\$A\u0002\u0005%\u0002\"CBS\u000fB\u0005\t\u0019AA\u0015\u00039\u0019H/\u0019:uS:<wJ\u001a4tKR\fqDZ5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003\u0015\u0019Gn\\:f\u00035\u0019Gn\\:f\u0011\u0006tG\r\\3sg\u0006qA-\u001a7fi\u0016Le-\u0012=jgR\u001c\u0018\u0001\u00047bgRlu\u000eZ5gS\u0016$\u0017\u0001\u00057bgRlu\u000eZ5gS\u0016$w\fJ3r)\u0011\u0019)l!2\u0011\t\r]6\u0011Y\u0007\u0003\u0007sSAaa/\u0004>\u0006!a-\u001b7f\u0015\u0011\u0019yl!\u001c\u0002\u00079Lw.\u0003\u0003\u0004D\u000ee&\u0001\u0002)bi\"Dqaa2O\u0001\u0004\tI#\u0001\u0002ng\"\u001a\u0001Aa\u0006\u0002\u00151{wmU3h[\u0016tG\u000f\u0005\u0002\u007f!N\u0011\u0001\u000b\u0019\u000b\u0003\u0007\u001b\fAa\u001c9f]R\u0011\u0012QKBl\u00073\u001cYn!:\u0004h\u000e-8q^Bz\u0011\u001d\u0019\u0019G\u0015a\u0001\u0007KBq!!\nS\u0001\u0004\tI\u0003C\u0004\u0004^J\u0003\raa8\u0002\r\r|gNZ5h!\rq8\u0011]\u0005\u0004\u0007GT&!\u0003'pO\u000e{gNZ5h\u0011\u001d\t\tE\u0015a\u0001\u0003\u000bB\u0011b!;S!\u0003\u0005\r!a\u001d\u0002#\u0019LG.Z!me\u0016\fG-_#ySN$8\u000fC\u0005\u0004nJ\u0003\n\u00111\u0001\u00026\u0005a\u0011N\\5u\r&dWmU5{K\"I1\u0011\u001f*\u0011\u0002\u0003\u0007\u00111O\u0001\faJ,\u0017\r\u001c7pG\u0006$X\rC\u0005\u0004vJ\u0003\n\u00111\u0001\u0004>\u0005Qa-\u001b7f'V4g-\u001b=\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%k\u0005qq\u000e]3oI\u0011,g-Y;mi\u00122\u0014AD8qK:$C-\u001a4bk2$HeN\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00139+\t!\tA\u000b\u0003\u0004>\t5F\u0003CAD\t\u000b!9\u0001\"\u0003\t\u000f\r\rt\u000b1\u0001\u0004f!9\u0011QE,A\u0002\u0005%\u0002\"CB{/B\u0005\t\u0019AB\u001f\u0003a!W\r\\3uK&3W\t_5tiN$C-\u001a4bk2$He\r")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> _maxTimestampSoFar;
    private volatile Option<Object> _offsetOfMaxTimestampSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return "";
    }

    public static String open$default$8() {
        return "";
    }

    public static boolean open$default$7() {
        return false;
    }

    public static int open$default$6() {
        return 0;
    }

    public static boolean open$default$5() {
        return false;
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated) {
                this.timeIndex().resize(0);
            }
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private Option<Object> _maxTimestampSoFar() {
        return this._maxTimestampSoFar;
    }

    private void _maxTimestampSoFar_$eq(Option<Object> x$1) {
        this._maxTimestampSoFar = x$1;
    }

    public void maxTimestampSoFar_$eq(long timestamp) {
        this._maxTimestampSoFar_$eq(new Some<Object>(timestamp));
    }

    public long maxTimestampSoFar() {
        if (this._maxTimestampSoFar().isEmpty()) {
            this._maxTimestampSoFar_$eq(new Some<Object>(this.timeIndex().lastEntry().timestamp()));
        }
        return BoxesRunTime.unboxToLong(this._maxTimestampSoFar().get());
    }

    private Option<Object> _offsetOfMaxTimestampSoFar() {
        return this._offsetOfMaxTimestampSoFar;
    }

    private void _offsetOfMaxTimestampSoFar_$eq(Option<Object> x$1) {
        this._offsetOfMaxTimestampSoFar = x$1;
    }

    public void offsetOfMaxTimestampSoFar_$eq(long offset) {
        this._offsetOfMaxTimestampSoFar_$eq(new Some<Object>(offset));
    }

    public long offsetOfMaxTimestampSoFar() {
        if (this._offsetOfMaxTimestampSoFar().isEmpty()) {
            this._offsetOfMaxTimestampSoFar_$eq(new Some<Object>(this.timeIndex().lastEntry().offset()));
        }
        return BoxesRunTime.unboxToLong(this._offsetOfMaxTimestampSoFar().get());
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String> & Serializable)() -> new StringBuilder(0).append(new StringBuilder(45).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").toString()).append(new StringBuilder(42).append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString()).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq(new Some<Object>(largestTimestamp));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String> & Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampSoFar_$eq(largestTimestamp);
                this.offsetOfMaxTimestampSoFar_$eq(shallowOffsetOfMaxTimestamp);
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                TimeIndex qual$1 = this.timeIndex();
                long x$1 = this.maxTimestampSoFar();
                long x$2 = this.offsetOfMaxTimestampSoFar();
                boolean x$3 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$1, x$2, x$3);
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        ObjectRef<ByteBuffer> objectRef;
        LongRef longRef;
        LongRef longRef2;
        LongRef longRef3;
        IntRef intRef;
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef bytesToAppend = intRef2;
        long create_e2 = Long.MIN_VALUE;
        LongRef longRef4 = longRef3 = new LongRef(create_e2);
        longRef3 = null;
        LongRef maxTimestamp = longRef4;
        long create_e3 = Long.MIN_VALUE;
        LongRef longRef5 = longRef2 = new LongRef(create_e3);
        longRef2 = null;
        LongRef offsetOfMaxTimestamp = longRef5;
        long create_e4 = Long.MIN_VALUE;
        LongRef longRef6 = longRef = new LongRef(create_e4);
        longRef = null;
        LongRef maxOffset = longRef6;
        ByteBuffer create_e5 = bufferSupplier.get(0x100000);
        ObjectRef<ByteBuffer> objectRef2 = objectRef = new ObjectRef<ByteBuffer>(create_e5);
        Object var20_16 = null;
        objectRef = null;
        ObjectRef<ByteBuffer> readBuffer = objectRef2;
        ((IterableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator().takeWhile((Function1<RecordBatch, Object> & Serializable)batch -> BoxesRunTime.boxToBoolean(this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)readBuffer.elem));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String> & Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin$Replication$.MODULE$);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, None$.MODULE$);
            producerStateManager.update(appendInfo);
            if (maybeCompletedTxn == null) {
                throw null;
            }
            if (!maybeCompletedTxn.isEmpty()) {
                CompletedTxn completedTxn = maybeCompletedTxn.get();
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
            }
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, Math.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        int n;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        if (minOneMessage) {
            int max_y = startOffsetAndSize.size;
            n = Math.max(maxSize, max_y);
        } else {
            n = adjustedMaxSize = maxSize;
        }
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, MemoryRecords.EMPTY, false, None$.MODULE$);
        }
        int n2 = Math.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, this.log().slice(startPosition, n2), adjustedMaxSize < startOffsetAndSize.size, None$.MODULE$);
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        Option<OffsetPosition> option = this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize);
        if (option == null) {
            throw null;
        }
        Option<OffsetPosition> map_this = option;
        Option option2 = map_this.isEmpty() ? None$.MODULE$ : new Some<Long>(map_this.get().offset());
        return option2;
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        IntRef intRef;
        IntRef intRef2;
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        int create_e = 0;
        IntRef intRef3 = intRef2 = new IntRef(create_e);
        intRef2 = null;
        IntRef validBytes = intRef3;
        int create_e2 = 0;
        IntRef intRef4 = intRef = new IntRef(create_e2);
        intRef = null;
        IntRef lastIndexEntry = intRef4;
        this.maxTimestampSoFar_$eq(-1L);
        try {
            ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException;
            if (bl) {
                this.warn((Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension("Found invalid messages in log segment %s at byte offset %d: %s. %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.log().file().getAbsolutePath(), validBytes$1.elem, throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String> & Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampSoFar_$eq(lastTimeIndexEntry.timestamp());
        this.offsetOfMaxTimestampSoFar_$eq(lastTimeIndexEntry.offset());
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.timestamp);
            this.offsetOfMaxTimestampSoFar_$eq(maxTimestampOffsetAfterLastEntry.offset);
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(63).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestTime=").append(this.largestTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.txnIndex().truncateTo(offset);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq(None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        Object object;
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        if (fetchData == null) {
            return this.baseOffset();
        }
        Option option = ((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Option option2 = map_this.isEmpty() ? None$.MODULE$ : new Some<Long>(((RecordBatch)map_this.get()).nextOffset());
        None$ none$ = option2;
        Object var2_2 = null;
        option2 = null;
        None$ getOrElse_this = none$;
        if (getOrElse_this.isEmpty()) {
            Long l;
            Long l2 = l = Long.valueOf(this.baseOffset());
            l = null;
            object = l2;
        } else {
            object = ((Option)getOrElse_this).get();
        }
        Object a = object;
        Object var4_4 = null;
        object = null;
        return BoxesRunTime.unboxToLong(a);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateDir(File dir) {
        this.log().setFile(new File(dir, this.log().file().getName()));
        this.lazyOffsetIndex().file_$eq(new File(dir, this.lazyOffsetIndex().file().getName()));
        this.lazyTimeIndex().file_$eq(new File(dir, this.lazyTimeIndex().file().getName()));
        this.txnIndex().file_$eq(new File(dir, this.txnIndex().file().getName()));
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.offsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.timeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        Iterator<FileLogInputStream.FileChannelRecordBatch> iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq(new Some<Object>(iter.next().maxTimestamp()));
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong(((Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong(((Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(Math.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply(this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        CoreUtils$.MODULE$.swallow(() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, Level.WARN);
        CoreUtils$.MODULE$.swallow(() -> this.offsetIndex().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow(() -> this.timeIndex().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow(() -> this.log().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow(() -> this.txnIndex().close(), this, Level.WARN);
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow(() -> this.offsetIndex().closeHandler(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow(() -> this.timeIndex().closeHandler(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow(() -> this.log().closeHandlers(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow(() -> this.txnIndex().close(), this, Level.WARN);
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((rpl.shaded.scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Function0[]{() -> {
            boolean bl = true;
            File delete$1_file = this.log().file();
            String delete$1_fileType = "log";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$4(this)) {
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, () -> {
            OffsetIndex offsetIndex = this.offsetIndex();
            boolean bl = true;
            File delete$1_file = this.lazyOffsetIndex().file();
            String delete$1_fileType = "offset index";
            try {
                void delete$1_logIfMissing;
                if (offsetIndex.deleteIfExists()) {
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, () -> {
            TimeIndex timeIndex = this.timeIndex();
            boolean bl = true;
            File delete$1_file = this.lazyTimeIndex().file();
            String delete$1_fileType = "time index";
            try {
                void delete$1_logIfMissing;
                if (timeIndex.deleteIfExists()) {
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, () -> {
            boolean bl = false;
            File delete$1_file = this.txnIndex().file();
            String delete$1_fileType = "transaction index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$10(this)) {
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String> & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }})));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.lastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ boolean $anonfun$recover$3(FileLogInputStream.FileChannelRecordBatch batch$1, int x$2) {
        return batch$1.partitionLeaderEpoch() > x$2;
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() > 0) {
            int n;
            Option<Object> option = cache.latestEpoch();
            if (option == null) {
                throw null;
            }
            Option<Object> forall_this = option;
            boolean bl = forall_this.isEmpty() || LogSegment.$anonfun$recover$3(batch$1, n = BoxesRunTime.unboxToInt(forall_this.get()));
            Object var2_2 = null;
            if (bl) {
                cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
            }
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.ensureOffsetInRange(batch.lastOffset());
        if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
            $this.maxTimestampSoFar_$eq(batch.maxTimestamp());
            $this.offsetOfMaxTimestampSoFar_$eq(batch.lastOffset());
        }
        if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
            $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
            TimeIndex qual$1 = $this.timeIndex();
            long x$1 = $this.maxTimestampSoFar();
            long x$2 = $this.offsetOfMaxTimestampSoFar();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
            lastIndexEntry$1.elem = validBytes$1.elem;
        }
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            if (leaderEpochCache$1 == null) {
                throw null;
            }
            if (!leaderEpochCache$1.isEmpty()) {
                LeaderEpochFileCache leaderEpochFileCache = (LeaderEpochFileCache)leaderEpochCache$1.get();
                LogSegment.$anonfun$recover$2(batch, leaderEpochFileCache);
            }
            $this.updateProducerState(producerStateManager$2, batch);
        }
    }

    public static final /* synthetic */ long $anonfun$readNextOffset$2(LogSegment $this) {
        return $this.baseOffset();
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String> & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String> & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$4(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$6(OffsetIndex eta$0$1$1) {
        return eta$0$1$1.deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$8(TimeIndex eta$0$2$1) {
        return eta$0$2$1.deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$10(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampSoFar = None$.MODULE$;
        this._offsetOfMaxTimestampSoFar = None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$updateProducerState$1$adapted(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        LogSegment.$anonfun$updateProducerState$1($this, producerStateManager$1, completedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$fetchUpperBoundOffset$1$adapted(OffsetPosition x$1) {
        return BoxesRunTime.boxToLong(x$1.offset());
    }

    public static final /* synthetic */ Object $anonfun$readNextOffset$1$adapted(RecordBatch x$3) {
        return BoxesRunTime.boxToLong(x$3.nextOffset());
    }

    public static final /* synthetic */ Object $anonfun$recover$2$adapted(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        LogSegment.$anonfun$recover$2(batch$1, cache);
        return BoxedUnit.UNIT;
    }
}

