/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.utils;

import rpl.shaded.org.apache.kafka.common.utils.KafkaThread;

public class Exit {
    private static final Procedure DEFAULT_HALT_PROCEDURE = new Procedure(){

        @Override
        public void execute(int statusCode, String message) {
            Runtime.getRuntime().halt(statusCode);
        }
    };
    private static final Procedure DEFAULT_EXIT_PROCEDURE = new Procedure(){

        @Override
        public void execute(int statusCode, String message) {
            System.exit(statusCode);
        }
    };
    private static final ShutdownHookAdder DEFAULT_SHUTDOWN_HOOK_ADDER = new ShutdownHookAdder(){

        @Override
        public void addShutdownHook(String name, Runnable runnable) {
            if (name != null) {
                Runtime.getRuntime().addShutdownHook(KafkaThread.nonDaemon(name, runnable));
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(runnable));
            }
        }
    };
    private static volatile Procedure exitProcedure = DEFAULT_EXIT_PROCEDURE;
    private static volatile Procedure haltProcedure = DEFAULT_HALT_PROCEDURE;
    private static volatile ShutdownHookAdder shutdownHookAdder = DEFAULT_SHUTDOWN_HOOK_ADDER;

    public static void exit(int statusCode) {
        Exit.exit(statusCode, null);
    }

    public static void exit(int statusCode, String message) {
        exitProcedure.execute(statusCode, message);
    }

    public static void halt(int statusCode) {
        Exit.halt(statusCode, null);
    }

    public static void halt(int statusCode, String message) {
        haltProcedure.execute(statusCode, message);
    }

    public static void addShutdownHook(String name, Runnable runnable) {
        shutdownHookAdder.addShutdownHook(name, runnable);
    }

    public static void setExitProcedure(Procedure procedure) {
        exitProcedure = procedure;
    }

    public static void setHaltProcedure(Procedure procedure) {
        haltProcedure = procedure;
    }

    public static void setShutdownHookAdder(ShutdownHookAdder shutdownHookAdder) {
        Exit.shutdownHookAdder = shutdownHookAdder;
    }

    public static void resetExitProcedure() {
        exitProcedure = DEFAULT_EXIT_PROCEDURE;
    }

    public static void resetHaltProcedure() {
        haltProcedure = DEFAULT_HALT_PROCEDURE;
    }

    public static void resetShutdownHookAdder() {
        shutdownHookAdder = DEFAULT_SHUTDOWN_HOOK_ADDER;
    }

    public static interface ShutdownHookAdder {
        public void addShutdownHook(String var1, Runnable var2);
    }

    public static interface Procedure {
        public void execute(int var1, String var2);
    }
}

