/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpl.shaded.org.apache.kafka.common.config.types.Password;
import rpl.shaded.org.apache.kafka.common.network.ListenerName;
import rpl.shaded.org.apache.kafka.common.security.JaasConfig;

public class JaasContext {
    private static final Logger LOG = LoggerFactory.getLogger(JaasContext.class);
    private static final String GLOBAL_CONTEXT_NAME_SERVER = "KafkaServer";
    private static final String GLOBAL_CONTEXT_NAME_CLIENT = "KafkaClient";
    private final String name;
    private final Type type;
    private final Configuration configuration;
    private final List<AppConfigurationEntry> configurationEntries;
    private final Password dynamicJaasConfig;

    public static JaasContext loadServerContext(ListenerName listenerName, String mechanism, Map<String, ?> configs) {
        if (listenerName == null) {
            throw new IllegalArgumentException("listenerName should not be null for SERVER");
        }
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism should not be null for SERVER");
        }
        String globalContextName = GLOBAL_CONTEXT_NAME_SERVER;
        String listenerContextName = listenerName.value().toLowerCase(Locale.ROOT) + "." + GLOBAL_CONTEXT_NAME_SERVER;
        Password dynamicJaasConfig = (Password)configs.get(mechanism.toLowerCase(Locale.ROOT) + "." + "sasl.jaas.config");
        if (dynamicJaasConfig == null && configs.get("sasl.jaas.config") != null) {
            LOG.warn("Server config {} should be prefixed with SASL mechanism name, ignoring config", (Object)"sasl.jaas.config");
        }
        return JaasContext.load(Type.SERVER, listenerContextName, globalContextName, dynamicJaasConfig);
    }

    public static JaasContext loadClientContext(Map<String, ?> configs) {
        String globalContextName = GLOBAL_CONTEXT_NAME_CLIENT;
        Password dynamicJaasConfig = (Password)configs.get("sasl.jaas.config");
        return JaasContext.load(Type.CLIENT, null, globalContextName, dynamicJaasConfig);
    }

    static JaasContext load(Type contextType, String listenerContextName, String globalContextName, Password dynamicJaasConfig) {
        if (dynamicJaasConfig != null) {
            JaasConfig jaasConfig = new JaasConfig(globalContextName, dynamicJaasConfig.value());
            AppConfigurationEntry[] contextModules = jaasConfig.getAppConfigurationEntry(globalContextName);
            if (contextModules == null || contextModules.length == 0) {
                throw new IllegalArgumentException("JAAS config property does not contain any login modules");
            }
            if (contextModules.length != 1) {
                throw new IllegalArgumentException("JAAS config property contains " + contextModules.length + " login modules, should be 1 module");
            }
            return new JaasContext(globalContextName, contextType, jaasConfig, dynamicJaasConfig);
        }
        return JaasContext.defaultContext(contextType, listenerContextName, globalContextName);
    }

    private static JaasContext defaultContext(Type contextType, String listenerContextName, String globalContextName) {
        String jaasConfigFile = System.getProperty("java.security.auth.login.config");
        if (jaasConfigFile == null) {
            if (contextType == Type.CLIENT) {
                LOG.debug("System property 'java.security.auth.login.config' and Kafka SASL property 'sasl.jaas.config' are not set, using default JAAS configuration.");
            } else {
                LOG.debug("System property 'java.security.auth.login.config' is not set, using default JAAS configuration.");
            }
        }
        Configuration jaasConfig = Configuration.getConfiguration();
        AppConfigurationEntry[] configEntries = null;
        String contextName = globalContextName;
        if (listenerContextName != null && (configEntries = jaasConfig.getAppConfigurationEntry(listenerContextName)) != null) {
            contextName = listenerContextName;
        }
        if (configEntries == null) {
            configEntries = jaasConfig.getAppConfigurationEntry(globalContextName);
        }
        if (configEntries == null) {
            String listenerNameText = listenerContextName == null ? "" : " or '" + listenerContextName + "'";
            String errorMessage = "Could not find a '" + globalContextName + "'" + listenerNameText + " entry in the JAAS configuration. System property '" + "java.security.auth.login.config" + "' is " + (jaasConfigFile == null ? "not set" : jaasConfigFile);
            throw new IllegalArgumentException(errorMessage);
        }
        return new JaasContext(contextName, contextType, jaasConfig, null);
    }

    public JaasContext(String name, Type type, Configuration configuration, Password dynamicJaasConfig) {
        this.name = name;
        this.type = type;
        this.configuration = configuration;
        AppConfigurationEntry[] entries = configuration.getAppConfigurationEntry(name);
        if (entries == null) {
            throw new IllegalArgumentException("Could not find a '" + name + "' entry in this JAAS configuration.");
        }
        this.configurationEntries = Collections.unmodifiableList(new ArrayList<AppConfigurationEntry>(Arrays.asList(entries)));
        this.dynamicJaasConfig = dynamicJaasConfig;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public List<AppConfigurationEntry> configurationEntries() {
        return this.configurationEntries;
    }

    public Password dynamicJaasConfig() {
        return this.dynamicJaasConfig;
    }

    public static String configEntryOption(List<AppConfigurationEntry> configurationEntries, String key, String loginModuleName) {
        for (AppConfigurationEntry entry : configurationEntries) {
            Object val;
            if (loginModuleName != null && !loginModuleName.equals(entry.getLoginModuleName()) || (val = entry.getOptions().get(key)) == null) continue;
            return (String)val;
        }
        return null;
    }

    public static enum Type {
        CLIENT,
        SERVER;

    }
}

