/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import rpl.shaded.org.apache.kafka.common.protocol.ApiKeys;
import rpl.shaded.org.apache.kafka.common.protocol.Errors;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class TxnOffsetCommitResponse
extends AbstractResponse {
    public final TxnOffsetCommitResponseData data;

    public TxnOffsetCommitResponse(TxnOffsetCommitResponseData data) {
        this.data = data;
    }

    public TxnOffsetCommitResponse(Struct struct, short version) {
        this.data = new TxnOffsetCommitResponseData(struct, version);
    }

    public TxnOffsetCommitResponse(int requestThrottleMs, Map<TopicPartition, Errors> responseData) {
        HashMap<String, TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic> responseTopicDataMap = new HashMap<String, TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic>();
        for (Map.Entry<TopicPartition, Errors> entry : responseData.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            String topicName = topicPartition.topic();
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topic = responseTopicDataMap.getOrDefault(topicName, new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(topicName));
            topic.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setErrorCode(entry.getValue().code()).setPartitionIndex(topicPartition.partition()));
            responseTopicDataMap.put(topicName, topic);
        }
        this.data = new TxnOffsetCommitResponseData().setTopics(new ArrayList<TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic>(responseTopicDataMap.values())).setThrottleTimeMs(requestThrottleMs);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.errors().values());
    }

    public Map<TopicPartition, Errors> errors() {
        HashMap<TopicPartition, Errors> errorMap = new HashMap<TopicPartition, Errors>();
        for (TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topic : this.data.topics()) {
            for (TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition partition : topic.partitions()) {
                errorMap.put(new TopicPartition(topic.name(), partition.partitionIndex()), Errors.forCode(partition.errorCode()));
            }
        }
        return errorMap;
    }

    public static TxnOffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new TxnOffsetCommitResponse(ApiKeys.TXN_OFFSET_COMMIT.parseResponse(version, buffer), version);
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

