/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rpl.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.utils.AbstractIterator;

public class ConsumerRecords<K, V>
implements Iterable<ConsumerRecord<K, V>> {
    public static final ConsumerRecords<Object, Object> EMPTY = new ConsumerRecords(Collections.EMPTY_MAP);
    private final Map<TopicPartition, List<ConsumerRecord<K, V>>> records;

    public ConsumerRecords(Map<TopicPartition, List<ConsumerRecord<K, V>>> records) {
        this.records = records;
    }

    public List<ConsumerRecord<K, V>> records(TopicPartition partition) {
        List<ConsumerRecord<K, V>> recs = this.records.get(partition);
        if (recs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(recs);
    }

    public Iterable<ConsumerRecord<K, V>> records(String topic) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic must be non-null.");
        }
        ArrayList<List<ConsumerRecord<K, V>>> recs = new ArrayList<List<ConsumerRecord<K, V>>>();
        for (Map.Entry<TopicPartition, List<ConsumerRecord<K, V>>> entry : this.records.entrySet()) {
            if (!entry.getKey().topic().equals(topic)) continue;
            recs.add(entry.getValue());
        }
        return new ConcatenatedIterable(recs);
    }

    public Set<TopicPartition> partitions() {
        return Collections.unmodifiableSet(this.records.keySet());
    }

    @Override
    public Iterator<ConsumerRecord<K, V>> iterator() {
        return new ConcatenatedIterable<K, V>(this.records.values()).iterator();
    }

    public int count() {
        int count = 0;
        for (List<ConsumerRecord<K, V>> recs : this.records.values()) {
            count += recs.size();
        }
        return count;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public static <K, V> ConsumerRecords<K, V> empty() {
        return EMPTY;
    }

    private static class ConcatenatedIterable<K, V>
    implements Iterable<ConsumerRecord<K, V>> {
        private final Iterable<? extends Iterable<ConsumerRecord<K, V>>> iterables;

        public ConcatenatedIterable(Iterable<? extends Iterable<ConsumerRecord<K, V>>> iterables) {
            this.iterables = iterables;
        }

        @Override
        public Iterator<ConsumerRecord<K, V>> iterator() {
            return new AbstractIterator<ConsumerRecord<K, V>>(){
                Iterator<? extends Iterable<ConsumerRecord<K, V>>> iters;
                Iterator<ConsumerRecord<K, V>> current;
                {
                    this.iters = iterables.iterator();
                }

                @Override
                public ConsumerRecord<K, V> makeNext() {
                    while (this.current == null || !this.current.hasNext()) {
                        if (this.iters.hasNext()) {
                            this.current = this.iters.next().iterator();
                            continue;
                        }
                        return (ConsumerRecord)this.allDone();
                    }
                    return this.current.next();
                }
            };
        }
    }
}

