/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.utils;

import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.event.Level;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.com.typesafe.scalalogging.Logger$;
import rpl.shaded.kafka.cluster.EndPoint;
import rpl.shaded.kafka.cluster.EndPoint$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.org.apache.kafka.common.network.ListenerName;
import rpl.shaded.org.apache.kafka.common.security.auth.SecurityProtocol;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.$eq$colon$eq;
import rpl.shaded.scala.$less$colon$less;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.AbstractIterator;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.Iterator;
import rpl.shaded.scala.collection.MapOps;
import rpl.shaded.scala.collection.Seq$;
import rpl.shaded.scala.collection.SeqOps;
import rpl.shaded.scala.collection.StringOps$;
import rpl.shaded.scala.collection.concurrent.Map;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.mutable.ArrayBuilder;
import rpl.shaded.scala.collection.mutable.ArraySeq;
import rpl.shaded.scala.collection.mutable.HashMap;
import rpl.shaded.scala.math.Ordering;
import rpl.shaded.scala.reflect.ClassTag;
import rpl.shaded.scala.reflect.ClassTag$;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.ObjectRef;
import rpl.shaded.scala.runtime.ScalaRunTime$;
import rpl.shaded.scala.runtime.java8.JFunction0$mcI$sp;

public final class CoreUtils$ {
    public static final CoreUtils$ MODULE$ = new CoreUtils$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public <A, B> A min(Iterable<A> iterable, A ifEmpty, Ordering<B> cmp) {
        if (iterable.isEmpty()) {
            return ifEmpty;
        }
        return iterable.min(cmp);
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if (Level.ERROR.equals(logLevel)) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(e.getMessage(), e);
                    return;
                }
            } else if (Level.WARN.equals(logLevel)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(e.getMessage(), e);
                    return;
                }
            } else if (Level.INFO.equals(logLevel)) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(e.getMessage(), e);
                    return;
                }
            } else if (Level.DEBUG.equals(logLevel)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(e.getMessage(), e);
                    return;
                }
            } else if (Level.TRACE.equals(logLevel)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(e.getMessage(), e);
                    return;
                }
            } else {
                throw new MatchError(logLevel);
            }
            return;
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(rpl.shaded.scala.collection.Seq<String> files2) {
        files2.foreach((Function1<String, Object> & Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public void tryAll(rpl.shaded.scala.collection.Seq<Function0<BoxedUnit>> all) {
        ObjectRef<Object> objectRef;
        ObjectRef<Object> objectRef2 = objectRef = new ObjectRef<Object>(null);
        objectRef = null;
        ObjectRef<Object> exception = objectRef2;
        all.foreach((Function1<Function0, Object> & Serializable)element -> {
            CoreUtils$.$anonfun$tryAll$1(exception, element);
            return BoxedUnit.UNIT;
        });
        if ((Throwable)exception.elem != null) {
            throw (Throwable)exception.elem;
        }
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mbs) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : mbs
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(25).append("Failed to register Mbean ").append(name).toString(), (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mbs) {
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
            return;
        }
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        switch (n) {
            case -1: {
                throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public rpl.shaded.scala.collection.Map<String, String> parseCsvMap(String str) {
        void toMap_ev;
        Object var6_5;
        HashMap<String, String> map = new HashMap<String, String>();
        if ("".equals(str)) {
            return map;
        }
        String[] map$extension_$this = str.split("\\s*,\\s*");
        int n = map$extension_$this.length;
        Tuple2[] map$extension_ys = new Tuple2[n];
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                Tuple2 array_update_value;
                map$extension_ys[map$extension_i] = array_update_value = CoreUtils$.$anonfun$parseCsvMap$1(map$extension_$this[map$extension_i]);
                Object var9_7 = null;
            }
        }
        void v0 = var6_5;
        Object var5_3 = null;
        var6_5 = null;
        void keyVals = v0;
        ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((T[])keyVals);
        $eq$colon$eq $eq$colon$eq = $less$colon$less$.MODULE$.refl();
        if (ofRef2 == null) {
            throw null;
        }
        return IterableOnceOps.toMap$(ofRef2, ($less$colon$less)toMap_ev);
    }

    public rpl.shaded.scala.collection.Seq<String> parseCsvList(String csvList) {
        ArrayBuilder arrayBuilder;
        String[] stringArray;
        if (csvList == null || csvList.isEmpty()) {
            return (rpl.shaded.scala.collection.Seq)Seq$.MODULE$.empty();
        }
        String[] stringArray2 = stringArray = csvList.split("\\s*,\\s*");
        stringArray = null;
        String[] filter$extension_$this = stringArray2;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
        Class<?> clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            arrayBuilder = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                arrayBuilder = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    arrayBuilder = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        arrayBuilder = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            arrayBuilder = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                arrayBuilder = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    arrayBuilder = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        arrayBuilder = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        arrayBuilder = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ArrayBuilder.ofByte ofByte2 = arrayBuilder;
        Object var7_4 = null;
        arrayBuilder = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = ofByte2;
        for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
            String filter$extension_x = filter$extension_$this[filter$extension_i];
            if (!CoreUtils$.$anonfun$parseCsvList$1(filter$extension_x)) continue;
            filter$extension_res.addOne(filter$extension_x);
        }
        Object var3_3 = null;
        Object var4_7 = null;
        Object var6_9 = null;
        return Predef$.MODULE$.wrapRefArray((Object[])filter$extension_res.result());
    }

    public <T> T createObject(String className, Seq<Object> args) {
        return (T)Class.forName(className, true, Utils.getContextOrKafkaClassLoader()).getConstructor((Class[])((IterableOnceOps)args.map((Function1<Object, Class> & Serializable)x$1 -> x$1.getClass())).toArray(ClassTag$.MODULE$.apply(Class.class))).newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        JFunction0$mcI$sp continually_elem = () -> 1;
        Object var2_2 = null;
        return new AbstractIterator<A>(continually_elem){
            private final Function0 elem$5;

            public boolean hasNext() {
                return true;
            }

            public A next() {
                return (A)this.elem$5.apply();
            }
            {
                this.elem$5 = elem$5;
            }
        }.flatMap((Function1<Object, Iterable> & Serializable)x$2 -> CoreUtils$.$anonfun$circularIterator$2(coll, BoxesRunTime.unboxToInt(x$2)));
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (!s.endsWith(oldSuffix)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("Expected string to end with '%s' but string is '%s'", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{oldSuffix, s})));
        }
        return new StringBuilder(0).append(s.substring(0, s.length() - oldSuffix.length())).append(newSuffix).toString();
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        T t;
        lock.lock();
        try {
            t = fun.apply();
        }
        finally {
            lock.unlock();
        }
        return t;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        T t;
        Lock inLock_lock = lock.readLock();
        inLock_lock.lock();
        try {
            t = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return t;
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        T t;
        Lock inLock_lock = lock.writeLock();
        inLock_lock.lock();
        try {
            t = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return t;
    }

    public <T> Iterable<T> duplicates(Iterable<T> s) {
        return ((MapOps)s.groupBy((Function1<Object, Object> & Serializable)x -> Predef$.MODULE$.identity(x)).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            Object k = x0$1._1();
            Iterable l = (Iterable)x0$1._2();
            Tuple2 tuple2 = new Tuple2(k, l.size());
            return tuple2;
        }).filter((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$duplicates$3(x0$2)))).keys();
    }

    /*
     * WARNING - void declaration
     */
    public rpl.shaded.scala.collection.Seq<EndPoint> listenerListToEndPoints(String listeners, rpl.shaded.scala.collection.Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        void var3_4;
        rpl.shaded.scala.collection.Seq seq;
        try {
            seq = (rpl.shaded.scala.collection.Seq)this.parseCsvList(listeners).map((Function1<String, EndPoint> & Serializable)x$6 -> EndPoint$.MODULE$.createEndPoint((String)x$6, (Option<rpl.shaded.scala.collection.Map<ListenerName, SecurityProtocol>>)new Some<rpl.shaded.scala.collection.Map<ListenerName, SecurityProtocol>>(securityProtocolMap)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Error creating broker listeners from '").append(listeners).append("': ").append(e.getMessage()).toString(), e);
        }
        rpl.shaded.scala.collection.Seq endPoints = seq;
        CoreUtils$.validate$1(endPoints, listeners);
        return var3_4;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[]{new Tuple2<String, String>(key, value)}));
    }

    /*
     * WARNING - void declaration
     */
    public Properties propsWith(Seq<Tuple2<String, String>> props) {
        void var2_2;
        Properties properties = new Properties();
        props.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = properties.put(k, v);
            return object;
        });
        return var2_2;
    }

    public <K, V> V atomicGetOrUpdate(Map<K, V> map, K key, Function0<V> createValue) {
        Object object;
        Option option = map.get(key);
        if (option instanceof Some) {
            object = ((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            V value = createValue.apply();
            Option<V> option2 = map.putIfAbsent(key, value);
            if (option2 == null) {
                throw null;
            }
            Option<V> getOrElse_this = option2;
            V v = getOrElse_this.isEmpty() ? value : getOrElse_this.get();
            V v2 = v;
            Object var7_7 = null;
            v = null;
            object = v2;
        } else {
            throw new MatchError(option);
        }
        return (V)object;
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete(new File(f));
    }

    public static final /* synthetic */ void $anonfun$tryAll$1(ObjectRef exception$1, Function0 element) {
        try {
            element.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if ((Throwable)exception$1.elem != null) {
                ((Throwable)exception$1.elem).addSuppressed(e);
                return;
            }
            exception$1.elem = e;
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$parseCsvMap$1(String s) {
        int lio = s.lastIndexOf(":");
        return new Tuple2<String, String>(s.substring(0, lio).trim(), s.substring(lio + 1).trim());
    }

    public static final /* synthetic */ boolean $anonfun$parseCsvList$1(String v) {
        return !v.equals("");
    }

    public static final /* synthetic */ Iterable $anonfun$circularIterator$2(Iterable coll$1, int x$2) {
        return (Iterable)coll$1.map((Function1<Object, Object> & Serializable)t -> t);
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError((Object)null);
        }
        boolean bl = x0$2._2$mcI$sp() > 1;
        return bl;
    }

    public static final /* synthetic */ String $anonfun$listenerListToEndPoints$4(String listeners$1) {
        return new StringBuilder(53).append("Each listener must have a different port, listeners: ").append(listeners$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listenerListToEndPoints$5(String listeners$1) {
        return new StringBuilder(53).append("Each listener must have a different name, listeners: ").append(listeners$1).toString();
    }

    private static final void validate$1(rpl.shaded.scala.collection.Seq endPoints, String listeners$1) {
        rpl.shaded.scala.collection.Seq portsExcludingZero = (rpl.shaded.scala.collection.Seq)((IterableOps)endPoints.map((Function1<EndPoint, Object> & Serializable)x$3 -> BoxesRunTime.boxToInteger(x$3.port()))).filter(x$4 -> x$4 != 0);
        rpl.shaded.scala.collection.Seq distinctPorts = (rpl.shaded.scala.collection.Seq)portsExcludingZero.distinct();
        rpl.shaded.scala.collection.Seq distinctListenerNames = (rpl.shaded.scala.collection.Seq)((SeqOps)endPoints.map((Function1<EndPoint, ListenerName> & Serializable)x$5 -> x$5.listenerName())).distinct();
        if (distinctPorts == null) {
            throw null;
        }
        if (!(distinctPorts.length() == portsExcludingZero.length())) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)CoreUtils$.$anonfun$listenerListToEndPoints$4(listeners$1)).toString());
        }
        if (distinctListenerNames == null) {
            throw null;
        }
        if (!(distinctListenerNames.length() == endPoints.length())) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)CoreUtils$.$anonfun$listenerListToEndPoints$5(listeners$1)).toString());
        }
    }

    public static final /* synthetic */ Object $anonfun$atomicGetOrUpdate$1(Object value$1) {
        return value$1;
    }

    private CoreUtils$() {
    }

    public static final /* synthetic */ Object $anonfun$parseCsvList$1$adapted(String v) {
        return BoxesRunTime.boxToBoolean(CoreUtils$.$anonfun$parseCsvList$1(v));
    }
}

