/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.tools;

import java.io.PrintStream;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import joptsimple.OptionSpec;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.common.MessageFormatter;
import rpl.shaded.kafka.tools.ConsoleConsumer;
import rpl.shaded.kafka.utils.CommandLineUtils$;
import rpl.shaded.kafka.utils.Exit$;
import rpl.shaded.kafka.utils.Implicits;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import rpl.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import rpl.shaded.org.apache.kafka.common.errors.AuthenticationException;
import rpl.shaded.org.apache.kafka.common.errors.WakeupException;
import rpl.shaded.org.apache.kafka.common.serialization.ByteArrayDeserializer;
import rpl.shaded.org.apache.kafka.common.serialization.Deserializer;
import rpl.shaded.org.apache.kafka.common.utils.Exit;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.runtime.BoxesRunTime;

public final class ConsoleConsumer$
implements Logging {
    public static final ConsoleConsumer$ MODULE$ = new ConsoleConsumer$();
    private static int messageCount = 0;
    private static final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public int messageCount() {
        return messageCount;
    }

    public void messageCount_$eq(int x$1) {
        messageCount = x$1;
    }

    private CountDownLatch shutdownLatch() {
        return shutdownLatch;
    }

    public void main(String[] args) {
        ConsoleConsumer.ConsumerConfig conf = new ConsoleConsumer.ConsumerConfig(args);
        try {
            this.run(conf);
            return;
        }
        catch (AuthenticationException e) {
            if (this.logger().underlying().isErrorEnabled()) {
                String string;
                String string2 = string = "Authentication failed: terminating consumer process";
                string = null;
                String msgWithLogIdent_msg = string2;
                Object var5_5 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), (Throwable)e);
            }
            throw Exit$.MODULE$.exit(1, None$.MODULE$);
        }
        catch (Throwable e) {
            if (this.logger().underlying().isErrorEnabled()) {
                String string;
                String string3 = string = "Unknown error when running consumer: ";
                string = null;
                String msgWithLogIdent_msg = string3;
                Object var6_8 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
            }
            throw Exit$.MODULE$.exit(1, None$.MODULE$);
        }
    }

    public void run(ConsoleConsumer.ConsumerConfig conf) {
        long timeoutMs = conf.timeoutMs() >= 0 ? (long)conf.timeoutMs() : Long.MAX_VALUE;
        KafkaConsumer<byte[], byte[]> consumer = new KafkaConsumer<byte[], byte[]>(this.consumerProps(conf), (Deserializer<byte[]>)new ByteArrayDeserializer(), (Deserializer<byte[]>)new ByteArrayDeserializer());
        ConsoleConsumer.ConsumerWrapper consumerWrapper = conf.partitionArg().isDefined() ? new ConsoleConsumer.ConsumerWrapper(Option$.MODULE$.apply(conf.topicArg()), conf.partitionArg(), Option$.MODULE$.apply(conf.offsetArg()), None$.MODULE$, consumer, timeoutMs) : new ConsoleConsumer.ConsumerWrapper(Option$.MODULE$.apply(conf.topicArg()), None$.MODULE$, None$.MODULE$, Option$.MODULE$.apply(conf.whitelistArg()), consumer, timeoutMs);
        this.addShutdownHook(consumerWrapper, conf);
        try {
            this.process(conf.maxMessages(), conf.formatter(), consumerWrapper, System.out, conf.skipMessageOnError());
        }
        finally {
            consumerWrapper.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            this.shutdownLatch().countDown();
        }
    }

    public void addShutdownHook(ConsoleConsumer.ConsumerWrapper consumer, ConsoleConsumer.ConsumerConfig conf) {
        Exit.addShutdownHook("consumer-shutdown-hook", () -> Exit$.$anonfun$addShutdownHook$1(() -> {
            consumer.wakeup();
            MODULE$.shutdownLatch().await();
            if (conf.enableSystestEventsLogging()) {
                System.out.println("shutdown_complete");
            }
        }));
    }

    public void process(Integer maxMessages, MessageFormatter formatter, ConsoleConsumer.ConsumerWrapper consumer, PrintStream output, boolean skipMessageOnError) {
        while (this.messageCount() < BoxesRunTime.unboxToInt(maxMessages) || BoxesRunTime.equalsNumObject(maxMessages, -1)) {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            try {
                consumerRecord = consumer.receive();
            }
            catch (WakeupException wakeupException) {
                if (this.logger().underlying().isTraceEnabled()) {
                    String string;
                    String string2 = string = "Caught WakeupException because consumer is shutdown, ignore and terminate.";
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var9_11 = null;
                    this.logger().underlying().trace(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                    return;
                }
                return;
            }
            catch (Throwable e) {
                if (this.logger().underlying().isErrorEnabled()) {
                    String string;
                    String string3 = string = "Error processing message, terminating consumer process: ";
                    string = null;
                    String msgWithLogIdent_msg = string3;
                    Object var10_14 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
                    return;
                }
                return;
            }
            ConsumerRecord<byte[], byte[]> msg = consumerRecord;
            this.messageCount_$eq(this.messageCount() + 1);
            try {
                formatter.writeTo(new ConsumerRecord<byte[], byte[]>(msg.topic(), msg.partition(), msg.offset(), msg.timestamp(), msg.timestampType(), 0L, 0, 0, msg.key(), msg.value(), msg.headers()), output);
            }
            catch (Throwable e) {
                if (skipMessageOnError) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        String string;
                        String string4 = string = "Error processing message, skipping this message: ";
                        string = null;
                        String msgWithLogIdent_msg = string4;
                        Object var11_8 = null;
                        this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
                    }
                }
                throw e;
            }
            if (!this.checkErr(output, formatter)) continue;
            return;
        }
    }

    public void reportRecordCount() {
        System.err.println(new StringBuilder(30).append("Processed a total of ").append(this.messageCount()).append(" messages").toString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkErr(PrintStream output, MessageFormatter formatter) {
        void var3_3;
        boolean gotError = output.checkError();
        if (gotError) {
            System.err.println("Unable to write to standard out, closing consumer.");
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties consumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(config.consumerProps());
        new Implicits.PropertiesOps(props).$plus$plus$eq(config.extraConsumerProps());
        this.setAutoOffsetResetValue(config, props);
        props.put("bootstrap.servers", config.bootstrapServer());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "isolation.level", config.options(), config.isolationLevelOpt());
        return var2_2;
    }

    public void setAutoOffsetResetValue(ConsoleConsumer.ConsumerConfig config, Properties props) {
        String string = "latest";
        String string2 = "earliest";
        if (props.containsKey("auto.offset.reset")) {
            String autoResetOption = props.getProperty("auto.offset.reset");
            if (config.options().has((OptionSpec)config.resetBeginningOpt()) && !string2.equals(autoResetOption)) {
                System.err.println(new StringBuilder(24).append(new StringBuilder(72).append("Can't simultaneously specify --from-beginning and 'auto.offset.reset=").append(autoResetOption).append("', ").toString()).append("please remove one option").toString());
                throw Exit$.MODULE$.exit(1, None$.MODULE$);
            }
        } else {
            String autoResetOption = config.options().has((OptionSpec)config.resetBeginningOpt()) ? string2 : string;
            props.put("auto.offset.reset", autoResetOption);
        }
    }

    public static final /* synthetic */ String $anonfun$main$1() {
        return "Authentication failed: terminating consumer process";
    }

    public static final /* synthetic */ AuthenticationException $anonfun$main$2(AuthenticationException e$1) {
        return e$1;
    }

    public static final /* synthetic */ String $anonfun$main$3() {
        return "Unknown error when running consumer: ";
    }

    public static final /* synthetic */ Throwable $anonfun$main$4(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$process$1() {
        return "Caught WakeupException because consumer is shutdown, ignore and terminate.";
    }

    public static final /* synthetic */ String $anonfun$process$2() {
        return "Error processing message, terminating consumer process: ";
    }

    public static final /* synthetic */ Throwable $anonfun$process$3(Throwable e$3) {
        return e$3;
    }

    public static final /* synthetic */ String $anonfun$process$4() {
        return "Error processing message, skipping this message: ";
    }

    public static final /* synthetic */ Throwable $anonfun$process$5(Throwable e$4) {
        return e$4;
    }

    private ConsoleConsumer$() {
    }
}

