/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.log;

import java.io.Serializable;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.log.Log;
import rpl.shaded.kafka.log.LogSegment;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.Tuple2$mcJJ$sp;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.Seq$;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.math.Numeric$LongIsIntegral$;
import rpl.shaded.scala.math.Ordering$Long$;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class LogCleanerManager$
implements Logging {
    public static final LogCleanerManager$ MODULE$ = new LogCleanerManager$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public long maxCompactionDelay(Log log, long firstDirtyOffset, long now) {
        long max_y;
        Iterable<LogSegment> dirtyNonActiveSegments = log.nonActiveLogSegmentsFrom(firstDirtyOffset);
        Iterable firstBatchTimestamps = (Iterable)log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).filter(x$5 -> x$5 > 0L);
        long earliestDirtySegmentTimestamp = firstBatchTimestamps.nonEmpty() ? BoxesRunTime.unboxToLong(firstBatchTimestamps.min(Ordering$Long$.MODULE$)) : Long.MAX_VALUE;
        long l = BoxesRunTime.unboxToLong(log.config().maxCompactionLagMs());
        long l2 = Math.max(l, max_y = 0L);
        long cleanUntilTime = now - l2;
        if (earliestDirtySegmentTimestamp < cleanUntilTime) {
            return cleanUntilTime - earliestDirtySegmentTimestamp;
        }
        return 0L;
    }

    public Tuple2<Object, Object> cleanableOffsets(Log log, Option<Object> lastCleanOffset, long now) {
        None$ none$;
        long l;
        Object object;
        long logStartOffset = log.logStartOffset();
        if (lastCleanOffset == null) {
            throw null;
        }
        if (lastCleanOffset.isEmpty()) {
            Long l2;
            Long l3 = l2 = Long.valueOf(logStartOffset);
            l2 = null;
            object = l3;
        } else {
            object = lastCleanOffset.get();
        }
        Object object2 = object;
        object = null;
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong(object2);
        if (checkpointDirtyOffset < logStartOffset) {
            if (!this.isCompactAndDelete(log) && this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$2(log, logStartOffset, checkpointDirtyOffset);
                Object var22_8 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            l = logStartOffset;
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$3(log, checkpointDirtyOffset, logStartOffset);
                Object var23_9 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            l = logStartOffset;
        } else {
            l = checkpointDirtyOffset;
        }
        long firstDirtyOffset = l;
        long l4 = BoxesRunTime.unboxToLong(log.config().compactionLagMs());
        long max_y = 0L;
        long l5 = Math.max(l4, max_y);
        Option[] optionArray = new Option[3];
        optionArray[0] = log.firstUnstableOffset();
        optionArray[1] = Option$.MODULE$.apply(log.activeSegment().baseOffset());
        if (l5 > 0L) {
            Option option = log.nonActiveLogSegmentsFrom(firstDirtyOffset).find((Function1<LogSegment, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(LogCleanerManager$.$anonfun$cleanableOffsets$4(now, l5, log, s)));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Option option2 = map_this.isEmpty() ? None$.MODULE$ : new Some<Long>(((LogSegment)map_this.get()).baseOffset());
            none$ = option2;
            Object var14_14 = null;
            option2 = null;
        } else {
            none$ = None$.MODULE$;
        }
        optionArray[2] = none$;
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong(((IterableOnceOps)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(optionArray)).flatten($less$colon$less$.MODULE$.refl())).min(Ordering$Long$.MODULE$));
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$7(log, lastCleanOffset, now, firstDirtyOffset, firstUncleanableDirtyOffset);
            Object var24_17 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return new Tuple2$mcJJ$sp(firstDirtyOffset, Math.max(firstDirtyOffset, firstUncleanableDirtyOffset));
    }

    public Tuple2<Object, Object> calculateCleanableBytes(Log log, long firstDirtyOffset, long uncleanableOffset) {
        Object object;
        Option option = log.nonActiveLogSegmentsFrom(uncleanableOffset).headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            LogSegment logSegment;
            LogSegment logSegment2 = logSegment = log.activeSegment();
            logSegment = null;
            object = logSegment2;
        } else {
            object = getOrElse_this.get();
        }
        Object a = object;
        Object var10_4 = null;
        object = null;
        long firstUncleanableOffset = ((LogSegment)a).baseOffset();
        long cleanableBytes = BoxesRunTime.unboxToLong(((IterableOnceOps)log.logSegments(firstDirtyOffset, Math.max(firstDirtyOffset, firstUncleanableOffset)).map((Function1<LogSegment, Object> & Serializable)x$7 -> BoxesRunTime.boxToLong(x$7.size()))).sum(Numeric$LongIsIntegral$.MODULE$));
        return new Tuple2$mcJJ$sp(firstUncleanableOffset, cleanableBytes);
    }

    public static final /* synthetic */ long $anonfun$cleanableOffsets$1(long logStartOffset$1) {
        return logStartOffset$1;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$2(Log log$2, long logStartOffset$1, long checkpointDirtyOffset$1) {
        return new StringBuilder(0).append(new StringBuilder(54).append("Resetting first dirty offset of ").append(log$2.name()).append(" to log start offset ").append(logStartOffset$1).append(" ").toString()).append(new StringBuilder(42).append("since the checkpointed offset ").append(checkpointDirtyOffset$1).append(" is invalid.").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$3(Log log$2, long checkpointDirtyOffset$1, long logStartOffset$1) {
        return new StringBuilder(0).append(new StringBuilder(53).append("The last checkpoint dirty offset for partition ").append(log$2.name()).append(" is ").append(checkpointDirtyOffset$1).append(", ").toString()).append(new StringBuilder(77).append("which is larger than the log end offset ").append(log$2.logEndOffset()).append(". Resetting to the log start offset ").append(logStartOffset$1).append(".").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$5(Log log$2, LogSegment s$1, long now$3, long minCompactionLagMs$1, boolean isUncleanable$1) {
        return new StringBuilder(0).append(new StringBuilder(67).append("Checking if log segment may be cleaned: log='").append(log$2.name()).append("' segment.baseOffset=").append(s$1.baseOffset()).append(" ").toString()).append(new StringBuilder(49).append("segment.largestTimestamp=").append(s$1.largestTimestamp()).append("; now - compactionLag=").append(now$3 - minCompactionLagMs$1).append("; ").toString()).append(new StringBuilder(15).append("is uncleanable=").append(isUncleanable$1).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(long now$3, long minCompactionLagMs$1, Log log$2, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$3 - minCompactionLagMs$1;
        LogCleanerManager$ debug_this = MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$5(log$2, s, now$3, minCompactionLagMs$1, isUncleanable);
            Object var8_6 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
        }
        return isUncleanable;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$7(Log log$2, Option lastCleanOffset$1, long now$3, long firstDirtyOffset$1, long firstUncleanableDirtyOffset$1) {
        return new StringBuilder(0).append(new StringBuilder(64).append("Finding range of cleanable offsets for log=").append(log$2.name()).append(". Last clean offset=").append(lastCleanOffset$1).append(" ").toString()).append(new StringBuilder(50).append("now=").append(now$3).append(" => firstDirtyOffset=").append(firstDirtyOffset$1).append(" firstUncleanableOffset=").append(firstUncleanableDirtyOffset$1).append(" ").toString()).append(new StringBuilder(25).append("activeSegment.baseOffset=").append(log$2.activeSegment().baseOffset()).toString()).toString();
    }

    public static final /* synthetic */ LogSegment $anonfun$calculateCleanableBytes$1(Log log$3) {
        return log$3.activeSegment();
    }

    private LogCleanerManager$() {
    }

    public static final /* synthetic */ Object $anonfun$cleanableOffsets$6$adapted(LogSegment x$6) {
        return BoxesRunTime.boxToLong(x$6.baseOffset());
    }
}

