/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.admin;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.admin.AdminOperationException;
import rpl.shaded.kafka.admin.TopicCommand;
import rpl.shaded.kafka.admin.TopicCommand$AdminClientTopicService$;
import rpl.shaded.kafka.admin.TopicCommand$ZookeeperTopicService$;
import rpl.shaded.kafka.common.AdminCommandFailedException;
import rpl.shaded.kafka.log.LogConfig$;
import rpl.shaded.kafka.utils.CoreUtils$;
import rpl.shaded.kafka.utils.Exit$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.kafka.utils.Whitelist;
import rpl.shaded.org.apache.kafka.clients.admin.PartitionReassignment;
import rpl.shaded.org.apache.kafka.common.Node;
import rpl.shaded.org.apache.kafka.common.TopicPartitionInfo;
import rpl.shaded.org.apache.kafka.common.internals.Topic;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.Console$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.Seq;
import rpl.shaded.scala.collection.SeqOps;
import rpl.shaded.scala.collection.immutable.$colon$colon;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.immutable.Range;
import rpl.shaded.scala.collection.immutable.Set;
import rpl.shaded.scala.collection.mutable.ArraySeq;
import rpl.shaded.scala.collection.mutable.Buffer;
import rpl.shaded.scala.collection.mutable.LinkedHashMap;
import rpl.shaded.scala.io.StdIn;
import rpl.shaded.scala.io.StdIn$;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.Statics;

public final class TopicCommand$
implements Logging {
    public static final TopicCommand$ MODULE$ = new TopicCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        opts.checkArgs();
        TopicCommand.ZookeeperTopicService topicService = opts.zkConnect().isDefined() ? TopicCommand$ZookeeperTopicService$.MODULE$.apply(opts.zkConnect()) : TopicCommand$AdminClientTopicService$.MODULE$.apply(opts.commandConfig(), opts.bootstrapServer());
        int exitCode = 0;
        try {
            try {
                if (opts.hasCreateOption()) {
                    topicService.createTopic(opts);
                } else if (opts.hasAlterOption()) {
                    topicService.alterTopic(opts);
                } else if (opts.hasListOption()) {
                    topicService.listTopics(opts);
                } else if (opts.hasDescribeOption()) {
                    topicService.describeTopic(opts);
                } else if (opts.hasDeleteOption()) {
                    topicService.deleteTopic(opts);
                }
            }
            catch (Throwable e) {
                String println_x = new StringBuilder(38).append("Error while executing topic command : ").append(e.getMessage()).toString();
                Console$.MODULE$.println(println_x);
                Object var6_6 = null;
                if (this.logger().underlying().isErrorEnabled()) {
                    String string;
                    String string2 = string = Utils.stackTrace(e);
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var7_8 = null;
                    this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                exitCode = 1;
            }
        }
        catch (Throwable throwable) {
            topicService.close();
            throw Exit$.MODULE$.exit(exitCode, None$.MODULE$);
        }
        topicService.close();
        throw Exit$.MODULE$.exit(exitCode, None$.MODULE$);
    }

    public void kafka$admin$TopicCommand$$ensureTopicExists(Seq<String> foundTopics, Option<String> requestedTopic, boolean requireTopicExists) {
        if (requestedTopic.isDefined() && requireTopicExists && foundTopics.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Topic '").append((Object)requestedTopic.get()).append("' does not exist as expected").toString());
        }
    }

    public boolean kafka$admin$TopicCommand$$ensureTopicExists$default$3() {
        return true;
    }

    public Seq<String> kafka$admin$TopicCommand$$doGetTopics(Seq<String> allTopics, Option<String> topicWhitelist, boolean excludeInternalTopics) {
        if (topicWhitelist.isDefined()) {
            Whitelist topicsFilter = new Whitelist(topicWhitelist.get());
            return (Seq)allTopics.filter((Function1<String, Object> & Serializable)x$16 -> BoxesRunTime.boxToBoolean(topicsFilter.isTopicAllowed(x$16, excludeInternalTopics)));
        }
        return (Seq)allTopics.filterNot((Function1<String, Object> & Serializable)x$17 -> BoxesRunTime.boxToBoolean(TopicCommand$.$anonfun$doGetTopics$2(excludeInternalTopics, x$17)));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_6;
        List<String> list;
        Option<List<String>> option = opts.topicConfig();
        if (option == null) {
            throw null;
        }
        Option<List<String>> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            List list2;
            List list3 = list2 = Collections.emptyList();
            list2 = null;
            list = list3;
        } else {
            list = getOrElse_this.get();
        }
        List<String> list4 = list;
        Object var4_2 = null;
        list = null;
        Buffer configsToBeAdded = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(list4).asScala()).map((Function1<String, String[]> & Serializable)x$18 -> x$18.split("\\s*=\\s*"));
        if (!configsToBeAdded.forall((Function1<String[], Object> & Serializable)config -> BoxesRunTime.boxToBoolean(TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config)))) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Invalid topic config: all configs to be added must be in the format \"key=val\".").toString());
        }
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1<String[], Object> & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
        LogConfig$.MODULE$.validate(props);
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            String println_x = new StringBuilder(0).append(new StringBuilder(43).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").toString()).append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString();
            Console$.MODULE$.println(println_x);
        }
        return var3_6;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        void var2_5;
        List<String> list;
        Option<List<String>> option = opts.configsToDelete();
        if (option == null) {
            throw null;
        }
        Option<List<String>> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            List list2;
            List list3 = list2 = Collections.emptyList();
            list2 = null;
            list = list3;
        } else {
            list = getOrElse_this.get();
        }
        List<String> list4 = list;
        Object var4_2 = null;
        list = null;
        Buffer configsToBeDeleted = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(list4).asScala()).map((Function1<String, String> & Serializable)x$19 -> x$19.trim());
        Properties propsToBeDeleted = new Properties();
        configsToBeDeleted.foreach((Function1<String, Object> & Serializable)x$20 -> propsToBeDeleted.setProperty((String)x$20, ""));
        LogConfig$.MODULE$.validateNames(propsToBeDeleted);
        return var2_5;
    }

    /*
     * WARNING - void declaration
     */
    public rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.immutable.List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        void var3_3;
        String[] partitionList = replicaAssignmentList.split(",");
        LinkedHashMap ret = new LinkedHashMap();
        int n = 0;
        int n2 = partitionList.length;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, n2, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TopicCommand$.$anonfun$parseReplicaAssignment$1(partitionList, ret, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        return var3_3;
    }

    public Map<Integer, List<Integer>> asJavaReplicaReassignment(rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.immutable.List<Object>> original) {
        return JavaConverters$.MODULE$.mapAsJavaMapConverter((rpl.shaded.scala.collection.Map)original.map((Function1<Tuple2, Tuple2> & Serializable)f -> {
            rpl.shaded.scala.collection.immutable.List list;
            Integer n = f._1$mcI$sp();
            rpl.shaded.scala.collection.immutable.List list2 = (rpl.shaded.scala.collection.immutable.List)f._2();
            if (list2 == null) {
                throw null;
            }
            rpl.shaded.scala.collection.immutable.List map_this = list2;
            if (map_this == Nil$.MODULE$) {
                list = Nil$.MODULE$;
            } else {
                $colon$colon<Nothing$> map_h;
                $colon$colon<Nothing$> map_t = map_h = new $colon$colon<Nothing$>((Nothing$)((Object)Integer.valueOf(BoxesRunTime.unboxToInt(map_this.head()))), Nil$.MODULE$);
                for (rpl.shaded.scala.collection.immutable.List map_rest = (rpl.shaded.scala.collection.immutable.List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (rpl.shaded.scala.collection.immutable.List)map_rest.tail()) {
                    $colon$colon<Nothing$> map_nx = new $colon$colon<Nothing$>((Nothing$)((Object)Integer.valueOf(BoxesRunTime.unboxToInt(map_rest.head()))), Nil$.MODULE$);
                    map_t.next_$eq(map_nx);
                    map_t = map_nx;
                }
                Statics.releaseFence();
                list = map_h;
            }
            Nil$ nil$ = list;
            Object var3_1 = null;
            Object var4_3 = null;
            Object var5_4 = null;
            Object var6_5 = null;
            Object var7_6 = null;
            list = null;
            List<Nothing$> $minus$greater$extension_y = JavaConverters$.MODULE$.seqAsJavaListConverter(nil$).asJava();
            Integer $minus$greater$extension_$this = n;
            return new Tuple2<Integer, List<Nothing$>>($minus$greater$extension_$this, $minus$greater$extension_y);
        })).asJava();
    }

    public int kafka$admin$TopicCommand$$getReplicationFactor(TopicPartitionInfo tpi, Option<PartitionReassignment> reassignment) {
        int n;
        PartitionReassignment ra;
        if (reassignment instanceof Some && TopicCommand$.isReassignmentInProgress$1(ra = (PartitionReassignment)((Some)reassignment).value(), tpi)) {
            SeqOps seqOps = (SeqOps)((SeqOps)JavaConverters$.MODULE$.asScalaBufferConverter(ra.replicas()).asScala()).diff((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(ra.addingReplicas()).asScala());
            if (seqOps == null) {
                throw null;
            }
            SeqOps size_this = seqOps;
            Object var5_4 = null;
            n = size_this.length();
        } else {
            n = tpi.replicas().size();
        }
        return n;
    }

    public void askToProceed() {
        String println_x = "Are you sure you want to continue? [y/n]";
        Console$.MODULE$.println(println_x);
        Object var1_1 = null;
        if (!StdIn.readLine$(StdIn$.MODULE$).equalsIgnoreCase("y")) {
            String println_x2 = "Ending your session";
            Console$.MODULE$.println(println_x2);
            Object var2_2 = null;
            throw Exit$.MODULE$.exit(0, None$.MODULE$);
        }
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace(e$1);
    }

    public static final /* synthetic */ boolean $anonfun$doGetTopics$2(boolean excludeInternalTopics$1, String x$17) {
        return Topic.isInternal(x$17) && excludeInternalTopics$1;
    }

    public static final /* synthetic */ List $anonfun$parseTopicConfigsToBeAdded$1() {
        return Collections.emptyList();
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ String $anonfun$parseTopicConfigsToBeAdded$4() {
        return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
    }

    public static final /* synthetic */ List $anonfun$parseTopicConfigsToBeDeleted$1() {
        return Collections.emptyList();
    }

    public static final /* synthetic */ int $anonfun$parseReplicaAssignment$2(String s) {
        return Integer.parseInt(s.trim());
    }

    public static final /* synthetic */ void $anonfun$parseReplicaAssignment$1(String[] partitionList$1, LinkedHashMap ret$1, int i) {
        Object var7_7;
        int[] nArray;
        int[] nArray2;
        String[] map$extension_$this = partitionList$1[i].split(":");
        int n = map$extension_$this.length;
        int[] nArray3 = nArray2 = new int[n];
        nArray2 = null;
        int[] nArray4 = nArray = nArray3;
        nArray = null;
        int[] map$extension_ys = nArray4;
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                int n2;
                map$extension_ys[map$extension_i] = n2 = TopicCommand$.$anonfun$parseReplicaAssignment$2(map$extension_$this[map$extension_i]);
            }
        }
        void v2 = var7_7;
        Object var6_3 = null;
        var7_7 = null;
        void brokerList = v2;
        Iterable<Object> duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray((int[])brokerList));
        if (duplicateBrokers.nonEmpty()) {
            String mkString_sep = ",";
            Object var5_12 = null;
            throw new AdminCommandFailedException(new StringBuilder(59).append("Partition replica lists may not contain duplicate entries: ").append(duplicateBrokers.mkString("", mkString_sep, "")).toString());
        }
        ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray((int[])brokerList);
        if (ofInt2 == null) {
            throw null;
        }
        ret$1.put(i, IterableOnceOps.toList$(ofInt2));
        SeqOps seqOps = (SeqOps)ret$1.apply(i);
        if (seqOps == null) {
            throw null;
        }
        SeqOps seqOps2 = (SeqOps)ret$1.apply(0);
        if (seqOps2 == null) {
            throw null;
        }
        if (seqOps.length() != seqOps2.length()) {
            throw new AdminOperationException(new StringBuilder(45).append("Partition ").append(i).append(" has different replication factor: ").append(brokerList).toString());
        }
    }

    public static final /* synthetic */ int $anonfun$getReplicationFactor$2(Object x) {
        return BoxesRunTime.unboxToInt(x);
    }

    private static final boolean isReassignmentInProgress$1(PartitionReassignment ra, TopicPartitionInfo tpi$1) {
        Set allReplicaIds = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(tpi$1.replicas()).asScala()).map((Function1<Node, Object> & Serializable)x$21 -> BoxesRunTime.boxToInteger(x$21.id()))).toSet();
        Set removingReplicaIds = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(ra.removingReplicas()).asScala()).map((Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToInteger(TopicCommand$.$anonfun$getReplicationFactor$2(x)))).toSet();
        return allReplicaIds.exists(elem -> removingReplicaIds.contains(BoxesRunTime.boxToInteger(elem)));
    }

    private TopicCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$parseReplicaAssignment$2$adapted(String s) {
        return BoxesRunTime.boxToInteger(TopicCommand$.$anonfun$parseReplicaAssignment$2(s));
    }

    public static final /* synthetic */ Integer $anonfun$asJavaReplicaReassignment$2$adapted(Object e) {
        return BoxesRunTime.unboxToInt(e);
    }
}

