/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.admin;

import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.admin.AdminOperationException;
import rpl.shaded.kafka.admin.LeaderElectionCommandOptions;
import rpl.shaded.kafka.common.AdminCommandFailedException;
import rpl.shaded.kafka.utils.CommandLineUtils$;
import rpl.shaded.kafka.utils.CoreUtils$;
import rpl.shaded.kafka.utils.Json$;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeInt$;
import rpl.shaded.kafka.utils.json.DecodeJson$DecodeString$;
import rpl.shaded.kafka.utils.json.JsonObject;
import rpl.shaded.kafka.utils.json.JsonValue;
import rpl.shaded.org.apache.kafka.clients.admin.Admin;
import rpl.shaded.org.apache.kafka.common.ElectionType;
import rpl.shaded.org.apache.kafka.common.TopicPartition;
import rpl.shaded.org.apache.kafka.common.errors.ClusterAuthorizationException;
import rpl.shaded.org.apache.kafka.common.errors.ElectionNotNeededException;
import rpl.shaded.org.apache.kafka.common.errors.TimeoutException;
import rpl.shaded.org.apache.kafka.common.utils.Utils;
import rpl.shaded.scala.$eq$colon$eq;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Console$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.None$;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Option$;
import rpl.shaded.scala.Predef$;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.Iterable;
import rpl.shaded.scala.collection.IterableFactory;
import rpl.shaded.scala.collection.IterableOnce;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.Iterator;
import rpl.shaded.scala.collection.JavaConverters$;
import rpl.shaded.scala.collection.immutable.$colon$colon;
import rpl.shaded.scala.collection.immutable.List;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.immutable.Seq$;
import rpl.shaded.scala.collection.mutable.Buffer;
import rpl.shaded.scala.collection.mutable.Buffer$;
import rpl.shaded.scala.collection.mutable.Map;
import rpl.shaded.scala.collection.mutable.Map$;
import rpl.shaded.scala.collection.mutable.Set$;
import rpl.shaded.scala.concurrent.duration.Duration;
import rpl.shaded.scala.concurrent.duration.DurationConversions;
import rpl.shaded.scala.concurrent.duration.package;
import rpl.shaded.scala.runtime.BoxedUnit;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.Nothing$;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class LeaderElectionCommand$
implements Logging {
    public static final LeaderElectionCommand$ MODULE$ = new LeaderElectionCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        this.run(args, DurationConversions.second$(new package.DurationInt(30)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run(String[] args, Duration timeout) {
        commandOptions = new LeaderElectionCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOptions, "This tool attempts to elect a new leader for a set of topic partitions. The type of elections supported are preferred replicas and unclean replicas.");
        this.validate(commandOptions);
        electionType = (ElectionType)commandOptions.options().valueOf(commandOptions.electionType());
        v0 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.pathToJsonFile()));
        if (v0 == null) {
            throw null;
        }
        map_this = v0;
        var14_6 /* !! */  = map_this.isEmpty() != false ? None$.MODULE$ : new Some<rpl.shaded.scala.collection.immutable.Set>(LeaderElectionCommand$.$anonfun$run$1((String)map_this.get()));
        v1 = var14_6 /* !! */ ;
        var13_5 = null;
        var14_6 /* !! */  = null;
        jsonFileTopicPartitions = v1;
        var23_8 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.partition()));
        var22_9 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.topic()));
        if (!(var22_9 instanceof Some)) ** GOTO lbl-1000
        topic = (String)((Some)var22_9).value();
        if (var23_8 instanceof Some) {
            partition = (Integer)((Some)var23_8).value();
            v2 = Predef$.MODULE$.Set();
            var20_12 = ScalaRunTime$.MODULE$.wrapRefArray(new TopicPartition[]{new TopicPartition(topic, BoxesRunTime.unboxToInt(partition))});
            if (v2 == null) {
                throw null;
            }
            var20_12 = null;
            var3_13 /* !! */  = new Some<Object>(IterableFactory.apply$(v2, (Seq)apply_elems));
        } else lbl-1000:
        // 2 sources

        {
            var3_13 /* !! */  = None$.MODULE$;
        }
        var15_14 /* !! */  = jsonFileTopicPartitions.isEmpty() != false ? (Option)var3_13 /* !! */  : jsonFileTopicPartitions;
        v3 /* !! */  = var15_14 /* !! */ ;
        var15_14 /* !! */  = null;
        topicPartitions /* !! */  = v3 /* !! */ ;
        v4 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.adminClientConfig()));
        if (v4 == null) {
            throw null;
        }
        map_this = v4;
        var17_17 /* !! */  = map_this.isEmpty() != false ? None$.MODULE$ : new Some<Properties>(Utils.loadProps((String)map_this.get(), null));
        v5 = var17_17 /* !! */ ;
        var16_16 = null;
        var17_17 /* !! */  = null;
        getOrElse_this = v5;
        if (getOrElse_this.isEmpty()) {
            v6 = var21_19 = new Properties();
            var21_19 = null;
            var19_20 /* !! */  = v6;
        } else {
            var19_20 /* !! */  = getOrElse_this.get();
        }
        v7 = var19_20 /* !! */ ;
        var18_18 = null;
        var19_20 /* !! */  = null;
        props = (Properties)v7;
        props.setProperty("bootstrap.servers", (String)commandOptions.options().valueOf(commandOptions.bootstrapServer()));
        props.setProperty("default.api.timeout.ms", Long.valueOf(timeout.toMillis()).toString());
        props.setProperty("request.timeout.ms", Long.valueOf(timeout.toMillis() / 2L).toString());
        adminClient = Admin.create(props);
        try {
            this.electLeaders(adminClient, electionType, topicPartitions /* !! */ );
        }
        finally {
            adminClient.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private rpl.shaded.scala.collection.immutable.Set<TopicPartition> parseReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Option<JsonValue> option2 = ((JsonValue)((Some)option).value()).asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Buffer buffer;
                Iterator iterator = ((JsonValue)((Some)option2).value()).asJsonArray().iterator().map((Function1<JsonValue, JsonObject> & Serializable)x$1 -> x$1.asJsonObject()).map((Function1<JsonObject, TopicPartition> & Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt(p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicPartition(topic, partition);
                });
                if (iterator == null) {
                    throw null;
                }
                Iterator toBuffer_this = iterator;
                Buffer buffer2 = buffer = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
                Object var7_4 = null;
                buffer = null;
                Buffer partitions = buffer2;
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (!duplicatePartitions.nonEmpty()) return partitions.toSet();
                String mkString_sep = ",";
                Object var9_8 = null;
                throw new AdminOperationException(new StringBuilder(53).append("Replica election data contains duplicate partitions: ").append(duplicatePartitions.mkString("", mkString_sep, "")).toString());
            }
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            throw new AdminOperationException("Replica election data is missing \"partitions\" field");
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("Replica election data is empty");
    }

    /*
     * WARNING - void declaration
     */
    private void electLeaders(Admin client, ElectionType electionType, Option<rpl.shaded.scala.collection.immutable.Set<TopicPartition>> topicPartitions) {
        Map<TopicPartition, Optional<Throwable>> map;
        try {
            void orNull_ev;
            if (topicPartitions == null) {
                throw null;
            }
            Option option = topicPartitions.isEmpty() ? None$.MODULE$ : new Some<Set>(LeaderElectionCommand$.$anonfun$electLeaders$1(topicPartitions.get()));
            None$ none$ = option;
            option = null;
            $eq$colon$eq $eq$colon$eq = $less$colon$less$.MODULE$.refl();
            None$ orNull_this = none$;
            Object object = orNull_this.isEmpty() ? orNull_ev.apply(null) : ((Option)orNull_this).get();
            Object object2 = object;
            Object var20_6 = null;
            $eq$colon$eq = null;
            object = null;
            Set partitions = (Set)object2;
            if (this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = LeaderElectionCommand$.$anonfun$electLeaders$2(electionType, partitions);
                Object var30_9 = null;
                this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            map = JavaConverters$.MODULE$.mapAsScalaMapConverter(client.electLeaders(electionType, partitions).partitions().get()).asScala();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for election results";
                Console$.MODULE$.println(message);
                throw new AdminCommandFailedException(message, timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized to perform leader election";
                Console$.MODULE$.println(message);
                throw new AdminCommandFailedException(message, clusterAuthorizationException);
            }
            throw e;
        }
        catch (Throwable e) {
            String println_x = "Error while making request";
            Console$.MODULE$.println(println_x);
            Object var27_17 = null;
            throw e;
        }
        Map<TopicPartition, Optional<Throwable>> electionResults = map;
        rpl.shaded.scala.collection.mutable.Set succeeded = (rpl.shaded.scala.collection.mutable.Set)Set$.MODULE$.empty();
        rpl.shaded.scala.collection.mutable.Set noop = (rpl.shaded.scala.collection.mutable.Set)Set$.MODULE$.empty();
        Map failed = (Map)Map$.MODULE$.empty();
        electionResults.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            LeaderElectionCommand$.$anonfun$electLeaders$3(noop, failed, succeeded, x0$1);
            return BoxedUnit.UNIT;
        });
        if (succeeded.nonEmpty()) {
            String string;
            String mkString_sep = ", ";
            String string2 = string = succeeded.mkString("", mkString_sep, "");
            Object var23_22 = null;
            string = null;
            String partitions = string2;
            String println_x = new StringBuilder(57).append("Successfully completed leader election (").append((Object)electionType).append(") for partitions ").append(partitions).toString();
            Console$.MODULE$.println(println_x);
            Object var28_25 = null;
        }
        if (noop.nonEmpty()) {
            String string;
            String mkString_sep = ", ";
            String string3 = string = succeeded.mkString("", mkString_sep, "");
            Object var25_26 = null;
            string = null;
            String partitions = string3;
            String println_x = new StringBuilder(45).append("Valid replica already elected for partitions ").append(partitions).toString();
            Console$.MODULE$.println(println_x);
            Object var29_29 = null;
        }
        if (failed.nonEmpty()) {
            AdminCommandFailedException rootException = new AdminCommandFailedException(new StringBuilder(32).append(failed.size()).append(" replica(s) could not be elected").toString());
            failed.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
                LeaderElectionCommand$.$anonfun$electLeaders$4(electionType, rootException, x0$2);
                return BoxedUnit.UNIT;
            });
            throw rootException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validate(LeaderElectionCommandOptions commandOptions) {
        Nil$ nil$;
        Nil$ nil$2 = nil$ = Nil$.MODULE$;
        nil$ = null;
        List missingOptions = nil$2;
        if (!commandOptions.options().has(commandOptions.bootstrapServer())) {
            $colon$colon<Nothing$> $colon$colon;
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            $colon$colon<Nothing$> $colon$colon2 = $colon$colon = new $colon$colon<Nothing$>((Nothing$)((Object)string), missingOptions);
            $colon$colon = null;
            missingOptions = $colon$colon2;
        }
        if (!commandOptions.options().has(commandOptions.electionType())) {
            String string = (String)commandOptions.electionType().options().get(0);
            missingOptions = new $colon$colon<Nothing$>((Nothing$)((Object)string), missingOptions);
        }
        if (missingOptions.nonEmpty()) {
            String mkString_sep = ", ";
            Object var6_7 = null;
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(missingOptions.mkString("", mkString_sep, "")).toString());
        }
        Seq mutuallyExclusiveOptions = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new AbstractOptionSpec[]{commandOptions.topic(), commandOptions.allTopicPartitions(), commandOptions.pathToJsonFile()}));
        switch (mutuallyExclusiveOptions.count(arg_0 -> LeaderElectionCommand$.$anonfun$validate$1$adapted(commandOptions.options(), arg_0))) {
            case 1: {
                break;
            }
            default: {
                void mkString_sep;
                IterableOnceOps iterableOnceOps = (IterableOnceOps)mutuallyExclusiveOptions.map((Function1<AbstractOptionSpec, String> & Serializable)x$3 -> (String)x$3.options().get(0));
                String string = ", ";
                if (iterableOnceOps == null) {
                    throw null;
                }
                string = null;
                throw new AdminCommandFailedException(new StringBuilder(55).append("One and only one of the following options is required: ").append(String.valueOf(iterableOnceOps.mkString("", (String)mkString_sep, ""))).toString());
            }
        }
        boolean bl = commandOptions.options().has(commandOptions.partition());
        boolean bl2 = commandOptions.options().has(commandOptions.topic());
        if (bl2 && !bl) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(commandOptions.partition().options().get(0)).toString());
        }
        if (!bl2 && bl) {
            throw new AdminCommandFailedException(new StringBuilder(0).append(new StringBuilder(27).append("Option ").append(commandOptions.partition().options().get(0)).append(" is only allowed if ").toString()).append(new StringBuilder(8).append(commandOptions.topic().options().get(0)).append(" is used").toString()).toString());
        }
    }

    public static final /* synthetic */ rpl.shaded.scala.collection.immutable.Set $anonfun$run$1(String path) {
        return MODULE$.parseReplicaElectionData(Utils.readFileAsString(path));
    }

    public static final /* synthetic */ Option $anonfun$run$2(Option singleTopicPartition$1) {
        return singleTopicPartition$1;
    }

    public static final /* synthetic */ Properties $anonfun$run$3(String config) {
        return Utils.loadProps(config);
    }

    public static final /* synthetic */ Properties $anonfun$run$4() {
        return new Properties();
    }

    public static final /* synthetic */ Set $anonfun$electLeaders$1(rpl.shaded.scala.collection.immutable.Set x$2) {
        return JavaConverters$.MODULE$.setAsJavaSetConverter(x$2).asJava();
    }

    public static final /* synthetic */ String $anonfun$electLeaders$2(ElectionType electionType$1, Set partitions$1) {
        return new StringBuilder(36).append("Calling AdminClient.electLeaders(").append((Object)electionType$1).append(", ").append(partitions$1).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$electLeaders$3(rpl.shaded.scala.collection.mutable.Set noop$1, Map failed$1, rpl.shaded.scala.collection.mutable.Set succeeded$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Optional error = (Optional)x0$1._2();
            if (error.isPresent()) {
                void $plus$eq_elem;
                Tuple2 tuple2;
                if ((Throwable)error.get() instanceof ElectionNotNeededException) {
                    noop$1.addOne(topicPartition);
                    return;
                }
                Object $minus$greater$extension_y = error.get();
                Tuple2 tuple22 = tuple2 = new Tuple2(topicPartition, $minus$greater$extension_y);
                Object var6_6 = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                if (failed$1 == null) {
                    throw null;
                }
                failed$1.addOne($plus$eq_elem);
                return;
            }
            if (succeeded$1 == null) {
                throw null;
            }
            succeeded$1.addOne(topicPartition);
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$electLeaders$4(ElectionType electionType$1, AdminCommandFailedException rootException$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            Throwable exception = (Throwable)x0$2._2();
            String println_x = new StringBuilder(53).append("Error completing leader election (").append((Object)electionType$1).append(") for partition: ").append(topicPartition).append(": ").append(exception).toString();
            Console$.MODULE$.println(println_x);
            Object var5_5 = null;
            rootException$1.addSuppressed(exception);
            return;
        }
        throw new MatchError((Object)null);
    }

    private LeaderElectionCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$validate$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean(eta$0$1$1.has(x$1));
    }
}

