/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.kafka.admin;

import java.io.Serializable;
import java.util.Random;
import rpl.shaded.com.typesafe.scalalogging.Logger;
import rpl.shaded.kafka.admin.AdminOperationException;
import rpl.shaded.kafka.admin.BrokerMetadata;
import rpl.shaded.kafka.utils.Logging;
import rpl.shaded.org.apache.kafka.common.errors.InvalidPartitionsException;
import rpl.shaded.org.apache.kafka.common.errors.InvalidReplicationFactorException;
import rpl.shaded.scala.$less$colon$less$;
import rpl.shaded.scala.Function0;
import rpl.shaded.scala.Function1;
import rpl.shaded.scala.MatchError;
import rpl.shaded.scala.Option;
import rpl.shaded.scala.Some;
import rpl.shaded.scala.Tuple2;
import rpl.shaded.scala.collection.ArrayOps$;
import rpl.shaded.scala.collection.IndexedSeq;
import rpl.shaded.scala.collection.IterableFactory;
import rpl.shaded.scala.collection.IterableOnceOps;
import rpl.shaded.scala.collection.IterableOps;
import rpl.shaded.scala.collection.Iterator;
import rpl.shaded.scala.collection.SeqOps;
import rpl.shaded.scala.collection.immutable.Nil$;
import rpl.shaded.scala.collection.immutable.Range;
import rpl.shaded.scala.collection.immutable.Seq;
import rpl.shaded.scala.collection.mutable.ArrayBuffer;
import rpl.shaded.scala.collection.mutable.ArrayBuffer$;
import rpl.shaded.scala.collection.mutable.Map;
import rpl.shaded.scala.collection.mutable.Map$;
import rpl.shaded.scala.collection.mutable.Set;
import rpl.shaded.scala.collection.mutable.Set$;
import rpl.shaded.scala.math.Ordering$Int$;
import rpl.shaded.scala.math.Ordering$String$;
import rpl.shaded.scala.reflect.ClassTag$;
import rpl.shaded.scala.runtime.BoxesRunTime;
import rpl.shaded.scala.runtime.IntRef;
import rpl.shaded.scala.runtime.ScalaRunTime$;

public final class AdminUtils$
implements Logging {
    public static final AdminUtils$ MODULE$ = new AdminUtils$();
    private static final Random rand = new Random();
    private static final String AdminClientId = "__admin_client";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Random rand() {
        return rand;
    }

    public String AdminClientId() {
        return AdminClientId;
    }

    public rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> assignReplicasToBrokers(rpl.shaded.scala.collection.Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("Number of partitions must be larger than 0.");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Replication factor must be larger than 0.");
        }
        if (brokerMetadatas == null) {
            throw null;
        }
        if (replicationFactor > brokerMetadatas.length()) {
            throw new InvalidReplicationFactorException(new StringBuilder(53).append("Replication factor: ").append(replicationFactor).append(" larger than available brokers: ").append(brokerMetadatas.length()).append(".").toString());
        }
        if (brokerMetadatas.forall((Function1<BrokerMetadata, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(AdminUtils$.$anonfun$assignReplicasToBrokers$1(x$1)))) {
            return this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, (rpl.shaded.scala.collection.Seq)brokerMetadatas.map((Function1<BrokerMetadata, Object> & Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.id())), fixedStartIndex, startPartitionId);
        }
        if (brokerMetadatas.exists((Function1<BrokerMetadata, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(AdminUtils$.$anonfun$assignReplicasToBrokers$3(x$3)))) {
            throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment.");
        }
        return this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, rpl.shaded.scala.collection.Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        Map ret = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray(ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        int n = Math.max(0, startPartitionId);
        int n2 = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        int n3 = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n3, nPartitions, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                if (n > 0 && n % brokerArray.length == 0) {
                    ++n2;
                }
                int $anonfun$assignReplicasToBrokersRackUnaware$1_firstReplicaIndex = (n + startIndex) % brokerArray.length;
                ArrayBuffer $anonfun$assignReplicasToBrokersRackUnaware$1_replicaBuffer = (ArrayBuffer)IterableFactory.apply$(ArrayBuffer$.MODULE$, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerArray[$anonfun$assignReplicasToBrokersRackUnaware$1_firstReplicaIndex]}));
                int n4 = 0;
                int $anonfun$assignReplicasToBrokersRackUnaware$1_until$extension_end = replicationFactor - 1;
                Range.Exclusive $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this = new Range.Exclusive(n4, $anonfun$assignReplicasToBrokersRackUnaware$1_until$extension_end, 1);
                if (!$anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this.isEmpty()) {
                    int $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_i = $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this.start();
                    while (true) {
                        Integer n5;
                        int $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers = brokerArray.length;
                        int $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_shift = 1 + (n2 + $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_i) % ($anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers - 1);
                        Integer n6 = n5 = Integer.valueOf(brokerArray[($anonfun$assignReplicasToBrokersRackUnaware$1_firstReplicaIndex + $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_shift) % $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers]);
                        n5 = null;
                        Integer $anonfun$assignReplicasToBrokersRackUnaware$2_$plus$eq_elem = n6;
                        Object var18_20 = null;
                        ArrayBuffer cfr_ignored_0 = (ArrayBuffer)$anonfun$assignReplicasToBrokersRackUnaware$1_replicaBuffer.addOne($anonfun$assignReplicasToBrokersRackUnaware$2_$plus$eq_elem);
                        if ($anonfun$assignReplicasToBrokersRackUnaware$1_foreach_i == $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this.scala$collection$immutable$Range$$lastElement) break;
                        $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_i += $anonfun$assignReplicasToBrokersRackUnaware$1_foreach_this.step();
                    }
                }
                Object var15_17 = null;
                ret.put(n, $anonfun$assignReplicasToBrokersRackUnaware$1_replicaBuffer);
                ++n;
                Object var13_15 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private rpl.shaded.scala.collection.Map<Object, rpl.shaded.scala.collection.Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, rpl.shaded.scala.collection.Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        rpl.shaded.scala.collection.immutable.Map<Object, String> brokerRackMap = ((IterableOnceOps)brokerMetadatas.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_12;
                if (x1 != null) {
                    int id = x1.id();
                    Option<String> option = x1.rack();
                    if (option instanceof Some) {
                        Tuple2<Integer, String> tuple2;
                        Integer n;
                        Integer n2;
                        String rack = (String)((Some)option).value();
                        Integer n3 = n2 = Integer.valueOf(id);
                        n2 = null;
                        Integer n4 = n = n3;
                        n = null;
                        Integer $minus$greater$extension_$this = n4;
                        Tuple2<Integer, String> tuple22 = tuple2 = new Tuple2<Integer, String>($minus$greater$extension_$this, rack);
                        Object var7_8 = null;
                        tuple2 = null;
                        Tuple2<Integer, String> tuple23 = tuple22;
                        return var3_12;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var3_12;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                boolean bl = x1 != null && x1.rack() instanceof Some;
                return bl;
            }
        })).toMap($less$colon$less$.MODULE$.refl());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList(brokerRackMap);
        if (arrangedBrokerList == null) {
            throw null;
        }
        int n = arrangedBrokerList.length();
        Map ret = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.length());
        int n2 = Math.max(0, startPartitionId);
        int n3 = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.length());
        int n4 = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n4, nPartitions, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                Object var26_28;
                Object var28_30;
                Integer n5;
                Integer n6;
                Integer n7;
                if (n2 > 0 && n2 % arrangedBrokerList.length() == 0) {
                    ++n3;
                }
                int $anonfun$assignReplicasToBrokersRackAware$1_firstReplicaIndex = (n2 + startIndex) % arrangedBrokerList.length();
                int $anonfun$assignReplicasToBrokersRackAware$1_leader = BoxesRunTime.unboxToInt(arrangedBrokerList.apply($anonfun$assignReplicasToBrokersRackAware$1_firstReplicaIndex));
                ArrayBuffer $anonfun$assignReplicasToBrokersRackAware$1_replicaBuffer = (ArrayBuffer)IterableFactory.apply$(ArrayBuffer$.MODULE$, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$anonfun$assignReplicasToBrokersRackAware$1_leader}));
                Set $anonfun$assignReplicasToBrokersRackAware$1_racksWithReplicas = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{(String)brokerRackMap.apply(Integer.valueOf($anonfun$assignReplicasToBrokersRackAware$1_leader))}));
                Set $anonfun$assignReplicasToBrokersRackAware$1_brokersWithReplicas = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$anonfun$assignReplicasToBrokersRackAware$1_leader}));
                int n8 = 0;
                int n9 = 0;
                int $anonfun$assignReplicasToBrokersRackAware$1_until$extension_end = replicationFactor - 1;
                Range.Exclusive $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this = new Range.Exclusive(n9, $anonfun$assignReplicasToBrokersRackAware$1_until$extension_end, 1);
                if (!$anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this.isEmpty()) {
                    int $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_i = $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this.start();
                    while (true) {
                        boolean $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_done = false;
                        while (!$anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_done) {
                            int $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_secondReplicaShift = n3 * numRacks;
                            int n10 = arrangedBrokerList.length();
                            int $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_shift = 1 + ($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_secondReplicaShift + n8) % (n10 - 1);
                            int $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker = BoxesRunTime.unboxToInt(arrangedBrokerList.apply(($anonfun$assignReplicasToBrokersRackAware$1_firstReplicaIndex + $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_shift) % n10));
                            String $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_rack = (String)brokerRackMap.apply(Integer.valueOf($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker));
                            if (!($anonfun$assignReplicasToBrokersRackAware$1_racksWithReplicas.contains($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_rack) && $anonfun$assignReplicasToBrokersRackAware$1_racksWithReplicas.size() != numRacks || $anonfun$assignReplicasToBrokersRackAware$1_brokersWithReplicas.contains($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker) && $anonfun$assignReplicasToBrokersRackAware$1_brokersWithReplicas.size() != n)) {
                                void $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem;
                                Integer n11 = n7 = Integer.valueOf($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker);
                                n7 = null;
                                n6 = n11;
                                if ($anonfun$assignReplicasToBrokersRackAware$1_replicaBuffer == null) {
                                    throw null;
                                }
                                $anonfun$assignReplicasToBrokersRackAware$1_replicaBuffer.addOne($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem);
                                n6 = null;
                                $anonfun$assignReplicasToBrokersRackAware$1_racksWithReplicas.addOne($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_rack);
                                Integer n12 = n5 = Integer.valueOf($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_broker);
                                n5 = null;
                                Integer $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem2 = n12;
                                $anonfun$assignReplicasToBrokersRackAware$1_brokersWithReplicas.addOne($anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem2);
                                var28_30 = null;
                                $anonfun$assignReplicasToBrokersRackAware$1_$anonfun$assignReplicasToBrokersRackAware$2_done = true;
                            }
                            ++n8;
                        }
                        var26_28 = null;
                        n6 = null;
                        var28_30 = null;
                        n7 = null;
                        n5 = null;
                        if ($anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_i == $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                        $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_i += $anonfun$assignReplicasToBrokersRackAware$1_foreach$mVc$sp_this.step();
                    }
                }
                Object var21_23 = null;
                ret.put(n2, $anonfun$assignReplicasToBrokersRackAware$1_replicaBuffer);
                ++n2;
                Object var17_19 = null;
                Object var18_20 = null;
                Object var19_21 = null;
                var26_28 = null;
                n6 = null;
                var28_30 = null;
                n7 = null;
                n5 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(rpl.shaded.scala.collection.Map<Object, String> brokerRackMap) {
        rpl.shaded.scala.collection.Map brokersIteratorByRack = (rpl.shaded.scala.collection.Map)this.getInverseMap(brokerRackMap).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String rack = (String)x0$1._1();
            rpl.shaded.scala.collection.Seq brokers = (rpl.shaded.scala.collection.Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2(rack, brokers.iterator());
            return tuple2;
        });
        String[] racks = (String[])ArrayOps$.MODULE$.sorted$extension((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class)), Ordering$String$.MODULE$);
        ArrayBuffer<Object> result2 = new ArrayBuffer<Object>();
        int rackIndex = 0;
        while (SeqOps.size$(result2) < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply(racks[rackIndex]);
            if (rackIterator.hasNext()) {
                Object $plus$eq_elem = rackIterator.next();
                result2.addOne($plus$eq_elem);
                Object var7_7 = null;
            }
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result2;
    }

    public rpl.shaded.scala.collection.Map<String, rpl.shaded.scala.collection.Seq<Object>> getInverseMap(rpl.shaded.scala.collection.Map<Object, String> brokerRackMap) {
        return (rpl.shaded.scala.collection.Map)((IterableOps)brokerRackMap.toSeq().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            int id = x0$1._1$mcI$sp();
            String rack = (String)x0$1._2();
            Tuple2<String, Integer> tuple2 = new Tuple2<String, Integer>(rack, id);
            return tuple2;
        })).groupBy((Function1<Tuple2, String> & Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            String rack = (String)x0$2._1();
            return var1_1;
        }).map((Function1<Tuple2, Tuple2> & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError((Object)null);
            }
            String rack = (String)x0$3._1();
            Seq rackAndIdList = (Seq)x0$3._2();
            Tuple2 tuple2 = new Tuple2(rack, ((SeqOps)rackAndIdList.map((Function1<Tuple2, Object> & Serializable)x0$4 -> BoxesRunTime.boxToInteger(AdminUtils$.$anonfun$getInverseMap$4(x0$4)))).sorted(Ordering$Int$.MODULE$));
            return tuple2;
        });
    }

    private int replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$1(BrokerMetadata x$1) {
        return x$1.rack().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assignReplicasToBrokers$3(BrokerMetadata x$3) {
        return x$3.rack().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$assignReplicasToBrokersRackUnaware$2(ArrayBuffer replicaBuffer$1, int[] brokerArray$1, int firstReplicaIndex$1, IntRef nextReplicaShift$1, int j) {
        Integer n;
        void replicaIndex_nBrokers;
        int n2 = brokerArray$1.length;
        int replicaIndex_secondReplicaShift = nextReplicaShift$1.elem;
        int replicaIndex_shift = 1 + (replicaIndex_secondReplicaShift + j) % (replicaIndex_nBrokers - true);
        Integer n3 = n = Integer.valueOf(brokerArray$1[(firstReplicaIndex$1 + replicaIndex_shift) % replicaIndex_nBrokers]);
        n = null;
        Integer $plus$eq_elem = n3;
        return (ArrayBuffer)replicaBuffer$1.addOne($plus$eq_elem);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assignReplicasToBrokersRackUnaware$1(IntRef currentPartitionId$1, int[] brokerArray$1, IntRef nextReplicaShift$1, int startIndex$1, int replicationFactor$1, Map ret$1, int x$4) {
        if (currentPartitionId$1.elem > 0 && currentPartitionId$1.elem % brokerArray$1.length == 0) {
            ++nextReplicaShift$1.elem;
        }
        int firstReplicaIndex = (currentPartitionId$1.elem + startIndex$1) % brokerArray$1.length;
        ArrayBuffer replicaBuffer = (ArrayBuffer)IterableFactory.apply$(ArrayBuffer$.MODULE$, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerArray$1[firstReplicaIndex]}));
        int n = 0;
        int until$extension_end = replicationFactor$1 - 1;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                Integer n2;
                void $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers;
                int n3 = brokerArray$1.length;
                int $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_secondReplicaShift = nextReplicaShift$1.elem;
                int $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_shift = 1 + ($anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_secondReplicaShift + foreach_i) % ($anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers - true);
                Integer n4 = n2 = Integer.valueOf(brokerArray$1[(firstReplicaIndex + $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_shift) % $anonfun$assignReplicasToBrokersRackUnaware$2_replicaIndex_nBrokers]);
                n2 = null;
                Integer $anonfun$assignReplicasToBrokersRackUnaware$2_$plus$eq_elem = n4;
                Object var13_13 = null;
                ArrayBuffer cfr_ignored_0 = (ArrayBuffer)replicaBuffer.addOne($anonfun$assignReplicasToBrokersRackUnaware$2_$plus$eq_elem);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var10_11 = null;
        ret$1.put(currentPartitionId$1.elem, replicaBuffer);
        ++currentPartitionId$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assignReplicasToBrokersRackAware$2(IndexedSeq arrangedBrokerList$1, int firstReplicaIndex$2, IntRef nextReplicaShift$2, int numRacks$1, IntRef k$1, rpl.shaded.scala.collection.immutable.Map brokerRackMap$1, Set racksWithReplicas$1, Set brokersWithReplicas$1, int numBrokers$1, ArrayBuffer replicaBuffer$2, int x$5) {
        boolean done = false;
        while (!done) {
            void replicaIndex_replicaIndex;
            int n = arrangedBrokerList$1.length();
            int n2 = k$1.elem;
            int replicaIndex_secondReplicaShift = nextReplicaShift$2.elem * numRacks$1;
            int replicaIndex_shift = 1 + (replicaIndex_secondReplicaShift + replicaIndex_replicaIndex) % (n - 1);
            int broker = BoxesRunTime.unboxToInt(arrangedBrokerList$1.apply((firstReplicaIndex$2 + replicaIndex_shift) % n));
            String rack = (String)brokerRackMap$1.apply(broker);
            if (!(racksWithReplicas$1.contains(rack) && racksWithReplicas$1.size() != numRacks$1 || brokersWithReplicas$1.contains(broker) && brokersWithReplicas$1.size() != numBrokers$1)) {
                Integer n3;
                void $plus$eq_elem;
                Integer n4;
                Integer n5 = n4 = Integer.valueOf(broker);
                n4 = null;
                Integer n6 = n5;
                if (replicaBuffer$2 == null) {
                    throw null;
                }
                replicaBuffer$2.addOne($plus$eq_elem);
                n6 = null;
                racksWithReplicas$1.addOne(rack);
                Integer n7 = n3 = Integer.valueOf(broker);
                n3 = null;
                Integer $plus$eq_elem2 = n7;
                brokersWithReplicas$1.addOne($plus$eq_elem2);
                Object var15_15 = null;
                done = true;
            }
            ++k$1.elem;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assignReplicasToBrokersRackAware$1(IntRef currentPartitionId$2, IndexedSeq arrangedBrokerList$1, IntRef nextReplicaShift$2, int startIndex$2, rpl.shaded.scala.collection.immutable.Map brokerRackMap$1, int replicationFactor$2, int numRacks$1, int numBrokers$1, Map ret$2, int x$6) {
        if (currentPartitionId$2.elem > 0) {
            if (arrangedBrokerList$1 == null) {
                throw null;
            }
            if (currentPartitionId$2.elem % arrangedBrokerList$1.length() == 0) {
                ++nextReplicaShift$2.elem;
            }
        }
        if (arrangedBrokerList$1 == null) {
            throw null;
        }
        int firstReplicaIndex = (currentPartitionId$2.elem + startIndex$2) % arrangedBrokerList$1.length();
        int leader = BoxesRunTime.unboxToInt(arrangedBrokerList$1.apply(firstReplicaIndex));
        ArrayBuffer replicaBuffer = (ArrayBuffer)IterableFactory.apply$(ArrayBuffer$.MODULE$, ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}));
        Set racksWithReplicas = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new String[]{(String)brokerRackMap$1.apply(leader)}));
        Set brokersWithReplicas = (Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}));
        int n = 0;
        int n2 = 0;
        int until$extension_end = replicationFactor$2 - 1;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n2, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                Object var23_24;
                Integer n3;
                Integer n4;
                Integer n5;
                boolean $anonfun$assignReplicasToBrokersRackAware$2_done = false;
                while (!$anonfun$assignReplicasToBrokersRackAware$2_done) {
                    int $anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_secondReplicaShift = nextReplicaShift$2.elem * numRacks$1;
                    int n6 = arrangedBrokerList$1.length();
                    int $anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_shift = 1 + ($anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_secondReplicaShift + n) % (n6 - 1);
                    int $anonfun$assignReplicasToBrokersRackAware$2_broker = BoxesRunTime.unboxToInt(arrangedBrokerList$1.apply((firstReplicaIndex + $anonfun$assignReplicasToBrokersRackAware$2_replicaIndex_shift) % n6));
                    String $anonfun$assignReplicasToBrokersRackAware$2_rack = (String)brokerRackMap$1.apply($anonfun$assignReplicasToBrokersRackAware$2_broker);
                    if (!(racksWithReplicas.contains($anonfun$assignReplicasToBrokersRackAware$2_rack) && racksWithReplicas.size() != numRacks$1 || brokersWithReplicas.contains($anonfun$assignReplicasToBrokersRackAware$2_broker) && brokersWithReplicas.size() != numBrokers$1)) {
                        void $anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem;
                        Integer n7 = n5 = Integer.valueOf($anonfun$assignReplicasToBrokersRackAware$2_broker);
                        n5 = null;
                        n4 = n7;
                        if (replicaBuffer == null) {
                            throw null;
                        }
                        replicaBuffer.addOne($anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem);
                        n4 = null;
                        racksWithReplicas.addOne($anonfun$assignReplicasToBrokersRackAware$2_rack);
                        Integer n8 = n3 = Integer.valueOf($anonfun$assignReplicasToBrokersRackAware$2_broker);
                        n3 = null;
                        Integer $anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem2 = n8;
                        brokersWithReplicas.addOne($anonfun$assignReplicasToBrokersRackAware$2_$plus$eq_elem2);
                        var23_24 = null;
                        $anonfun$assignReplicasToBrokersRackAware$2_done = true;
                    }
                    ++n;
                }
                Object var21_22 = null;
                n4 = null;
                var23_24 = null;
                n5 = null;
                n3 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var16_18 = null;
        ret$2.put(currentPartitionId$2.elem, replicaBuffer);
        ++currentPartitionId$2.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$getInverseMap$4(Tuple2 x0$4) {
        void var1_1;
        if (x0$4 == null) {
            throw new MatchError((Object)null);
        }
        int id = x0$4._2$mcI$sp();
        return (int)var1_1;
    }

    private AdminUtils$() {
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$assignReplicasToBrokersRackUnaware$2$adapted(ArrayBuffer replicaBuffer$1, int[] brokerArray$1, int firstReplicaIndex$1, IntRef nextReplicaShift$1, Object j) {
        return AdminUtils$.$anonfun$assignReplicasToBrokersRackUnaware$2(replicaBuffer$1, brokerArray$1, firstReplicaIndex$1, nextReplicaShift$1, BoxesRunTime.unboxToInt(j));
    }
}

