/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.SocketProtocolFamily;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.SegmentedDatagramPacket;
import io.netty.channel.unix.Socket;
import io.netty.channel.uring.AbstractIoUringChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringDatagramChannelConfig;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringIoOps;
import io.netty.channel.uring.IoUringRecvByteAllocatorHandle;
import io.netty.channel.uring.LinuxSocket;
import io.netty.channel.uring.MsgHdrMemory;
import io.netty.channel.uring.MsgHdrMemoryArray;
import io.netty.channel.uring.Native;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;

public final class IoUringDatagramChannel
extends AbstractIoUringChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + "<" + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ")";
    private final IoUringDatagramChannelConfig config;
    private volatile boolean connected;
    private final MsgHdrMemoryArray recvmsgHdrs = new MsgHdrMemoryArray(256);
    private final MsgHdrMemoryArray sendmsgHdrs = new MsgHdrMemoryArray(256);
    private final int[] sendmsgResArray = new int[this.sendmsgHdrs.capacity()];

    public IoUringDatagramChannel() {
        this(null);
    }

    public IoUringDatagramChannel(SocketProtocolFamily family) {
        this(LinuxSocket.newSocketDgram(IoUringDatagramChannel.useIpv6(family)), false);
    }

    private static boolean useIpv6(SocketProtocolFamily family) {
        if (family == null) {
            return Socket.isIPv6Preferred();
        }
        return family == SocketProtocolFamily.INET6;
    }

    public IoUringDatagramChannel(int fd) {
        this(new LinuxSocket(fd), true);
    }

    private IoUringDatagramChannel(LinuxSocket fd, boolean active) {
        super(null, fd, active);
        this.config = new IoUringDatagramChannelConfig(this);
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public boolean isActive() {
        return this.socket.isOpen() && (this.config.getActiveOnOpen() && this.isRegistered() || super.isActive());
    }

    public boolean isConnected() {
        return this.connected;
    }

    public ChannelFuture joinGroup(InetAddress multicastAddress) {
        return this.joinGroup(multicastAddress, this.newPromise());
    }

    public ChannelFuture joinGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            return this.joinGroup(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, promise);
        }
        catch (IOException e) {
            promise.setFailure((Throwable)e);
            return promise;
        }
    }

    public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        return this.joinGroup(multicastAddress, networkInterface, this.newPromise());
    }

    public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        return this.joinGroup(multicastAddress.getAddress(), networkInterface, null, promise);
    }

    public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        return this.joinGroup(multicastAddress, networkInterface, source, this.newPromise());
    }

    public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        try {
            this.socket.joinGroup(multicastAddress, networkInterface, source);
            promise.setSuccess();
        }
        catch (IOException e) {
            promise.setFailure((Throwable)e);
        }
        return promise;
    }

    public ChannelFuture leaveGroup(InetAddress multicastAddress) {
        return this.leaveGroup(multicastAddress, this.newPromise());
    }

    public ChannelFuture leaveGroup(InetAddress multicastAddress, ChannelPromise promise) {
        try {
            return this.leaveGroup(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, promise);
        }
        catch (IOException e) {
            promise.setFailure((Throwable)e);
            return promise;
        }
    }

    public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(multicastAddress, networkInterface, this.newPromise());
    }

    public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise promise) {
        return this.leaveGroup(multicastAddress.getAddress(), networkInterface, null, promise);
    }

    public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
        return this.leaveGroup(multicastAddress, networkInterface, source, this.newPromise());
    }

    public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise promise) {
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        try {
            this.socket.leaveGroup(multicastAddress, networkInterface, source);
            promise.setSuccess();
        }
        catch (IOException e) {
            promise.setFailure((Throwable)e);
        }
        return promise;
    }

    public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
        return this.block(multicastAddress, networkInterface, sourceToBlock, this.newPromise());
    }

    public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock, ChannelPromise promise) {
        ObjectUtil.checkNotNull((Object)multicastAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)sourceToBlock, (String)"sourceToBlock");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        promise.setFailure((Throwable)new UnsupportedOperationException("Multicast not supported"));
        return promise;
    }

    public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock) {
        return this.block(multicastAddress, sourceToBlock, this.newPromise());
    }

    public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock, ChannelPromise promise) {
        try {
            return this.block(multicastAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), sourceToBlock, promise);
        }
        catch (Throwable e) {
            promise.setFailure(e);
            return promise;
        }
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new IoUringDatagramChannelUnsafe();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        InetSocketAddress socketAddress;
        if (localAddress instanceof InetSocketAddress && (socketAddress = (InetSocketAddress)localAddress).getAddress().isAnyLocalAddress() && socketAddress.getAddress() instanceof Inet4Address && this.socket.family() == SocketProtocolFamily.INET6) {
            localAddress = new InetSocketAddress(LinuxSocket.INET6_ANY, socketAddress.getPort());
        }
        super.doBind(localAddress);
        this.active = true;
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> envelope) {
        if (envelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)envelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)msg;
            IoUringDatagramChannel.checkUnresolved(packet);
            ByteBuf content = (ByteBuf)packet.content();
            return !content.hasMemoryAddress() ? packet.replace(this.newDirectBuffer(packet, content)) : msg;
        }
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            return !buf.hasMemoryAddress() ? this.newDirectBuffer(buf) : buf;
        }
        if (msg instanceof AddressedEnvelope) {
            AddressedEnvelope e = (AddressedEnvelope)msg;
            IoUringDatagramChannel.checkUnresolved(e);
            if (e.content() instanceof ByteBuf && (e.recipient() == null || e.recipient() instanceof InetSocketAddress)) {
                ByteBuf content = (ByteBuf)e.content();
                return !content.hasMemoryAddress() ? new DefaultAddressedEnvelope((Object)this.newDirectBuffer(e, content), (SocketAddress)((InetSocketAddress)e.recipient())) : e;
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
    }

    public DatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.socket.disconnect();
        this.active = false;
        this.connected = false;
        this.resetCachedAddresses();
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.connected = false;
    }

    private static IOException translateForConnected(Errors.NativeIoException e) {
        if (e.expectedErr() == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            PortUnreachableException error = new PortUnreachableException(e.getMessage());
            error.initCause(e);
            return error;
        }
        return e;
    }

    public static boolean isSegmentedDatagramPacketSupported() {
        return IoUring.isAvailable();
    }

    @Override
    protected void cancelOutstandingReads(IoRegistration registration, int numOutstandingReads) {
        if (numOutstandingReads > 0) {
            int canceled = this.cancel(registration, (byte)10, this.recvmsgHdrs);
            assert (canceled == numOutstandingReads);
        }
    }

    @Override
    protected void cancelOutstandingWrites(IoRegistration registration, int numOutstandingWrites) {
        if (numOutstandingWrites > 0) {
            int canceled = this.cancel(registration, (byte)9, this.sendmsgHdrs);
            assert (canceled == numOutstandingWrites);
        }
    }

    private int cancel(IoRegistration registration, byte op, MsgHdrMemoryArray array) {
        int cancelled = 0;
        for (int idx = 0; idx < array.length(); ++idx) {
            long id = array.id(idx);
            if (id == 0L) continue;
            IoUringIoOps ops = IoUringIoOps.newAsyncCancel((byte)0, id, op);
            registration.submit((IoOps)ops);
            ++cancelled;
        }
        return cancelled;
    }

    @Override
    protected boolean socketIsEmpty(int flags) {
        return IoUring.isCqeFSockNonEmptySupported() && (flags & 4) == 0;
    }

    @Override
    boolean isPollInFirst() {
        return false;
    }

    private final class IoUringDatagramChannelUnsafe
    extends AbstractIoUringChannel.AbstractUringUnsafe {
        private final WriteProcessor writeProcessor;
        private ByteBuf readBuffer;

        private IoUringDatagramChannelUnsafe() {
            super(IoUringDatagramChannel.this);
            this.writeProcessor = new WriteProcessor();
        }

        @Override
        protected void readComplete0(byte op, int res, int flags, short data, int outstanding) {
            assert (outstanding != -1) : "multi-shot not implemented yet";
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ChannelPipeline pipeline = IoUringDatagramChannel.this.pipeline();
            ByteBuf byteBuf = this.readBuffer;
            assert (byteBuf != null);
            try {
                this.recvmsgComplete(pipeline, allocHandle, byteBuf, res, flags, data, outstanding);
            }
            catch (Throwable t) {
                Throwable e = IoUringDatagramChannel.this.connected && t instanceof Errors.NativeIoException ? IoUringDatagramChannel.translateForConnected((Errors.NativeIoException)t) : t;
                pipeline.fireExceptionCaught(e);
            }
        }

        private void recvmsgComplete(ChannelPipeline pipeline, IoUringRecvByteAllocatorHandle allocHandle, ByteBuf byteBuf, int res, int flags, int idx, int outstanding) throws IOException {
            MsgHdrMemory hdr = IoUringDatagramChannel.this.recvmsgHdrs.hdr(idx);
            if (res < 0) {
                if (res != Native.ERRNO_ECANCELED_NEGATIVE) {
                    allocHandle.lastBytesRead(Errors.ioResult((String)"io_uring recvmsg", (int)res));
                }
            } else {
                allocHandle.lastBytesRead(res);
                if (hdr.hasPort(IoUringDatagramChannel.this)) {
                    allocHandle.incMessagesRead(1);
                    DatagramPacket packet = hdr.get(IoUringDatagramChannel.this, (IoUringIoHandler)IoUringDatagramChannel.this.registration().attachment(), byteBuf, res);
                    pipeline.fireChannelRead((Object)packet);
                }
            }
            IoUringDatagramChannel.this.recvmsgHdrs.setId(idx, 0L);
            if (outstanding == 0) {
                this.readBuffer.release();
                this.readBuffer = null;
                IoUringDatagramChannel.this.recvmsgHdrs.clear();
                if (res != Native.ERRNO_ECANCELED_NEGATIVE) {
                    if (allocHandle.lastBytesRead() > 0 && allocHandle.continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER) && (!IoUring.isCqeFSockNonEmptySupported() || (flags & 4) != 0)) {
                        this.scheduleRead(false);
                    } else {
                        allocHandle.readComplete();
                        pipeline.fireChannelReadComplete();
                    }
                }
            }
        }

        @Override
        protected int scheduleRead0(boolean first, boolean socketIsEmpty) {
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ByteBuf byteBuf = allocHandle.allocate(IoUringDatagramChannel.this.alloc());
            assert (this.readBuffer == null);
            this.readBuffer = byteBuf;
            int writable = byteBuf.writableBytes();
            allocHandle.attemptedBytesRead(writable);
            int datagramSize = ((IoUringDatagramChannelConfig)IoUringDatagramChannel.this.config()).getMaxDatagramPayloadSize();
            int numDatagram = datagramSize == 0 ? 1 : Math.max(1, byteBuf.writableBytes() / datagramSize);
            int scheduled = this.scheduleRecvmsg(byteBuf, numDatagram, datagramSize);
            if (scheduled == 0) {
                this.readBuffer = null;
                byteBuf.release();
            }
            return scheduled;
        }

        private int scheduleRecvmsg(ByteBuf byteBuf, int numDatagram, int datagramSize) {
            int i;
            int writable = byteBuf.writableBytes();
            long bufferAddress = IoUring.memoryAddress(byteBuf) + (long)byteBuf.writerIndex();
            if (numDatagram <= 1) {
                return this.scheduleRecvmsg0(bufferAddress, writable, true) ? 1 : 0;
            }
            for (i = 0; i < numDatagram && writable >= datagramSize && this.scheduleRecvmsg0(bufferAddress, datagramSize, i == 0); writable -= datagramSize, ++i) {
                bufferAddress += (long)datagramSize;
            }
            return i;
        }

        private boolean scheduleRecvmsg0(long bufferAddress, int bufferLength, boolean first) {
            MsgHdrMemory msgHdrMemory = IoUringDatagramChannel.this.recvmsgHdrs.nextHdr();
            if (msgHdrMemory == null) {
                return false;
            }
            msgHdrMemory.set(IoUringDatagramChannel.this.socket, null, bufferAddress, bufferLength, (short)0);
            int fd = IoUringDatagramChannel.this.fd().intValue();
            int msgFlags = first ? 0 : Native.MSG_DONTWAIT;
            IoRegistration registration = IoUringDatagramChannel.this.registration();
            IoUringIoOps ops = IoUringIoOps.newRecvmsg(fd, (byte)0, msgFlags, msgHdrMemory.address(), msgHdrMemory.idx());
            long id = registration.submit((IoOps)ops);
            if (id == 0L) {
                IoUringDatagramChannel.this.recvmsgHdrs.restoreNextHdr(msgHdrMemory);
                return false;
            }
            IoUringDatagramChannel.this.recvmsgHdrs.setId(msgHdrMemory.idx(), id);
            return true;
        }

        @Override
        boolean writeComplete0(byte op, int res, int flags, short data, int outstanding) {
            ChannelOutboundBuffer outboundBuffer = this.outboundBuffer();
            IoUringDatagramChannel.this.sendmsgHdrs.setId(data, 0L);
            ((IoUringDatagramChannel)IoUringDatagramChannel.this).sendmsgResArray[data] = res;
            if (outstanding == 0) {
                boolean writtenSomething = false;
                int numWritten = IoUringDatagramChannel.this.sendmsgHdrs.length();
                IoUringDatagramChannel.this.sendmsgHdrs.clear();
                for (int i = 0; i < numWritten; ++i) {
                    writtenSomething |= this.removeFromOutboundBuffer(outboundBuffer, IoUringDatagramChannel.this.sendmsgResArray[i], "io_uring sendmsg");
                }
                return writtenSomething;
            }
            return true;
        }

        private boolean removeFromOutboundBuffer(ChannelOutboundBuffer outboundBuffer, int res, String errormsg) {
            if (res >= 0) {
                return outboundBuffer.remove();
            }
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                return false;
            }
            try {
                return Errors.ioResult((String)errormsg, (int)res) != 0;
            }
            catch (Throwable cause) {
                return outboundBuffer.remove(cause);
            }
        }

        @Override
        void connectComplete(byte op, int res, int flags, short data) {
            if (res >= 0) {
                IoUringDatagramChannel.this.connected = true;
            }
            super.connectComplete(op, res, flags, data);
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            return this.writeProcessor.write(in);
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            return this.scheduleWrite(msg, true) ? 1 : 0;
        }

        private boolean scheduleWrite(Object msg, boolean first) {
            int segmentSize;
            InetSocketAddress remoteAddress;
            ByteBuf data;
            if (msg instanceof AddressedEnvelope) {
                AddressedEnvelope envelope = (AddressedEnvelope)msg;
                data = (ByteBuf)envelope.content();
                remoteAddress = (InetSocketAddress)envelope.recipient();
                segmentSize = msg instanceof SegmentedDatagramPacket ? ((SegmentedDatagramPacket)msg).segmentSize() : 0;
            } else {
                data = (ByteBuf)msg;
                remoteAddress = (InetSocketAddress)this.remoteAddress();
                segmentSize = 0;
            }
            long bufferAddress = IoUring.memoryAddress(data);
            return this.scheduleSendmsg(remoteAddress, bufferAddress, data.readableBytes(), segmentSize, first);
        }

        private boolean scheduleSendmsg(InetSocketAddress remoteAddress, long bufferAddress, int bufferLength, int segmentSize, boolean first) {
            MsgHdrMemory hdr = IoUringDatagramChannel.this.sendmsgHdrs.nextHdr();
            if (hdr == null) {
                return false;
            }
            hdr.set(IoUringDatagramChannel.this.socket, remoteAddress, bufferAddress, bufferLength, (short)segmentSize);
            int fd = IoUringDatagramChannel.this.fd().intValue();
            int msgFlags = first ? 0 : Native.MSG_DONTWAIT;
            IoRegistration registration = IoUringDatagramChannel.this.registration();
            IoUringIoOps ops = IoUringIoOps.newSendmsg(fd, (byte)0, msgFlags, hdr.address(), hdr.idx());
            long id = registration.submit((IoOps)ops);
            if (id == 0L) {
                IoUringDatagramChannel.this.sendmsgHdrs.restoreNextHdr(hdr);
                return false;
            }
            IoUringDatagramChannel.this.sendmsgHdrs.setId(hdr.idx(), id);
            return true;
        }

        @Override
        protected void freeResourcesNow(IoRegistration reg) {
            IoUringDatagramChannel.this.sendmsgHdrs.release();
            IoUringDatagramChannel.this.recvmsgHdrs.release();
            super.freeResourcesNow(reg);
        }

        private final class WriteProcessor
        implements ChannelOutboundBuffer.MessageProcessor {
            private int written;

            private WriteProcessor() {
            }

            public boolean processMessage(Object msg) {
                if (IoUringDatagramChannelUnsafe.this.scheduleWrite(msg, this.written == 0)) {
                    ++this.written;
                    return true;
                }
                return false;
            }

            int write(ChannelOutboundBuffer in) {
                this.written = 0;
                try {
                    in.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)this);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                return this.written;
            }
        }
    }
}

