/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.impl.Constants;
import java.util.HashMap;
import java.util.Map;

public class WriteCache {
    public static final int MIN_SIZE_CACHEABLE = 4;
    public static final int CACHE_CODE_DIGITS = 44;
    public static final int MAX_CACHE_ENTRIES = 1936;
    public static final int BASE_CHAR_IDX = 48;
    private final Map<String, String> cache = new HashMap<String, String>(1936);
    private int index = 0;
    private boolean enabled;

    public WriteCache() {
        this(true);
    }

    public WriteCache(boolean enabled) {
        this.enabled = enabled;
    }

    public static boolean isCacheable(String s, boolean asMapKey) {
        return s.length() >= 4 && (asMapKey || s.charAt(0) == '~' && (s.charAt(1) == ':' || s.charAt(1) == '$' || s.charAt(1) == '#'));
    }

    private String indexToCode(int index) {
        int hi = index / 44;
        int lo = index % 44;
        if (hi == 0) {
            return Constants.SUB_STR + (char)(lo + 48);
        }
        return Constants.SUB_STR + (char)(hi + 48) + (char)(lo + 48);
    }

    public String cacheWrite(String s, boolean asMapKey) {
        if (this.enabled && WriteCache.isCacheable(s, asMapKey)) {
            String val = this.cache.get(s);
            if (val != null) {
                return val;
            }
            if (this.index == 1936) {
                this.init();
            }
            String code = this.indexToCode(this.index++);
            this.cache.put(s, code);
        }
        return s;
    }

    public WriteCache init() {
        this.index = 0;
        this.cache.clear();
        return this;
    }
}

