/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.Ratio;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RatioImpl
implements Ratio {
    private final BigInteger numerator;
    private final BigInteger denominator;

    public RatioImpl(BigInteger numerator, BigInteger denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public boolean equals(Object o) {
        return o instanceof Ratio && ((Ratio)o).getNumerator() == this.numerator && ((Ratio)o).getDenominator() == this.denominator;
    }

    @Override
    public Double getValue() {
        BigDecimal n = new BigDecimal(this.numerator);
        BigDecimal d = new BigDecimal(this.denominator);
        return n.divide(d).doubleValue();
    }

    @Override
    public BigInteger getNumerator() {
        return this.numerator;
    }

    @Override
    public BigInteger getDenominator() {
        return this.denominator;
    }

    @Override
    public int compareTo(Ratio o) {
        return this.getValue().compareTo(o.getValue());
    }
}

