/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.impl.AbstractEmitter;
import com.cognitect.transit.impl.Constants;
import com.cognitect.transit.impl.Util;
import com.cognitect.transit.impl.WriteCache;
import com.cognitect.transit.impl.WriteHandlerMap;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;

public class JsonEmitter
extends AbstractEmitter {
    private static final BigInteger JSON_INT_MAX = new BigInteger(String.valueOf((long)Math.pow(2.0, 53.0) - 1L));
    private static final BigInteger JSON_INT_MIN = new BigInteger("-" + JSON_INT_MAX.toString());
    protected final JsonGenerator gen;

    @Deprecated
    public JsonEmitter(JsonGenerator gen, WriteHandlerMap writeHandlerMap) {
        super(writeHandlerMap, null);
        this.gen = gen;
    }

    public JsonEmitter(JsonGenerator gen, WriteHandlerMap writeHandlerMap, WriteHandler defaultWriteHandler) {
        super(writeHandlerMap, defaultWriteHandler);
        this.gen = gen;
    }

    public JsonEmitter(JsonGenerator gen, WriteHandlerMap writeHandlerMap, WriteHandler defaultWriteHandler, Function<Object, Object> transform) {
        super(writeHandlerMap, defaultWriteHandler, transform);
        this.gen = gen;
    }

    @Override
    public void emit(Object o, boolean asMapKey, WriteCache cache) throws Exception {
        this.marshalTop(o, cache);
    }

    @Override
    public void emitNil(boolean asMapKey, WriteCache cache) throws Exception {
        if (asMapKey) {
            this.emitString(Constants.ESC_STR, "_", "", asMapKey, cache);
        } else {
            this.gen.writeNull();
        }
    }

    @Override
    public void emitString(String prefix, String tag, String s, boolean asMapKey, WriteCache cache) throws Exception {
        String outString = cache.cacheWrite(Util.maybePrefix(prefix, tag, s), asMapKey);
        this.gen.writeString(outString);
    }

    @Override
    public void emitBoolean(Boolean b, boolean asMapKey, WriteCache cache) throws Exception {
        if (asMapKey) {
            this.emitString(Constants.ESC_STR, "?", b != false ? "t" : "f", asMapKey, cache);
        } else {
            this.gen.writeBoolean(b.booleanValue());
        }
    }

    @Override
    public void emitBoolean(boolean b, boolean asMapKey, WriteCache cache) throws Exception {
        if (asMapKey) {
            this.emitString(Constants.ESC_STR, "?", b ? "t" : "f", asMapKey, cache);
        } else {
            this.gen.writeBoolean(b);
        }
    }

    @Override
    public void emitInteger(Object o, boolean asMapKey, WriteCache cache) throws Exception {
        long i = Util.numberToPrimitiveLong(o);
        if (asMapKey || i > JSON_INT_MAX.longValue() || i < JSON_INT_MIN.longValue()) {
            this.emitString(Constants.ESC_STR, "i", String.valueOf(i), asMapKey, cache);
        } else {
            this.gen.writeNumber(i);
        }
    }

    @Override
    public void emitInteger(long i, boolean asMapKey, WriteCache cache) throws Exception {
        if (asMapKey || i > JSON_INT_MAX.longValue() || i < JSON_INT_MIN.longValue()) {
            this.emitString(Constants.ESC_STR, "i", String.valueOf(i), asMapKey, cache);
        } else {
            this.gen.writeNumber(i);
        }
    }

    @Override
    public void emitDouble(Object d, boolean asMapKey, WriteCache cache) throws Exception {
        if (asMapKey) {
            this.emitString(Constants.ESC_STR, "d", d.toString(), asMapKey, cache);
        } else if (d instanceof Double) {
            this.gen.writeNumber(((Double)d).doubleValue());
        } else if (d instanceof Float) {
            this.gen.writeNumber(((Float)d).floatValue());
        }
    }

    @Override
    public void emitDouble(float d, boolean asMapKey, WriteCache cache) throws Exception {
        if (asMapKey) {
            this.emitString(Constants.ESC_STR, "d", String.valueOf(d), asMapKey, cache);
        } else {
            this.gen.writeNumber(d);
        }
    }

    @Override
    public void emitDouble(double d, boolean asMapKey, WriteCache cache) throws Exception {
        if (asMapKey) {
            this.emitString(Constants.ESC_STR, "d", String.valueOf(d), asMapKey, cache);
        } else {
            this.gen.writeNumber(d);
        }
    }

    @Override
    public void emitBinary(Object b, boolean asMapKey, WriteCache cache) throws Exception {
        byte[] encodedBytes = Base64.encodeBase64((byte[])((byte[])b));
        this.emitString(Constants.ESC_STR, "b", new String(encodedBytes), asMapKey, cache);
    }

    @Override
    public void emitArrayStart(Long size) throws Exception {
        this.gen.writeStartArray();
    }

    @Override
    public void emitArrayEnd() throws Exception {
        this.gen.writeEndArray();
    }

    @Override
    public void emitMapStart(Long ignored) throws Exception {
        this.gen.writeStartObject();
    }

    @Override
    public void emitMapEnd() throws Exception {
        this.gen.writeEndObject();
    }

    @Override
    public void flushWriter() throws IOException {
        this.gen.flush();
    }

    @Override
    public boolean prefersStrings() {
        return true;
    }

    @Override
    protected void emitMap(Iterable<Map.Entry<Object, Object>> i, boolean ignored, WriteCache cache) throws Exception {
        long sz = Util.mapSize(i);
        this.emitArrayStart(sz);
        this.emitString(null, null, "^ ", false, cache);
        for (Map.Entry<Object, Object> e : i) {
            this.marshal(e.getKey(), true, cache);
            this.marshal(e.getValue(), false, cache);
        }
        this.emitArrayEnd();
    }
}

