/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpl.shaded.org.apache.kafka.common.utils.Utils;

public class LoggingSignalHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingSignalHandler.class);
    private static final List<String> SIGNALS = Arrays.asList("TERM", "INT", "HUP");
    private final Constructor<?> signalConstructor;
    private final Class<?> signalHandlerClass;
    private final Class<?> signalClass = Class.forName("sun.misc.Signal");
    private final Method signalHandleMethod;
    private final Method signalGetNameMethod;
    private final Method signalHandlerHandleMethod;

    public LoggingSignalHandler() throws ReflectiveOperationException {
        this.signalConstructor = this.signalClass.getConstructor(String.class);
        this.signalHandlerClass = Class.forName("sun.misc.SignalHandler");
        this.signalHandlerHandleMethod = this.signalHandlerClass.getMethod("handle", this.signalClass);
        this.signalHandleMethod = this.signalClass.getMethod("handle", this.signalClass, this.signalHandlerClass);
        this.signalGetNameMethod = this.signalClass.getMethod("getName", new Class[0]);
    }

    public void register() throws ReflectiveOperationException {
        ConcurrentHashMap<String, Object> jvmSignalHandlers = new ConcurrentHashMap<String, Object>();
        for (String signal : SIGNALS) {
            this.register(signal, jvmSignalHandlers);
        }
        log.info("Registered signal handlers for " + String.join((CharSequence)", ", SIGNALS));
    }

    private Object createSignalHandler(final Map<String, Object> jvmSignalHandlers) {
        InvocationHandler invocationHandler = new InvocationHandler(){

            private String getName(Object signal) throws ReflectiveOperationException {
                return (String)LoggingSignalHandler.this.signalGetNameMethod.invoke(signal, new Object[0]);
            }

            private void handle(Object signalHandler, Object signal) throws ReflectiveOperationException {
                LoggingSignalHandler.this.signalHandlerHandleMethod.invoke(signalHandler, signal);
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object signal = args[0];
                log.info("Terminating process due to signal {}", signal);
                Object handler = jvmSignalHandlers.get(this.getName(signal));
                if (handler != null) {
                    this.handle(handler, signal);
                }
                return null;
            }
        };
        return Proxy.newProxyInstance(Utils.getContextOrKafkaClassLoader(), new Class[]{this.signalHandlerClass}, invocationHandler);
    }

    private void register(String signalName, Map<String, Object> jvmSignalHandlers) throws ReflectiveOperationException {
        Object signal = this.signalConstructor.newInstance(signalName);
        Object signalHandler = this.createSignalHandler(jvmSignalHandlers);
        Object oldHandler = this.signalHandleMethod.invoke(null, signal, signalHandler);
        if (oldHandler != null) {
            jvmSignalHandlers.put(signalName, oldHandler);
        }
    }
}

