/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.utils;

import java.util.Iterator;
import java.util.List;

public class CircularIterator<T>
implements Iterator<T> {
    int i = 0;
    private List<T> list;

    public CircularIterator(List<T> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("CircularIterator can only be used on non-empty lists");
        }
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public T next() {
        T next = this.list.get(this.i);
        this.i = (this.i + 1) % this.list.size();
        return next;
    }

    public T peek() {
        return this.list.get(this.i);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

