/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.security.scram.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ScramMechanism {
    SCRAM_SHA_256("SHA-256", "HmacSHA256", 4096),
    SCRAM_SHA_512("SHA-512", "HmacSHA512", 4096);

    private final String mechanismName;
    private final String hashAlgorithm;
    private final String macAlgorithm;
    private final int minIterations;
    private static final Map<String, ScramMechanism> MECHANISMS_MAP;

    private ScramMechanism(String hashAlgorithm, String macAlgorithm, int minIterations) {
        this.mechanismName = "SCRAM-" + hashAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
        this.macAlgorithm = macAlgorithm;
        this.minIterations = minIterations;
    }

    public final String mechanismName() {
        return this.mechanismName;
    }

    public String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String macAlgorithm() {
        return this.macAlgorithm;
    }

    public int minIterations() {
        return this.minIterations;
    }

    public static ScramMechanism forMechanismName(String mechanismName) {
        return MECHANISMS_MAP.get(mechanismName);
    }

    public static Collection<String> mechanismNames() {
        return MECHANISMS_MAP.keySet();
    }

    public static boolean isScram(String mechanismName) {
        return MECHANISMS_MAP.containsKey(mechanismName);
    }

    static {
        HashMap<String, ScramMechanism> map = new HashMap<String, ScramMechanism>();
        for (ScramMechanism mech : ScramMechanism.values()) {
            map.put(mech.mechanismName, mech);
        }
        MECHANISMS_MAP = Collections.unmodifiableMap(map);
    }
}

