/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.security.oauthbearer.internals;

import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpl.shaded.org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import rpl.shaded.org.apache.kafka.common.security.auth.Login;
import rpl.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import rpl.shaded.org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredential;
import rpl.shaded.org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredentialRefreshConfig;
import rpl.shaded.org.apache.kafka.common.security.oauthbearer.internals.expiring.ExpiringCredentialRefreshingLogin;

public class OAuthBearerRefreshingLogin
implements Login {
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerRefreshingLogin.class);
    private ExpiringCredentialRefreshingLogin expiringCredentialRefreshingLogin = null;

    @Override
    public void configure(Map<String, ?> configs, String contextName, Configuration configuration, AuthenticateCallbackHandler loginCallbackHandler) {
        Class<OAuthBearerRefreshingLogin> classToSynchronizeOnPriorToRefresh = OAuthBearerRefreshingLogin.class;
        this.expiringCredentialRefreshingLogin = new ExpiringCredentialRefreshingLogin(contextName, configuration, new ExpiringCredentialRefreshConfig(configs, true), loginCallbackHandler, classToSynchronizeOnPriorToRefresh){

            @Override
            public ExpiringCredential expiringCredential() {
                Set<OAuthBearerToken> privateCredentialTokens = OAuthBearerRefreshingLogin.this.expiringCredentialRefreshingLogin.subject().getPrivateCredentials(OAuthBearerToken.class);
                if (privateCredentialTokens.isEmpty()) {
                    return null;
                }
                final OAuthBearerToken token = privateCredentialTokens.iterator().next();
                if (log.isDebugEnabled()) {
                    log.debug("Found expiring credential with principal '{}'.", (Object)token.principalName());
                }
                return new ExpiringCredential(){

                    @Override
                    public String principalName() {
                        return token.principalName();
                    }

                    @Override
                    public Long startTimeMs() {
                        return token.startTimeMs();
                    }

                    @Override
                    public long expireTimeMs() {
                        return token.lifetimeMs();
                    }

                    @Override
                    public Long absoluteLastRefreshTimeMs() {
                        return null;
                    }
                };
            }
        };
    }

    @Override
    public void close() {
        if (this.expiringCredentialRefreshingLogin != null) {
            this.expiringCredentialRefreshingLogin.close();
        }
    }

    @Override
    public Subject subject() {
        return this.expiringCredentialRefreshingLogin != null ? this.expiringCredentialRefreshingLogin.subject() : null;
    }

    @Override
    public String serviceName() {
        return this.expiringCredentialRefreshingLogin != null ? this.expiringCredentialRefreshingLogin.serviceName() : null;
    }

    @Override
    public synchronized LoginContext login() throws LoginException {
        if (this.expiringCredentialRefreshingLogin != null) {
            return this.expiringCredentialRefreshingLogin.login();
        }
        throw new LoginException("Login was not configured properly");
    }
}

