/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import rpl.shaded.org.apache.kafka.common.message.SaslHandshakeResponseData;
import rpl.shaded.org.apache.kafka.common.protocol.ApiKeys;
import rpl.shaded.org.apache.kafka.common.protocol.Errors;
import rpl.shaded.org.apache.kafka.common.protocol.types.Struct;
import rpl.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class SaslHandshakeResponse
extends AbstractResponse {
    private final SaslHandshakeResponseData data;

    public SaslHandshakeResponse(SaslHandshakeResponseData data) {
        this.data = data;
    }

    public SaslHandshakeResponse(Struct struct, short version) {
        this.data = new SaslHandshakeResponseData(struct, version);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public List<String> enabledMechanisms() {
        return this.data.mechanisms();
    }

    public static SaslHandshakeResponse parse(ByteBuffer buffer, short version) {
        return new SaslHandshakeResponse(ApiKeys.SASL_HANDSHAKE.parseResponse(version, buffer), version);
    }
}

