/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.record;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;
import rpl.shaded.org.apache.kafka.common.record.BufferSupplier;
import rpl.shaded.org.apache.kafka.common.record.KafkaLZ4BlockOutputStream;

public final class KafkaLZ4BlockInputStream
extends InputStream {
    public static final String PREMATURE_EOS = "Stream ended prematurely";
    public static final String NOT_SUPPORTED = "Stream unsupported (invalid magic bytes)";
    public static final String BLOCK_HASH_MISMATCH = "Block checksum mismatch";
    public static final String DESCRIPTOR_HASH_MISMATCH = "Stream frame descriptor corrupted";
    private static final LZ4SafeDecompressor DECOMPRESSOR = LZ4Factory.fastestInstance().safeDecompressor();
    private static final XXHash32 CHECKSUM = XXHashFactory.fastestInstance().hash32();
    private final ByteBuffer in;
    private final boolean ignoreFlagDescriptorChecksum;
    private final BufferSupplier bufferSupplier;
    private final ByteBuffer decompressionBuffer;
    private KafkaLZ4BlockOutputStream.FLG flg;
    private int maxBlockSize;
    private ByteBuffer decompressedBuffer;
    private boolean finished;

    public KafkaLZ4BlockInputStream(ByteBuffer in, BufferSupplier bufferSupplier, boolean ignoreFlagDescriptorChecksum) throws IOException {
        this.ignoreFlagDescriptorChecksum = ignoreFlagDescriptorChecksum;
        this.in = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.bufferSupplier = bufferSupplier;
        this.readHeader();
        this.decompressionBuffer = bufferSupplier.get(this.maxBlockSize);
        if (!this.decompressionBuffer.hasArray() || this.decompressionBuffer.arrayOffset() != 0) {
            throw new RuntimeException("decompression buffer must have backing array with zero array offset");
        }
        this.finished = false;
    }

    public boolean ignoreFlagDescriptorChecksum() {
        return this.ignoreFlagDescriptorChecksum;
    }

    private void readHeader() throws IOException {
        if (this.in.remaining() < 6) {
            throw new IOException(PREMATURE_EOS);
        }
        if (407708164 != this.in.getInt()) {
            throw new IOException(NOT_SUPPORTED);
        }
        this.in.mark();
        this.flg = KafkaLZ4BlockOutputStream.FLG.fromByte(this.in.get());
        this.maxBlockSize = KafkaLZ4BlockOutputStream.BD.fromByte(this.in.get()).getBlockMaximumSize();
        if (this.flg.isContentSizeSet()) {
            if (this.in.remaining() < 8) {
                throw new IOException(PREMATURE_EOS);
            }
            this.in.position(this.in.position() + 8);
        }
        if (this.ignoreFlagDescriptorChecksum) {
            this.in.position(this.in.position() + 1);
            return;
        }
        int len = this.in.position() - this.in.reset().position();
        int hash = this.in.hasArray() ? CHECKSUM.hash(this.in.array(), this.in.arrayOffset() + this.in.position(), len, 0) : CHECKSUM.hash(this.in, this.in.position(), len, 0);
        this.in.position(this.in.position() + len);
        if (this.in.get() != (byte)(hash >> 8 & 0xFF)) {
            throw new IOException(DESCRIPTOR_HASH_MISMATCH);
        }
    }

    private void readBlock() throws IOException {
        boolean compressed;
        if (this.in.remaining() < 4) {
            throw new IOException(PREMATURE_EOS);
        }
        int blockSize = this.in.getInt();
        boolean bl = compressed = (blockSize & Integer.MIN_VALUE) == 0;
        if ((blockSize &= Integer.MAX_VALUE) == 0) {
            this.finished = true;
            if (this.flg.isContentChecksumSet()) {
                this.in.getInt();
            }
            return;
        }
        if (blockSize > this.maxBlockSize) {
            throw new IOException(String.format("Block size %s exceeded max: %s", blockSize, this.maxBlockSize));
        }
        if (this.in.remaining() < blockSize) {
            throw new IOException(PREMATURE_EOS);
        }
        if (compressed) {
            try {
                int bufferSize = this.in.hasArray() ? DECOMPRESSOR.decompress(this.in.array(), this.in.position() + this.in.arrayOffset(), blockSize, this.decompressionBuffer.array(), 0, this.maxBlockSize) : DECOMPRESSOR.decompress(this.in, this.in.position(), blockSize, this.decompressionBuffer, 0, this.maxBlockSize);
                this.decompressionBuffer.position(0);
                this.decompressionBuffer.limit(bufferSize);
                this.decompressedBuffer = this.decompressionBuffer;
            }
            catch (LZ4Exception e) {
                throw new IOException(e);
            }
        } else {
            this.decompressedBuffer = this.in.slice();
            this.decompressedBuffer.limit(blockSize);
        }
        if (this.flg.isBlockChecksumSet()) {
            int hash = this.in.hasArray() ? CHECKSUM.hash(this.in.array(), this.in.arrayOffset() + this.in.position(), blockSize, 0) : CHECKSUM.hash(this.in, this.in.position(), blockSize, 0);
            this.in.position(this.in.position() + blockSize);
            if (hash != this.in.getInt()) {
                throw new IOException(BLOCK_HASH_MISMATCH);
            }
        } else {
            this.in.position(this.in.position() + blockSize);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return -1;
        }
        return this.decompressedBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        SafeUtils.checkRange(b, off, len);
        if (this.finished) {
            return -1;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return -1;
        }
        len = Math.min(len, this.available());
        this.decompressedBuffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.finished) {
            return 0L;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return 0L;
        }
        int skipped = (int)Math.min(n, (long)this.available());
        this.decompressedBuffer.position(this.decompressedBuffer.position() + skipped);
        return skipped;
    }

    @Override
    public int available() {
        return this.decompressedBuffer == null ? 0 : this.decompressedBuffer.remaining();
    }

    @Override
    public void close() {
        this.bufferSupplier.release(this.decompressionBuffer);
    }

    @Override
    public void mark(int readlimit) {
        throw new RuntimeException("mark not supported");
    }

    @Override
    public void reset() {
        throw new RuntimeException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

