/*
 * Decompiled with CFR 0.152.
 */
package rpl.shaded.org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import rpl.shaded.org.apache.kafka.common.protocol.types.Field;
import rpl.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import rpl.shaded.org.apache.kafka.common.protocol.types.SchemaException;
import rpl.shaded.org.apache.kafka.common.protocol.types.Type;
import rpl.shaded.org.apache.kafka.common.utils.ByteUtils;

public class TaggedFields
extends Type.DocumentedType {
    private static final String TAGGED_FIELDS_TYPE_NAME = "TAGGED_FIELDS";
    private final Map<Integer, Field> fields;

    public static TaggedFields of(Object ... fields) {
        if (fields.length % 2 != 0) {
            throw new RuntimeException("TaggedFields#of takes an even number of parameters.");
        }
        TreeMap<Integer, Field> newFields = new TreeMap<Integer, Field>();
        for (int i = 0; i < fields.length; i += 2) {
            Integer tag = (Integer)fields[i];
            Field field2 = (Field)fields[i + 1];
            newFields.put(tag, field2);
        }
        return new TaggedFields(newFields);
    }

    public TaggedFields(Map<Integer, Field> fields) {
        this.fields = fields;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        NavigableMap objects = (NavigableMap)o;
        ByteUtils.writeUnsignedVarint(objects.size(), buffer);
        for (Map.Entry entry : objects.entrySet()) {
            Integer tag = (Integer)entry.getKey();
            Field field2 = this.fields.get(tag);
            ByteUtils.writeUnsignedVarint((int)tag, buffer);
            if (field2 == null) {
                RawTaggedField value = (RawTaggedField)entry.getValue();
                ByteUtils.writeUnsignedVarint(value.data().length, buffer);
                buffer.put(value.data());
                continue;
            }
            ByteUtils.writeUnsignedVarint(field2.type.sizeOf(entry.getValue()), buffer);
            field2.type.write(buffer, entry.getValue());
        }
    }

    @Override
    public NavigableMap<Integer, Object> read(ByteBuffer buffer) {
        int numTaggedFields = ByteUtils.readUnsignedVarint(buffer);
        if (numTaggedFields == 0) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<Integer, Object> objects = new TreeMap<Integer, Object>();
        int prevTag = -1;
        for (int i = 0; i < numTaggedFields; ++i) {
            int tag = ByteUtils.readUnsignedVarint(buffer);
            if (tag <= prevTag) {
                throw new RuntimeException("Invalid or out-of-order tag " + tag);
            }
            prevTag = tag;
            int size = ByteUtils.readUnsignedVarint(buffer);
            Field field2 = this.fields.get(tag);
            if (field2 == null) {
                byte[] bytes = new byte[size];
                buffer.get(bytes);
                objects.put(tag, new RawTaggedField(tag, bytes));
                continue;
            }
            objects.put(tag, field2.type.read(buffer));
        }
        return objects;
    }

    @Override
    public int sizeOf(Object o) {
        int size = 0;
        NavigableMap objects = (NavigableMap)o;
        size += ByteUtils.sizeOfUnsignedVarint(objects.size());
        for (Map.Entry entry : objects.entrySet()) {
            Integer tag = (Integer)entry.getKey();
            size += ByteUtils.sizeOfUnsignedVarint(tag);
            Field field2 = this.fields.get(tag);
            if (field2 == null) {
                RawTaggedField value = (RawTaggedField)entry.getValue();
                size += value.data().length + ByteUtils.sizeOfUnsignedVarint(value.data().length);
                continue;
            }
            int valueSize = field2.type.sizeOf(entry.getValue());
            size += valueSize + ByteUtils.sizeOfUnsignedVarint(valueSize);
        }
        return size;
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder("TAGGED_FIELDS_TYPE_NAME(");
        String prefix = "";
        for (Map.Entry<Integer, Field> field2 : this.fields.entrySet()) {
            bld.append(prefix);
            prefix = ", ";
            bld.append(field2.getKey()).append(" -> ").append(field2.getValue().toString());
        }
        bld.append(")");
        return bld.toString();
    }

    @Override
    public Map<Integer, Object> validate(Object item) {
        try {
            NavigableMap objects = (NavigableMap)item;
            for (Map.Entry entry : objects.entrySet()) {
                Integer tag = (Integer)entry.getKey();
                Field field2 = this.fields.get(tag);
                if (field2 == null) {
                    if (entry.getValue() instanceof RawTaggedField) continue;
                    throw new SchemaException("The value associated with tag " + tag + " must be a RawTaggedField in this version of the software.");
                }
                field2.type.validate(entry.getValue());
            }
            return objects;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not a NavigableMap.");
        }
    }

    @Override
    public String typeName() {
        return TAGGED_FIELDS_TYPE_NAME;
    }

    @Override
    public String documentation() {
        return "Represents a series of tagged fields.";
    }
}

